<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname: linklistentry.php                                     # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

require_once (DIR."/vb/search/core.php");

/**
 * Index Controller for linklist entries
 *
 * @package vBulletin
 * @subpackage Search
 */
class vBLinklist_Search_IndexController_LinklistEntry extends vB_Search_IndexController
{
	public function __construct()
	{
		$this->contenttypeid = vB_Search_Core::get_instance()->get_contenttypeid('vBLinklist', 'LinklistEntry');
	}

	public function get_max_id()
	{
		global $vbulletin;
		$row = $vbulletin->db->query_first_slave("
			SELECT MAX(id) AS max FROM " . TABLE_PREFIX . "vblinklist_entry"
		);
		return $row['max'];
	}

	/**
	 * Index linklist entry
	 *
	 * @param int $id
	 */
	public function index($id)
	{
		global $vbulletin;
		$row = $vbulletin->db->query_first_slave($this->make_query("entry.id = " . intval($id)));
		if ($row)
		{
			$indexer = vB_Search_Core::get_instance()->get_core_indexer();
			$fields = $this->record_to_indexfields($row);
			$indexer->index($fields);
		}
	}


	public function index_id_range($start, $finish)
	{
		global $vbulletin;
		$indexer = vB_Search_Core::get_instance()->get_core_indexer();
		$set = $vbulletin->db->query_read_slave($this->make_query("entry.id BETWEEN " . intval($start) . " AND " . intval($finish)));
		while ($row = $vbulletin->db->fetch_array($set))
		{
			$fields = $this->record_to_indexfields($row);
			$indexer->index($fields);
		}
	}

	private function make_query($filter)
	{
		return "
			SELECT entry.id, entry.userid, entry.dateline, entry.name, user.username, entry.ipaddress, entry.description
			FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = entry.userid)
			WHERE $filter
		";
	}

	/**
	 * Convert the basic table row to the index fieldset
	 *
	 * @param array $record
	 * @return return index fields
	 */
	private function record_to_indexfields($record)
	{
		$default = '';
				
		//common fields
		$fields = array();
		$fields['contenttypeid'] = $this->get_contenttypeid();
		$fields['id'] = $record['id'];
		$fields['dateline'] = $record['dateline'];
		$fields['userid'] = $record['userid'];
		$fields['username'] = $record['username'];
		$fields['ipaddress'] = $record['ipaddress'];
		$fields['title'] = $record['name'];
		$fields['keywordtext'] = $record['description'];

		return $fields;
	}
}

?>