<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname: moderate_vblinklist.php                                # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('forum', 'cpuser', 'forumdisplay', 'prefix', 'vblinklist', 'maintenance', 'thread', 'threadmanage');
$globaltemplates = array('vblinklist');
$specialtemplates = array('vblinklist');
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_vblinklist.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canlinklist'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'entries';
}

($hook = vBulletinHook::fetch_hook('vblinklist_modentrystart')) ? eval($hook) : false;

// ########################################################################
// moderate entries
if ($_REQUEST['do'] == 'entries')
{
	print_cp_header($vbphrase['moderation']);

	print_form_header('vblinklist', 'doentries', 0, 1, 'entries');
	print_table_header($vbphrase['vblinklist_entries_awaiting_moderation'], 2, 0, 'entrylist');

	$entries = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_entry
		WHERE status = '0'
		ORDER BY dateline
	");

	$haveentries = false;

	while ($entry = $db->fetch_array($entries))
	{
		if ($haveentries)
		{
			print_description_row('<span class="smallfont">&nbsp;</span>', 0, 2, 'thead');
			print_description_row('<span class="smallfont">&nbsp;</span>', 0, 2, 'thead');
		}
		else
		{
			print_description_row('
					<input type="button" value="' . $vbphrase['validate'] . '" onclick="js_check_all_option(this.form, 1);" class="button" title="' . $vbphrase['validate'] . '" />
					' . '&nbsp;
					<input type="button" value="' . $vbphrase['delete'] . '" onclick="js_check_all_option(this.form, -1);" class="button" title="' . $vbphrase['delete'] . '" />' . '
					&nbsp;
					<input type="button" value="' . $vbphrase['ignore'] . '" onclick="js_check_all_option(this.form, 0);" class="button" title="' . $vbphrase['ignore'] . '" />
				', 0, 2, 'thead', 'center');
		}

		if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
		{
			print_label_row('<b>' . $vbphrase['posted_by'] . '</b>', iif($entry['userid'], '<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . "do=viewuser&u=$entry[userid]\" target=\"_blank\">$entry[username]</a>", $vbphrase['guest']));
		}
		else
		{
			print_label_row('<b>' . $vbphrase['posted_by'] . '</b>', iif($entry['userid'], '<a href="../' . $vbulletin->config['Misc']['admincpdir'] . '/user.php?' . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$entry[userid]\" target=\"_blank\">$entry[username]</a>", $vbphrase['guest']));
		}

		print_label_row('<b>' . $vbphrase['vblinklist_history_entry'] . '</b>', '<a href="../vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . "do=showentry&amp;catid=$entry[categoryid]&amp;id=$entry[id]\" target=\"_blank\">$entry[name]</a>");
		print_label_row('<b>' . $vbphrase['vblinklist_category'] . '</b> ', '<a href="../vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . "do=showcat&amp;catid=$entry[categoryid]\" target=\"_blank\">" . $vbulletin->vblinklist['categories']["$entry[categoryid]"]['name'] . "</a>");

		print_input_row($vbphrase['title'], "entrytitle[$entry[id]]", $entry['name'], 0, 70);
		print_textarea_row($vbphrase['vblinklist_description'], "entrypagetext[$entry[description]]", $entry['description'], 15, 70);

		print_label_row($vbphrase['action'], "
				<label for=\"val_$entry[id]\"><input type=\"radio\" name=\"entryaction[$entry[id]]\" value=\"1\" id=\"val_$entry[id]\" tabindex=\"1\" />" . $vbphrase['validate'] . "</label>
				<label for=\"del_$entry[id]\"><input type=\"radio\" name=\"entryaction[$entry[id]]\" value=\"-1\" id=\"del_$entry[id]\" tabindex=\"1\" />" . $vbphrase['delete'] . "</label>" . "
				<label for=\"ign_$entry[id]\"><input type=\"radio\" name=\"entryaction[$entry[id]]\" value=\"0\" id=\"ign_$entry[id]\" tabindex=\"1\"  checked=\"checked\" />" . $vbphrase['ignore'] . "</label>
			", '', 'top', 'entryaction');

		$haveentries = true;
	}

	if (!$haveentries)
	{
		print_description_row($vbphrase['vblinklist_no_entries_awaiting_moderation']);
		print_table_footer();
	}
	else
	{
		print_submit_row();
	}
}

// ########################################################################
// finally blow actions for entries to be moderated
if ($_POST['do'] == 'doentries')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'entryaction'     => TYPE_ARRAY_INT
	));

	foreach ($vbulletin->GPC['entryaction'] AS $id => $action)
	{
		if ($action == 1)
		{
			// activate entry
			$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_entry SET
				status = '1'
				WHERE id = '" . intval($id) . "'
			");
		}
		else if ($action == -1)
		{
			// delete entry
			$deleteentry = $db->query_write("
				DELETE FROM " . TABLE_PREFIX . "vblinklist_entry
				WHERE id = '" . intval($id) . "'
			");
		}
	}

	// actualize datastore
	build_vblinklist_datastore(true);

	define('CP_REDIRECT', 'vblinklist.php?do=entries');
	print_stop_message('vblinklist_moderated_entries_successfully');
}

// ########################################################################
print_cp_footer();
?>
