<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname/filename: class_dm_vblinklist_entry.php		      # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager'))
{
	exit;
}

/**
* Class to do data save/delete operations for entries
*/
class vB_DataManager_vBLinklist_Entry extends vB_DataManager
{
	/**
	* Array of recognised and required fields
	*
	* @var	array
	*/
	var $validfields = array(
		'id'			=> array(TYPE_UINT,	REQ_INCR, 	'return ($data > 0);'),
		'name'			=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'linkurl'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'banner'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'description'		=> array(TYPE_STR,	REQ_YES,	VF_METHOD),
		'userid'		=> array(TYPE_UINT,	REQ_NO,		VF_METHOD, 	'verify_userid'),
		'username'		=> array(TYPE_STR,	REQ_NO),
		'dateline'		=> array(TYPE_UNIXTIME,	REQ_AUTO),
		'lastupdate'		=> array(TYPE_UNIXTIME,	REQ_NO),
		'categoryid'		=> array(TYPE_UINT,	REQ_YES,	VF_METHOD),
		'status'		=> array(TYPE_INT,	REQ_NO),
		'ipaddress'		=> array(TYPE_STR,	REQ_AUTO),
		'categoryid'		=> array(TYPE_INT,	REQ_NO),
		'lastupdater'		=> array(TYPE_STR, 	REQ_NO),
		'lastupdaterid'		=> array(TYPE_INT, 	REQ_NO),
		'image'			=> array(TYPE_INT, 	REQ_NO),
		'imagename'		=> array(TYPE_STR, 	REQ_NO),
		'meta_name'		=> array(TYPE_STR, 	REQ_YES,	VF_METHOD),
		'meta_keywords'		=> array(TYPE_STR, 	REQ_YES,	VF_METHOD),
		'meta_description'	=> array(TYPE_STR, 	REQ_YES,	VF_METHOD),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable
	* in the registry with the definitions.
	*
	* @var	array
	*/
	var $bitfields = array();

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'vblinklist_entry';

	/**
	* Array of entryfields
	*
	* @var	array
	*/
	var $vblinklist_entry = array();

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('id = %1$d', 'id');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to
	*				have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vB_DataManager_vBLinklist_Entry(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('vblinklist_entrydata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that a user id is valid and exists
	*
	* @param	integer	User ID
	*
	* @return	boolean
	*/
	function verify_userid(&$userid)
	{
		if ($userid AND $user = $this->dbobject->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid = " . intval($userid)))
		{
			$this->set('username', $user['username']);
			return true;
		}
		else
		{
			$this->error('invalid_user_specified');
			return false;
		}
	}

	/**
	* Verifies the title/name of an entry
	*
	* @param	string	Name/Title of the Entry
	*
	* @return	boolean
	*/
	function verify_name(&$name)
	{
		// replace html-encoded spaces with actual spaces
		$name = preg_replace('/&#(0*32|x0*20);/', ' ', $name);
		$name = trim($name);

		$titlelen = vbstrlen($name);
		if ($titlelen < $this->registry->options['vblinklist_titleminchars'])
		{
			$this->error('vblinklist_entry_name_too_short', $this->registry->options['vblinklist_titleminchars'], $titlelen);
			return false;
		}
		else if ($titlelen > $this->registry->options['vblinklist_titlemaxchars'])
		{
			$this->error('vblinklist_entry_name_too_long', $this->registry->options['vblinklist_titlemaxchars'], $titlelen);
			return false;
		}

		$name = htmlspecialchars_uni($name);

		if ($name != fetch_censored_text($name))
		{
			$this->error('vblinklist_entry_name_contains_censored_words');
			return false;
		}

		return true;
	}

	/**
	* Verifies the linkurl of an entry
	*
	* @param	string	linkurl of the Entry
	*
	* @return	boolean
	*/
	function verify_linkurl(&$linkurl)
	{
		// replace html-encoded spaces with actual spaces
		$linkurl = preg_replace('/&#(0*32|x0*20);/', ' ', $linkurl);
		$linkurl = trim($linkurl);

		$linkurl = htmlspecialchars_uni($linkurl);

		if ($linkurl != fetch_censored_text($linkurl))
		{
			$this->error('vblinklist_entry_name_contains_censored_words');
			return false;
		}

		// check URL for complete insert
		if ($linkurl)
		{
			if(!preg_match('/^(http|https|ftp)\:\/\/([a-z0-9-\.]+)[a-z0-9-]+\.[a-z]{2,4}\b/', $linkurl))
			{ 
				$linkurl = 'http://' . $linkurl; 
			}
		}
		return true;
	}

	/**
	* Verifies the banner url of an entry
	*
	* @param	string	banner url of the Entry
	*
	* @return	boolean
	*/
	function verify_banner(&$banner)
	{
		// replace html-encoded spaces with actual spaces
		$banner = preg_replace('/&#(0*32|x0*20);/', ' ', $banner);
		$banner = trim($banner);

		$banner = htmlspecialchars_uni($banner);

		if ($banner != fetch_censored_text($banner))
		{
			$this->error('vblinklist_entry_name_contains_censored_words');
			return false;
		}

		// check URL for complete insert
		if ($banner)
		{
			if(!preg_match('/^(http|https|ftp)\:\/\/([a-z0-9-\.]+)[a-z0-9-]+\.[a-z]{2,4}\b/', $banner))
			{ 
				$banner = 'http://' . $banner; 
			}
		}
		return true;
	}

	/**
	* Verifies the id of the category this entry belongs to
	*
	* @param	string	Category-ID
	*
	* @return	boolean
	*/
	function verify_categoryid(&$catid)
	{
		if (!($category = fetch_catinfo($catid)))
		{
			$this->error('vblinklist_invalid_category_specified');
			return false;
		}

		return true;
	}


	/**
	* Verifies the meta description of an entry
	*
	* @param	string	Description of the meta information
	*
	* @return	boolean
	*/
	function verify_meta_description(&$metadesc)
	{
		require_once(DIR . '/includes/functions_newpost.php');

		$metadesc = preg_replace('/&#(0*32|x0*20);/', ' ', $metadesc);
		$metadesc = trim($metadesc);

		// add # to color tags using hex if it's not there
		$metadesc = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $metadesc);

		// strip alignment codes that are closed and then immediately reopened
		$metadesc = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $metadesc);

		// censor main message text
		$metadesc = fetch_censored_text($metadesc);

		// parse URLs in message text
		if ($this->info['parseurl'])
		{
			$metadesc = convert_url_to_bbcode($metadesc);
		}

		$metadesc = fetch_no_shouting_text($metadesc);

		return true;
	}

	/**
	* Verifies the meta description of an entry
	*
	* @param	string	Keywords of the meta information
	*
	* @return	boolean
	*/
	function verify_meta_keywords(&$metakeywords)
	{
		require_once(DIR . '/includes/functions_newpost.php');

		$metakeywords = preg_replace('/&#(0*32|x0*20);/', ' ', $metakeywords);
		$metakeywords = trim($metakeywords);

		// add # to color tags using hex if it's not there
		$metakeywords = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $metakeywords);

		// strip alignment codes that are closed and then immediately reopened
		$metakeywords = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $metakeywords);

		// censor main message text
		$metakeywords = fetch_censored_text($metakeywords);

		// parse URLs in message text
		if ($this->info['parseurl'])
		{
			$metakeywords = convert_url_to_bbcode($metakeywords);
		}

		$metakeywords = fetch_no_shouting_text($metakeywords);

		return true;
	}

	/**
	* Verifies the meta description of an entry
	*
	* @param	string	Name of the meta information
	*
	* @return	boolean
	*/
	function verify_meta_name(&$metaname)
	{
		require_once(DIR . '/includes/functions_newpost.php');

		$metaname = preg_replace('/&#(0*32|x0*20);/', ' ', $metaname);
		$metaname = trim($metaname);

		// add # to color tags using hex if it's not there
		$metaname = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $metaname);

		// strip alignment codes that are closed and then immediately reopened
		$metaname = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $metaname);

		// censor main message text
		$metaname = fetch_censored_text($metaname);

		// parse URLs in message text
		if ($this->info['parseurl'])
		{
			$metaname = convert_url_to_bbcode($metaname);
		}

		$metaname = fetch_no_shouting_text($metaname);

		return true;
	}




	/**
	* Verifies the description of an entry
	*
	* @param	string	Description of the Entry
	*
	* @return	boolean
	*/
	function verify_description(&$desc)
	{
		$textlen = vbstrlen(strip_bbcode($desc, $this->registry->options['ignorequotechars']));
		if ($textlen < $this->registry->options['vblinklist_entryminchars'])
		{
			$this->error('tooshort', $this->registry->options['vblinklist_entryminchars']);
			return false;
		}
		else if ($textlen > $this->registry->options['vblinklist_entrymaxchars'])
		{
			$this->error('toolong', $textlen, $this->registry->options['vblinklist_entryminchars']);
			return false;
		}

		require_once(DIR . '/includes/functions_newpost.php');

		$desc = preg_replace('/&#(0*32|x0*20);/', ' ', $desc);
		$desc = trim($desc);

		// add # to color tags using hex if it's not there
		$desc = preg_replace('#\[color=(&quot;|"|\'|)([a-f0-9]{6})\\1]#i', '[color=\1#\2\1]', $desc);

		// strip alignment codes that are closed and then immediately reopened
		$desc = preg_replace('#\[/(left|center|right)]((\r\n|\r|\n)*)\[\\1]#si', '\\2', $desc);

		// censor main message text
		$desc = fetch_censored_text($desc);

		// parse URLs in message text
		if ($this->info['parseurl'])
		{
			$desc = convert_url_to_bbcode($desc);
		}

		$desc = fetch_no_shouting_text($desc);

		return true;
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if (!$this->condition)
		{
			$this->set('dateline', TIMENOW);
			$this->set('lastupdate', TIMENOW);
		}
		else
		{
#			$this->set('dateline', TIMENOW);
			$this->set('lastupdate', TIMENOW);

			if (!$this->set_fields['lastupdaterid'])
			{
				($hook = vBulletinHook::fetch_hook('vblinklist_query_lastupdater')) ? eval($hook) : false;

				if ($this->registry->userinfo['userid'])
				{
					$this->set('lastupdater', $this->registry->userinfo['username']);
					$this->set('lastupdaterid', $this->registry->userinfo['userid']);
				}
				else
				{
					// we don't know anything about updates, so just keep the timestamp?
					$this->set('lastupdater', '');
					$this->set('lastupdaterid', 0);
				}
			}
		}

		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$return_value = true;

		($hook = vBulletinHook::fetch_hook('vblinklist_entrydata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	Returns true if query successfully passed
	*/
	function post_save_once($doquery = true)
	{
		// completely rebuild datastore
		require_once(DIR . '/includes/adminfunctions_vblinklist.php');
		build_vblinklist_datastore();

		require_once (DIR . '/vb/search/indexcontroller/queue.php');
		vB_Search_Indexcontroller_Queue::indexQueue('vBLinklist', 'LinklistEntry', 'index', $this->fetch_field('id'));

		($hook = vBulletinHook::fetch_hook('vblinklist_entrydata_postsave')) ? eval($hook) : false;

		return true;
	}

	/**
	* Set entryfields
	*
	* @param	array	content of entrfields
	*
	* @return	string customfields
	*/
	function set_entryfields(&$values)
	{
		global $vbphrase;

		if (!is_array($values))
		{
			$this->error('::$values for profile fields is not an array::');
			return false;
		}

		$catid = $this->fetch_field('categoryid');

		if (!$catid)
		{
			$this->error('::Categoryid not set!::');
		}

		if (empty($this->registry->vblinklistentryfields['entryfields']))
		{
			return false;
		}

		foreach ($this->registry->vblinklistentryfields['entryfields'] AS $id => $profilefield)
		{
			if ($profilefield['entryfieldcategoryid'] != $catid)
			{
				continue;
			}

			// main Value
			$varname = 'field' . $id;
			$value =& $values["$varname"];

			// optional Value
			$optionalvar = 'field' . $id . '_opt';
			$value_opt =& $values["$optionalvar"];

			// text box / text area
			if ($profilefield['type'] == 'input' OR $profilefield['type'] == 'textarea')
			{
				$value = trim(substr(fetch_censored_text($value), 0, $profilefield['maxlength']));
				$value = (empty($value) AND $value != '0') ? false : $value;

				$customfields .= "$profilefield[title] : $value\n";
			}
			else if ($profilefield['type'] == 'radio' OR $profilefield['type'] == 'select')
			{
				if ($profilefield['optional'] AND $value_opt != '')
				{
					$value = trim(substr(fetch_censored_text($value_opt), 0, $profilefield['maxlength']));
					$value = (empty($value) AND $value != '0') ? false : $value;
				}
				else
				{
					$data = unserialize($profilefield['data']);
					$value -= 1;
					if (isset($data["$value"]))
					{
						$value = unhtmlspecialchars(trim($data["$value"]));
					}
					else
					{
						$value = false;
					}
				}
				$customfields .= "$profilefield[title] : $value\n";
			}
			else if (($profilefield['type'] == 'checkbox' OR $profilefield['type'] == 'select_multiple'))
			{
				if (is_array($value))
				{
					if (($profilefield['size'] == 0) OR (sizeof($value) <= $profilefield['size']))
					{
						$data = unserialize($profilefield['data']);

						$bitfield = 0;
						$cfield = '';
						foreach($value AS $key => $val)
						{
							$val--;
							$bitfield += pow(2, $val);
							$cfield .= (!empty($cfield) ? ', ' : '') . $data["$val"];
						}
						$value = $bitfield;
					}
					else
					{
						$this->error('checkboxsize', $profilefield['size'], $profilefield['title']);
						$value = false;
					}
					$customfields .= "$profilefield[title] : $cfield\n";
				}
				else
				{
					$value = false;
				}
			}
			else
			{
				continue;
			}

			if ($profilefield['required'] AND $value === false)
			{
				$this->error('required_field_x_missing_or_invalid', $profilefield['title']);
			}

			$this->setfields["$id"] = true;
			$this->entryfield["$id"] = htmlspecialchars_uni($value);
		}

		return $customfields;
	}

	/**
	* Saves the data from the object into the specified database tables
	*
	* @param	boolean	Do the query?
	* @param	mixed	Whether to run the query now; see db_update() for more info
	*
	* @return	integer	Returns the user id of the affected data
	*/
	function save($doquery = true, $delayed = false)
	{
		if ($this->has_errors())
		{
			return false;
		}

		if (!$this->pre_save($doquery))
		{
			return 0;
		}

		if ($this->condition)
		{
			$this->db_update(TABLE_PREFIX, 'vblinklist_entry', $this->condition, $doquery, $delayed);
			$eid = $this->existing['id'];
			$this->vblinklist_entry['id'] = $this->existing['id'];
		}
		else
		{
			$eid = $this->db_insert(TABLE_PREFIX, $this->table, $doquery);
			$this->vblinklist_entry['id'] = $eid;
		}

		$this->post_save_each($doquery);
		$this->post_save_once($doquery);

		return $eid;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	Returns true if query successfully passed
	*/
	function post_delete($doquery = true)
	{
		require_once (DIR . '/vb/search/indexcontroller/queue.php');
		vB_Search_Indexcontroller_Queue::indexQueue('vBLinklist', 'LinklistEntry', 'delete', $this->fetch_field('id'));

		($hook = vBulletinHook::fetch_hook('vblinklist_entrydata_delete')) ? eval($hook) : false;

		$lastentry = $this->dbobject->query_first("
			SELECT id, name, categoryid, entry.userid, IF(NOT ISNULL(user.userid), user.username, entry.username) AS username, dateline
			FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = entry.userid)
			WHERE entry.categoryid = '" . $this->existing['categoryid'] . "'
			ORDER BY entry.dateline DESC
			LIMIT 1
		");

		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['entriesamount']--;
		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['lastentryid'] = $lastentry['id'];
		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['lastpostusername'] = $lastentry['username'];
		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['lastpostuserid'] = $lastentry['userid'];
		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['lastentryname'] = $lastentry['name'];
		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['lastentrydateline'] = $lastentry['dateline'];
		$this->registry->vblinklist['categories'][$this->existing['categoryid']]['lastentrycatid'] = $lastentry['categoryid'];

		build_datastore('vblinklist', serialize($this->registry->vblinklist), true);

		$deletepparsed = $this->dbobject->query_write("
			DELETE FROM " . TABLE_PREFIX . "postparsed
			WHERE MATCH pagetext_html AGAINST ('" . $this->dbobject->escape_string(htmlspecialchars_uni($this->existing['name'])) . "' IN BOOLEAN MODE)
		");

		return true;
	}
}

/*======================================================================*\
|| ####################################################################
|| # $Revision: 354 $
|| # $Date: 2009-01-13 19:42:08 +0100 (Di, 13. Jan 2009) $
|| ####################################################################
\*======================================================================*/
?>