<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$globaltemplates = array();
$phrasegroups = array();
$specialtemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_misc.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_bootstrap_framework.php');
vB_Bootstrap_Framework::init();

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// alte cat lesen
$result = $db->query_read("
	SELECT cats.*, lang.*
	FROM " . TABLE_PREFIX . "vbcmslinkscats AS cats
	LEFT JOIN " . TABLE_PREFIX . "vbcmslinkscatslang AS lang ON(cats.catid = lang.linkcatid )
	WHERE lang.langid = 1
	ORDER BY cats.catid
");

$i = 1;
while ($row = $db->fetch_array($result))
{
	echo $row['catid'] . ': ' . $row['langtitle'] . '<br/>';

	// neue cat schreiben
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_category (id, parentid, displayorder, name, description, status, defaulticon, definedicon, groupshow, groupshowlist, allowhtml, allowbbcode, allowsmilies, linkurl, banner, thumbnail, picturelocation, image, meta)
	VALUES (
		'" . intval($row['catid']) . "',
		'-1',
		'" . intval($i) . "',
		'" . $db->escape_string($row['langtitle']) . "',
		'" . $db->escape_string($row['langdesc']) . "',
		'1',
		'1',
		'',
		'1',
		'',
		'0',
		'1',
		'1',
		'1',
		'1',
		'1',
		'',
		'1',
		'1'
	)");

	$i++;
}

echo '<br/><br/><br/>';

// alte Eintrge fr cat lesen
$entry = $db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "vbcmslinks
	ORDER BY linkid
");

while ($link = $db->fetch_array($entry))
{
	echo $link['linkid'] . ': ' . $link['linktitle'] . '<br/>';

	// neue eintrge fr cat schreiben
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_entry (id, name, description, userid, username, dateline, lastupdate, categoryid, status, ipaddress, views, votenum, votetotal, linkurl, banner, lastupdater, lastupdaterid, image, imagename, meta_name, meta_keywords, meta_description)
	VALUES (
		'" . intval($link['linkid']) . "',
		'" . $db->escape_string($link['linktitle']) . "',
		'" . $db->escape_string($link['description']) . "',
		'" . intval($link['userid']) . "',
		'" . $db->escape_string($link['username']) . "',
		'" . intval($link['date']) . "',
		'" . intval($link['date']) . "',
		'" . intval($link['catid']) . "',
		'1',
		'" . $db->escape_string($link['ipaddress']) . "',
		'" . intval($link['hits']) . "',
		'" . intval($link['votenum']) . "',
		'" . intval($link['votetotal']) . "',
		'" . $db->escape_string($link['link']) . "',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		''
	)");
}

?>
