<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname: linklistentry.php                                     # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

require_once (DIR . '/vb/search/type.php');

/**
 * @package vBulletin
 * @subpackage Search
 */
class vBLinklist_Search_Type_LinklistEntry extends vB_Search_Type
{
	public function fetch_validated_list($user, $ids, $gids)
	{
		$list = array_fill_keys($ids, false);
		$items = vBLinklist_Search_Result_LinklistEntry::create_array($ids);
		foreach ($items as $id => $item)
		{
			if ($item->can_search($user))
			{
				$list[$id] = $item;
			}
		}
		return array('list' => $list, 'groups_rejected' => array());
	}

	/**
	 * @param unknown_type $id
	 */
	public function create_item($id)
	{
		return vBLinklist_Search_Result_LinklistEntry::create($id);
	}

	/**
	 * You can create from an array also
	 *
	 * @param integer $id
	 * @return object
	 */
	public function create_array($ids)
	{
		return vBLinklist_Search_Result_LinklistEntry::create_array($ids);
	}

	public function get_display_name()
	{
		return new vB_Phrase('search', 'searchtype_linklist_entries');
	}

	public function additional_pref_defaults()
	{
		return array(
			'query'       => '',
			'titleonly'   => 0,
			'nocache'     => '',
			'searchuser'  => '',
			'exactname'   => '',
		);
	}


	/**
	 * This function composes the html to display the user interface for this
	 * search type
	 *
	 * @param mixed $prefs : the array of user preferences
	 * @param mixed $contenttypeid : the content type for which we are going to search
	 * @param array registers : any additional elements to be registered. These are	just passed to the template
	 * @param string $template_name : name of the template to use for display. We have a default template.
	 * @param boolean $groupable : a flag to tell whether the interface should display grouping option(s).
	 * @return $html: complete html for the search elements
	 */
	public function listUi($prefs = null, $contenttypeid = null, $registers = null, $template_name = null)
	{
		global $vbulletin, $vbphrase;

		if (! isset($template_name))
		{
			$template_name = 'search_input_default';
		}

		if (! isset($contenttypeid))
		{
			$contenttypeid = vB_Types::instance()->getContentTypeID('vBLinklist_LinklistEntry');
		}

		$template = vB_Template::create($template_name);
		$template->register('securitytoken', $vbulletin->userinfo['securitytoken']);
		$template->register('class', $this->get_display_name());
		$template->register('contenttypeid',$contenttypeid);

		$prefsettings = array(
			'select'=> array('searchdate', 'beforeafter', 'titleonly', 'sortby', 'sortorder'),
			'cb' => array('exactname'),
		 	'value' => array('query', 'searchuser'));
		$this->setPrefs($template, $prefs, $prefsettings);
		vB_Search_Searchtools::searchIntroRegisterHumanVerify($template);

		if (isset($registers) AND is_array($registers) )
		{
			foreach($registers as $key => $value)
			{
				$template->register($key, htmlspecialchars_uni($value));
			}
		}
		return $template->render();
	}

	public function add_advanced_search_filters($criteria, $registry)
	{
		// we don't have any advanced filters at this time
	}

	public function get_db_query_info($fieldname)
	{
		// currently we don't have any attributes that would require joining our tables
		return false;
	}

	public function __construct()
	{
		parent::__construct();
	}

	protected $package = "vBLinklist";
	protected $class = "LinklistEntry";

	protected $type_globals = array ();
}

?>