<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)# ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname/filename: functions_vblinklist.php		# ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen# ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in# ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Fetch informations of defined entry
*
* @param	integer	entryid of specific entry
*
* @return 	boolean	status of information if entry exists or not
*/
function fetch_linkinfo(&$entryid)
{
	global $db;

	if ($existingentry = $db->query_first("
		SELECT entry.*
		FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
		WHERE id = '" . intval($entryid) . "'
	"))
	{
		return $existingentry;
	}
	else
	{
		return false;
	}
}

/**
* Fetch informations of defined category (html/bbcode/etc)
*
* @param	integer	catid of specific categorie
*
* @return 	boolean	status of information
*/
function &fetch_linkcatinfo(&$catid)
{
	global $vbulletin;

	if ($vbulletin->vblinklist['categories']["$catid"])
	{
		return $vbulletin->vblinklist['categories']["$catid"];
	}
	else
	{
		return false;
	}
}

/**
* Actualize datastore with informations about a new entry in category
*
* @param	integer	catid		id of category
* @param	integer	entryid		id of new entry
* @param	string	username	username from author of new entry
* @param	integer	userid 		userid from author of new entry
* @param	integer	dateline 	timestamp of new entry
*/
/*function datastore_newlink($catid, $entryid, $username, $userid, $dateline)
{
	global $vbulletin;

	$vbulletin->vblinklist['categories']['lastentryuserid']["$catid"] = $userid;
	$vbulletin->vblinklist['categories']['lastentryusername']["$catid"] = $username;
	$vbulletin->vblinklist['categories']['lastentryid']["$catid"] = $entryid;
	$vbulletin->vblinklist['categories']['entrieslastpost']["$catid"]['dateline'] = $dateline;
	$vbulletin->vblinklist['categories']['entriesamount']["$catid"]['anzahl']++;
}
*/
/**
* Actualize datastore with informations about a deleted entry in category
*
* @param	integer	catid	id of category
* @param	integer	entryid	id of new entry
*/
/*function datastore_deletelink($catid, $entryid)
{
	global $vbulletin;

	// is deleted entry an actual entry in datastore?
	if ($vbulletin->vblinklist['categories']["$catid"]['lastentryid'] == $entryid)
	{
		// fetch amount of entries and last entries for each category
		$entries_result = $vbulletin->db->query_first("
			SELECT MAX(dateline) AS dateline
			FROM " . TABLE_PREFIX . "vblinklist_entry
			WHERE categoryid = " . intval($catid) . "
			GROUP BY categoryid
		");

		$vbulletin->vblinklist['categories']['entrieslastpost']["$catid"]['dateline'] = $entries_result['dateline'];

		unset($entries_result);

		// fetch usernames for every last entry
		$userstats_result = $vbulletin->db->query_first("
			SELECT id, categoryid, userid, username
			FROM " . TABLE_PREFIX . "vblinklist_entry
			WHERE categoryid = '" . $catid . "'
			ORDER BY dateline DESC
			LIMIT 1
		");

		$vbulletin->vblinklist['categories']['lastentryuserid']["$catid"] = $userstats_result['userid'];
		$vbulletin->vblinklist['categories']['lastentryusername']["$catid"] = $userstats_result['username'];
		$vbulletin->vblinklist['categories']['lastentryid']["$catid"] = $userstats_result['id'];

		unset($userstats_result);
		unset($lastpostids);
	}

	$vbulletin->vblinklist['categories']['entriesamount']["$catid"]['anzahl']--;
}
*/
/**
* Generates a preview of an entry
*
* @param	array	Message and disablesmilies options
* @param	string	Parse type (user, post or comment)
*
* @return	string	The generated preview
*
*/
function process_link_preview($entry, $type, $attachments = NULL)
{
	global $vbulletin, $vbphrase, $show;

#	require_once(DIR . '/includes/class_bbcode_vblinklist.php');
#	$bbcode_parser = new vB_BbCodeParser_Linklist($vbulletin, fetch_tag_list());

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$bbcode_parser->set_parse_userinfo($vbulletin->userinfo, $vbulletin->userinfo['permissions']);
	$bbcode_parser->attachments = $attachments;

	$previewmessage = $bbcode_parser->parse(
		$entry['message'],
		'nonforum',
		$entry['disablesmilies'] ? 0 : 1,
		false,
		'',
		3,
		false,
		$entry['htmlstate']
	);

	return $previewmessage;
}

/**
* Constructs the rules template for the linklist together with global permissions of vBulletin
*
* @param	array	Array of linklist info
* @param	string	template for constructed rules
*/
function construct_linklist_rules($permissions, $catid)
{
	global $vblinklist_rules, $stylevar, $vbphrase, $vbcollapse, $show, $vbulletin;

	if ($catinfo = fetch_linkcatinfo($catid))
	{
		$do_html = $catinfo['allowhtml'];
		$do_nl2br = !$catinfo['allowhtml'];
		$do_smilies = $catinfo['allowsmilies'];
		$do_bbcode = $do_imgcode = $catinfo['allowbbcode'];
	}

	// bb-codes global
	$bbcodeon = iif($do_bbcode, $vbphrase['on'], $vbphrase['off']);
	$imgcodeon = iif($do_bbcode, $vbphrase['on'], $vbphrase['off']);
	$htmlcodeon = iif($do_html, $vbphrase['on'], $vbphrase['off']);
	$smilieson = iif($do_smilies, $vbphrase['on'], $vbphrase['off']);

	// group-settings/permissions
	$can['postnew'] = $permissions & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_add_link'];
	$can['attachment'] = false;
	$can['editpost'] = $permissions & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link'];

	$templater = vB_Template::create('vblinklist_rules');
		$templater->register('can', $can);
		$templater->register('bbcodeon', $bbcodeon);
		$templater->register('imgcodeon', $imgcodeon);
		$templater->register('htmlcodeon', $htmlcodeon);
		$templater->register('smilieson', $smilieson);
	$vblinklist_rules = $templater->render();
}

/**
* Constructs the jump-dropdown for categories
*
* @param	string	template with catjump
*/
function construct_linklist_catjump($catid)
{
	global $vblinklist_catjump, $stylevar, $vbphrase, $vbcollapse, $show, $vbulletin;

	// if there are categories
	if (count($vbulletin->vblinklist['categories']))
	{
		foreach ($vbulletin->vblinklist['categories'] AS $row)
		{
			// is this category a main category?
			if ($row['parentid'] == -1)
			{
				$mcatname = $vbulletin->vblinklist['categories']["$row[id]"]['name'];
				$tmpcatid = $vbulletin->vblinklist['categories']["$row[id]"]['id'];

				$templater = vB_Template::create('vblinklist_catjumpbitsmain');
					$templater->register('mcatname', $mcatname);
					$templater->register('tmpcatid', $tmpcatid);
				$catjumpbits .= $templater->render();

				foreach ($vbulletin->vblinklist['categories'] AS $subrow)
				{
					if ($subrow['parentid'] == $row['id'])
					{
						$scatname = $vbulletin->vblinklist['categories']["$subrow[id]"]['name'];
						$tmpcatid = $vbulletin->vblinklist['categories']["$subrow[id]"]['id'];
						$catdepth = '1';

						$templater = vB_Template::create('vblinklist_catjumpbitssub');
							$templater->register('scatname', $scatname);
							$templater->register('tmpcatid', $tmpcatid);
							$templater->register('catdepth', $catdepth);
						$catjumpbits .= $templater->render();

						foreach ($vbulletin->vblinklist['categories'] AS $subrow2)
						{
							if ($subrow2['parentid'] == $subrow['id'])
							{
								$scatname = $vbulletin->vblinklist['categories']["$subrow2[id]"]['name'];
								$tmpcatid = $vbulletin->vblinklist['categories']["$subrow2[id]"]['id'];
								$catdepth = '2';

								$templater = vB_Template::create('vblinklist_catjumpbitssub');
									$templater->register('scatname', $scatname);
									$templater->register('tmpcatid', $tmpcatid);
									$templater->register('catdepth', $catdepth);
								$catjumpbits .= $templater->render();

								foreach ($vbulletin->vblinklist['categories'] AS $subrow3)
								{
									if ($subrow3['parentid'] == $subrow2['id'])
									{
										$scatname = $vbulletin->vblinklist['categories']["$subrow3[id]"]['name'];
										$tmpcatid = $vbulletin->vblinklist['categories']["$subrow3[id]"]['id'];
										$catdepth = '3';

										$templater = vB_Template::create('vblinklist_catjumpbitssub');
											$templater->register('scatname', $scatname);
											$templater->register('tmpcatid', $tmpcatid);
											$templater->register('catdepth', $catdepth);
										$catjumpbits .= $templater->render();

										foreach ($vbulletin->vblinklist['categories'] AS $subrow4)
										{
											if ($subrow4['parentid'] == $subrow3['id'])
											{
												$scatname = $vbulletin->vblinklist['categories']["$subrow4[id]"]['name'];
												$tmpcatid = $vbulletin->vblinklist['categories']["$subrow4[id]"]['id'];
												$catdepth = '4';

												$templater = vB_Template::create('vblinklist_catjumpbitssub');
													$templater->register('scatname', $scatname);
													$templater->register('tmpcatid', $tmpcatid);
													$templater->register('catdepth', $catdepth);
												$catjumpbits .= $templater->render();
												foreach ($vbulletin->vblinklist['categories'] AS $subrow4)
												{
													if ($subrow5['parentid'] == $subrow4['id'])
													{
														$scatname = $vbulletin->vblinklist['categories']["$subrow5[id]"]['name'];
														$tmpcatid = $vbulletin->vblinklist['categories']["$subrow5[id]"]['id'];
														$catdepth = '5';
		
														$templater = vB_Template::create('vblinklist_catjumpbitssub');
															$templater->register('scatname', $scatname);
															$templater->register('tmpcatid', $tmpcatid);
															$templater->register('catdepth', $catdepth);
														$catjumpbits .= $templater->render();
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	$templater = vB_Template::create('vblinklist_catjump');
		$templater->register('catjumpbits', $catjumpbits);
		$templater->register('tmpcatid', $tmpcatid);
	$vblinklist_catjump .= $templater->render();
}

/**
* Check permissions to show category to specified usergroups
*
* @param	int	id of specified category
* @param	bool	Check perms of parent categories also or not
*
* @return	boolean	true/false if allowed or not
*/
function fetch_linkcatpermission($catid, $rec = true)
{
	global $vbulletin;

	$cat =& fetch_linkcatinfo($catid);

	if (!$rec)
	{
		return ($cat['groupshow'] ? true : is_member_of($vbulletin->userinfo, explode(',', $cat['groupshowlist'])));
	}

	// show this category to this usergroup only?
	if (!$cat['groupshow'])
	{
		if (is_member_of($vbulletin->userinfo, explode(',', $cat['groupshowlist'])))
		{
			return (($cat['parentid'] != -1) ? fetch_linkcatpermission($cat['parentid']) : true);
		}

		return false;
	}
	else
	{
		return (($cat['parentid'] != -1) ? fetch_linkcatpermission($cat['parentid']) : true);
	}
}

/**
* Check for availability/activated vBSEO and perform url to category
*
* @param	string	entry	array with category informations
* @param	string	Appendix to add to the url (e.g. perpage var, page var, etc)
*
* @return	string	url	url to category, either seo-like or standard
*/
function construct_linklist_category_url(&$category, $append = '')
{
	global $vbulletin;

	if ($vbulletin->options['vblinklist_vbseo'] AND defined('VBSEO_ENABLED'))
	{
		$url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $category['id'] . '&amp;cattitle=' . vbseo_filter_text($category['name']) . $append;
	}
	else
	{
		$url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $category['id'] . $append;
	}

	$category['url'] = $url;

	return $url;
}

/**
* Check for availability/activated vBSEO and perform url to entry
*
* @param	string	entry	array with entry informations
* @param	string	Type of the URL to build (shownetry, pdf, report, etc)
*
* @return	string	url	url to entry, either seo-like or standard
*/
function construct_linklist_entry_url(&$entry, $type = 'showentry')
{
	global $vbulletin;

	if ($vbulletin->options['vblinklist_vbseo'] AND defined('VBSEO_ENABLED'))
	{
		$cat =& $vbulletin->vblinklist['categories'][($entry['catid'] ? $entry['catid'] : $entry['categoryid'])];

		$url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . $type . '&amp;id=' . $entry['id'] . '&amp;title=' . vbseo_filter_text(($entry['entryname'] ? $entry['entryname'] : $entry['name'])) . '&amp;catid=' . $cat['id'] . '&amp;cattitle=' . vbseo_filter_text($cat['name']);
	}
	else
	{
		$url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . $type . '&amp;id=' . $entry['id'];
	}

	if ($type == 'showentry')
	{
		$entry['url'] = $url;
	}
	else
	{
		$entry["{$type}url"] = $url;
	}

	return $url;
}

/**
* Check for availability/activated vBSEO and perform urls to entry
*
* @param		entry	array with entry informations
* @return		main url to the entry
*/
function construct_linklist_entry_urls(&$entry)
{
	global $vbulletin;

	$types = array(
		'showentry',
		'report'
	);

	foreach ($types AS $type)
	{
		if ($type == 'showentry')
		{
			$url = construct_linklist_entry_url($entry, $type);
		}
		else
		{
			construct_linklist_entry_url($entry, $type);
		}
	}

	return $url;
}

/**
* Logs the moderation actions that are being performed on the linklist
*
* @param	array	Array of information indicating on what data the action was performed
* @param	integer	This value corresponds to the action that was being performed
* @param	string	Other moderator parameters
*/
function vblinklist_moderator_action(&$loginfo, $logtype, $action = '')
{
	require_once(DIR . '/includes/functions_log_error.php');

	global $vbulletin;

	$modlogsql = array();

	if ($result = fetch_modlogtypes($logtype))
	{
		$logtype =& $result;
	}

	if (is_array($loginfo[0]))
	{
		foreach ($loginfo AS $index => $log)
		{
			if (is_array($action))
			{
				$action = serialize($action);
			}
			else if ($log['username'] OR $log['title'])
			{
				$action = serialize(array($log['title'], $log['username']));
			}
			$log['id1'] = $log['vblinklist_userid'] ? $log['vblinklist_userid'] : $log['id1'];
			$log['id2'] = $log['entryid'] ? $log['entryid'] : $log['id2'];
			$log['id4'] = $log['attachmentid'] ? $log['attachmentid'] : $log['id4'];

			$modlogsql[] = "(" . intval($logtype) . ", " . intval($log['userid']) . ", " . TIMENOW . ", " . intval($log['id1']) . ", " . intval($log['id2']) . ", " . intval($log['id3']) . ", " . intval($log['id4']) . ", " . intval($log['id5']) . ", '" . $vbulletin->db->escape_string($action) . "', '" . $vbulletin->db->escape_string(IPADDRESS) . "', 'vblinklist')";
		}

		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "moderatorlog (type, userid, dateline, id1, id2, id3, id4, id5, action, ipaddress, product) VALUES " . implode(', ', $modlogsql));
	}
	else
	{
		$moderatorlog['userid'] =& $vbulletin->userinfo['userid'];
		$moderatorlog['dateline'] = TIMENOW;

		$moderatorlog['type'] = intval($logtype);

		$moderatorlog['id1'] = $loginfo['vblinklist_userid'] ? $loginfo['vblinklist_userid'] : ($loginfo['userid'] ? intval($loginfo['userid']) : intval($loginfo['id1']));
		$moderatorlog['id2'] = $loginfo['entryid'] ? intval($loginfo['entryid']) : intval($loginfo['id2']);
		$moderatorlog['id4'] = $loginfo['attachmentid'] ? intval($loginfo['attachmentid']) : intval($loginfo['id4']);
		$moderatorlog['product'] = 'vblinklist';
		$moderatorlog['ipaddress'] = IPADDRESS;

		if (is_array($action))
		{
			$action = serialize($action);
		}
		$moderatorlog['action'] = $action;

		// insert query
		$vbulletin->db->query_write(fetch_query_sql($moderatorlog, 'moderatorlog'));
	}
}

/**
* Builds the Like button for Facebook
*
* @return	string	renedered template for the like-button
*/
function construct_vblinklist_fblikebutton()
{
	global $show, $vbulletin, $entry;

	// make sure like button is enabled for the given page
	if ((THIS_SCRIPT == 'vblinklist' AND $vbulletin->options['vblinklist_facebooklike']))
	{
		$show['fb_likebutton'] = true;
		$templater = vB_Template::create('facebook_likebutton');
		$fbcanonicalurl = create_full_url('vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . intval($entry['id']) . '&amp;catid=' . intval($entry['categoryid']));
		$templater->register('href', $fbcanonicalurl);

		return $templater->render();
	}

	// if like button is not enabled, return null data
	else
	{
		$show['fb_likebutton'] = false;
		return '';
	}
}

/**
* Builds the html for thumbnail service
*
* @return	string	renedered template
*/
function construct_vblinklist_thumbnail()
{
	global $show, $vbulletin, $entry, $linkentry_thumbnail;

	switch ($vbulletin->options['vblinklist_thumbnail_service'])
	{
		case '0':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src="http://www.thumbshots.de/cgi-bin/show.cgi?url=' . $entry['linkurl'] . '" border="0" onload="if (this.width>50) this.border=1; this.alt=\'Vorschau bei Thumbshots.de\';" />';
			$linkentry_thumbnail = 'http://www.thumbshots.de/cgi-bin/show.cgi?url=' . $entry['linkurl'] . '&amp;size=20';
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '1':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src="http://www.mr-thumb.de/kunterbunt.php?url=' . $entry['linkurl'] . '&amp;size=120" />';
			$linkentry_thumbnail = 'http://www.mr-thumb.de/kunterbunt.php?url=' . $entry['linkurl'] . '&amp;size=120';
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '2':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src="http://www.mr-thumb.de/kunterbunt.php?url=' . $entry['linkurl'] . '&amp;size=200" />';
			$linkentry_thumbnail = 'http://www.mr-thumb.de/kunterbunt.php?url=' . $entry['linkurl'] . '&amp;size=200';
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '3':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src="http://image.thumber.de/?size=M&amp;url=' . $entry['linkurl'] . '" />';
			$linkentry_thumbnail = 'http://image.thumber.de/?size=M&amp;url=' . $entry['linkurl'];
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '4':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src="http://www.artviper.net/screenshots/screener.php?url=' . $entry['linkurl'] . '&amp;w=120&hamp;=90&amp;sdx=1024&map;sdy=768&amp;q=90&amp;userID=' . $vbulletin->options['vblinklist_thumbnail_parameter_1'] . '&amp;hash=' . md5($entry['linkurl'] . $vbulletin->options['vblinklist_thumbnail_parameter_1'] . $vbulletin->options['vblinklist_thumbnail_parameter_2']) . '" />';
			$linkentry_thumbnail = 'http://www.artviper.net/screenshots/screener.php?url=' . $entry['linkurl'] . '&amp;w=120&hamp;=90&amp;sdx=1024&map;sdy=768&amp;q=90&amp;userID=' . $vbulletin->options['vblinklist_thumbnail_parameter_1'] . '&amp;hash=' . md5($entry['linkurl'] . $vbulletin->options['vblinklist_thumbnail_parameter_1'] . $vbulletin->options['vblinklist_thumbnail_parameter_2']);
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '5':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src=http://www.m-software.de/screenshot/Screenshot.png?url=' . $entry['linkurl'] . '&scale=6" />';
			$linkentry_thumbnail = 'http://www.m-software.de/screenshot/Screenshot.png?url=' . $entry['linkurl'] . '&scale=6';
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '6':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = '<img src=http://open.thumbshots.org/image.aspx?url=' . $entry['linkurl'] . '" />';
			$linkentry_thumbnail = 'http://open.thumbshots.org/image.aspx?url=' . $entry['linkurl'];
			$templater->register('service_url', $service_url);
			return $templater->render();
		case '7':
			$templater = vB_Template::create('vblinklist_thumbnail_service');
			$service_url = $vbulletin->options['vblinklist_thumbnail_servicelink'];
			$service_url = str_replace("{1}", $entry['linkurl'], $service_url);
			$templater->register('service_url', $service_url);
			return $templater->render();
		default:
			break;
	}
}

/**
* Builds the backlink html for thumbnail service
*
* @return	string	renedered template
*/
function construct_vblinklist_thumbnail_backlink()
{
	global $show, $vbulletin, $entry;

	$show['thumbnail_backlink'] = true;

	switch ($vbulletin->options['vblinklist_thumbnail_service'])
	{
		case '0':
			$templater = vB_Template::create('vblinklist_thumbnail_backlink');
			$backlink_url = '<a href="http://www.thumbshots.de/" target="_blank"><img height="16" alt="Kostenlose Screenshots Ihrer Webseite von Thumbshots.de" src="http://www.thumbshots.de/images/thumbshots_2007.png" width="80" border="0" /></a>';
			$templater->register('backlink_url', $backlink_url);
			return $templater->render();
		case '1':
		case '2':
			$templater = vB_Template::create('vblinklist_thumbnail_backlink');
			$backlink_url = '<a href="http://www.mr-thumb.de" target="_blank" title="Thumbshots von Mr-Thumb Free Thumbnail Service"><img border="0" src="http://www.mr-thumb.de/images/button.gif" width="80" height="15" alt="Mr-Thumb Free Thumbnail Service"></a>';
			$templater->register('backlink_url', $backlink_url);
			return $templater->render();
		case '3':
			$templater = vB_Template::create('vblinklist_thumbnail_backlink');
			$backlink_url = '<a target="_blank" href="http://thumber.de" title="Thumbshots by Thumber.de">Thumbshots</a>';
			$templater->register('backlink_url', $backlink_url);
			return $templater->render();
		case '4':
			$templater = vB_Template::create('vblinklist_thumbnail_backlink');
			$backlink_url = '<a href="http://www.artviper.net" title="artViper designstudio">thumbnails by artViper designstudio</a>';
			$templater->register('backlink_url', $backlink_url);
			return $templater->render();
		case '5':
			$templater = vB_Template::create('vblinklist_thumbnail_backlink');
			$backlink_url = '<a href="http://www.m-software.de/thumbshots.html"> <img src="http://www.m-software.de/thumbshots/thumshots-icon.gif" alt="FreeThumbshots by M-Software.de" width="80" height="15" border="0"></a>';
			$templater->register('backlink_url', $backlink_url);
			return $templater->render();
		case '7':
			$templater = vB_Template::create('vblinklist_thumbnail_backlink');
			$backlink_url = $vbulletin->options['vblinklist_thumbnail_backlink'];
			$templater->register('backlink_url', $backlink_url);
			return $templater->render();
		default:
			break;
	}
}

/**
* Fetch google pagerank
*
* @return	integer	Google pagerank
*/
define('GOOGLE_MAGIC', 0xE6359A60);
class pageRank
{
	var $pr;

	function zeroFill($a, $b)
	{
		$z = hexdec(80000000);
		if ($z & $a)
		{
			$a = ($a>>1);
			$a &= (~$z);
			$a |= 0x40000000;
			$a = ($a>>($b-1));
		}
		else
		{
			$a = ($a>>$b);
		}

		return $a;
	}

	function mix($a, $b, $c)
	{
		$a -= $b; $a -= $c; $a ^= ($this->zeroFill($c,13));
		$b -= $c; $b -= $a; $b ^= ($a<<8);
		$c -= $a; $c -= $b; $c ^= ($this->zeroFill($b,13));
		$a -= $b; $a -= $c; $a ^= ($this->zeroFill($c,12));
		$b -= $c; $b -= $a; $b ^= ($a<<16);
		$c -= $a; $c -= $b; $c ^= ($this->zeroFill($b,5));
		$a -= $b; $a -= $c; $a ^= ($this->zeroFill($c,3));
		$b -= $c; $b -= $a; $b ^= ($a<<10);
		$c -= $a; $c -= $b; $c ^= ($this->zeroFill($b,15));

		return array($a,$b,$c);
	}

	function GoogleCH($url, $length=null, $init=GOOGLE_MAGIC)
	{
		if(is_null($length))
		{
			$length = sizeof($url);
		}

		$a = $b = 0x9E3779B9; 
		$c = $init; 
		$k = 0; 
		$len = $length; 

		while($len >= 12)
		{
			$a += ($url[$k+0] +($url[$k+1]<<8) +($url[$k+2]<<16) +($url[$k+3]<<24));
			$b += ($url[$k+4] +($url[$k+5]<<8) +($url[$k+6]<<16) +($url[$k+7]<<24));
			$c += ($url[$k+8] +($url[$k+9]<<8) +($url[$k+10]<<16)+($url[$k+11]<<24));
			$mix = $this->mix($a,$b,$c);
			$a = $mix[0]; $b = $mix[1]; $c = $mix[2];
			$k += 12;
			$len -= 12;
		}

		$c += $length;

		switch($len)
		{
			case 11: $c+=($url[$k+10]<<24);
			case 10: $c+=($url[$k+9]<<16);
			case 9 : $c+=($url[$k+8]<<8);
			case 8 : $b+=($url[$k+7]<<24);
			case 7 : $b+=($url[$k+6]<<16);
			case 6 : $b+=($url[$k+5]<<8);
			case 5 : $b+=($url[$k+4]);
			case 4 : $a+=($url[$k+3]<<24);
			case 3 : $a+=($url[$k+2]<<16);
			case 2 : $a+=($url[$k+1]<<8);
			case 1 : $a+=($url[$k+0]);
		}

		$mix = $this->mix($a,$b,$c);
		return $mix[2];
	}

	function strord($string)
	{
		for($i=0;$i<strlen($string);$i++)
		{
			$result[$i] = ord($string{$i});
		}
		return $result;
	}

	function printrank($url)
	{
		$ch = "6".$this->GoogleCH($this->strord("info:" . $url));
 
		$fp = fsockopen("www.google.com", 80, $errno, $errstr, 30);
		if (!$fp)
		{
			echo "$errstr ($errno)<br />\n";
		}
		else
		{
			$out = "GET /search?client=navclient-auto&ch=" . $ch ."&features=Rank&q=info:" . $url . " HTTP/1.1\r\n";
			$out .= "Host: www.google.com\r\n";
			$out .= "Connection: Close\r\n\r\n";
			fwrite($fp, $out);

			while (!feof($fp))
			{
				$data = fgets($fp, 128);
				$pos = strpos($data, "Rank_");

				if($pos === false)
				{
				}
				else
				{
					$pagerank = substr($data, $pos + 9);
					$this->pr_image($pagerank);
				}
			}
			fclose($fp);
		}
	}

	function pr_image($pagerank)
	{
		$this->pr = $pagerank;
	}

	function get_pr()
	{
		return $this->pr;
	}
}

?>