<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2011, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname/filename: adminfunctions_vblinklist.php                # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Build datastore for categories
*/
function build_vblinklist_datastore()
{
	global $vbulletin, $db;

	// set fields for datastore (array)
	$vblinklist_array = array(
		'categories' => array()
	);

	if ($vbulletin->options['vblinklist_displayorder'] == 0)
	{
		$sortfield = 'name';
	}
	else
	{
		$sortfield = 'displayorder';
	}

	// fetch all active categories
	$cat_result = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_category
		ORDER BY " . $sortfield . " ASC
	");

	while ($data = $db->fetch_array($cat_result))
	{
		$vblinklist_array['categories'][$data['id']] = $data;
	}

	unset($cat_result);

	// fetch amount of entries and last entries for each category
	if (count($vblinklist_array['categories']))
	{
		$entries_result = $vbulletin->db->query_read("
			SELECT categoryid, COUNT(id) AS count, MAX(dateline) AS dateline, MAX(id) AS id
			FROM " . TABLE_PREFIX . "vblinklist_entry
  			WHERE categoryid IN (" . implode( ',', array_keys($vblinklist_array['categories'])) . ")
  			AND status = 1
  			GROUP BY categoryid
		");

		while ($data = $db->fetch_array($entries_result))
		{
			$vblinklist_array['categories'][$data['categoryid']]['entriesamount'] = $data['count'];
			$vblinklist_array['categories'][$data['categoryid']]['lastentryid'] = $data['id'];
		}

		unset($entries_result);
	}

	// fetch usernames for every last entry
	if (count($vblinklist_array['categories']))
	{
		// set -1 for root category
		$lastentryids = array(-1);

		foreach ($vblinklist_array['categories'] AS $cat => $data)
		{
			if (isset($data['lastentryid']))
			{
				$lastentryids[] = intval($data['lastentryid']);
			}
		}

		$userstats_result = $vbulletin->db->query_read("
			SELECT entry.id, entry.name, entry.categoryid, entry.userid, entry.username, IF(NOT ISNULL(user.userid), user.username, entry.username) AS username, entry.dateline
			FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
			WHERE entry.id IN (" . implode( ',', $lastentryids) . ")
			AND entry.status = 1;
		");

		while ($data = $db->fetch_array($userstats_result))
		{
			$vblinklist_array['categories'][$data['categoryid']]['lastentryusername'] = $data['username'];
			$vblinklist_array['categories'][$data['categoryid']]['lastentryuserid'] = $data['userid'];
			$vblinklist_array['categories'][$data['categoryid']]['lastentryid'] = $data['id'];
			$vblinklist_array['categories'][$data['categoryid']]['lastentryname'] = $data['name'];
			$vblinklist_array['categories'][$data['categoryid']]['lastentrydateline'] = $data['dateline'];
		}

		unset($userstats_result);
		unset($lastentryids);
	}

	build_datastore('vblinklist', serialize($vblinklist_array), true);
}

/**
* Construct text for an SQL query to recreate a table.
*
* @Author	Vossi
*
* @param	string	Table name
*/
function fetch_table_dump_sql($table)
{
	global $vbulletin;

	$backupdate = vbdate($vbulletin->options['dateformat'], TIMENOW);
	$backuptime = vbdate($vbulletin->options['timeformat'], TIMENOW);

	$tabledump = "-- vBulletin-Linklist SQL Dump\r\n-- Backup-Version 1.0.0\r\n--\r\n-- Created: " . $backupdate . " at " . $backuptime . "\r\n\r\n-- --------------------------------------------------------\r\n\r\n--\r\n-- table " . $table . "\r\n--\r\n\r\n";

	// fetch data of each entry
	$rows = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "$table");
	$numfields=$vbulletin->db->num_fields($rows);

	while ($row = $vbulletin->db->fetch_array($rows, DBARRAY_NUM))
	{
		$tabledump .= "INSERT INTO " . TABLE_PREFIX . "$table VALUES(";

		$fieldcounter = -1;
		$firstfield = 1;

		// get each field's data
		while (++$fieldcounter < $numfields)
		{
			if (!$firstfield)
			{
				$tabledump .= ', ';
			}
			else
			{
				$firstfield = 0;
			}

			if (!isset($row["$fieldcounter"]))
			{
				$tabledump .= 'NULL';
			}
			else
			{
				$tabledump .= "'" . $vbulletin->db->escape_string($row["$fieldcounter"]) . "'";
			}
		}

		$tabledump .= ");\r\n";
	}
	$vbulletin->db->free_result($rows);

	$tabledump .= "\r\n-- vBulletin-Linklist dump completed\r\n";

	return $tabledump;
}

?>