<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname/filename: admin_vblinklist.php			      # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array(
	'forum',
	'cpuser',
	'forumdisplay',
	'prefix',
	'vblinklist',
	'maintenance',
	'profilefield'
);

$globaltemplates = array('vblinklist');
$specialtemplates = array('vblinklist');
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/functions_misc.php');
require_once(DIR . '/includes/adminfunctions_vblinklist.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canlinklist'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (in_array($_REQUEST['do'], array('managecats', 'doordercats', 'addcat', 'editcat', 'updatecat', 'removecat', 'killcat')))
{
	print_cp_header($vbphrase['vblinklist_adminheadline_cats']);
}
else if (in_array($_REQUEST['do'], array('manageentries')))
{
	print_cp_header($vbphrase['vblinklist_adminheadline_entries']);
}
else if (in_array($_REQUEST['do'], array('tools')))
{
	print_cp_header($vbphrase['vblinklist_adminheadline_tools']);
}
else if (in_array($_REQUEST['do'], array('info')))
{
	print_cp_header($vbphrase['vblinklist_adminheadline_info']);
}
else
{
	print_cp_header($vbphrase['vblinklist_adminheadline']);
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'managecats';
}

// ########################################################################
// edit or add category
if ($_REQUEST['do'] == 'addcat' OR $_REQUEST['do'] == 'editcat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'catid'	 	 => TYPE_UINT,
		'defaultforumid' => TYPE_UINT,
		'parentid'	 => TYPE_UINT
	));

	if ($_REQUEST['do'] == 'addcat')
	{
		if (!($vbulletin->GPC['parentid'] == ''))
		{
			$cat['parentid'] = $vbulletin->GPC['parentid'];
		}

		$cat['defaulticon'] = '1';
		$cat['status'] = '1';
		$cat['displayorder'] = '1';
		$cat['groupshow'] = '1';

		$cat['allowhtml'] = '0';
		$cat['allowbbcode'] = '1';
		$cat['allowsmilies'] = '1';

		$newcat = true;

		print_form_header('admin_vblinklist', 'updatecat');
		print_table_header($vbphrase['vblinklist_add_new_category']);
		construct_hidden_code('catid', '0');
	}
	else
	{
		$newcat = false;

		require_once(DIR . '/includes/functions_vblinklist.php');
		if (!($cat = fetch_linkcatinfo($vbulletin->GPC['catid'])))
		{
			print_stop_message('vblinklist_invalid_cat_specified');
		}

		// fetch usergroups
		$membersarray = array('membergroupids' => $cat['groupshowlist']);

		print_form_header('admin_vblinklist', 'updatecat');
		print_table_header(construct_phrase($vbphrase['vblinklist_cat_x_y_id_z'], $vbphrase['vblinklist_category'], $cat['name'], $cat['id']));
		construct_hidden_code('catid', $vbulletin->GPC['catid']);
	}

	$cat['name'] = str_replace('&amp;', '&', $cat['name']);
	$cat['description'] = str_replace('&amp;', '&', $cat['description']);

	print_input_row($vbphrase['vblinklist_category_name'], 'cat[name]', $cat['name']);
	print_textarea_row($vbphrase['vblinklist_description'], 'cat[description]', $cat['description']);

	print_yes_no_row($vbphrase['vblinklist_default_icon'], 'cat[defaulticon]', $cat['defaulticon']);

	// make array for all icons to prune into select row
	$iconfiles = array();
	$icondir = './images/vblinklist/cat';

	// does dir exist?
	if ( is_dir($icondir) )
	{
		$dir = opendir($icondir);

		// read files with .gif
		while (($filename = readdir($dir)) !== false)
		{
			if ( ($filename != '.') AND ($filename != '..') )
			{
				$filetype = substr(strrchr($filename, '.'), 1);
				if ($filetype  == 'gif')
				{
					$iconfiles[] = str_replace('.gif', '', $filename);
				}
			}
		}
	closedir($dir);
	}

	// sort files
	asort($iconfiles);

	$icons = array(
		'0' => $vbphrase['vblinklist_noone']
	);

	// if file exists
	if (count($iconfiles) > 0)
	{
		foreach ($iconfiles AS $actualfile)
		{
			$icons["$actualfile"] = $actualfile;
		}
	}

	print_select_row($vbphrase['vblinklist_defined_icon'], 'cat[definedicon]', $icons, $cat['definedicon']);
	print_input_row($vbphrase['vblinklist_picturelocation'], 'cat[picturelocation]', $cat['picturelocation']);
	print_yes_no_row($vbphrase['vblinklist_cat_is_active'], 'cat[status]', $cat['status']);
	print_input_row($vbphrase['vblinklist_displayorder'], 'cat[displayorder]', $cat['displayorder']);

	$parentcats = array(
		'-1' => $vbphrase['none']
	);

	foreach ($vbulletin->vblinklist['categories'] AS $catid => $currentcat)
	{
#		if ($catid == $cat['id'] OR $currentcat['parentid'] != -1)
		if ($catid == $cat['id'])
		{
			continue;
		}

		$parentcats["$catid"] = $currentcat['name'];
	}

	print_select_row($vbphrase['vblinklist_parent_cat'], 'cat[parentid]', $parentcats, $cat['parentid']);
	print_yes_no_row($vbphrase['vblinklist_cat_groupshow'], 'cat[groupshow]', $cat['groupshow']);
	print_membergroup_row($vbphrase['vblinklist_cat_groupshow_list'], 'cat[groupshowlist]', 2, $membersarray);

	print_table_header($vbphrase['vblinklist_additional_linklist_function']);
	print_yes_no_row($vbphrase['vblinklist_use_banner'], 'cat[banner]', $cat['banner']);
	print_yes_no_row($vbphrase['vblinklist_use_thumbnailer'], 'cat[thumbnail]', $cat['thumbnail']);
	print_yes_no_row($vbphrase['vblinklist_use_image'], 'cat[image]', $cat['image']);
	print_yes_no_row($vbphrase['vblinklist_use_meta'], 'cat[meta]', $cat['meta']);

	print_table_header($vbphrase['enable_disable_features']);
	print_yes_no_row($vbphrase['allow_html'], 'cat[allowhtml]', $cat['allowhtml']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'cat[allowbbcode]', $cat['allowbbcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'cat[allowsmilies]', $cat['allowsmilies']);
	print_submit_row($vbphrase['vblinklist_save_cat']);
}

// ########################################################################
// update category
if ($_POST['do'] == 'updatecat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'catid'			=> TYPE_UINT,
		'cat'			=> TYPE_ARRAY
	));

	require_once(DIR . '/includes/functions_vblinklist.php');
	$cat = fetch_linkcatinfo($vbulletin->GPC['catid']);

	if ($vbulletin->GPC['cat']['name'] == '')
	{
		define('CP_REDIRECT', 'admin_vblinklist.php?do=managecats');
		print_stop_message('vblinklist_saved_category_not_successfull');
	}

	$usergrouparray =& htmlspecialchars_uni($vbulletin->GPC['cat']['groupshowlist']);

	if ($usergrouparray)
	{
		$usergrouparray = implode(',', $usergrouparray);
	}
	else
	{
		$usergrouparray = '';
	}

	$parentid = intval($vbulletin->GPC['cat']['parentid']);
	$parentcat = fetch_linkcatinfo($parentid);

#	if (!$parentcat OR $parentcat['parentid'] != -1)
	if (!$parentcat)
	{
		$parentid = -1;
	}

	if (!$cat)
	{
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_category (name, description, status, parentid, displayorder, defaulticon, definedicon, groupshow, groupshowlist, allowhtml, allowbbcode, allowsmilies, banner, thumbnail, image, meta, picturelocation)
		VALUES (
			'" . $db->escape_string($vbulletin->GPC['cat']['name']) . "',
			'" . $db->escape_string($vbulletin->GPC['cat']['description']) . "',
			'" . intval($vbulletin->GPC['cat']['status']) . "',
			'" . $parentid . "',
			'" . intval($vbulletin->GPC['cat']['displayorder']) . "',
			'" . intval($vbulletin->GPC['cat']['defaulticon']) . "',
			'" . $db->escape_string($vbulletin->GPC['cat']['definedicon']) . "',
			'" . intval($vbulletin->GPC['cat']['groupshow']) . "',
			'" . $db->escape_string($usergrouparray) . "',
			'" . intval($vbulletin->GPC['cat']['allowhtml']) . "',
			'" . intval($vbulletin->GPC['cat']['allowbbcode']) . "',
			'" . intval($vbulletin->GPC['cat']['allowsmilies']) . "',
			'" . intval($vbulletin->GPC['cat']['banner']) . "',
			'" . intval($vbulletin->GPC['cat']['thumbnail']) . "',
			'" . intval($vbulletin->GPC['cat']['image']) . "',
			'" . intval($vbulletin->GPC['cat']['meta']) . "',
			'" . $db->escape_string($vbulletin->GPC['cat']['picturelocation']) . "'
		)");
	}
	else
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_category SET
			name = '" . $db->escape_string($vbulletin->GPC['cat']['name']) . "',
			description = '" . $db->escape_string($vbulletin->GPC['cat']['description']) . "',
			status = '" . intval($vbulletin->GPC['cat']['status']) . "',
			parentid = '" . $parentid . "',
			displayorder = '" . intval($vbulletin->GPC['cat']['displayorder']) . "',
			defaulticon = '" . intval($vbulletin->GPC['cat']['defaulticon']) . "',
			definedicon = '" . $db->escape_string($vbulletin->GPC['cat']['definedicon']) . "',
			groupshow = '" . intval($vbulletin->GPC['cat']['groupshow']) . "',
			groupshowlist = '" . $db->escape_string($usergrouparray) . "',
			allowhtml = '" . intval($vbulletin->GPC['cat']['allowhtml']) . "',
			allowbbcode = '" . intval($vbulletin->GPC['cat']['allowbbcode']) . "',
			allowsmilies = '" . intval($vbulletin->GPC['cat']['allowsmilies']) . "',
			banner = '" . intval($vbulletin->GPC['cat']['banner']) . "',
			thumbnail = '" . intval($vbulletin->GPC['cat']['thumbnail']) . "',
			image = '" . intval($vbulletin->GPC['cat']['image']) . "',
			meta = '" . intval($vbulletin->GPC['cat']['meta']) . "',
			picturelocation = '" . $db->escape_string($vbulletin->GPC['cat']['picturelocation']) . "'
			WHERE id = '" . intval($cat['id']) . "'
		");
	}

	// actualize datastore
	build_vblinklist_datastore(true);

	define('CP_REDIRECT', 'admin_vblinklist.php?do=managecats');
	print_stop_message('vblinklist_saved_category_x_successfully', $vbulletin->GPC['cat']['name']);
}

// ########################################################################
// order catetories
if ($_POST['do'] == 'doordercats')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'order' => TYPE_ARRAY
	));

	if (is_array($vbulletin->GPC['order']))
	{
		$cats = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "vblinklist_category
		");

		while ($cat = $db->fetch_array($cats))
		{
			if (!isset($vbulletin->GPC['order']["$cat[id]"]))
			{
				continue;
			}

			$displayorder = intval($vbulletin->GPC['order']["$cat[id]"]);
			if ($cat['displayorder'] != $displayorder)
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "vblinklist_category
					SET displayorder = '" . intval($displayorder) . "'
					WHERE id = '" . intval($cat['id']) . "'
				");
			}
		}
	}

	// actualize datastore
	build_vblinklist_datastore(true);

	define('CP_REDIRECT', 'admin_vblinklist.php?do=managecats');
	print_stop_message('vblinklist_saved_displayorder_successfully');
}

// ########################################################################
// remove cat
if ($_REQUEST['do'] == 'removecat')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_UINT
	));

	$cat = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_category
		WHERE id = " . intval($vbulletin->GPC['catid']) . "
	");

	print_form_header('admin_vblinklist', 'killcat');
	print_table_header(construct_phrase($vbphrase['vblinklist_delete_cat_x_y_id_z'], $vbphrase['vblinklist_category'], $cat['name'], $cat['id']));
	construct_hidden_code('catid', $vbulletin->GPC['catid']);

	print_yes_no_row($vbphrase['vblinklist_delete_category'], 'cat[delete]', 0);
	print_yes_no_row($vbphrase['vblinklist_move_entries'], 'cat[moveentries]', 0);

	// make array for all categories to prune into select row
	$prunecats = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_category
	");

	$pruneoptions = array();

	while ($prunecat = $db->fetch_array($prunecats))
	{
		if (!($prunecat['id'] == $vbulletin->GPC['catid']))
		{
			$pruneoptions[$prunecat['id']] = $prunecat['name'];
		}
	}
	print_select_row($vbphrase['vblinklist_move_entries_choose'], 'cat[moveentriesto]', $pruneoptions, $cat['parentid']);

	print_yes_no_row($vbphrase['vblinklist_move_subcats'], 'cat[movesubcats]', 0);
	while ($prunecat = $db->fetch_array($prunecats))
	{
		$pruneoptions[$prunecat['id']] = $prunecat['name'];
	}
	print_select_row($vbphrase['vblinklist_move_subcats_choose'], 'cat[movesubcatsto]', $pruneoptions, $cat['parentid']);

	print_submit_row($vbphrase['vblinklist_kill_cat']);
}

// ########################################################################
// remove cat
if ($_REQUEST['do'] == 'killcat')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'catid' => TYPE_UINT,
		'cat'	=> TYPE_ARRAY
	));

	if ($vbulletin->GPC['cat']['delete'] == 1)
	{
		if ($vbulletin->GPC['cat']['moveentries'] == 1)
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "vblinklist_entry
				SET categoryid = '" . intval($vbulletin->GPC['cat']['moveentriesto']) . "'
				WHERE categoryid = '" . intval($vbulletin->GPC['catid']) . "'
			");
		}

		if ($vbulletin->GPC['cat']['movesubcats'] == 1)
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "vblinklist_category
				SET parentid = '" . intval($vbulletin->GPC['cat']['movesubcatsto']) . "'
				WHERE parentid = '" . intval($vbulletin->GPC['catid']) . "'
			");
		}

		$db->query_write("DELETE FROM " . TABLE_PREFIX . "vblinklist_category WHERE id = '" . intval($vbulletin->GPC['catid']) . "'");

		// actualize datastore
		build_vblinklist_datastore(true);

		define('CP_REDIRECT', 'admin_vblinklist.php?do=managecats');
		print_stop_message('vblinklist_deleted_category_successfully');
	}
	else
	{
		define('CP_REDIRECT', 'admin_vblinklist.php?do=managecats');
		print_stop_message('vblinklist_deleted_category_error');
	}
}

// ########################################################################
// manage categories
if ($_REQUEST['do'] == 'managecats')
{
	$categoryoptions = array(
		'dummy'		=> $vbphrase['vblinklist_choose_cat_option'],
		'editcat'	=> $vbphrase['vblinklist_edit_category'],
		'removecat'	=> $vbphrase['vblinklist_delete_category'],
		'addcat'	=> $vbphrase['vblinklist_add_child_category'],
	);

	// a little javascript for the options menus
	?>
	<script type="text/javascript">
	<!--
	function js_forum_jump(foruminfo)
	{
		if (foruminfo == 0)
		{
			alert('<?php echo addslashes_js($vbphrase['vblinklist_please_select_cat']); ?>');
			return;
		}
		else if (typeof(document.cpform.forumid) != 'undefined')
		{
			action = document.cpform.controls.options[document.cpform.controls.selectedIndex].value;
		}
		else
		{
			action = eval("document.cpform.f" + foruminfo + ".options[document.cpform.f" + foruminfo + ".selectedIndex].value");
		}
		if (action != '')
		{
			switch (action)
			{
				case 'editcat':		page = "admin_vblinklist.php?do=editcat&catid=";
							break;
				case 'removecat':	page = "admin_vblinklist.php?do=removecat&catid=";
							break;
				case 'addcat':		page = "admin_vblinklist.php?do=addcat&parentid=";
							break;
			}
			document.cpform.reset();
			jumptopage = page + foruminfo + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";

			window.location = jumptopage;

		}
		else
		{
			alert('<?php echo addslashes_js($vbphrase['vblinklist_invalid_action_specified']); ?>');
		}
	}
	//-->
	</script>
	<?php

	print_form_header('admin_vblinklist', 'doordercats');

	print_table_header($vbphrase['vblinklist_category_manager'], 3);
	print_description_row($vbphrase['vblinklist_if_you_change_displayorder'], 0, 3);

	// main depth
	$linklistcats = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_category
		WHERE parentid < 0
		ORDER BY displayorder ASC
	");

	print_cells_row(array($vbphrase['vblinklist_category'], $vbphrase['vblinklist_cat_setting'], $vbphrase['vblinklist_cat_displayorder']), 1, 'tcat');

	while ($cat = $db->fetch_array($linklistcats))
	{
		$cell = array();

		$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b><a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
		$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

		print_cells_row($cell);

		// depth 1
		$linklistsubcats = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "vblinklist_category
			WHERE parentid = " . $cat['id'] . "
			ORDER BY displayorder ASC
		");

		while ($cat = $db->fetch_array($linklistsubcats))
		{
			$cell = array();

			$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b>- - <a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
			$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

			print_cells_row($cell);

			// depth 2
			$linklistsubcats2 = $db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . "vblinklist_category
				WHERE parentid = " . $cat['id'] . "
				ORDER BY displayorder ASC
			");

			while ($cat = $db->fetch_array($linklistsubcats2))
			{
				$cell = array();

				$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b>- - - - <a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
				$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

				print_cells_row($cell);

				// depth 3
				$linklistsubcats3 = $db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "vblinklist_category
					WHERE parentid = " . $cat['id'] . "
					ORDER BY displayorder ASC
				");

				while ($cat = $db->fetch_array($linklistsubcats3))
				{
					$cell = array();

					$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b>- - - - - - <a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
					$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

					print_cells_row($cell);

					// depth 4
					$linklistsubcats4 = $db->query_read("
						SELECT *
						FROM " . TABLE_PREFIX . "vblinklist_category
						WHERE parentid = " . $cat['id'] . "
						ORDER BY displayorder ASC
					");

					while ($cat = $db->fetch_array($linklistsubcats4))
					{
						$cell = array();
			
						$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b>- - - - - - - - <a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
						$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
						$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

						print_cells_row($cell);

						// depth 5
						$linklistsubcats5 = $db->query_read("
							SELECT *
							FROM " . TABLE_PREFIX . "vblinklist_category
							WHERE parentid = " . $cat['id'] . "
							ORDER BY displayorder ASC
						");

						while ($cat = $db->fetch_array($linklistsubcats5))
						{
							$cell = array();

							$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b>- - - - - - - - - - <a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
							$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
							$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

							print_cells_row($cell);

							// depth 6
							$linklistsubcats6 = $db->query_read("
								SELECT *
								FROM " . TABLE_PREFIX . "vblinklist_category
								WHERE parentid = " . $cat['id'] . "
								ORDER BY displayorder ASC
							");

							while ($cat = $db->fetch_array($linklistsubcats6))
							{
								$cell = array();

								$cell[] = "<a name=\"cat$cat[id]\">&nbsp;</a><b>- - - - - - - - - - - - <a href=\"admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=editcat&amp;catid=$cat[id]\">$cat[name]</a></b>";
								$cell[] = "\n\t<select name=\"f$cat[id]\" onchange=\"js_forum_jump($cat[id]);\" class=\"bginput\">\n" . construct_select_options($categoryoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\"  />\n\t";
								$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$cat[id]]\" value=\"$cat[displayorder]\" tabindex=\"1\" size=\"3\" title=\"\" />";

								print_cells_row($cell);
							}
						}
					}
				}
			}
		}
	}

	print_table_footer(3, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vblinklist_cat_save_displayorder'] . "\" accesskey=\"s\" />" . construct_button_code($vbphrase['vblinklist_add_new_category'], "admin_vblinklist.php?" . $vbulletin->session->vars['sessionurl'] . "do=addcat"));
}

// ########################################################################
// tools
if ($_REQUEST['do'] == 'tools')
{
	// generate statistic
	$cell = array();
	$cell[] = $vbphrase['vblinklist_tools_description'];
	$cell[] = $vbphrase['vblinklist_tools_possible_function'];
	$cells = sizeof($cell);

	echo '<br /><table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder" id="cpform_table2">';
	print_table_header($vbphrase['vblinklist_tools_create_datastore'], $cells);
	print_description_row($vbphrase['vblinklist_tools_create_datastore_desc'], 0, $cells);
	print_cells_row($cell, 1);

	$cell = array();
	$cell[] = $vbphrase['vblinklist_tools_create_datastore_desc_2'];
	$cell[] = "<div align=\"center\"><form action=\"admin_vblinklist.php?do=generatedatastore\" method=\"post\" name=\"cpformgenerateds\" id=\"cpformgenerateds\"><input type=\"hidden\" name=\"securitytoken\" value=\"" . $vbulletin->userinfo['securitytoken'] . "\"><input type=\"hidden\" name=\"generateds\" value=\"tools\"><input type=\"submit\" class=\"button\" name=\"generateds\" value=\"$vbphrase[vblinklist_tools_create_datastore_button]\"></small></form>";
	print_cells_row($cell);
	echo '</table>';
	print_table_footer();

	// check for changed usernames
	$cell = array();
	$cell[] = $vbphrase['vblinklist_tools_description'];
	$cell[] = $vbphrase['vblinklist_tools_possible_function'];
	$cells = sizeof($cell);

	echo '<br /><table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder" id="cpform_table">';
	print_table_header($vbphrase['vblinklist_tools_aliascheck'], $cells);
	print_description_row($vbphrase['vblinklist_tools_aliascheck_desc'], 0, $cells);
	print_cells_row($cell, 1);

	$cell = array();
	$cell[] = $vbphrase['vblinklist_tools_aliascheck_desc_2'];
	$cell[] = "<div align=\"center\"><form action=\"admin_vblinklist.php?do=aliascheck\" method=\"post\" name=\"cpformaliascheck\" id=\"cpformaliascheck\"><input type=\"hidden\" name=\"securitytoken\" value=\"" . $vbulletin->userinfo['securitytoken'] . "\"><input type=\"hidden\" name=\"aliascheck\" value=\"aliascheck\"><input type=\"submit\" class=\"button\" name=\"filealiascheck\" value=\"$vbphrase[vblinklist_tools_aliascheck_button]\"></small></form>";
	print_cells_row($cell);
	echo '</table>';
	print_table_footer();
}

// ########################################################################
// generate statistic
if ($_REQUEST['do'] == 'generatedatastore')
{
	build_vblinklist_datastore(true);

	define('CP_REDIRECT', 'admin_vblinklist.php?do=tools');
	print_stop_message('saved_settings_successfully');
}

// ########################################################################
// check aliases for changes
if ($_REQUEST['do'] == 'aliascheck')
{
	$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_entry AS vblinklist, " . TABLE_PREFIX . "user AS user SET vblinklist.username=user.username WHERE vblinklist.userid=user.userid");

	define('CP_REDIRECT', 'admin_vblinklist.php?do=tools');
	print_stop_message('saved_settings_successfully');
}

// ########################################################################
// manage entries
if ($_REQUEST['do'] == 'manageentries')
{
	global $Installarray;
	$Installarray = '';

	// ---------- export entries
	$cell = array();
	$cell[] = $vbphrase['vblinklist_entries_name_of_database'];
	$cell[] = $vbphrase['vblinklist_entries_possible_function'];
	$cells = sizeof($cell);

	echo '<br /><table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder" id="cpform_table">';
	print_table_header($vbphrase['vblinklist_entries_user_export'], $cells);
	print_description_row($vbphrase['vblinklist_entries_user_export_desc'], 0, $cells);
	print_cells_row($cell, 1);

	$cell = array();
	$cell[] = TABLE_PREFIX . 'vblinklist_entry';
	$cell[] = "<div align=\"center\"><form action=\"admin_vblinklist.php?do=exportentries\" method=\"post\" name=\"cpform\" id=\"cpform\"><input type=\"hidden\" name=\"securitytoken\" value=\"" . $vbulletin->userinfo['securitytoken'] . "\"><input type=\"hidden\" name=\"deleter\" value=\"nodelete\"><input type=\"submit\" class=\"button\" name=\"exportusers\" value=\"$vbphrase[vblinklist_entries_user_export_button]\"></small></form>";
	print_cells_row($cell);

	echo '</table>';
	print_table_footer();

	// ---------- import entries
	$cell = array();
	$cell[] = $vbphrase['vblinklist_entries_date_of_data_save'];
	$cell[] = $vbphrase['vblinklist_entries_possible_function'];
	$cell[] = $vbphrase['vblinklist_entries_possible_function'];
	$cells = sizeof($cell);

	echo '<br /><table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder" id="cpform_table">';
	print_table_header($vbphrase['vblinklist_entries_user_import'], $cells);
	print_description_row($vbphrase['vblinklist_entries_user_import_desc'], 0, $cells);
	print_cells_row($cell, 1);

	$files = array();
	$directory = './vblinklist/backup';

	$number = 1;

	// does dir exist?
	if (is_dir($directory))
	{
		$data_directory = opendir($directory);

		// read .sql-files
		while (($filename = readdir($data_directory)) !== false)
		{
			if (($filename != '.') AND ($filename != '..'))
			{
				$filetype = substr(strrchr($filename, '.'), 1);
				if ($filetype  == 'sql')
				{
					$files[] = str_replace('.sql', '', $filename);
				}
			}
		}
		closedir($data_directory);
	}

	// sort files
	arsort($files);

	// print files if exist
	$number = 1;
	if (count($files) > 0)
	{
		foreach ($files AS $actualfile )
		{
			$tempor = substr(str_replace('backup-', '', $actualfile), 0, 10);

			$date  = vbdate($vbulletin->options['dateformat'], $tempor, $vbulletin->options['yestoday']);
			$time  = vbdate($vbulletin->options['timeformat'], $tempor, $vbulletin->options['yestoday']);

			$cell = array();
			$cell[] = "<b>$date, $time Uhr</b>";
			$cell[] = "<div align=\"center\"><form action=\"admin_vblinklist.php?do=deletebackup\" method=\"post\" name=\"cpform$number\" id=\"cpform$number\"><input type=\"hidden\" name=\"securitytoken\" value=\"" . $vbulletin->userinfo['securitytoken'] . "\"><input type=\"hidden\" name=\"file\" value=\"$actualfile\"><input type=\"submit\" class=\"button\" name=\"file$number\" value=\"$vbphrase[vblinklist_entries_delete_button]\"></small></form>";
			$number++;
			$cell[] = "<div align=\"center\"><form action=\"admin_vblinklist.php?do=importentries\" method=\"post\" name=\"cpform$number\" id=\"cpform$number\"><input type=\"hidden\" name=\"securitytoken\" value=\"" . $vbulletin->userinfo['securitytoken'] . "\"><input type=\"hidden\" name=\"file\" value=\"$actualfile\"><input type=\"submit\" class=\"button\" name=\"file$number\" value=\"$vbphrase[vblinklist_entries_import_button]\"></small></form>";

			print_cells_row($cell);

			$number++;
		}
	}
	// no files
	else
	{
		print_description_row($vbphrase['vblinklist_entries_no_backups'], 0, $cells);
	}
	echo '</table>';
	print_table_footer();

	// ---------- delete entries
	$cell = array();
	$cell[] = $vbphrase['vblinklist_entries_description'];
	$cell[] = $vbphrase['vblinklist_entries_possiblefunction'];
	$cells = sizeof($cell);

	echo '<br /><table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder" id="cpform_table">';
	print_table_header($vbphrase['vblinklist_entries_user_delete'], $cells);
	print_description_row($vbphrase['vblinklist_entries_user_delete_desc'], 0, $cells);
	print_cells_row($cell, 1);

	$cell = array();
	$cell[] = $vbphrase['vblinklist_entries_user_delete_desc_2'];
	$cell[] = "<div align=\"center\"><form action=\"admin_vblinklist.php?do=deleteentries\" method=\"post\" name=\"cpformdelete\" id=\"cpformdelete\"><input type=\"hidden\" name=\"securitytoken\" value=\"" . $vbulletin->userinfo['securitytoken'] . "\"><input type=\"submit\" class=\"button\" name=\"filedelete\" value=\"$vbphrase[vblinklist_entries_user_delete_button]\"></small></form>";

	print_cells_row($cell);

	echo '</table>';
	print_table_footer();
}

// ########################################################################
// export entries and start the action to generate the .sql-file
if ($_REQUEST['do'] == 'exportentries')
{
	require_once(DIR . '/includes/adminfunctions_vblinklist.php');

	$tabledump = fetch_table_dump_sql('vblinklist_entry');

	// set time of backup for all backup actions
	$time = TIMENOW;

	// filename of setting file with conditions
	$setfile = './vblinklist/backup/' . 'backup-' . $time . '.sql';

	// open file for writing conditions
	$fp = fopen($setfile, 'w+');

	// write conditions into file
	fwrite($fp, $tabledump);

	// close file with conditions
	fclose($fp);

	define('CP_REDIRECT', 'admin_vblinklist.php?do=manageentries');
	print_stop_message('vblinklist_backup_successfully_saved');
}

// ########################################################################
// delete backup file
if ($_REQUEST['do'] == 'deleteentries')
{
	require_once(DIR . '/includes/adminfunctions_vblinklist.php');

	$tabledump = fetch_table_dump_sql('vblinklist_entry');

	// set time of backup for all backup actions
	$time = TIMENOW;

	// filename of setting file with conditions
	$setfile = './vblinklist/backup/' . 'backup-' . $time . '.sql';

	// open file for writing conditions
	$fp = fopen($setfile, 'w+');

	// write conditions into file
	fwrite($fp, $tabledump);

	// close file with conditions
	fclose($fp);

	// delete tables
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "vblinklist_entry");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "vblinklist_entryrate");

	build_vblinklist_datastore(true);

	define('CP_REDIRECT', 'admin_vblinklist.php?do=manageentries');
	print_stop_message('vblinklist_entries_successfully_deleted');
}

// ########################################################################
// delete backup file
if ($_REQUEST['do'] == 'deletebackup')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'file' => TYPE_NOHTML
	));

	// delete dump of vblinklist_entry
	$filename = './vblinklist/backup/' . $vbulletin->GPC['file'] . '.sql';

	if (file_exists($filename))
	{
		unlink($filename);
	}

	define('CP_REDIRECT', 'admin_vblinklist.php?do=manageentries');
	print_stop_message('vblinklist_backup_successfully_deleted');
}

// ########################################################################
// import entries
if ($_REQUEST['do'] == 'importentries')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'file' => TYPE_NOHTML
	));

	$filename = './vblinklist/backup/backup-' . substr(str_replace('backup-', '', $vbulletin->GPC['file']), 0, 10) . '.sql';

	// to avoid problems we're reading line by line of backup file
	$lines = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES); 

	$buffer = ''; 

	foreach ($lines as $line)
	{ 
		// skip lines containing eol only 
		if (($line = trim($line)) == '') 
		{
			continue; 
		}

		// skipping sql comments 
		if (substr(ltrim($line), 0, 2) == '--') 
		{
			continue; 
		}

		// a sql statement can span over multiple lines
		if (substr($line, -1) != ';')
		{ 
			$buffer .= $line; 
			continue; 
		}
	
		if ($buffer)
		{ 
			$line = $buffer . $line; 
			$buffer = ''; 
		} 

		// strip the trailing
		$line = substr($line, 0, -1); 

		// send query
		$db->query_write($line);
	}

	build_vblinklist_datastore(true);

	define('CP_REDIRECT', 'admin_vblinklist.php?do=manageentries');
	print_stop_message('vblinklist_backup_successfully_imported');
}

// ########################################################################
// information
if ($_REQUEST['do'] == 'info')
{
	print_description_row($vbphrase['vblinklist_admincp_info']);
}

// ########################################################################
print_cp_footer();

?>