<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$globaltemplates = array();
$phrasegroups = array();
$specialtemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_misc.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_bootstrap_framework.php');
vB_Bootstrap_Framework::init();

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

echo 'Leere Tabellen von vBulletin-Linkliste / truncate table of vBulletin Link Directory: <br/><br/>';

$vossi1 = $db->query_read("TRUNCATE TABLE " . TABLE_PREFIX . "vblinklist_category");
$vossi2 = $db->query_read("TRUNCATE TABLE " . TABLE_PREFIX . "vblinklist_entry");

echo 'Konvertiere Kategorien / Convert categories: <br/><br/>';

// alte cat lesen
$result = $db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "adv_links_categories 
	ORDER BY catid
");
$i = 1;
while ($row = $db->fetch_array($result))
{
	echo $row['catid'] . ': ' . $row['title'] . '<br/>';

	if ($row['parent'] == '0')
	{
		$row['parent'] = '-1';
	}

	// neue cat schreiben
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_category (id, parentid, displayorder, name, description, status)
	VALUES (
		'" . intval($row['catid']) . "',
		'" . intval($row['parent']) . "',
		'" . intval($row['displayorder']) . "',
		'" . $db->escape_string($row['title']) . "',
		'" . $db->escape_string($row['description']) . "',
		'" . intval($row['active']) . "'
	)");
	$i++;
}

echo '<br/><br/>Konvertiere Links / Convert links: <br/><br/>';

// alte Eintrge lesen
$entry = $db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "adv_links 
	ORDER BY linkid
");
while ($link = $db->fetch_array($entry))
{
	echo $link['linkid'] . ': ' . $link['name'] . '<br/>';

	// neue eintrge schreiben
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_entry (id, name, description, userid, username, dateline, categoryid, status, views, linkurl, votenum, votetotal, ipaddress, lastupdate)
	VALUES (
		'" . intval($link['linkid']) . "',
		'" . $db->escape_string($link['name']) . "',
		'" . $db->escape_string($link['description']) . "',
		'" . intval($link['userid']) . "',
		'" . $db->escape_string($link['username']) . "',
		'" . intval($link['dateline']) . "',
		'" . intval($link['catid']) . "',
		'1',
		'" . intval($link['views']) . "',
		'" . $db->escape_string($link['linkurl']) . "',
		'" . intval($link['votenum']) . "',
		'" . intval($link['votetotal']) . "',
		'" . intval($link['ipaddress']) . "',
		'" . intval($link['lastupdated']) . "'
	)");
}

echo '<br/><br/>Erstelle Datastore / build datastore... <br/><br/>';

require_once(DIR . '/includes/adminfunctions_vblinklist.php');
build_vblinklist_datastore();

echo '<br/><br/>... beendet / finished !!!';

?>
