<?php
if (!defined('VB_ENTRY')) die('Access denied.');

global $db, $vbulletin, $entry, $randomentry;

require_once(DIR . '/includes/functions_vblinklist.php');

// premium-option on linklist home
$show['randomentry'] = $show['comments'] = $show['comments_id'] = $show['comments_sum'] = $show['entries_sum'] = $show['categories_sum'] = false;

$entry = $db->query_first("SELECT *
	FROM " . TABLE_PREFIX . "vblinklist_entry
	WHERE status = '1'
	ORDER BY RAND()
	LIMIT 1
");

if ($entry)
{
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());

	require_once(DIR . '/includes/class_vblinklist_entry.php');
	$entry_factory = new vB_vBLinklist_EntryFactory($vbulletin, $bbcode, $row['categoryid']);
	$entry_handler =& $entry_factory->create($entry);
	$entry_handler->userinfo = $row;
	$entry_handler->construct();
	$row =& $entry_handler->entry;
	$status =& $entry_handler->status;

	$show['randomentry'] = true;

	// thumbnail
	if ($vbulletin->options['vblinklist_thumbnail'])
	{
		$show['vblinklist_thumbnail'] = construct_vblinklist_thumbnail();

		if ($catinfo['thumbnail'] == 1)
		{
			$show['thumbnail'] = true;
		}
	
		if ($vbulletin->options['vblinklist_thumbnail_show_backlink'])
		{
			$show['vblinklist_thumbnail_backlink'] = construct_vblinklist_thumbnail_backlink();
		}
	}
}

$show['vblinklist_message'] = $row['message'];
$show['vblinklist_message'] = fetch_trimmed_title($show['vblinklist_message'], 150);
$show['vblinklist_name'] = $row['name'];
$show['vblinklist_url'] = construct_linklist_entry_urls($row, 'showentry');
$show['vblinklist_linkurl'] = $row['linkurl'];
$show['vblinklist_dateline'] = $row['dateline'];
$show['vblinklist_username'] = $row['username'];
$show['vblinklist'] = $entry;

$categories = $db->query_first("
	SELECT COUNT(*) AS count
	FROM " . TABLE_PREFIX . "vblinklist_category
	WHERE status = 1
");

if ($categories['count'] > 0)
{
	$show['categories_sum'] = true;
	$show['vblinklist_sum_categories'] = $categories['count'];
}

$entries = $db->query_first("
	SELECT COUNT(*) AS count, MAX(dateline) AS dateline, MAX(id) AS id
	FROM " . TABLE_PREFIX . "vblinklist_entry
	WHERE status = 1
");

if ($entries['count'] > 0)
{
	$show['entries_sum'] = true;
	$show['vblinklist_sum_entries'] = ($entries['count']);

	$entries = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_entry
		WHERE id = '" . intval($entries['id']) . "'
	");
}

$show['vblinklist_latest_entry'] = $entries['name'];
$show['vblinklist_latest_entry_url'] = construct_linklist_entry_urls($entries, 'showentry');
$show['vblinklist_latest_entry_username'] = $entries['username'];
$show['vblinklist_latest_entry_dateline'] = $entries['dateline'];
$show['vblinklist_latest_entry_array'] = $entries;

if ($vbulletin->options['vblinklist_comment'])
{
	$show['comments'] = true;

	$comments = $db->query_first("
		SELECT COUNT(*) AS count, MAX(dateline) AS dateline, MAX(commentid) AS commentid
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE state = 'visible'
	");

	if ($comments['commentid'])
	{
		$show['comments_id'] = true;

		if ($comments['count'] > 0)
		{
			$show['comments_sum'] = true;
			$show['vblinklist_sum_comments'] = $comments['count'];

			$last_comments_entry = $db->query_first("
				SELECT entry.*, comment.*
				FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
				LEFT JOIN " . TABLE_PREFIX . "vblinklist_comment AS comment ON (comment.entryid = entry.id)
				WHERE comment.commentid = '" . intval($comments['commentid']) . "'
			");

			$show['vblinklist_latest_comment'] = $last_comments_entry['name'];
			$show['vblinklist_latest_comment_url'] = construct_linklist_entry_urls($last_comments_entry, 'showentry');
			$show['vblinklist_latest_comment_dateline'] = $last_comments_entry['dateline'];
			$show['vblinklist_lastcomment_username'] = $last_comments_entry['postusername'];

			$last_comments_entry['userid'] = $last_comments_entry['postuserid'];
			$last_comments_entry['username'] = $last_comments_entry['postusername'];

			$show['vblinklist_lastcomment'] = $last_comments_entry;
		}
	}
}
?>