<?php
// Reverted Tables
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->drop_field('dbtech_thanksadminperms');
	self::report('Reverted Table', 'administrator');
}

// Clean up
$db->assertQuery('datastore', array(
	vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE, 
	vB_dB_Query::CONDITIONS_KEY => array(
		array(
			'field' => 'title',
			'value' => 'dbtech_vbshout_',
			'operator' => vB_dB_Query::OPERATOR_BEGINS
		)
	)
));
self::report('Reverted Table', 'datastore');

if (self::$db_alter->fetch_table_info('node'))
{
	self::$db_alter->drop_field('dbtech_thanks_disabledbuttons');
	self::$db_alter->drop_field('dbtech_thanks_requiredbuttons_content');
	self::$db_alter->drop_field('dbtech_thanks_requiredbuttons_attach');
	self::$db_alter->drop_field('dbtech_thanks_firstpostonly');
	self::report('Reverted Table', 'node');
}

$db->assertQuery('routenew', array(
	vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE, 
	vB_dB_Query::CONDITIONS_KEY => array(
		array(
			'field' => 'guid',
			'value' => 'dbtechthanks-',
			'operator' => vB_dB_Query::OPERATOR_BEGINS
		)
	)
));
self::report('Reverted Table', 'routenew');

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->drop_field('dbtech_thanks_alertcount');
	self::$db_alter->drop_field('dbtech_thanks_excluded');
	self::$db_alter->drop_field('dbtech_thanks_points');
	self::$db_alter->drop_field('dbtech_thanks_settings');
	self::$db_alter->drop_field('dbtech_thanks_settings2');
	self::report('Reverted Table', 'user');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->drop_field('dbtech_thankspermissions');
	self::report('Reverted Table', 'usergroup');
}

if (self::$db_alter->fetch_table_info('usernote'))
{
	self::$db_alter->drop_field('dbtech_thanks_disabledbuttons');
	self::report('Reverted Table', 'usernote');
}

// Deleted Tables

// Drop
$tables = array(
	'button',
	'entry',
	'statistics',
);
foreach ($tables as $table)
{
	self::$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "dbtech_thanks_{$table}`");
	self::report('Deleted Table', 'dbtech_thanks_' . $table);
}
?>