<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

@set_time_limit(0);
ignore_user_abort(1);


// #############################################################################
// Core installer class

/**
* Handles everything to do with Activity.
*
* @package	vBActivity
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class DBTech_Install
{
	/**
	* The vB_Database object
	*
	* @public	vB_Database
	*/		
	protected static $db = NULL;
	
	/**
	* The vB_Database_Alter_MySQL object
	*
	* @public	vB_Database
	*/		
	protected static $db_alter = NULL;
	
	/**
	* Path to the installer files
	*
	* @protected	string
	*/		
	protected static $installpath = '';
	
	/**
	* Product ID
	*
	* @protected	string
	*/		
	protected static $productid = '';
	
	protected static $hightrafficengine = '';
	
	/**
	* Initialises the installer and ensures we have
	* all the classes we need
	*
	* @param	string	Path to the installer files
	* @param	string	Product ID we are setting
	*/
	public static function init($installpath, $productid = '')
	{
		// Install path is valid
		self::$installpath = $installpath . '/install';		

		if (!is_dir(self::$installpath))
		{
			// Wrong install path
			self::error(self::$installpath . ' is not a directory. Please upload all files that came with the product.');
		}
		
		if (!file_exists($installpath . '/xml/bitfield_' . $productid . '.xml') AND $productid)
		{
			// Missing bitfields
			self::error('bitfield_' . $productid . '.xml not found in directory ' . $installpath . '/xml/');
		}

		// We need this
		require_once(DIR . '/includes/class_dbalter.php');		

		// Set some important variables
		self::$productid = $productid;
		self::$db =& vB::getDbAssertor()->getDBConnection();	
		self::$db_alter = new vB_Database_Alter_MySQL(self::$db);
		
		// Get the high concurrency table engine (innodb support check)
		self::get_high_concurrency_table_engine();
}
	
	/**
	* Installs / Upgrades to a version
	*
	* @param	integer	Version number to install
	* @param	string	Textual representation of the version
	*/
	public static function install($version, $fullversion)
	{
		global $code, $arr;

		if (!file_exists(self::$installpath . '/' . $version . '.php'))
		{
			// Missing version file
			self::error($version . '.php not found in directory ' . self::$installpath);
		}

		// Shorthand
		$db =& vB::getDbAssertor();

		// Run the install
		self::report('<strong>Updating Version Number To</strong>:', $fullversion, 'finalise');
		
		echo '<ul>';
		require_once(self::$installpath . '/' . $version . '.php');
		echo '</ul>';
		
		// Update settings
		vB::getDatastore()->build_options();
	}
	
	/**
	* Uninstalls the product
	*/
	public static function uninstall()
	{
		if (!file_exists(self::$installpath . '/uninstall.php'))
		{
			// Missing version file
			self::error('uninstall.php not found in directory ' . self::$installpath);
		}

		// Shorthand
		$db =& vB::getDbAssertor();

		echo '<ul>';
		require_once(self::$installpath . '/uninstall.php');
		echo '</ul>';
	}
	
	/**
	* Print out an informational notice
	*
	* @param	string	What we were doing
	* @param	string	What the action returned
	* @param	string	What type of message we are printing
	*/
	public static function report($action, $message, $type = 'action')
	{
		if ($type == 'action')
		{
			// During install
			echo '<li><strong>' . $action . ':</strong> <em>' . TABLE_PREFIX . $message . '</em></li>';
		}
		else
		{
			// Finalise
			echo '<p>' . $action . ' ' . $message . '</p>';
		}
		
		vbflush();
		usleep(500000);
	}

	/**
	* Something went boom, print a message.
	*
	* @param	string	Error message
	*/
	public static function error($message = '')
	{
		$e = new Exception();

		print_dots_stop();
		print_cp_message('
			<strong>Installation Failed</strong><br />
			Sorry, the product encountered an error during installation. More information is provided below to help address the issue.<br />
			<br />
			' . $message . '<br />
			<br />
			A stack trace has been generated, please paste this when making an error report:<br />
			<br />
			<code>
			' . nl2br(vB_String::htmlSpecialCharsUni(str_replace(DIR, '', $e->getTraceAsString()))) . '
			</code>
		');
	}
	
	/**
	* Determine if we can use InnoDB
	*
	* @param	string	Error message
	*/
	public static function get_high_concurrency_table_engine()
	{
		if (self::$hightrafficengine)
		{
			return self::$hightrafficengine;
		}
		
		if (defined('SKIPDB'))
		{
			self::$hightrafficengine = 'MyISAM';
			return self::$hightrafficengine;
		}

		$set = self::$db->query('SHOW ENGINES');
		while ($row = self::$db->fetch_array($set))
		{
			if (
				strcasecmp($row['Engine'], 'innodb') == 0 AND
				(
					(strcasecmp($row['Support'], 'yes') == 0) OR
					(strcasecmp($row['Support'], 'default') == 0)
				)
			)
			{
				self::$hightrafficengine = 'InnoDB';
				return self::$hightrafficengine;
			}
	
		}
		
		self::$hightrafficengine = 'MyISAM';
		return self::$hightrafficengine;
	}
}