<?php if (!defined('VB_ENTRY')) die('Access denied.');

require_once(DIR . '/packages/dbtechthanks/class_api_core.php');

/**
 * vB_Api_DBTechThanks
 *
 * @package DBTechThanks
 * @access public
 */
class DBTechThanks_Api_Thanks_Core extends DBTechThanks_Core
{
	public $title = 'Core API';
	public $version = '3.0.0';	
	public $extensionOrder = 9;

	/**
	* Version info
	*
	* @protected	mixed
	*/	
	protected static $_version 		 	= '3.0.4 Alpha 5';
	protected static $_versionNumber 	= '304a5';

	/**
	* Whether we have the pro version or not
	*
	* @protected	boolean
	*/		
	protected static $_isPro			= false;

	/**
	* Array of table data
	*
	* @protected	array
	*/	
	protected static $_cachedTables 	= array();


	protected function __construct($prevResult)
	{
		parent::__construct($prevResult);

		

		$classname = 'DBTechThanks_dB_' . vB::getDbAssertor()->getDbType() . "_QueryDefs";
		$filename = DIR . '/packages/' . strtolower(str_replace('_', '/', $classname)) . '.php';

		if (file_exists($filename))
		{
			include_once($filename);
		}

		//make sure this is valid
		if (!class_exists($classname, false))
		{
			// We have no querydefs file
			return true;
		}

		$queryDef = new $classname();
		$tableData = $queryDef->getTableData();
		unset($queryDef);

		if (!count($tableData) OR !is_array($tableData))
		{
			// We have no tables to fetch data for
			return true;
		}

		foreach ($tableData as $table => $info)
		{
			if (!array_key_exists('_isCacheable', $info))
			{
				// Skip this
				continue;
			}

			// Set this table to be cached
			self::$_cachedTables[$info['_tableShort']] = $info;
		}
	}

	/**
	 * Returns an element from the cache
	 *
	 * @return	array
	 */
	public static function getCache($prevResult, $element)
	{
		$_cache = vB_Cache::instance(vB_Cache::CACHE_LARGE)->read('DBTTH.cache.' . $element);

		if ($_cache === FALSE)
		{
			// We need a rebuild
			$_cache = vB_Api::instance('thanks_core')->buildCache($element);
		}

		// Ensure this is an array
		$_cache = is_array($_cache) ? $_cache : array();

		switch ($element)
		{
			case 'button':
				if (!vB_Api::instance('thanks_core')->isPro())
				{
					foreach ($_cache as $buttonid => &$button)
					{
						// Just set this to the same text as we can't un-click
						$button['undotext'] = $button['actiontext'];
					}
				}
				break;
		}

		// Fix the cache and return it
		return $_cache;
	}

	/**
	 * Returns a sub-ement from an element in the cache
	 *
	 * @return	array
	 */
	public static function getCacheElement($prevResult, $element, $subElement)
	{
		// Grab the cache
		$_cache = vB_Api::instance('thanks_core')->getCache($element);

		return array_key_exists($subElement, $_cache) ? $_cache[$subElement] : array();

	}

	/**
	 * Rebuilds the cache for a specific table
	 *
	 * @return	boolean
	 */
	public static function buildCache($prevResult, $tableShort)
	{
		$keyField = '';
		if (!isset(self::$_cachedTables[$tableShort]['_keyField']))
		{
			// Default key field
			$keyField = $tableShort . 'id';
		}
		else if (count(self::$_cachedTables[$tableShort]['_keyField']) == 1)
		{
			// We're using a singular key field
			$keyField = self::$_cachedTables[$tableShort]['_keyField'][0];
		}

		try
		{
			// Grab the data
			$data = vB::getDbAssertor()->getRows('DBTechThanks:getDataForCache-' . $tableShort, array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED), false, $keyField);
		}
		catch (Exception $e)
		{
			// Should never happen but debug purposes, never know
			echo "<pre>";
			print_r($e);
			die();
		}

		if (isset(self::$_cachedTables[$tableShort]['_unserialize']))
		{
			// We need to unserialize something
			foreach ($data as $key => &$arr)
			{
				// Walk through all the values and apply unserialize where needed
				array_walk($arr, function(&$value, $key, $unserialize)
				{
					if (!in_array($key, $unserialize))
					{
						// Skip this
						return true;
					}

					// We found unserialize needed
					$value = @unserialize($value);
					$value = is_array($value) ? $value : array();

				}, self::$_cachedTables[$tableShort]['_unserialize']);
			}
		}

		// Now build the datastore
		vB_Cache::instance(vB_Cache::CACHE_LARGE)->write('DBTTH.cache.' . $tableShort, $data, 0, 'DBTTH.cacheChg.' . $tableShort);
		
		return $data;
	}

	/**
	 * Rebuilds all cache elements
	 *
	 * @return	boolean
	 */
	public static function buildAllCaches($prevResult)
	{
		foreach (self::$_cachedTables as $tableShort => $info)
		{
			// We need a rebuild
			vB_Api::instance('thanks_core')->buildCache($tableShort);
		}
	}

	/**
	 * Fetches the full literal version number
	 *
	 * @return	string
	 */
	public static function getVersion($prevResult)
	{
		return self::$_version;
	}

	/**
	 * Fetches the version number (short version)
	 *
	 * @return	string
	 */
	public static function getVersionNumber($prevResult)
	{
		return self::$_versionNumber;
	}

	/**
	 * Checks whether we're using the Pro version
	 *
	 * @return	boolean
	 */
	public static function isPro($prevResult)
	{
		return self::$_isPro;
	}

	/**
	 * Checks whether we should write copyright and returns the string
	 *
	 * @return	boolean
	 */
	public static function getCopyright($prevResult)
	{
		if (vB::getDatastore()->getOption('dbtech_thanks_branding_free') == '25599748-40762228ffdcc52c2d61ca69407b00f0')
		{
			$check = explode('-', vB::getDatastore()->getOption('dbtech_thanks_branding_free'));
			if ($check[0] > 25632516)
			{
				// We have BF
				return false;
			}
		}

		// Shorthand
		$referral = vB::getDatastore()->getOption('dbtech_thanks_referral');		

		return 'Post Thanks Buttons by <a rel="nofollow" href="http://www.dragonbyte-tech.com/product.php?dbtechthanks' . ($referral ? '&referrerid=' . $referral : '') . '" target="_blank">
			Advanced Post Thanks / Like' . (vB::getDatastore()->getOption('dbtech_thanks_displayversion') ? ' v' . vB_Api::instance('thanks_core')->getVersion() : '') . (vB_Api::instance('thanks_core')->isPro() ? ' (Pro)' : ' (Lite)') . '</a> - 
			<a href="http://www.dragonbyte-tech.com' . ($referral ? '?referrerid=' . $referral : '') . '" target="_blank">
				vBulletin Mods &amp; Addons
			</a> 
			Copyright &copy; ' . date('Y') . ' DragonByte Technologies Ltd.'
			/* . (!vB_Api::instance('thanks_core')->isPro() AND !vB::getDatastore()->getOption('dbtech_thanks_nohivel') ? ' Runs best on 
			<a href="http://www.hivelocity.net/?utm_source=Iain%2BKidd&utm_medium=back%2Blink&utm_term=Dedicated%2BServer%2BSponsor&utm_campaign=Back%2BLinks%2Bfrom%2BIain%2BKidd" target="_blank">
				HiVelocity Hosting
			</a>.' : '')*/ . '<br />';		
	}

	/**
	 * Fetches the cache data for a specified option
	 *
	 * @param string 	$hashKey 	The field name to read from the cache
	 *
	 * @return mixed 				The data read back from the cache
	 */
	public static function _getCache($prevResult, $hashkey, $cacheType = vB_Cache::CACHE_STD)
	{
		$minutes = vB::getDatastore()->getOption('dbtech_thanks_counter_ttl');
		if (!$minutes)
		{
			// We're not caching
			return false;
		}

		$write_lock = true;
		return vB_Cache::instance($cacheType)->read('DBTTH.' . $hashkey, $write_lock);
	}

	/**
	 * Writes the cache data for a specified option
	 *
	 * @param string 	$hashKey 	The field name to write to the cache
	 * @param array 	$result 	The data to write
	 */
	public static function _writeCache($prevResult, $hashKey, $result, $minute = false, $events = array(), $cacheType = vB_Cache::CACHE_STD)
	{
		$minutes = ($minute ? $minute : vB::getDatastore()->getOption('dbtech_thanks_counter_ttl'));
		if (!$minutes)
		{
			// We're not caching
			return false;
		}

		return vB_Cache::instance($cacheType)->write('DBTTH.' . $hashKey, $result, $minutes, $events);
	}

	/**
	 * Executes a specific cache event
	 *
	 * @param string 	$event 	The cache event to purge the cache for
	 */
	public static function _execEvent($prevResult, $event, $cacheType = vB_Cache::CACHE_STD)
	{
		vB_Cache::instance($cacheType)->event($event);
		vB_Cache::instance()->event($event);

		return true;
	}

	/**
	* Check if we have permissions to perform an action
	*
	* @param	array		User info
	* @param	array		Permissions info
	*/		
	public static function checkPermissions($prevResult, $user, $permissions, $bitIndex)
	{
		if (!array_key_exists('usergroupid', $user) OR !$user['usergroupid'] OR (!isset($user['membergroupids']) AND $user['userid']))
		{
			// Ensure we have this
			$user = vB_Api::instance('user')->fetchUserinfo($user['userid']);
		}

		if (!empty($user['membergroupids']))
		{
			$membergroups = explode(',', str_replace(' ', '', $user['membergroupids']));
		}
		else
		{
			$membergroups = array();
		}
		$membergroups[] = $user['usergroupid'];

		$ugs = array_unique($membergroups);

		if (!$ugs[0])
		{
			// Hardcode guests
			$ugs[0] = 1;
		}
		
		foreach ($ugs as $usergroupid)
		{
			$value = $permissions[$usergroupid][$bitIndex];
			$value = (isset($value) ? $value : 0);
			
			switch ($value)
			{
				case 1:
					// Allow
					return true;
					break;
			}
		}
		
		// We didn't make it
		return false;
	}
}
?>