<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$vb5_config =& vB::getConfig();

require_once(DIR . '/includes/adminfunctions_options.php');

// #############################################################################
if ($_REQUEST['action'] == 'options' OR empty($_REQUEST['action']))
{
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'varname' 	=> vB_Cleaner::TYPE_STR,
		'dogroup' 	=> vB_Cleaner::TYPE_STR,
		'advanced' 	=> vB_Cleaner::TYPE_BOOL,
		'expand'   	=> vB_Cleaner::TYPE_BOOL,
	));

	// intercept direct call to do=options with $varname specified instead of $dogroup
	if ($_REQUEST['do'] == 'options' AND !empty($cleaned['varname']))
	{
		if ($cleaned['varname'] == '[all]')
		{
			// go ahead and show all settings
			$cleaned['dogroup'] = '[all]';
		}
		else if ($group = $assertor->getRow('setting', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT, 'varname' => $cleaned['varname'])))
		{
			$args = array();
			parse_str(vB::getCurrentSession()->get('sessionurl_js'),$args);
			$args['do'] = 'options';
			$args['dogroup'] = $group['grouptitle'];
			$args['#'] = $group['varname'];
			// redirect to show the correct group and use and anchor to jump to the correct variable
			exec_header_redirect2('options', $args);
		}
	}

	$vb5_config =& vB::getConfig();
	$vb_options = vB::getDatastore()->getValue('options');

	// query settings phrases
	global $settingphrase;
	$settingphrase = array();
	$phrases = $assertor->assertQuery('vBForum:phrase',
		array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'fieldname' => 'vbsettings',
			'languageid' => array(-1, 0, LANGUAGEID),
		),
		array('field' => 'languageid', 'direction' => vB_dB_Query::SORT_ASC)
	);
	if ($phrases AND $phrases->valid())
	{
		foreach ($phrases AS $phrase)
		{
			$settingphrase[$phrase['varname']] = $phrase['text'];
		}
	}

	print_cp_header(new vB_Phrase('global', 'dbtech_thanks_settings'));
	
	global $settingscache, $grouptitlecache;

	echo '<script type="text/javascript" src="' . $vb_options['bburl']. '/clientscript/vbulletin_cpoptions_scripts.js?v=' . SIMPLE_VERSION . '"></script>';
	
	// display links to settinggroups and create settingscache
	$settingscache = array();
	$options = array('[all]' => '-- ' . new vB_Phrase('cpoption', 'show_all_settings') . ' --');
	$lastgroup = '';

	$settings = $assertor->assertQuery('DBTechThanks:fetchSettingsByGroup',
		array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_METHOD, 'product' => 'dbtechthanks', 'debug' => $vb5_config['Misc']['debug'])
	);
	
	if (empty($cleaned['dogroup']) AND $cleaned['expand'])
	{
		foreach ($settings AS $setting)
		{
			$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
			if ($setting['grouptitle'] != $lastgroup)
			{
				$grouptitlecache[$setting['grouptitle']] = $setting['grouptitle'];
				$grouptitle = $settingphrase["settinggroup_$setting[grouptitle]"];
			}
			$options[$grouptitle][$setting['varname']] = $settingphrase["setting_$setting[varname]_title"];
			$lastgroup = $setting['grouptitle'];
		}

		$altmode = 0;
		$linktext = new vB_Phrase('cpoption', 'collapse_setting_groups');
	}
	else
	{
		foreach ($settings AS $setting)
		{
			$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
			if ($setting['grouptitle'] != $lastgroup)
			{
				$grouptitlecache[$setting['grouptitle']] = $setting['grouptitle'];
				$options[$setting['grouptitle']] = $settingphrase["settinggroup_$setting[grouptitle]"];
			}
			$lastgroup = $setting['grouptitle'];
		}

		$altmode = 1;
		$linktext = new vB_Phrase('cpoption', 'expand_setting_groups');
	}
	
	$optionsmenu = "\n\t<select name=\"" . iif($cleaned['expand'], 'varname', 'dogroup') . "\" class=\"bginput\" tabindex=\"1\" " . iif(empty($cleaned['dogroup']), 'ondblclick="this.form.submit();" size="20"', 'onchange="this.form.submit();"') . " style=\"width:350px\">\n" . construct_select_options($options, iif($cleaned['dogroup'], $cleaned['dogroup'], '[all]')) . "\t</select>\n\t";
	
	print_form_header('thanks', 'options', false, true, 'groupForm', '90%', '', true, 'get');
	
	if (empty($cleaned['dogroup'])) // show the big <select> with no options
	{
		print_table_header(new vB_Phrase('cpglobal', 'vbulletin_options'));
		print_label_row(new vB_Phrase('cpglobal', 'settings_to_edit'), $optionsmenu);
		print_submit_row(new vB_Phrase('global', 'edit_settings'), 0);
	}
	else // show the small list with selected setting group(s) options
	{
		print_table_header(new vB_Phrase('cpglobal', 'setting_group') . " $optionsmenu <input type=\"submit\" value=\"" . new vB_Phrase('global', 'go') . "\" class=\"button\" tabindex=\"1\" />");
		print_table_footer();

		// show selected settings
		print_form_header('thanks', 'options', false, true, 'optionsform', '90%', '', true, 'post" onsubmit="return count_errors()');
		construct_hidden_code('action', 'dooptions');
		construct_hidden_code('dogroup', $cleaned['dogroup']);
		construct_hidden_code('advanced', $cleaned['advanced']);

		if ($cleaned['dogroup'] == '[all]') // show all settings groups
		{
			foreach ($grouptitlecache AS $curgroup => $group)
			{
				print_setting_group($curgroup, $cleaned['advanced']);
				echo '<tbody>';
				print_description_row("<input type=\"submit\" class=\"button\" value=\" " . new vB_Phrase('global', 'save') . " \" tabindex=\"1\" title=\"" . new vB_Phrase('cpoption', 'save_settings') . "\" />", 0, 2, 'tfoot" style="padding:1px" align="right');
				echo '</tbody>';
				print_table_break(' ');
			}
		}
		else
		{
			print_setting_group($cleaned['dogroup'], $cleaned['advanced']);
		}

		print_submit_row(new vB_Phrase('global', 'save'));

		?>
		<div id="error_output" style="font: 10pt courier new"></div>
		<script type="text/javascript">
		<!--
		var error_confirmation_phrase = "<?php echo new vB_Phrase('cpoption', 'error_confirmation_phrase'); ?>";
		//-->
		</script>
		<script type="text/javascript" src="<?php echo $vb_options['bburl']; ?>/clientscript/vbulletin_settings_validate.js?v=<?php echo SIMPLE_VERSION; ?>"></script>
		<?php
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'dooptions')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'setting'  => vB_Cleaner::TYPE_ARRAY,
		'advanced' => vB_Cleaner::TYPE_BOOL
	));

	if (!empty($cleaned['setting']))
	{
		$save = save_settings($cleaned['setting']);
		if ($save)
		{
			print_stop_message2('saved_settings_successfully', 'thanks',
				array('do' => 'options', 'dogroup' => $cleaned['dogroup'], 'advanced' => $cleaned['advanced']));
		}
		else
		{
			print_stop_message2('nothing_to_do');
		}
	}
	else
	{
		print_stop_message2('nothing_to_do');
	}
}

print_cp_footer();