<?php if (!defined('VB_ENTRY')) die('Access denied.');

require_once(DIR . '/packages/dbtechthanks/class_api_core.php');

/**
 * vB_Api_DBTechThanks
 *
 * @package DBTechThanks
 * @access public
 */
class DBTechThanks_Api_Thanks_Button extends DBTechThanks_Core
{
	public $title = 'Button API';
	public $version = '1.0.0';	
	public $extensionOrder = 9;


	/**
	 * Grabs the thanks data for a specific node's thread
	 *
	 * @return	boolean
	 */
	public static function getThanksData($prevResult, $node)
	{
		if (!$entrycache = vB_Api::instance('thanks_core')->_getCache('data.thread.' . $node['starter']))
		{
			// Init this
			$entrycache = array(
				'data' 			=> array(),
				'count' 		=> array(),
				'clicked' 		=> array(),
				'clickcount' 	=> array(),
			);

			// Sub-arrays
			$entrycache['data'][$node['nodeid']] = array();
			$entrycache['count'][$node['nodeid']] = array();
			$entrycache['clicked'][$node['nodeid']] = array();

			foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
			{
				// Default click count
				$entrycache['clickcount'][$button['varname']] = 0;
			}

			// get info
			$results = vB::getDbAssertor()->getRows('DBTechThanks:getEntriesByThread', array(
				'threadid' 		=> $node['starter'],
				'contenttypeid' => $node['contenttypeid'],
			));
			foreach ($results as $result)
			{
				// Raw data
				$entrycache['data'][$result['contentid']][$result['varname']][$result['userid']] = $result;
				
				// How many of each button was clicked
				$entrycache['count'][$result['contentid']][$result['varname']] = isset($entrycache['count'][$result['contentid']][$result['varname']]) ? $entrycache['count'][$result['contentid']][$result['varname']] + 1 : 1;
				
				// Whether the current user has clicked
				$entrycache['clicked'][$result['contentid']][$result['varname']] = isset($entrycache['clicked'][$result['contentid']][$result['varname']]) ? $entrycache['clicked'][$result['contentid']][$result['varname']] : false;
				$entrycache['clicked'][$result['contentid']][$result['varname']] = vB::getUserContext()->fetchUserId() == $result['userid'] ? true : $entrycache['clicked'][$result['contentid']][$result['varname']];
			}

						

			vB_Api::instance('thanks_core')->_writeCache('data.thread.' . $node['starter'], $entrycache, false, array('thanksEntryChg_' . $node['starter']));
		}

		return $entrycache;
	}
	/**
	 * Grabs the thanks data for a specific node's thread
	 *
	 * @return	boolean
	 */
	public static function fetchPostbitStats($prevResult, $node)
	{
		if (!$stats = vB_Api::instance('thanks_core')->_getCache('data.stats.' . $node['starter']))
		{
			$stats = $hasFixed = array();

			// get info
			$results = vB::getDbAssertor()->getRows('DBTechThanks:fetchStatsByThread', array(
				'threadid' 		=> $node['starter'],
			), false, 'userid');
			foreach ($results as $result)
			{
				foreach ($result as $key => $val)
				{
					if ($key == 'userid')
					{
						// Skip this
						continue;
					}

					if ($val === NULL)
					{
						// Odear.
						if (!isset($hasFixed[$result['userid']]))
						{
							// We need to fix stats records
							vB::getDbAssertor()->assertQuery('DBTechThanks:dbtech_thanks_statistics', array(
								vB_db_Query::TYPE_KEY => vB_db_Query::QUERY_INSERTIGNORE,
								'userid' => $result['userid'],
							));
							$hasFixed[$result['userid']] = true;
						}

						// Set a default value
						$val = 0;						
					}

					// Set ze stats
					$stats[$result['userid']][$key] = $val;					
				}
			}

			vB_Api::instance('thanks_core')->_writeCache('data.stats.' . $node['starter'], $stats, false, array('thanksEntryChg_' . $node['starter']));
		}

		// Shorthand
		$userInfo = vB_User::fetchUserinfo();		

		$retval = array();
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['disablestats_given'] AND !((int)$userInfo['dbtech_thanks_settings'] & (int)$button['bitfield']))
			{
				$retval[] = array(
					'title' => $button['title'] . ' (' . new vB_Phrase('global', 'dbtech_thanks_given') . ')',
					'num' 	=> $stats[$node['userid']][$button['varname'] . '_given']
				);
			}

			if (!$button['disablestats_received'] AND !((int)$userInfo['dbtech_thanks_settings'] & (int)$button['bitfield']))
			{
				$retval[] = array(
					'title' => $button['title'] . ' (' . new vB_Phrase('global', 'dbtech_thanks_received') . ')',
					'num' 	=> $stats[$node['userid']][$button['varname'] . '_received']
				);
			}
		}

		return $retval;
	}

	/**
	 * Whether we should be able to click a button / whether it should be displayed
	 *
	 * @return	boolean
	 */
	public static function getButtons($prevResult, $node)
	{
		if (!$noticeforum = vB_Api::instance('thanks_core')->_getCache('forumId.' . $node['starter'], vB_Cache::CACHE_FAST))
		{
			$top = vB_Api::instance('Content_Channel')->fetchTopLevelChannelIds();

			// Store notice forum
			$noticeforum = $top['forum'];

			

			// Write channelid
			vB_Api::instance('thanks_core')->_writeCache('forumId.' . $node['starter'], $noticeforum, false, array(), vB_Cache::CACHE_FAST);
		}

		// Grab what forum we're in
		$channels = vB_Api::instance('search')->getChannels(true);
		$forum = $channels[$noticeforum];

		// Grab the clicked data
		$entrycache = vB_Api::instance('thanks_button')->getThanksData($node);

		// Per-node data integrity validation
		if (!array_key_exists($node['nodeid'], $entrycache['data']))
		{
			$entrycache['data'][$node['nodeid']] = array();
		}
		if (!array_key_exists($node['nodeid'], $entrycache['count']))
		{
			$entrycache['count'][$node['nodeid']] = array();
		}
		if (!array_key_exists($node['nodeid'], $entrycache['clicked']))
		{
			$entrycache['clicked'][$node['nodeid']] = array();
		}

		$buttons = array();
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}

			if ((int)$forum['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
			{
				// Button was disabled for this thread
				continue;
			}

						
			
			if ((int)$node['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
			{
				// Button was disabled for this post
				continue;
			}

			if (vB_Api::instance('thanks_core')->checkPermissions($node, $button['permissions'], 'immune'))
			{
				// The target user is immune to this button click
				continue;
			}

			// Init this
			$button['_class'] = array();

			// Per-button data integrity validation
			if (!array_key_exists($button['varname'], $entrycache['data'][$node['nodeid']]))
			{
				$entrycache['data'][$node['nodeid']][$button['varname']] = array();
			}
			if (!array_key_exists($button['varname'], $entrycache['count'][$node['nodeid']]))
			{
				$entrycache['count'][$node['nodeid']][$button['varname']] = 0;
			}
			if (!array_key_exists($button['varname'], $entrycache['clicked'][$node['nodeid']]))
			{
				$entrycache['clicked'][$node['nodeid']][$button['varname']] = false;
			}

			// Shorthand
			$userInfo = vB_User::fetchUserinfo();

			if (!$userInfo['userid'])
			{
				// We can't click this button
				$button['_class'][] = 'h-disabled';
			}

			if ($userInfo['dbtech_thanks_excluded'])
			{
				// We can't click this button
				$button['_class'][] = 'h-disabled';
			}

			if (!vB_Api::instance('thanks_core')->checkPermissions($userInfo, $button['permissions'], 'canclick'))
			{
				// We can't click this button
				$button['_class'][] = 'h-disabled';
			}
			
			if ($userInfo['userid'] == $node['userid'])
			{
				// Can't click own posts' buttons
				$button['_class'][] = 'h-disabled';
			}
			
			if ($entrycache['clicked'][$node['nodeid']][$button['varname']])
			{
				$button['_class'][] = 'voted';

				if (!vB_Api::instance('thanks_core')->checkPermissions($userInfo, $button['permissions'], 'canunclick') OR !vB_Api::instance('thanks_core')->isPro())
				{
					// We can't un-click this button
					$button['_class'][] = 'h-disabled';
					$button['_text'] = $button['actiontext'];
				}
				else
				{
					// Show undo text
					$button['_text'] = $button['undotext'];
				}
			}
			else
			{
				// Store what text we're allowed to go with
				$button['_text'] = $button['actiontext'];

				if (!vB_Api::instance('thanks_core')->checkPermissions($userInfo, $button['permissions'], 'canclick'))
				{
					// We can't click this button
					$button['_class'][] = 'h-disabled';
				}
			}
			
			if ($userInfo['posts'] < $button['minposts'])
			{
				// Too few posts
				$button['_class'][] = 'h-disabled';
			}
			
			// Grab excluded buttons
			$excluded = self::_doButtonExclusive($entrycache, $node['nodeid'], vB::getUserContext()->fetchUserId());
			if (in_array($button['varname'], $excluded))
			{
				// We clicked another button that prevented this button click
				$button['_class'][] = 'h-disabled';
			}

			

			// Shorthand
			$button['_clicks'] = intval($entrycache['count'][$node['nodeid']][$button['varname']]);

			// Only unique classes plz
			$button['_class'] = implode(' ', array_unique($button['_class']));

			// Now finally dupe this
			$buttons[$button['buttonid']] = $button;
		}

		return $buttons;
	}

	/**
	 * Handler for clicking a button
	 *
	 * @return	boolean
	 */
	public function clickButton($prevResult, $nodeid, $varname)
	{
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}
			
			if ($button['varname'] == $varname)
			{
				// Copy this
				break;
			}
		}

		if (empty($button))
		{
			// Invalid varname
			throw new vB_Exception_Api('dbtech_thanks_invalid_button');
		}

		// Shorthand
		$userInfo = vB_User::fetchUserinfo();

		if (!$userInfo['userid'])
		{
			// We can't click this button
			throw new vB_Exception_Api('dbtech_thanks_guests_cannot_click');
		}

		if ($userInfo['dbtech_thanks_excluded'])
		{
			// We can't click this button
			throw new vB_Exception_Api('dbtech_thanks_youre_excluded');
		}

		if (!vB_Api::instance('thanks_core')->checkPermissions($userInfo, $button['permissions'], 'canclick'))
		{
			// We can't click this button
			throw new vB_Exception_Api('dbtech_thanks_no_permissions_click');
		}

		if ($userInfo['posts'] < $button['minposts'])
		{
			// Too few posts
			throw new vB_Exception_Api('dbtech_thanks_too_few_posts');
		}		

		// Grab the post info
		if (!$node = vB_Api::instance('node')->getNodeFullContent($nodeid))
		{
			// Invalid post id
			throw new vB_Exception_Api('dbtech_thanks_invalid_postid');
		}

		// Shorthand
		$node = $node[$nodeid];

		if ($node['userid'] == $userInfo['userid'])
		{
			// Can't click for own posts
			throw new vB_Exception_Api('dbtech_thanks_cant_click_own_posts');
		}

		if (vB_Api::instance('thanks_core')->checkPermissions($node, $button['permissions'], 'immune'))
		{
			// The target user is immune to this button click
			throw new vB_Exception_Api('dbtech_thanks_recipient_immune');
		}

		$channels = vB_Api::instance('search')->getChannels(true);
		$top = vB_Api::instance('Content_Channel')->fetchTopLevelChannelIds();

		// Store notice forum
		$noticeforum = $top['forum'];

		

		if (!vB::getUserContext()->getChannelPermission('forumpermissions', 'canview', $noticeforum))
		{
			throw new vB_Exception_Api('dbtech_thanks_cannot_view_forum');
		}	

		if ((int)$channels[$noticeforum]['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
		{
			// Button was disabled for this forum
			throw new vB_Exception_Api('dbtech_thanks_button_disabled_forum');
		}

		

		/*
		if ((int)$node['disabledbuttons_thread'] & (int)$button['bitfield'])
		{
			// Button was disabled for this thread
			throw new vB_Exception_Api('dbtech_thanks_button_disabled_thread');
		}
		 */

		if ((int)$node['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
		{
			// Button was disabled for this post
			throw new vB_Exception_Api('dbtech_thanks_button_disabled_post');
		}

		// Grab the clicked data
		$entrycache = vB_Api::instance('thanks_button')->getThanksData($node);

		if (array_key_exists($button['varname'], $entrycache['clicked'][$nodeid]) AND $entrycache['clicked'][$nodeid][$button['varname']] AND (!vB_Api::instance('thanks_core')->checkPermissions($userInfo, $button['permissions'], 'canunclick') OR !vB_Api::instance('thanks_core')->isPro()))
		{
			// We can't un-click this button
			throw new vB_Exception_Api('dbtech_thanks_button_cannot_unclick');
		}

		// Grab excluded buttons
		$excluded = self::_doButtonExclusive($entrycache, $nodeid, vB::getUserContext()->fetchUserId());
		if (in_array($button['varname'], $excluded))
		{
			// We clicked another button that prevented this button click
			throw new vB_Exception_Api('dbtech_thanks_button_exclusive');
		}

		// Shorthand
		$button['_text'] = $button['actiontext'];

		

		// We now have everything we need to build the entry info
		$entryinfo = array(
			'varname' 			=> $button['varname'],
			'userid' 			=> vB::getUserContext()->fetchUserId(),
			'contenttype' 		=> 'node',
			'contentid' 		=> $nodeid,
			'receiveduserid' 	=> $node['userid']
		);

		// Save the click
		$dm = new DBTechThanks_DataManager_Entry(vB_DataManager_Constants::ERRTYPE_SILENT);
		
		// button fields
		foreach ($entryinfo AS $key => $val)
		{
			// These values are always fresh
			$dm->set($key, $val);
		}
		
		// Save! Hopefully.
		$entryid = $dm->save();

		if (!$entryid)
		{
			// Unknown error
			throw new vB_Exception_Api('dbtech_thanks_unknown_click_error');
		}

		// Ensure the cache is purged
		vB_Api::instance('thanks_core')->_execEvent(array('thanksEntryChg_' . $node['starter'], 'thanksEntryChg'));

		$starterNode = array(
			'nodeid' 		=> $node['starter'],
			'channelid' 	=> $node['channelid'],
			'route' 		=> $node['starterroute'],
			'title' 		=> $node['startertitle'],
			'authorname' 	=> $node['starterauthorname'],
			'prefixid' 		=> $node['starterprefixid'],
			'userid' 		=> $node['starteruserid'],
			'lastcontentid' => $node['starterlastcontentid'],
			'totalcount' 	=> $node['startertotalcount'],
			'urlident' 		=> $node['starterurlident'],
		);

		
		$maildata = vB_Api::instanceInternal('phrase')->fetchEmailPhrases('dbtech_thanks_click_received_notif', 
			array(
				$receivedUserInfo['username'],
				$userInfo['username'],
				$button['title'],
				($node['nodeid'] == $node['starter'] ? 'thread' : 'post'),
				($node['title'] != '(Untitled)' ? $node['title'] : $node['startertitle']),
				vB_Api::instance('route')->getUrl($node['routeid'] . '|nosession|fullurl', $starterNode, array('p' => $node['nodeid'])),
				vB::getDatastore()->getOption('bbtitle'),
			),
			array(
				$button['title'],
				vB::getDatastore()->getOption('bbtitle'),
			),
			$receivedUserInfo['languageid']
		);

		// Notification regarding new click
		$data = array('sentto' => $node['userid'], 'title' => $maildata['subject'], 'rawtext' => $maildata['message'], 'sender' => vB::getUserContext()->fetchUserId());
		$messageLibrary = vB_Library::instance('Content_Privatemessage');
		$messageLibrary->add($data);
		

		return array(
			'clicks' => (array_key_exists($button['varname'], $entrycache['count'][$nodeid]) ? intval($entrycache['count'][$nodeid][$button['varname']]) : 0) + 1,
			'undoText' => $button['_text']
		);
	}

	/*DBTECH_PRO_START*/
	/**
	 * Handler for clicking a button
	 *
	 * @return	boolean
	 */
	public function unClickButton($prevResult, $nodeid, $varname)
	{
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}
			
			if ($button['varname'] == $varname)
			{
				// Copy this
				break;
			}
		}

		if (empty($button))
		{
			// Invalid varname
			throw new vB_Exception_Api('dbtech_thanks_invalid_button');
		}

		// Shorthand
		$userInfo = vB_User::fetchUserinfo();		

		if (!$userInfo['userid'])
		{
			// We can't click this button
			throw new vB_Exception_Api('dbtech_thanks_guests_cannot_click');
		}

		if ($userInfo['dbtech_thanks_excluded'])
		{
			// We can't click this button
			throw new vB_Exception_Api('dbtech_thanks_youre_excluded');
		}

		if (!vB_Api::instance('thanks_core')->checkPermissions($userInfo, $button['permissions'], 'canunclick'))
		{
			// We can't click this button
			throw new vB_Exception_Api('dbtech_thanks_button_cannot_unclick');
		}

		if ($userInfo['posts'] < $button['minposts'])
		{
			// Too few posts
			throw new vB_Exception_Api('dbtech_thanks_too_few_posts');
		}		

		// Grab the post info
		if (!$node = vB_Api::instance('node')->getNodeFullContent($nodeid))
		{
			// Invalid post id
			throw new vB_Exception_Api('dbtech_thanks_invalid_postid');
		}

		// Shorthand
		$node = $node[$nodeid];

		if ($node['userid'] == $userInfo['userid'])
		{
			// Can't click for own posts
			throw new vB_Exception_Api('dbtech_thanks_cant_click_own_posts');
		}

		if (vB_Api::instance('thanks_core')->checkPermissions($node, $button['permissions'], 'immune'))
		{
			// The target user is immune to this button click
			throw new vB_Exception_Api('dbtech_thanks_recipient_immune');
		}

		$channels = vB_Api::instance('search')->getChannels(true);
		$top = vB_Api::instance('Content_Channel')->fetchTopLevelChannelIds();

		// Store notice forum
		$noticeforum = $top['forum'];

		

		if (!vB::getUserContext()->getChannelPermission('forumpermissions', 'canview', $noticeforum))
		{
			throw new vB_Exception_Api('dbtech_thanks_cannot_view_forum');
		}	

		if ((int)$channels[$noticeforum]['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
		{
			// Button was disabled for this forum
			throw new vB_Exception_Api('dbtech_thanks_button_disabled_forum');
		}

		

		/*
		if ((int)$node['disabledbuttons_thread'] & (int)$button['bitfield'])
		{
			// Button was disabled for this thread
			throw new vB_Exception_Api('dbtech_thanks_button_disabled_thread');
		}
		 */

		if ((int)$node['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
		{
			// Button was disabled for this post
			throw new vB_Exception_Api('dbtech_thanks_button_disabled_post');
		}

		if (!$existing = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_entry', array(
			vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array(
				array('field' => 'varname', 	'value' => $button['varname'], 						'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'userid', 		'value' => vB::getUserContext()->fetchUserId(), 	'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'contenttype', 'value' => 'node', 									'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'contentid', 	'value' => $nodeid, 								'operator' => vB_dB_Query::OPERATOR_EQ)
			),
		)))
		{
			throw new vB_Exception_Api('dbtech_thanks_button_not_clicked');
		}

		// Grab the clicked data
		$entrycache = vB_Api::instance('thanks_button')->getThanksData($node);

		// Remove the click
		$dm = new DBTechThanks_DataManager_Entry(vB_DataManager_Constants::ERRTYPE_SILENT);
			$dm->set_existing($existing);
		$dm->delete();

		// Ensure the cache is purged
		vB_Api::instance('thanks_core')->_execEvent(array('thanksEntryChg_' . $node['starter'], 'thanksEntryChg'));

		return array(
			'clicks' => intval($entrycache['count'][$nodeid][$button['varname']]) - 1,
			'actionText' => $button['actiontext'],
		);
	}
	/*DBTECH_PRO_END*/

	public function fetchWhoClicked($prevResult, $nodeid, $varname)
	{
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}
			
			if ($button['varname'] == $varname)
			{
				// Copy this
				break;
			}
		}

		if (empty($button))
		{
			// Invalid varname
			throw new vB_Exception_Api('dbtech_thanks_invalid_button');
		}

		$users = vB::getDbAssertor()->getRows('DBTechThanks:fetchWhoClicked', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED,
			'nodeid' => $nodeid,
			'varname' => $varname,
		));

		foreach ($users as &$user)
		{
			$user['ismoderator'] = false;
			$user['isadmin'] = false;

			$usercontext = &vB::getUserContext($user['userid']);

			if ($usercontext->hasAdminPermission('ismoderator'))
			{
				$user['ismoderator'] = true;
			}
			if ($usercontext->hasAdminPermission('cancontrolpanel'))
			{
				$user['isadmin'] = true;
			}
			$user['avatarurl'] 	= vB_Api::instance('user')->fetchAvatar($user['userid']);
			$user['avatarurl'] 	= $user['avatarurl']['avatarpath'];
			$user['profileurl'] =  vB5_Route::buildUrl('profile|nosession', array('userid' => $user['userid']));
			$user['musername'] 	= vB_Api::instanceInternal('user')->fetchMusername($user);			
		}

		return $users;		
	}

	/**
	 * Checks what buttons should be flagged as exclusive
	 *
	 * @return	array
	 */
	protected static function _doButtonExclusive($entrycache, $nodeId, $userId)
	{
		$excluded = array();
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!array_key_exists($button['varname'], $entrycache['data'][$nodeId]))
			{
				// No clicks
				continue;
			}
			if (!array_key_exists($userId, $entrycache['data'][$nodeId][$button['varname']]))
			{
				// No clicks
				continue;
			}

			if (!$button['exclusivity'])
			{
				// No exclusivity
				continue;
			}
			
			foreach (vB_Api::instance('thanks_core')->getCache('button') as $excludebutton)
			{
				if (!((int)$button['exclusivity'] & (int)$excludebutton['bitfield']))
				{
					// No exclusivity
					continue;
				}
				
				// This button is exclusive
				$excluded[] = $excludebutton['varname'];
			}
		}

		return $excluded;
	}
}
?>