<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'button' 	=> vB_Api::instance('thanks_core')->getCache('button'),
);
$vb5_config =& vB::getConfig();

// Store the bitfield defs we need
$bitfields = array(
	'disableintegration' 	=> 'dbtech_thanks_disable_integration',
	'postfontsettings' 		=> 'dbtech_thanks_postfont_settings',
);

// #############################################################################
if ($_REQUEST['action'] == 'button' OR empty($_REQUEST['action']))
{
	print_cp_header(new vB_Phrase('hooks', 'dbtech_thanks_button_management'));
	
	// Table header
	$headings = array();
	$headings[] = new vB_Phrase('global', 'title');
	$headings[] = new vB_Phrase('cpglobal', 'varname');
	$headings[] = new vB_Phrase('global', 'description');
	$headings[] = new vB_Phrase('global', 'active');
	$headings[] = new vB_Phrase('cpglobal', 'display_order');
	$headings[] = preg_replace('/<dfn>.*<\/dfn>/isU', '', new vB_Phrase('hooks', 'dbtech_thanks_action_text'));
	
	//$headings[] = new vB_Phrase('global', 'reputation');
	$headings[] = new vB_Phrase('global', 'edit');
	
	
	
	if (count($_cache['button']))
	{
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'displayorder');
		print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_button_management'), count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach ($_cache['button'] as $buttonid => $button)
		{
			// Table data
			$cell = array();
			$cell[] = $button['title'];
			$cell[] = $button['varname'];
			$cell[] = $button['description'];
			$cell[] = ($button['active'] ? new vB_Phrase('global', 'yes') : '<span class="col-i"><strong>' . new vB_Phrase('global', 'no') . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$buttonid]\" value=\"$button[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . new vB_Phrase('forum', 'edit_display_order') . "\" />";
			$cell[] = $button['actiontext'];
			
			//$cell[] = $button['reputation'];
			$cell[] = construct_link_code(new vB_Phrase('global', 'edit'), 'thanks.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=button&amp;action=modify&amp;buttonid=' . $buttonid);
			
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		
		if (vB_Api::instance('thanks_core')->isPro())
		{
			
		}
		else
		{
			/*DBTECH_LITE_START*/
			print_table_footer();
			/*DBTECH_LITE_END*/
		}
	}
	else
	{
		/*DBTECH_LITE_START*/
		if (!vB_Api::instance('thanks_core')->isPro())
		{
			print_stop_message('dbtech_thanks_invalid_x', new vB_Phrase('global', 'dbtech_thanks_button'), 0);
		}
		/*DBTECH_LITE_END*/
		
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'modify');
		print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_button_management'), count($headings));
		print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_no_buttons'), false, count($headings));
		print_submit_row(new vB_Phrase('hooks', 'dbtech_thanks_add_new_button'), false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	// Ensure we can fetch bitfields
	require_once(DIR . '/packages/dbtechthanks/adminfunctions.php');
	
	$cleaned = vB::getCleaner()->clean($_REQUEST, 'buttonid', vB_Cleaner::TYPE_UINT);
	$buttonid = $cleaned['buttonid'];
	$button = ($buttonid ? $_cache['button'][$buttonid] : false);
	
	if (!is_array($button))
	{
		// Non-existing button
		$buttonid = 0;
	}
	
	$defaults = array(
		'varname'		=> 'recommends',
		'title' 		=> 'Recommend',
		'description' 	=> '"Recommend" this post.',
		'displayorder' 	=> 10,
		'active' 		=> 1,
		'actiontext' 	=> 'Recommend this post',
		'listtext' 		=> 'recommended this post',
		'undotext' 		=> 'Unrecommend',
		'minposts' 		=> 0,
		'clicksperday' 	=> 0,
		//'reputation'	=> 1,
		'postfont' 		=> array(
			1 => array(
				'threshold' => '',
				'color' 	=> '',
				'settings' 	=> 12,
			),
			2 => array(
				'threshold' => '',
				'color' 	=> '',
				'settings' 	=> 12,
			),
			3 => array(
				'threshold' => '',
				'color' 	=> '',
				'settings' 	=> 12,
			),
			4 => array(
				'threshold' => '',
				'color' 	=> '',
				'settings' 	=> 12,
			),
			5 => array(
				'threshold' => '',
				'color' 	=> '',
				'settings' 	=> 12,
			),
		),
	);
	
	$colours = array(
		'' 			=> '',
		
		// sRGB colours
		'White' 	=> 'White',
		'Silver' 	=> 'Silver',
		'Gray' 		=> 'Gray',
		'Black' 	=> 'Black',
		'Red' 		=> 'Red',
		'Maroon' 	=> 'Maroon',
		'Yellow' 	=> 'Yellow',
		'Olive' 	=> 'Olive',
		'Lime' 		=> 'Lime',
		'Green' 	=> 'Green',
		'Aqua' 		=> 'Aqua',
		'Teal' 		=> 'Teal',
		'Blue' 		=> 'Blue',
		'Navy' 		=> 'Navy',
		'Fuchsia' 	=> 'Fuchsia',
		'Purple' 	=> 'Purple',
	);
	
	if ($buttonid)
	{
		// Edit
		print_cp_header(strip_tags(new vB_Phrase('hooks', 'dbtech_thanks_editing_x_y', new vB_Phrase('global', 'dbtech_thanks_button'), $button['title'])));
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'update');
		construct_hidden_code('buttonid', $buttonid);
		print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_editing_x_y', new vB_Phrase('global', 'dbtech_thanks_button'), $button['title']));
	}
	else
	{
		/*DBTECH_LITE_START*/
		if (!vB_Api::instance('thanks_core')->isPro())
		{
			print_stop_message('dbtech_thanks_invalid_x', new vB_Phrase('global', 'dbtech_thanks_button'), 0);
		}
		/*DBTECH_LITE_END*/

		// Add
		print_cp_header(new vB_Phrase('hooks', 'dbtech_thanks_add_new_button'));
		print_form_header('thanks', 'button');
		construct_hidden_code('action', 'update');
		print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_add_new_button'));
		
		$button = $defaults;
	}
	
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_main_settings'), false, 2, 'optiontitle');	
	if ($buttonid)
	{
		construct_hidden_code('button[varname]', 																														$button['varname']);		
		print_label_row(new vB_Phrase('cpglobal', 'varname'), 																											$button['varname']);
	}
	else
	{
		print_input_row(new vB_Phrase('cpglobal', 'varname'), 								'button[varname]', 															$button['varname']);
	}
	print_input_row(new vB_Phrase('global', 'title'), 										'button[title]', 															$button['title']);
	print_textarea_row(new vB_Phrase('global', 'description'),								'button[description]',														$button['description']);
	print_input_row(new vB_Phrase('cpglobal', 'display_order'), 							'button[displayorder]', 													$button['displayorder']);
	print_yes_no_row(new vB_Phrase('global', 'active'),										'button[active]',															$button['active']);
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_button_settings'), false, 2, 'optiontitle');
	print_textarea_row(new vB_Phrase('hooks', 'dbtech_thanks_action_text'), 				'button[actiontext]', 														$button['actiontext']);
	//print_textarea_row(new vB_Phrase('hooks', 'dbtech_thanks_list_text'), 					'button[listtext]', 														$button['listtext']);
	 
	//print_input_row(new vB_Phrase('global', 'reputation'), 									'button[reputation]', 														$button['reputation']);
	//print_yes_no_row(new vB_Phrase('hooks', 'dbtech_thanks_default_button_attach'),			'button[defaultbutton_attach]',												$button['defaultbutton_attach']);
	//print_yes_no_row(new vB_Phrase('hooks', 'dbtech_thanks_default_button_content'),		'button[defaultbutton_content]',											$button['defaultbutton_content']);	
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_thanks_disable_stats_given'),			'button[disablestats_given]',												$button['disablestats_given']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_thanks_disable_stats_received'),		'button[disablestats_received]',											$button['disablestats_received']);
	print_bitfield_row(new vB_Phrase('hooks', 'dbtech_thanks_post_disabled_integration'), 	'button[disableintegration]', 	$bitfields['disableintegration'], 			$button['disableintegration']);
	 	
	
	print_table_break();
	
	// Table header
	$headings = array();
	$headings[] = '<label><input type="checkbox" rel="^-button[permissions]" />' . new vB_Phrase('global', 'usergroup') . '</label>';
	$headings[] = '<label><input type="checkbox" rel="*-[canclick]" />' . new vB_Phrase('hooks', 'dbtech_thanks_can_click') . '</label>';
	$headings[] = '<label><input type="checkbox" rel="*-[canreqclick]" />' . new vB_Phrase('hooks', 'dbtech_thanks_can_require_click') . '</label>';
	
	
	$cells = array();
	$cells[] = 'canclick';
	$cells[] = 'canreqclick';
	
	
	print_table_header(new vB_Phrase('global', 'dbtech_thanks_permissions'), count($headings));
	print_cells_row($headings, 0, 'thead');
	foreach (vB::getDatastore()->get_value('usergroupcache') as $usergroupid => $usergroup)
	{
		// Table data
		$cell = array();
		$cell[] = '<label><input type="checkbox" rel="^-button[permissions][' . $usergroupid . ']" />' . $usergroup['title'] . '</label>';
		foreach ($cells as $permtitle)
		{
			$cell[] = '<center>
				<input type="hidden" name="button[permissions][' . $usergroupid . '][' . $permtitle . ']" value="0" />
				<input type="checkbox" name="button[permissions][' . $usergroupid . '][' . $permtitle . ']" value="1"' . ($button['permissions'][$usergroupid][$permtitle] ? ' checked="checked"' : '') . ($vb5_config['Misc']['debug'] ? ' title="name=&quot;button[permissions][' . $usergroupid . '][' . $permtitle . ']&quot;"' : '') . '/>
			</center>';
		}
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
	}
	print_table_break();
	
	// Table header
	$headings = array();
	$headings[] = new vB_Phrase('global', 'dbtech_thanks_button');
	$headings[] = new vB_Phrase('hooks', 'dbtech_thanks_is_exclusive');
	
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_button_exclusivity'), count($headings));
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_button_exclusivity_descr'), false, count($headings));
	print_cells_row($headings, 0, 'thead');
	foreach ($_cache['button'] as $button_id => $button_info)
	{
		if ($button_id == $buttonid)
		{
			// Can't set to own button, lol
			continue;
		}
		
		// Table data
		$cell = array();
		$cell[] = $button_info['title'];
		$cell[] = '<center>
			<input type="hidden" name="button[exclusivity][' . $button_id . ']" value="0" />
			<input type="checkbox" name="button[exclusivity][' . $button_id . ']" value="' . $button_info['bitfield'] . '"' . (((int)$button['exclusivity'] & (int)$button_info['bitfield']) ? ' checked="checked"' : '') . ($vb5_config['Misc']['debug'] ? ' title="name=&quot;button[exclusivity][' . $button_id . ']&quot;"' : '') . '/>
		</center>';
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
	}
	print_table_break();
	print_submit_row(($buttonid ? new vB_Phrase('global', 'save') : new vB_Phrase('hooks', 'dbtech_thanks_add_new_button')), new vB_Phrase('global', 'reset'), count($headings));	
	echo '<script type="text/javascript" src="' . vB::getDatastore()->getOption('frontendurl') . '/js/jquery/jquery-' . JQUERY_VERSION . '.min.js"></script>';
	echo '<script type="text/javascript" src="' . vB::getDatastore()->getOption('frontendurl') . '/core/packages/dbtechthanks/js/admin.js"></script>';
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'buttonid' 	=> vB_Cleaner::TYPE_UINT,
		'button' 	=> vB_Cleaner::TYPE_ARRAY,
	));
	
	 

	// init data manager
	$dm = new DBTechThanks_DataManager_Button(vB_DataManager_Constants::ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($cleaned['buttonid'])
	{
		if (!$existing = $_cache['button'][$cleaned['buttonid']])
		{
			// Couldn't find the button
			print_stop_message('dbtech_thanks_invalid_x', new vB_Phrase('global', 'dbtech_thanks_button'), $cleaned['buttonid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
	}
	else
	{
		/*DBTECH_LITE_START*/
		if (!vB_Api::instance('thanks_core')->isPro())
		{
			print_stop_message('dbtech_thanks_invalid_x', new vB_Phrase('global', 'dbtech_thanks_button'), 0);
		}
		/*DBTECH_LITE_END*/
	}
	
	// button fields
	foreach ($cleaned['button'] AS $key => $val)
	{
		// Only set changed values
		$dm->set($key, $val);
	}
	
	// Save! Hopefully.
	$dm->save();

	print_stop_message2(array('dbtech_thanks_x_y',
		new vB_Phrase('global', 'dbtech_thanks_button'),
		new vB_Phrase('hooks', ($cleaned['buttonid'] ? 'dbtech_thanks_edited' : 'dbtech_thanks_added'))
	), 'thanks', array(
		'do' => 'button',
	));
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'order' => vB_Cleaner::TYPE_ARRAY
	));
	
	if (is_array($cleaned['order']))
	{
		foreach ($cleaned['order'] as $buttonid => $displayorder)
		{
			if (!$existing = $_cache['button'][$buttonid])
			{
				// Couldn't find the button
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm = new DBTechThanks_DataManager_Button(vB_DataManager_Constants::ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}

	print_stop_message2('saved_display_order_successfully', 'thanks', array(
		'do' => 'button',
	));
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$cleaned = vB::getCleaner()->clean($_REQUEST, 'buttonid', vB_Cleaner::TYPE_UINT);
	$buttonid = $cleaned['buttonid'];
	
	print_cp_header(new vB_Phrase('hooks', 'dbtech_thanks_delete_x', new vB_Phrase('global', 'dbtech_thanks_button')));
	print_delete_confirmation('DBTechThanks:dbtech_thanks_button', $buttonid, 'thanks', 'button', 'dbtech_thanks_button', array('action' => 'kill'), '', 'title', 'buttonid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'buttonid' 	=> vB_Cleaner::TYPE_UINT,
		'kill' 		=> vB_Cleaner::TYPE_BOOL
	));
	
	if (!$existing = $_cache['button'][$cleaned['buttonid']])
	{
		// Couldn't find the button
		print_stop_message('dbtech_thanks_invalid_x', new vB_Phrase('global', 'dbtech_thanks_button'), $cleaned['buttonid']);
	}
	
	// init data manager
	$dm = new DBTechThanks_DataManager_Button(vB_DataManager_Constants::ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	print_stop_message2(array('dbtech_thanks_x_y',
		new vB_Phrase('global', 'dbtech_thanks_button'),
		new vB_Phrase('hooks', 'dbtech_thanks_deleted')
	), 'thanks', array(
		'do' => 'button',
	));
}


print_cp_footer();