<?php

if (self::$db_alter->fetch_table_info('node'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_disabledbuttons',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));	
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_requiredbuttons_content',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));	
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_requiredbuttons_attach',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));	
	self::report('Altered Table', 'node');
}

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_thanks_alertcount',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));	
	self::report('Altered Table', 'user');
}

// New Tables
self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_thanks_button`
	(
		`buttonid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT,
		`varname` VARCHAR( 50 ) NOT NULL ,
		`title` VARCHAR( 50 ) NOT NULL ,
		`description` MEDIUMTEXT NOT NULL ,
		`active` TINYINT( 1 ) NOT NULL DEFAULT '1',
		`actiontext` VARCHAR( 250 ) NOT NULL ,
		`listtext` VARCHAR( 250 ) NOT NULL ,
		`undotext` VARCHAR( 250 ) NOT NULL ,
		`reputation` INT( 10 ) NOT NULL DEFAULT '0',
		`permissions` MEDIUMTEXT NULL DEFAULT NULL,
		`bitfield` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`buttonid`)
	) ENGINE=MyISAM;
");
self::report('Created Table', 'dbtech_thanks_button');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_thanks_statistics`
	(
		`userid` INT( 10 ) UNSIGNED NOT NULL ,
		`thanks_given` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`thanks_received` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`likes_given` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`likes_received` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`dislikes_given` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`dislikes_received` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		PRIMARY KEY (`userid`)
	) ENGINE=MyISAM;
");
self::report('Created Table', 'dbtech_thanks_statistics');

// Populated Tables
self::$db->query_write("
	INSERT IGNORE INTO `" . TABLE_PREFIX . "dbtech_thanks_button` 
		(`buttonid`, `varname`, `title`, `description`, `actiontext`, `listtext`, `undotext`, `reputation`, `bitfield`) 
	VALUES (
		1, 'thanks', 'Thanks', '\"Thank\" for a post.', 'Thanks', 'thanked for this post', 'Unthank', 1, 1
	)
");
self::$db->query_write("
	INSERT IGNORE INTO `" . TABLE_PREFIX . "dbtech_thanks_button` 
		(`buttonid`, `varname`, `title`, `description`, `actiontext`, `listtext`, `undotext`, `reputation`, `bitfield`) 
	VALUES(
		2, 'likes', 'Likes', '\"Likes\" for a post.', 'Like', 'liked this post', 'Unlike', 1, 2
	)
");
self::$db->query_write("
	INSERT IGNORE INTO `" . TABLE_PREFIX . "dbtech_thanks_button` 
		(`buttonid`, `varname`, `title`, `description`, `actiontext`, `listtext`, `undotext`, `reputation`,  `bitfield`) 
	VALUES (
		3, 'dislikes', 'Dislikes', '\"Dislike\" a post.', 'Dislike', 'disliked this post', 'Undislike', -2, 4
	)
");
self::report('Populated Table', 'dbtech_thanks_button');