<?php if (!defined('VB_ENTRY')) die('Access denied.');

class DBTechThanks_dB_MYSQL_QueryDefs extends vB_dB_QueryDefs
{
	protected $db_type = 'MYSQL';

	protected static $permission_string = false;

	/**
	 * This is the definition for tables.
	 */
	protected $table_data = array(
		'dbtech_thanks_button' => array(
			'key' => 'buttonid',
			'structure' => array(
				'buttonid', 'varname', 'title', 'description', 'active', 'actiontext', 'listtext', 'undotext', 'reputation',
				'permissions', 'bitfield', 'exclusivity', 'displayorder', 'minposts', 'clicksperday', 'postfont', 'defaultbutton_attach', 
				'defaultbutton_content', 'disablenotifs', 'disableemails', 'disablestats_given', 'disablestats_received', 'disableintegration'
			),
			'_isCacheable' 	=> true,
			'_tableShort' 	=> 'button',
			'_unserialize' 	=> array(
				'permissions',
				'postfont',
			),
		),
		'dbtech_thanks_entry' => array(
			'key' =>'entryid',
			'structure' => array(
				'entryid', 'varname', 'userid', 'receiveduserid', 'contenttype', 'contentid', 'dateline'
			),
		),
		'dbtech_thanks_statistics' => array(
			'key' =>'userid',
			'structure' => array(
				'userid'
			),
		),
	);

	/** This is the definition for queries we will process through.  We could also
	 * put them in the database, but this eliminates a query.
	 * * */
	protected $query_data = array(
		'getDataForCache-button' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT *
				FROM {TABLE_PREFIX}dbtech_thanks_button
				ORDER BY displayorder ASC
			"
		),
		'fetchSearchUsers' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT DISTINCT entry.userid, user.username
				FROM {TABLE_PREFIX}dbtech_thanks_entry AS entry
				LEFT JOIN {TABLE_PREFIX}user AS user USING(userid)
				ORDER BY username
			"
		),		
		'fetchMaintenanceEntriesCleanup' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT entry.*
				FROM {TABLE_PREFIX}dbtech_thanks_entry AS entry
				LEFT JOIN {TABLE_PREFIX}node AS node ON(node.nodeid = entry.contentid)
				WHERE entry.entryid >= {entryid}
					AND contenttype = 'post'
					AND node.nodeid IS NULL
				ORDER BY entry.entryid
				LIMIT {limit}
			"
		),
		'fetchMaintenanceEntriesRecalcGiven' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT COUNT(*) as value, varname
				FROM {TABLE_PREFIX}dbtech_thanks_entry
				WHERE userid = {userid}
				GROUP BY varname
			"
		),
		'fetchMaintenanceEntriesRecalcReceived' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT COUNT(*) as value, varname
				FROM {TABLE_PREFIX}dbtech_thanks_entry
				WHERE receiveduserid = {userid}
				GROUP BY varname
			"
		),
		'fetchMaintenanceEntriesRebuild' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT *
				FROM {TABLE_PREFIX}dbtech_thanks_entry
				WHERE userid = {userid}
					OR receiveduserid = {userid}
			"
		),
		'fetchMaintenanceEntriesRecalcRep' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_UPDATE,
			'query_string' => "
				UPDATE {TABLE_PREFIX}user
				SET reputation = reputation + {reputation}
				WHERE userid = {userid}
			"
		),
		'incrementAlertCount' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_UPDATE,
			'query_string' => "
				UPDATE `{TABLE_PREFIX}user`
				SET `dbtech_thanks_alertcount` = `dbtech_thanks_alertcount` + 1
				WHERE userid = {userid}
			"
		),
		'getEntriesByThread' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT * FROM {TABLE_PREFIX}dbtech_thanks_entry WHERE contentid IN(
					SELECT nodeid 
					FROM `{TABLE_PREFIX}node` 
					WHERE starter = {threadid} 
						AND contenttypeid = {contenttypeid}
				)
			"
		),
		'getEntryIdsByNodeButton' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT entryid
				FROM {TABLE_PREFIX}dbtech_thanks_entry 
				WHERE contentid = {nodeid}
					AND varname = {varname}
			"
		),
		'getEntriesByEntryIds' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT
					entry.*,
					user.*
				FROM {TABLE_PREFIX}dbtech_thanks_entry AS entry 
				LEFT JOIN {TABLE_PREFIX}user AS user USING(userid)
				WHERE entry.entryid IN({entryid})
				ORDER BY entry.entryid DESC
			"
		),
		'getNodeInfo' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT
					post.nodeid,
					post.contenttypeid,
					post.userid,
					post.starter,
					post.dbtech_thanks_disabledbuttons,
					thread.parentid AS forumid,
					thread.dbtech_thanks_disabledbuttons AS disabledbuttons_thread
				FROM {TABLE_PREFIX}node AS post 
				LEFT JOIN {TABLE_PREFIX}node AS thread ON(thread.nodeid = post.starter)
				WHERE post.nodeid = {nodeid}
			"
		),
		'fetchWhoClicked' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT user.userid, user.username
				FROM {TABLE_PREFIX}dbtech_thanks_entry AS entry
				INNER JOIN {TABLE_PREFIX}user AS user ON (user.userid = entry.userid)
				WHERE entry.contentid = {nodeid}
					AND entry.varname = {varname}
				ORDER BY entry.entryid DESC
			"
		),
		'fetchStatsByThread' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT stats.*, post.userid
				FROM {TABLE_PREFIX}node AS post
				LEFT JOIN {TABLE_PREFIX}dbtech_thanks_statistics AS stats ON (stats.userid = post.userid)
				WHERE post.starter = {threadid}
			"
		),
		'fetchEntries' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT
					post.nodeid AS postid,
					IF(post.title = '(Untitled)', thread.title, post.title) AS title,
					thread.nodeid,
					thread.routeid AS routeid,
					thread.parentid AS forumid,
					entry.*,
					user.*
				FROM {TABLE_PREFIX}dbtech_thanks_entry AS entry
				LEFT JOIN {TABLE_PREFIX}node AS post ON (post.nodeid = entry.contentid)
				LEFT JOIN {TABLE_PREFIX}node AS thread ON (thread.nodeid = post.starter)
				LEFT JOIN {TABLE_PREFIX}user AS user ON (user.userid = entry.userid)
				WHERE entry.entryid IN({entryid})
			"
		),
		'fetchTopEntries' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT contentid, COUNT(*) AS numentries, userid, receiveduserid
				FROM {TABLE_PREFIX}dbtech_thanks_entry
				WHERE varname = {varname}
					AND dateline >= {dateline}
				GROUP BY contentid
				ORDER BY numentries DESC
				LIMIT {limit}
			"
		),
	);

	/** Fetch settings by group
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function fetchSettingsByGroup($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}
		else
		{
			$sql = "SELECT setting.*, settinggroup.grouptitle
				FROM " . TABLE_PREFIX . "settinggroup AS settinggroup
				LEFT JOIN " . TABLE_PREFIX . "setting AS setting USING(grouptitle)
				WHERE 1=1";
			if ($params['product'])
			{
				$sql .= "
				    AND settinggroup.product LIKE '" . $params['product'] . "%'
				";
			}
			if (!$params['debug'])
			{
				$sql .= "
				    AND settinggroup.displayorder <> 0
				";
			}
			$sql .= "ORDER BY settinggroup.displayorder, setting.displayorder";

			return $this->_wrapper($sql, $db, $check_only);
		}
	}


	/** Count the commandlog rows
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function countSearchEntries($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		// Grab our sql conditions
		$sqlconds = $this->_searchPrepare($params, $db, $check_only);

		$sql = "
			SELECT COUNT(*) AS total
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
		";

		return $this->_wrapper($sql, $db, $check_only);
	}


	 /** Fetch the commandlog rows
	 * 
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function fetchSearchEntries($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		switch($params['orderby'])
		{
			case 'user':
				$params['order'] = 'username ASC, dateline DESC';
				break;
			case 'varname':
				$params['order'] = 'varname ASC, dateline DESC';
				break;
			case 'date':
			default:
				$params['order'] = 'dateline DESC';
		}

		// Grab our sql conditions
		$sqlconds = $this->_searchPrepare($params, $db, $check_only);

		$sql = "
			SELECT entry.*, user.username, post.title AS posttitle, thread.title AS threadtitle
			FROM " . TABLE_PREFIX . "dbtech_thanks_entry AS entry
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = entry.userid)
			LEFT JOIN " . TABLE_PREFIX . "node AS post ON (post.nodeid = entry.contentid)
			LEFT JOIN " . TABLE_PREFIX . "node AS thread ON (thread.nodeid = post.starter)
			" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
			ORDER BY " . $params['order'] . "
			LIMIT " . $params['startat'] . ", " . $params['perpage'] . "
		";

		return $this->_wrapper($sql, $db, $check_only);
	}



	/** Returns sql conds for the search
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	protected function _searchPrepare($params, vB_Database $db, $check_only = false)
	{
		$sqlconds = array();

		if (array_key_exists('userid', $params) AND $params['userid'])
		{
			$sqlconds[] = "entry.userid = " . $params['userid'];
		}
		
		if (array_key_exists('varname', $params) AND $params['varname'])
		{
			$sqlconds[] = "entry.varname LIKE '%" . $db->escape_string_like($params['varname']) . "%'";
		}
		
		if (array_key_exists('startdate', $params) AND $params['startdate'])
		{
			$sqlconds[] = "entry.dateline >= " . $params['startdate'];
		}
		
		if (array_key_exists('enddate', $params) AND $params['enddate'])
		{
			$sqlconds[] = "entry.dateline <= " . $params['enddate'];
		}

		return $sqlconds;
	}

	/** Wrapper function for query results
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function _wrapper($sql, vB_Database $db, $check_only = false)
	{
		$resultclass = 'vB_dB_' . $this->db_type . '_result';
		$config = vB::get_config();

		if (isset($config['Misc']['debug_sql']) AND $config['Misc']['debug_sql'])
		{
			echo "sql: $sql<br />\n";
		}

		$result = new $resultclass($db, $sql);
		return $result;
	}
}