<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Class to do data save/delete operations for Entries
*
* @package	Forumon
*/
class DBTechThanks_DataManager_Entry extends vB_DataManager
{
	/**
	* Array of recognised and required fields for entries, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'entryid' 			=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_INCR, 	vB_DataManager_Constants::VF_METHOD, 	'verify_nonzero'),
		'varname' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES, 		vB_DataManager_Constants::VF_METHOD),
		'userid' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES),
		'receiveduserid' 	=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES),		
		'contenttype' 		=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES),
		'contentid' 		=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES),
		'dateline' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'DBTechThanks:dbtech_thanks_entry';

	//Primary Key
	protected $keyField = 'entryid';

	/**
	* Verifies that the varname is valid
	*
	* @param	string	varname of the entry
	*
	* @return	boolean
	*/
	function verify_varname(&$varname)
	{
		$varname = strval($varname);
		if ($varname === '')
		{
			// Invalid
			return false;
		}
		
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}
			
			if ($button['varname'] == $varname)
			{
				// Exists
				$this->set_info('button', $button);
				return true;
			}
		}

		return false;
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		// Set the stats temporarily
		$timenow = vB::getRequest()->getTimeNow();
		$this->do_set('dateline', $timenow);		
		
		$return_value = true;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		if (!$this->condition)
		{
			// Add statistics
			$stats1 = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_statistics', array(
				vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::CONDITIONS_KEY => array(
					array('field' => 'userid', 'value' => intval($this->fetch_field('userid')), 'operator' => vB_dB_Query::OPERATOR_EQ)
				),
			));
			$stats2 = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_statistics', array(
				vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::CONDITIONS_KEY => array(
					array('field' => 'userid', 'value' => intval($this->fetch_field('receiveduserid')), 'operator' => vB_dB_Query::OPERATOR_EQ)
				),
			));

			if (!$stats1)
			{
				// Shouldn't happen, but just in case
				vB::getDbAssertor()->assertQuery('DBTechThanks:dbtech_thanks_statistics', array(
					vB_db_Query::TYPE_KEY => vB_db_Query::QUERY_INSERTIGNORE,
					'userid' => $this->fetch_field('userid'),
				));
				$stats1 = array(
					$this->fetch_field('varname') . '_given' => 0
				);
			}

			if (!$stats2)
			{
				// Shouldn't happen, but just in case
				vB::getDbAssertor()->assertQuery('DBTechThanks:dbtech_thanks_statistics', array(
					vB_db_Query::TYPE_KEY => vB_db_Query::QUERY_INSERTIGNORE,
					'userid' => $this->fetch_field('receiveduserid'),
				));
				$stats2 = array(
					$this->fetch_field('varname') . '_received' => 0
				);
			}

			// Now update
			vB::getDbAssertor()->update('DBTechThanks:dbtech_thanks_statistics', array(
				$this->fetch_field('varname') . '_given' => $stats1[$this->fetch_field('varname') . '_given'] + 1
			), array('userid' => intval($this->fetch_field('userid'))));
			
			vB::getDbAssertor()->update('DBTechThanks:dbtech_thanks_statistics', array(
				$this->fetch_field('varname') . '_received' => $stats1[$this->fetch_field('varname') . '_received'] + 1
			), array('userid' => intval($this->fetch_field('receiveduserid'))));

			if (!array_key_exists('disablenotifs', $this->info['button']) OR !$this->info['button']['disablenotifs'])
			{
				$entryGiven = vB::getDbAssertor()->assertQuery('DBTechThanks:incrementAlertCount', array(
					vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED,
					'userid' 	=> intval($this->fetch_field('receiveduserid')),
				));				
			}
		}

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		// Remove statistics
		$stats1 = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_statistics', array(
			vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array(
				array('field' => 'userid', 'value' => intval($this->existing['userid']), 'operator' => vB_dB_Query::OPERATOR_EQ)
			),
		));
		$stats2 = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_statistics', array(
			vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array(
				array('field' => 'userid', 'value' => intval($this->existing['receiveduserid']), 'operator' => vB_dB_Query::OPERATOR_EQ)
			),
		));

		// Now update
		vB::getDbAssertor()->update('DBTechThanks:dbtech_thanks_statistics', array(
			$this->fetch_field('varname') . '_given' => $stats1[$this->fetch_field('varname') . '_given'] - 1
		), array('userid' => intval($this->existing['userid'])));
		
		vB::getDbAssertor()->update('DBTechThanks:dbtech_thanks_statistics', array(
			$this->fetch_field('varname') . '_received' => $stats1[$this->fetch_field('varname') . '_received'] - 1
		), array('userid' => intval($this->existing['receiveduserid'])));
		
		return true;
	}
}