<?php if (!defined('VB_ENTRY')) die('Access denied.');

require_once(DIR . '/packages/dbtechthanks/class_api_core.php');

/**
 * vB_Api_DBTechThanks
 *
 * @package DBTechThanks
 * @access public
 */
class DBTechThanks_Api_Thanks_Widget extends DBTechThanks_Core
{
	public $title = 'Widget API';
	public $version = '1.0.0';	
	public $extensionOrder = 9;


	/**
	 * Grabs all active buttons indexed by varname
	 *
	 * @return	boolean
	 */
	public static function fetchButtons($prevResult, $widgetConfig, $widgetInstanceId)
	{
		$selectoptions = array();
		foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}

			// Add to select options
			$selectoptions[$button['varname']] = $button['title'];
		}

		return $selectoptions;			
	}

	/**
	 * Fetches the recent entries
	 *
	 * @return	boolean
	 */
	public static function fetchRecentEntries($prevResult, $widgetConfig, $widgetInstanceId)
	{
		if (!$entrycache = vB_Api::instance('thanks_core')->_getCache('data.widget.recent.' . $widgetInstanceId))
		{
			$entrycache = array();

			// Store the buttons
			$buttons = vB_Api::instance('thanks_widget')->fetchButtons($widgetConfig, $widgetInstanceId);

			// Ensure this is set
			$widgetConfig['datecutoff_amount'] 		= $widgetConfig['datecutoff_amount'] 	? $widgetConfig['datecutoff_amount'] 	: 1;
			$widgetConfig['datecutoff_timespan'] 	= $widgetConfig['datecutoff_timespan'] 	? $widgetConfig['datecutoff_timespan'] 	: 86400;
			
			$entryIds = $userIds = array();
			foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
			{
				if (!$button['active'])
				{
					// Inactive button
					continue;
				}

				$results = vB::getDbAssertor()->getRows('DBTechThanks:dbtech_thanks_entry', array(
					vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
					vB_dB_Query::COLUMNS_KEY 	=> array('entryid', 'userid'),
					vB_dB_Query::CONDITIONS_KEY => array(
						array('field' => 'varname', 'value' => $button['varname'], 'operator' => vB_dB_Query::OPERATOR_EQ),
					),
					vB_dB_Query::PARAM_LIMIT => $widgetConfig['maxresults'],
				), array('field' => 'entryid', 'direction' => vB_dB_Query::SORT_DESC));

				foreach ($results as $entry)
				{
					$entryIds[] = $entry['entryid'];

					// Store this
					$userIds[] = $entry['userid'];
				}
			}

			if (count($entryIds))
			{
				// Clean up the 2 arrays
				rsort($entryIds, SORT_NUMERIC);
				$userIds = array_unique($userIds);

				// Grab avatar info
				$avatarInfo = vB_Api::instance('user')->fetchAvatars($userIds);
				$avatarInfo = is_array($avatarInfo) ? $avatarInfo : array();

				$results = vB::getDbAssertor()->getRows('DBTechThanks:fetchEntries', array(
					vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_STORED,
					'entryid' => $entryIds
				), false, 'entryid');

				// Clean up the 2 arrays
				krsort($results, SORT_NUMERIC);			

				// Grab our channel reading permissions
				$userData = vB::getUserContext()->getReadChannels();

				foreach ($results as $entryid => $result)
				{
					// Append info
					$result['avatarInfo'] = $avatarInfo[$result['userid']];
					$result['buttontitle'] = $buttons[$result['varname']];
					$result['musername'] = vB_Api::instance('user')->fetchMusername($result);

					$result['showUrl'] = true;
					if (in_array($result['forumid'], $userData['cantRead']))
					{
						// We cannot access this channel
						$result['title'] = new vB_Phrase('hooks', 'dbtech_thanks_stripped_content');
						$result['showUrl'] = false;
					}

					// Now store entry cache
					$entrycache[$result['varname']][$entryid] = $result;
				}
			}

			vB_Api::instance('thanks_core')->_writeCache('data.widget.recent.' . $widgetInstanceId, $entrycache, false, array('thanksEntryChg'));			
		}

		return $entrycache;
	}

	/**
	 * Fetches the recent entries
	 *
	 * @return	boolean
	 */
	public static function fetchTopEntries($prevResult, $widgetConfig, $widgetInstanceId)
	{
		if (!$entrycache = vB_Api::instance('thanks_core')->_getCache('data.widget.top.' . $widgetInstanceId))
		{
			// Store the buttons
			$buttons = vB_Api::instance('thanks_widget')->fetchButtons($widgetConfig, $widgetInstanceId);

			// Ensure this is set
			$widgetConfig['datecutoff_amount'] 		= $widgetConfig['datecutoff_amount'] 	? $widgetConfig['datecutoff_amount'] 	: 1;
			$widgetConfig['datecutoff_timespan'] 	= $widgetConfig['datecutoff_timespan'] 	? $widgetConfig['datecutoff_timespan'] 	: 86400;
			
			$entryIds = $datastore = $userIds = $contentIds = array();
			foreach (vB_Api::instance('thanks_core')->getCache('button') as $button)
			{
				if (!$button['active'])
				{
					// Inactive button
					continue;
				}

				// Also init this
				$datastore[$button['varname']] = array();

				$results = vB::getDbAssertor()->getRows('DBTechThanks:fetchTopEntries', array(
					vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_STORED,
					'varname' => $button['varname'],
					'dateline' => (vB::getRequest()->getTimeNow() - ($widgetConfig['datecutoff_amount'] * $widgetConfig['datecutoff_timespan'])),
					'limit' => $widgetConfig['maxresults']
				));

				foreach ($results as $entry)
				{
					// Store a bunch of info
					$contentIds[] = $entry['contentid'];
					$datastore[$button['varname']][$entry['contentid']] = $entry['numentries'];
					$userIds[] = $entry['userid'];
					$userIds[] = $entry['receiveduserid'];
				}
			}

			// Uniqueify!
			$contentIds = array_unique($contentIds);
			$userIds = array_unique($userIds);

			// Trickery to get all content
			$nodeLib = vB_Library::instance('node');
			$nodes = vB_Api::instance('node')->getNodes($contentIds);
			$nodes = $nodeLib->addFullContentInfo($nodes);

			// Grab our channel reading permissions
			$userData = vB::getUserContext()->getReadChannels();

			$entrycache = array();
			foreach ($datastore as $varname => $contentids)
			{
				$entrycache[$varname] = array();
				foreach ($contentids as $contentid => $count)
				{
					// Grab this
					$result = $nodes[$contentid];

					// Append info
					$result['buttontitle'] = $buttons[$varname];
					$result['numentries'] = $count;

					$result['showUrl'] = true;
					if (in_array($result['content']['channelid'], $userData['cantRead']))
					{
						// We cannot access this channel
						$result['title'] = new vB_Phrase('hooks', 'dbtech_thanks_stripped_content');
						$result['showUrl'] = false;
					}

					// Set title
					$result['title'] = $result['title'] == '(Untitled)' ? $result['content']['startertitle'] : $result['title'];

					// Now store entry cache
					$entrycache[$varname][$contentid] = $result;
				}
			}

			vB_Api::instance('thanks_core')->_writeCache('data.widget.top.' . $widgetInstanceId, $entrycache, false, array('thanksEntryChg'));
		}

		return $entrycache;
	}
}
?>