<?php
// #############################################################################
/**
 * Constructs a bitfield row
 *
 * @param	string	The label text
 * @param	string	The name of the row for the form
 * @param	string	What bitfields we are using
 * @param	integer	The value of the setting
 */	
function print_bitfield_row($text, $name, $bitfield, $value)
{
	// make sure all rows use the alt1 class
	$bgcounter--;

	$value = intval($value);
	$HTML = '';
	$bitfielddefs = vB::getDatastore()->getValue('bf_misc_' . $bitfield);
	$config = vB::getConfig();

	if ($bitfielddefs === NULL)
	{
		print_label_row($text, new vB_Phrase('cpoption', 'settings_bitfield_error', new vB_Phrase('global', 'n_a')), '', 'top', $name, 40);
	}
	else
	{
		$HTML .= "<div id=\"ctrl_{$name}\" class=\"smallfont\">\r\n";
		$HTML .= "<input type=\"hidden\" name=\"{$name}[0]\" value=\"0\" />\r\n";
		foreach ($bitfielddefs AS $key => $val)
		{
			$val = intval($val);
			$HTML .= "<table style=\"width:175px; float:left\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr valign=\"top\">
			<td><input type=\"checkbox\" name=\"{$name}[$val]\" id=\"{$name}_$key\" value=\"$val\"" . (($value & $val) ? ' checked="checked"' : '') . ($config['Misc']['debug'] ? " title=\"name=&quot;{$name}[$val]&quot; value=&quot;$val&quot;\"" : '') . " /></td>
			<td width=\"100%\" style=\"padding-top:4px\"><label for=\"{$name}_$key\" class=\"smallfont\">" . new vB_Phrase('hooks', $key) . "</label></td>\r\n</tr></table>\r\n";
		}

		$HTML .= "</div>\r\n";
		print_label_row($text, $HTML, '', 'top', $name, 40);
	}		
}

// #############################################################################
/**
 * Prints a table row but not from a bitfield.
 *
 * @param	string	The label text
 * @param	string	The name of the row for the form
 * @param	string	What bitfields we are using
 * @param	integer	The value of the setting
 */	
function print_table_row($text, $name, $array, $value)
{
	// make sure all rows use the alt1 class
	$bgcounter--;

	$value = intval($value);
	$HTML = '';
	$config = vB::getConfig();

	$HTML .= "<div id=\"ctrl_{$name}\" class=\"smallfont\">\r\n";
	$HTML .= "<input type=\"hidden\" name=\"{$name}[0]\" value=\"0\" />\r\n";
	foreach ($array AS $key => $val)
	{
		$bit = intval($val['bitfield']);
		$HTML .= "<table style=\"width:175px; float:left\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr valign=\"top\">
		<td><input type=\"checkbox\" name=\"{$name}[$bit]\" id=\"{$name}_$key\" value=\"$bit\"" . (($value & (int)$bit) ? ' checked="checked"' : '') . ($config['Misc']['debug'] ? " title=\"name=&quot;{$name}[$bit]&quot; value=&quot;$bit&quot;\"" : '') . " /></td>
		<td width=\"100%\" style=\"padding-top:4px\"><label for=\"{$name}_$key\" class=\"smallfont\">" . $val['title'] . "</label></td>\r\n</tr></table>\r\n";
	}

	$HTML .= "</div>\r\n";
	print_label_row($text, $HTML, '', 'top', $name, 40);	
}