<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'button' 	=>vB_Api::instance('thanks_core')->getCache('button'),
);

// #############################################################################
if ($_REQUEST['action'] == 'search' OR empty($_REQUEST['action']))
{
	print_cp_header(new vB_Phrase('hooks', 'dbtech_thanks_log_title'));
	
	// ###################### Start modify #######################
	$users = $assertor->getRows('DBTechvBShout:fetchCommandLogUsers', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED));
	$userlist = array('no_value' => new vB_Phrase('logging', 'all_log_entries'));
	foreach ($users as $user)
	{
		if (!$user['username'])
		{
			// No username found
			continue;
		}
		$userlist[$user['userid']] = $user['username'];
	}
	
	$entrylist = array('no_value' => new vB_Phrase('hooks', 'dbtech_thanks_all_entry_types'));
	foreach ($_cache['button'] as $button)
	{
		$entrylist[$button['varname']] = $button['title'];
	}
	
	print_form_header('thanks', 'search');
	construct_hidden_code('action', 'searchresults');
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_log_title'));
	print_input_row(new vB_Phrase('logging', 'log_entries_to_show_per_page'), 'perpage', 15);
	print_select_row(new vB_Phrase('logging', 'show_only_entries_generated_by'), 'userid', $userlist);
	print_select_row(new vB_Phrase('hooks', 'dbtech_thanks_entrytype'), 'varname', $entrylist);
	print_time_row(new vB_Phrase('global', 'start_date'), 'startdate', 0, 0);
	print_time_row(new vB_Phrase('global', 'end_date'), 'enddate', 0, 0);
	print_select_row(new vB_Phrase('cpglobal', 'order_by_gcpglobal'), 'orderby', array('date' => new vB_Phrase('global', 'date'), 'user' => new vB_Phrase('global', 'username'), 'varname' => new vB_Phrase('cpglobal', 'varname')), 'date');
	print_submit_row(new vB_Phrase('global', 'view'), 0);
	
	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['action'] == 'searchresults')
{
	print_cp_header(new vB_Phrase('hooks', 'dbtech_thanks_log_title'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage'    	=> vB_Cleaner::TYPE_UINT,
		'pagenumber' 	=> vB_Cleaner::TYPE_UINT,
		'userid'     	=> vB_Cleaner::TYPE_UINT,
		'varname'  		=> vB_Cleaner::TYPE_STR,
		'orderby'    	=> vB_Cleaner::TYPE_NOHTML,
		'startdate'  	=> vB_Cleaner::TYPE_UNIXTIME,
		'enddate'    	=> vB_Cleaner::TYPE_UNIXTIME,
	));

	// Hacks
	$cleaned[vB_dB_Query::TYPE_KEY] = vB_dB_Query::QUERY_METHOD;

	if (!array_key_exists('perpage', $cleaned) OR $cleaned['perpage'] < 1)
	{
		$cleaned['perpage'] = 15;
	}

	// Count the rows
	$counter = $assertor->getRow('DBTechThanks:countSearchEntries', $cleaned);
	$totalpages = ceil($counter['total'] / $cleaned['perpage']);
	
	if ($cleaned['pagenumber'] < 1)
	{
		$cleaned['pagenumber'] = 1;
	}
	$cleaned['startat'] = ($cleaned['pagenumber'] - 1) * $cleaned['perpage'];
	
	$logs = $assertor->getRows('DBTechThanks:fetchSearchEntries', $cleaned);
	if (!count($logs))
	{
		print_stop_message2('no_results_matched_your_query');
	}

	$cleaned['varname'] = vB_String::htmlSpecialCharsUni($cleaned['varname']);

	if ($cleaned['pagenumber'] != 1)
	{
		$prv = $cleaned['pagenumber'] - 1;
		$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . new vB_Phrase('global', 'first_page') . "\" tabindex=\"1\" onclick=\"window.location='thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=1'\">";
		$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . new vB_Phrase('global', 'prev_page') . "\" tabindex=\"1\" onclick=\"window.location='thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=$prv'\">";
	}

	if ($cleaned['pagenumber'] != $totalpages)
	{
		$nxt = $cleaned['pagenumber'] + 1;
		$nextpage = "<input type=\"button\" class=\"button\" value=\"" . new vB_Phrase('global', 'next_page') . " &gt;\" tabindex=\"1\" onclick=\"window.location='thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=$nxt'\">";
		$lastpage = "<input type=\"button\" class=\"button\" value=\"" . new vB_Phrase('global', 'last_page') . " &raquo;\" tabindex=\"1\" onclick=\"window.location='thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=$totalpages'\">";
	}

	$headings = array();
	$headings[] = "<a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=user&page=" . $cleaned['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', new vB_Phrase('global', 'username')) . "</a>";
	$headings[] = "<a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=date&page=" . $cleaned['pagenumber'] . "\">" . new vB_Phrase('global', 'date') . "</a>";
	$headings[] = "<a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search&action=searchresults&varname=" . $cleaned['varname'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=varname&page=" . $cleaned['pagenumber'] . "\">" . new vB_Phrase('hooks', 'dbtech_thanks_content_type') . "</a>";
	$headings[] = new vB_Phrase('hooks', 'dbtech_thanks_entrytype');
	$headings[] = new vB_Phrase('global', 'title');
	

	print_form_header('', '');
	print_description_row(construct_link_code(new vB_Phrase('cpglobal', 'restart'), "thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=search"), 0, count($headings), 'thead', 'right');
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_entry_viewer_page_x_y_there_are_z_total_log_entries', vb_number_format($cleaned['pagenumber']), vb_number_format($totalpages), vb_number_format($counter['total'])), count($headings));
	print_cells_row($headings, 1);

	$lookup = array();
	foreach ($_cache['button'] as $button)
	{
		$lookup[$button['varname']] = $button['title'];
	}

	foreach ($logs as $log)
	{
		$cell = array();
		$cell[] = ($log['username'] ? "<a href=\"user.php?" . vB::getCurrentSession()->get('sessionurl') . "do=edit&u=$log[userid]\"><b>$log[username]</b></a>" : 'N/A');
		$cell[] = '<span class="smallfont">' . vbdate(vB::getDatastore()->getOption('logdateformat'), $log['dateline']) . '</span>';
		$cell[] = '<span class="smallfont">' . $log['contenttype'] . '</span>';
		$cell[] = '<span class="smallfont"><a href="thanks.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=search&action=searchresults&varname=' . $log['varname'] . '&u=' . $cleaned['userid'] . '&pp=' . $cleaned['perpage'] . '&orderby=' . $cleaned['orderby'] . '&page=' . $cleaned['pagenumber'] . '">' . $lookup[$log['varname']] . '</a></span>';
		$cell[] = ($log['posttitle'] != '(Untitled)' ? $log['posttitle'] : $log['threadtitle']);
		
		

		print_cells_row($cell, 0, 0, -4);
	}

	print_table_footer(count($headings), "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	
	
	print_cp_footer();
}