<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'button' 	=>vB_Api::instance('thanks_core')->getCache('button'),
);
$vb5_config =& vB::getConfig();

// #############################################################################
if ($_REQUEST['action'] == 'channel' OR empty($_REQUEST['action']))
{
	$channels = vB_Api::instance('search')->getChannels(true);
	$top = vB_Api::instance('Content_Channel')->fetchTopLevelChannelIds();	
	$channelids = array();

	foreach ($channels as $channelid => $channel)
	{
		/*DBTECH_LITE_START*/
		if (!vB_Api::instance('thanks_core')->isPro() AND $channel['parentid'] != $top['forum'])
		{
			// This channel isn't a parent channel
			continue;
		}
		/*DBTECH_LITE_END*/
		
		$channelids[] = $channelid;
	}
	
	$headings = array();
	$headings[] = '<label><input type="checkbox" rel="^-channel" />' . new vB_Phrase('global', 'channel') . '</label>';
	foreach ($_cache['button'] as $buttonid => $button)
	{
		// Show button headers
		$headings[] = '<label><input type="checkbox" rel="*-[' . $buttonid . '][dbtech" />' . $button['title'] . '</label>';
	}
	
	print_cp_header(strip_tags(new vB_Phrase('hooks', 'dbtech_thanks_editing_x_y', new vB_Phrase('global', 'dbtech_thanks_button'), new vB_Phrase('global', 'channel'))));
	print_form_header('thanks', 'channel');
	construct_hidden_code('action', 'update');	
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_editing_x_y', new vB_Phrase('global', 'dbtech_thanks_button'), new vB_Phrase('global', 'channel')), count($headings));
	print_cells_row($headings, 0, 'thead');
	
	foreach ((array)$channelids as $channelid)
	{
		// Shorthand
		$channel = $channels[$channelid];
		$cell = array();
		$cell[] = '<label><input type="checkbox" rel="^-channel[' . $channelid . ']" />' . construct_depth_mark($channel['depth'],'- - ') . $channel['title'] . '</label>';
		foreach ($_cache['button'] as $buttonid => $button)
		{
			$celldata = '<table align="center"><tr><td class="smallfont">
					<input type="hidden" name="channel[' . $channelid . '][' . $buttonid . '][dbtech_thanks_disabledbuttons]" value="0" />
					<label for="cb_channel_' . $channelid . '_' . $button['varname'] . '_dbtech_thanks_disabledbuttons">
						<input type="checkbox" name="channel[' . $channelid . '][' . $buttonid . '][dbtech_thanks_disabledbuttons]" id="cb_channel_' . $channelid . '_' . $button['varname'] . '_dbtech_thanks_disabledbuttons" value="1"' . (((int)$channel['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield']) ? ' checked="checked"' : '') . ($vb5_config['Misc']['debug'] ? ' title="name=&quot;channel[' . $channelid . '][' . $button['varname'] . '][dbtech_thanks_disabledbuttons]&quot;"' : '') . '/>
						' . new vB_Phrase('global', 'dbtech_thanks_disable_x', $button['title']) . '
					</label>
				</td></tr>
			';
			
			
			// Legacy hook 'dbtech_thanks_admin_channel_eachbutton' removed
			
			$cell[] = $celldata . '</table>';
		}
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);	
	}
	print_submit_row(new vB_Phrase('global', 'save'), false, count($headings));
	echo '<script type="text/javascript" src="' . vB::getDatastore()->getOption('frontendurl') . '/js/jquery/jquery-' . JQUERY_VERSION . '.min.js"></script>';
	echo '<script type="text/javascript" src="' . vB::getDatastore()->getOption('frontendurl') . '/core/packages/dbtechthanks/js/admin.js"></script>';
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	// Grab stuff
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'channel' 	=> vB_Cleaner::TYPE_ARRAY,
	));
	
	foreach ($cleaned['channel'] as $channelid => $buttons)
	{
		$bind = array();	
		foreach ($buttons as $buttonid => $columns)
		{
			foreach ($columns as $column => $yesno)
			{
				// Ensure this is set
				$bind[$column] = (!isset($bind[$column]) ? 0 : $bind[$column]);
				
				if (!$yesno)
				{
					// Enabled
					continue;
				}
				
				// Add this to the enabled bits
				$bind[$column] += $_cache['button'][$buttonid]['bitfield'];
			}
		}
		
		// Update the db
		$assertor->update('vBForum:node', $bind, array('nodeid' => $channelid));
		
		// Purge the cache
		vB_Cache::instance(vB_Cache::CACHE_FAST)->event('nodeChg_' . $channelid);
		vB_Cache::instance()->event('nodeChg_' . $channelid);
	}

	print_stop_message2(array('dbtech_thanks_x_y',
		new vB_Phrase('global', 'channels'),
		new vB_Phrase('hooks', 'dbtech_thanks_edited')
	), 'thanks', array(
		'do' => 'channel',
	));
}
print_cp_footer();