<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTechThanks_DataManager_Button extends vB_DataManager
{
	/**
	* Array of recognised and required fields for buttons, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'buttonid' 				=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_INCR, vB_DataManager_Constants::VF_METHOD, 	'verify_nonzero'),
		'varname' 				=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD),
		'title' 				=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES),
		'description' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'active' 				=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_onoff'),
		'actiontext' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'listtext' 				=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'undotext' 				=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'reputation' 			=> array(vB_Cleaner::TYPE_INT, 		vB_DataManager_Constants::REQ_NO),
		'permissions' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'exclusivity' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO),
		'bitfield' 				=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_AUTO),
		'displayorder' 			=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'minposts' 				=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'clicksperday' 			=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'postfont' 				=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'defaultbutton_attach' 	=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'defaultbutton_content' => array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'disablenotifs' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'disableemails' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'disablestats_given' 	=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'disablestats_received' => array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		'disableintegration' 	=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'DBTechThanks:dbtech_thanks_button';

	//Primary Key
	protected $keyField = 'buttonid';

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the button
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		/*
		// Check for existing block of this name
		if ($existing = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_button', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array( 
				array('field' => 'name', 		'value' => $title, 								'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'buttonid', 	'value' => (int)$this->existing['buttonid'], 	'operator' => vB_dB_Query::OPERATOR_NE),
			),
			vB_dB_Query::PARAM_LIMIT => 1))
		)
		{
			// Whoopsie, exists
			$this->error('dbtech_thanks_x_already_exists_y', new vB_Phrase('hooks', 'dbtech_thanks_button'), $title);
			return false;
		}
		*/
		
		return true;
	}

	/**
	* Verifies that the varname is valid
	*
	* @param	string	varname of the button
	*
	* @return	boolean
	*/
	function verify_varname(&$varname)
	{
		$varname = strval($varname);
		if ($varname === '')
		{
			// Invalid
			return false;
		}

		if (!preg_match('#^[a-z0-9_]+$#i', $varname)) // match a-z, A-Z, 0-9
		{
			// Invalid
			return false;
		}
		
		// Check for existing block of this name
		if ($existing = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_button', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array( 
				array('field' => 'varname', 	'value' => $varname, 							'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'buttonid', 	'value' => (int)$this->existing['buttonid'], 	'operator' => vB_dB_Query::OPERATOR_NE),
			),
			vB_dB_Query::PARAM_LIMIT => 1))
		)
		{
			// Whoopsie, exists
			$this->error('dbtech_thanks_x_already_exists_y', new vB_Phrase('hooks', 'dbtech_thanks_button'), $varname);
			return false;
		}
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array(0, 1)) ? 1 : $onoff);
		
		return true;
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		if (!$this->condition)
		{
			// Check for existing button of this name
			if ($existing = vB::getDbAssertor()->getRow('DBTechThanks:dbtech_thanks_button', array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::COLUMNS_KEY 	=> array('bitfield'),
				vB_dB_Query::PARAM_LIMIT => 1
			), array('field' => 'bitfield', 'direction' => vB_dB_Query::SORT_DESC)))
			{
				// Use existing bitfield
				$bitfield = ($existing['bitfield'] * 2);
			}
			else
			{
				// This is the first one
				$bitfield = 1;
			}
			
			// Set the bitfield
			$this->do_set('bitfield', $bitfield);
		}
		
		if ($this->setfields['exclusivity'])
		{		
			$bit = 0;
			foreach ((array)$this->fetch_field('exclusivity') as $val)
			{
				$bit += $val;
			}		
			$this->do_set('exclusivity', $bit);
		}
		
		$return_value = true;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		if (!$this->condition)
		{
			if (!class_exists('vB_Database_Alter_MySQL'))
			{
				// Grab the dbalter class
				require(DIR . '/includes/class_dbalter.php');
			}
			
			// Init db alter
			$db_alter = new vB_Database_Alter_MySQL(vB::getDbAssertor()->getDBConnection());
			
			if ($db_alter->fetch_table_info('dbtech_thanks_statistics'))
			{
				// Add the fields we need
				$db_alter->add_field(array(
					'name'       => $this->fetch_field('varname') . '_given',
					'type'       => 'int',
					'length'     => '10',
					'attributes' => 'unsigned',
					'null'       => false,	// True = NULL, false = NOT NULL
					'default'    => '0'
				));
				$db_alter->add_field(array(
					'name'       => $this->fetch_field('varname') . '_received',
					'type'       => 'int',
					'length'     => '10',
					'attributes' => 'unsigned',
					'null'       => false,	// True = NULL, false = NOT NULL
					'default'    => '0'
				));
			}
		}

		// Rebuild the cache
		vB_Api::instance('thanks_core')->buildCache('button');

		// Ensure the button adding works
		$doaddgiven 	= vB_Api::instance('vbactivity_core')->addType($this->fetch_field('varname') . 'given', 	$this->fetch_field('title') . ' Given', 	'dbtech_thanks', '/core/packages/dbtechthanks/vbactivity_type/' . $this->fetch_field('varname') . 'given.php', 		true);
		$doaddreceived 	= vB_Api::instance('vbactivity_core')->addType($this->fetch_field('varname') . 'received', 	$this->fetch_field('title') . ' Received', 	'dbtech_thanks', '/core/packages/dbtechthanks/vbactivity_type/' . $this->fetch_field('varname') . 'received.php', 	true);
		
		if ($doaddgiven)
		{
			$given = file_get_contents(DIR . '/packages/dbtechthanks/vbactivity_type/!given.txt');
			$given = str_replace('<varname>', $this->fetch_field('varname'), $given);
			file_put_contents(DIR . '/packages/dbtechthanks/vbactivity_type/' . $this->fetch_field('varname') . 'given.php', $given);
		}
		
		if ($doaddreceived)
		{
			$received = file_get_contents(DIR . '/packages/dbtechthanks/vbactivity_type/!received.txt');
			$received = str_replace('<varname>', $this->fetch_field('varname'), $received);
			file_put_contents(DIR . '/packages/dbtechthanks/vbactivity_type/' . $this->fetch_field('varname') . 'received.php', $received);
		}

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		if (!class_exists('vB_Database_Alter_MySQL'))
		{
			// Grab the dbalter class
			require(DIR . '/includes/class_dbalter.php');
		}
		
		// Init db alter
		$db_alter = new vB_Database_Alter_MySQL(vB::getDbAssertor()->getDBConnection());
		
		if ($db_alter->fetch_table_info('dbtech_thanks_statistics'))
		{		
			// Add the fields we need
			$db_alter->drop_field($this->fetch_field('varname') . '_given');
			$db_alter->drop_field($this->fetch_field('varname') . '_received');
		}
		
		if ($_cache = vB_Api::instance('vbactivity_core')->getCache('type'))
		{
			if ($existing = $_cache['type'][vB_Api::instance('vbactivity_core')->fetchType($this->fetch_field('varname') . 'given')])
			{
				// Remove given
				@unlink(DIR . '/packages/dbtechthanks/vbactivity_type/' . $this->fetch_field('varname') . 'given.php');		
				$dm = new DBTechvBActivity_DataManager_Type(vB_DataManager_Constants::ERRTYPE_SILENT);
					$dm->set_existing($existing);
				$dm->delete();
				unset($dm);
			}
			
			if ($existing = $_cache['type'][vB_Api::instance('vbactivity_core')->fetchType($this->fetch_field('varname') . 'received')])
			{
				// Remove received
				@unlink(DIR . '/packages/dbtechthanks/vbactivity_type/' . $this->fetch_field('varname') . 'received.php');					
				$dm = new DBTechvBActivity_DataManager_Type(vB_DataManager_Constants::ERRTYPE_SILENT);
					$dm->set_existing($existing);
				$dm->delete();
				unset($dm);
			}
		}

		// Rebuild the cache
		vB_Api::instance('thanks_core')->buildCache('button');
		
		return true;
	}
}