<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'button' 	=>vB_Api::instance('thanks_core')->getCache('button'),
);

// #############################################################################
if ($_REQUEST['action'] == 'maintenance' OR empty($_REQUEST['action']))
{
	print_cp_header(new vB_Phrase('cpglobal', 'maintenance'));
	
	print_form_header('thanks', 'maintenance');
	construct_hidden_code('action', 'cleanup');
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_cleanup'), 2, 0);
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_cleanup_descr'));
	print_input_row(new vB_Phrase('maintenance', 'number_of_posts_to_process_per_cycle'), 'perpage', 1000);
	print_submit_row(new vB_Phrase('hooks', 'dbtech_thanks_cleanup'));
	
	print_form_header('thanks', 'maintenance');
	construct_hidden_code('action', 'recalc');	
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_recalc'), 2, 0);
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_recalc_descr'));
	print_input_row(new vB_Phrase('maintenance', 'number_of_users_to_process_per_cycle_gmaintenance'), 'perpage', 1000);
	print_submit_row(new vB_Phrase('hooks', 'dbtech_thanks_recalc'));
	
	print_form_header('thanks', 'maintenance');
	construct_hidden_code('action', 'rebuildstatistics');	
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_rebuild_statistics'), 2, 0);
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_rebuild_statistics_descr'));
	print_input_row(new vB_Phrase('maintenance', 'number_of_users_to_process_per_cycle_gmaintenance'), 'perpage', 1000);
	print_submit_row(new vB_Phrase('hooks', 'dbtech_thanks_rebuild_statistics'));
	
	/*
	print_form_header('thanks', 'maintenance');
	construct_hidden_code('action', 'recalcrep');	
	print_table_header(new vB_Phrase('hooks', 'dbtech_thanks_recalcrep'), 2, 0);
	print_description_row(new vB_Phrase('hooks', 'dbtech_thanks_recalcrep_descr'));
	print_input_row(new vB_Phrase('maintenance', 'number_of_users_to_process_per_cycle_gmaintenance'), 'perpage', 1000);
	print_submit_row(new vB_Phrase('hooks', 'dbtech_thanks_recalcrep'));
	 */
	
	// Legacy hook 'dbtech_thanks_maintenance' removed
	
	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['action'] == 'cleanup')
{
	print_cp_header(new vB_Phrase('cpglobal', 'maintenance'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage' => vB_Cleaner::TYPE_UINT,
		'startat' => vB_Cleaner::TYPE_UINT
	));
	
	if (empty($cleaned['perpage']))
	{
		$cleaned['perpage'] = 1000;
	}
	
	echo '<p>' . new vB_Phrase('hooks', 'dbtech_thanks_cleaning_up_posts') . '</p>';
	
	$entries = $assertor->getRows('DBTechThanks:fetchMaintenanceEntriesCleanup', array(
		'entryid' 	=> $cleaned['startat'],
		'limit' 	=> $cleaned['perpage']
	));

	$finishat = $cleaned['startat'];
	
	foreach ($entries as $entry)
	{
		echo new vB_Phrase('cpglobal', 'processing_x', $entry['entryid']) . "<br />\n";
		vbflush();
		
		// init data manager
		$dm = new DBTechThanks_DataManager_Entry(vB_DataManager_Constants::ERRTYPE_CP);
			$dm->set_existing($entry);
		$dm->delete();
	
		$finishat = ($entry['entryid'] > $finishat ? $entry['entryid'] : $finishat);
	}
	
	$finishat++;
	
	if ($checkmore = $assertor->getRow('DBTechThanks:fetchMaintenanceEntriesCleanup', array(
		'entryid' 	=> $finishat,
		'limit' 	=> 1
	)))
	{
		print_cp_redirect("thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&action=cleanup&startat=$finishat&pp=" . $cleaned['perpage']);
		echo "<p><a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&amp;action=cleanup&amp;startat=$finishat&amp;pp=" . $cleaned['perpage'] . "\">" . new vB_Phrase('cpglobal', 'click_here_to_continue_processing') . "</a></p>";
	}
	else
	{
		print_stop_message2('dbtech_thanks_cleanup_succeeded', 'thanks', array(
			'do' => 'maintenance',
		));
	}
	
	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['action'] == 'recalc')
{
	print_cp_header(new vB_Phrase('cpglobal', 'maintenance'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage' => vB_Cleaner::TYPE_UINT,
		'startat' => vB_Cleaner::TYPE_UINT
	));
	
	if (empty($cleaned['perpage']))
	{
		$cleaned['perpage'] = 1000;
	}
	
	echo '<p>' . new vB_Phrase('hooks', 'dbtech_thanks_recalculating') . '</p>';
	
	$users = $assertor->getRows('user', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'userid', 'value' => intval($cleaned['startat']), 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => $cleaned['perpage']
	));
	
	$finishat = $cleaned['startat'];
	
	foreach ($users as $user)
	{
		// Shorthand
		$userid = intval($user['userid']);
		
		echo new vB_Phrase('cpglobal', 'processing_x', $userid) . "<br />\n";
		vbflush();
		
		// Default value
		$user['dbtech_thanks_points'] = 0;
		
		// Fetch given entries

		$entryGiven = $assertor->getRows('DBTechThanks:fetchMaintenanceEntriesRecalcGiven', array(
			'userid' 	=> $userid,
		));
		
		// All given entries
		foreach ($entryGiven as $given)
		{
			// Store given
			$user[$given['varname'] . '_given'] = $given['value'];
			$user['dbtech_thanks_points'] 		+= $given['value'];
		}

		// Fetch received entries
		$entryReceived = $assertor->getRows('DBTechThanks:fetchMaintenanceEntriesRecalcReceived', array(
			'userid' 	=> $userid,
		));
		
		// All received entries
		foreach ($entryReceived as $received)
		{
			// Store received
			$user[$received['varname'] . '_received'] 	= $received['value'];
			$user['dbtech_thanks_points'] 				+= $received['value'];
		}
		
		// Update points	
		$assertor->update('user', array('dbtech_thanks_points' => intval($user['dbtech_thanks_points'])), array('userid' => $userid));
		
		// Begin columns
		$SQL = array();
		foreach ($_cache['button'] as $button)
		{
			$SQL[$button['varname'] . '_given'] 	= intval($user[$button['varname'] . '_given']);
			$SQL[$button['varname'] . '_received'] 	= intval($user[$button['varname'] . '_received']);
		}
			
		if (count($SQL))
		{
			// Update the record
			$assertor->update('dbtech_thanks_statistics', $SQL, array('userid' => $userid));
		}
		$finishat = ($userid > $finishat ? $userid : $finishat);
	}
	
	$finishat++;
	
	if ($checkmore = $assertor->getRows('user', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'userid', 'value' => $finishat, 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => 1
	)))
	{
		print_cp_redirect("thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&action=recalc&startat=$finishat&pp=" . $cleaned['perpage']);
		echo "<p><a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&amp;action=recalc&amp;startat=$finishat&amp;pp=" . $cleaned['perpage'] . "\">" . new vB_Phrase('cpglobal', 'click_here_to_continue_processing') . "</a></p>";
	}
	else
	{
		print_stop_message2('dbtech_thanks_recalc_successful', 'thanks', array(
			'do' => 'maintenance',
		));
	}
	
	print_cp_footer();
}


// #############################################################################
if ($_REQUEST['action'] == 'recalc2')
{
	print_cp_header(new vB_Phrase('cpglobal', 'maintenance'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage' => vB_Cleaner::TYPE_UINT,
		'startat' => vB_Cleaner::TYPE_UINT
	));
	
	if (empty($cleaned['perpage']))
	{
		$cleaned['perpage'] = 1000;
	}
	
	echo '<p>' . new vB_Phrase('hooks', 'dbtech_thanks_recalculating') . '</p>';
	
	$users = $assertor->getRows('DBTechThanks:dbtech_thanks_entry', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'entryid', 'value' => intval($cleaned['startat']), 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => $cleaned['perpage']
	));	
	
	$finishat = $cleaned['startat'];
	
	foreach ($users as $user)
	{
		// Shorthand
		$userid = intval($user['entryid']);
		
		echo new vB_Phrase('cpglobal', 'processing_x', $userid) . "<br />\n";
		vbflush();
		
		if ($user['receiveduserid'])
		{
			// Skip this, already has received user id
			continue;
		}
		
		if ($user['contenttype'] != 'post')
		{
			// Skip this, already has received user id
			continue;
		}
		
		// Set received user id
		$receiveduserid = $assertor->getField('vBForum:node',  array(
			vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
			vB_dB_Query::CONDITIONS_KEY => array(
				array('field' => 'nodeid', 'value' => intval($user['contentid']), 'operator' => vB_dB_Query::OPERATOR_EQ)
			),
		));
		
		// Update entry
		$assertor->update('DBTechThanks:dbtech_thanks_entry', array('receiveduserid' => $receiveduserid), array('entryid' => $userid));
		
		$finishat = ($userid > $finishat ? $userid : $finishat);
	}
	
	$finishat++;
	
	if ($checkmore = $assertor->getRows('DBTechThanks:dbtech_thanks_entry', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'entryid', 'value' => $finishat, 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => 1
	)))
	{
		print_cp_redirect("thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&action=recalc2&startat=$finishat&pp=" . $cleaned['perpage']);
		echo "<p><a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&amp;action=recalc2&amp;startat=$finishat&amp;pp=" . $cleaned['perpage'] . "\">" . new vB_Phrase('cpglobal', 'click_here_to_continue_processing') . "</a></p>";
	}
	else
	{
		print_stop_message2('dbtech_thanks_recalc_successful', 'thanks', array(
			'do' => 'maintenance',
		));
	}
	
	print_cp_footer();
}

// #############################################################################
if ($_REQUEST['action'] == 'rebuildstatistics')
{
	print_cp_header(new vB_Phrase('cpglobal', 'maintenance'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage' => vB_Cleaner::TYPE_UINT,
		'startat' => vB_Cleaner::TYPE_UINT
	));
	
	if (empty($cleaned['perpage']))
	{
		$cleaned['perpage'] = 1000;
	}
	
	echo '<p>' . new vB_Phrase('hooks', 'dbtech_thanks_recalculating') . '</p>';	
	
	$users = $assertor->getRows('user', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'userid', 'value' => intval($cleaned['startat']), 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => $cleaned['perpage']
	));

	$finishat = $cleaned['startat'];
	
	foreach ($users as $user)
	{
		// Shorthand
		$userid = intval($user['userid']);
		
		echo new vB_Phrase('cpglobal', 'processing_x', $userid) . "<br />\n";
		vbflush();
		
		// Insert the record
		$assertor->assertQuery('DBTechThanks:dbtech_thanks_statistics', array(
			vB_db_Query::TYPE_KEY => vB_db_Query::QUERY_INSERTIGNORE,
			'userid' => $userid,
		));
		
		$SQL = array();
		$entries = $assertor->getRows('DBTechThanks:fetchMaintenanceEntriesRebuild', array(
			'userid' 	=> $userid,
		));
		foreach ($entries as $entry)
		{
			// Set the array
			$SQL[$entry['varname'] . ($entry['receiveduserid'] == $userid ? '_received' : '_given')]++;
		}
		
		if (count($SQL))
		{
			// Update the record
			$assertor->update('DBTechThanks:dbtech_thanks_statistics', $SQL, array('userid' => $userid));
		}
		$finishat = ($userid > $finishat ? $userid : $finishat);
	}
	$finishat++;
	
	if ($checkmore = $assertor->getRows('user', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'userid', 'value' => $finishat, 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => 1
	)))
	{
		print_cp_redirect("thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&action=rebuildstatistics&startat=$finishat&pp=" . $cleaned['perpage']);
		echo "<p><a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&amp;action=rebuildstatistics&amp;startat=$finishat&amp;pp=" . $cleaned['perpage'] . "\">" . new vB_Phrase('cpglobal', 'click_here_to_continue_processing') . "</a></p>";
	}
	else
	{	
		print_cp_message('Statistics Populated!', 'thanks.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=maintenance', 1, NULL, false);
	}
	
	print_cp_footer();
}

/*
// #############################################################################
if ($_REQUEST['action'] == 'recalcrep')
{
	print_cp_header(new vB_Phrase('cpglobal', 'maintenance'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage' => vB_Cleaner::TYPE_UINT,
		'startat' => vB_Cleaner::TYPE_UINT
	));
	
	if (empty($cleaned['perpage']))
	{
		$cleaned['perpage'] = 1000;
	}
	
	echo '<p>' . new vB_Phrase('hooks', 'dbtech_thanks_recalculating') . '</p>';	
	
	$users = $assertor->getRows('DBTechThanks:dbtech_thanks_statistics', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'userid', 'value' => intval($cleaned['startat']), 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => $cleaned['perpage']
	));
	
	$finishat = $cleaned['startat'];
	
	foreach ($users as $user)
	{
		// Shorthand
		$userid = intval($user['userid']);
		
		echo new vB_Phrase('cpglobal', 'processing_x', $userid) . "<br />\n";
		vbflush();
		
		$reputation = 0;
		foreach ($_cache['button'] as $button)
		{
			// Add to the reputation
			$reputation += ($button['reputation'] * $user[$button['varname'] . '_received']);
		}
		
		if ($reputation)
		{
			// Update the record
			$assertor->assertQuery('DBTechThanks:fetchMaintenanceEntriesRecalcRep', array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED,
				'reputation' 	=> $reputation,
				'userid' 		=> $userid,
			));
		}
		$finishat = ($userid > $finishat ? $userid : $finishat);
	}
	$finishat++;
	
	if ($checkmore = $assertor->getRows('DBTechThanks:dbtech_thanks_statistics', array(
		vB_dB_Query::TYPE_KEY 		=> vB_dB_Query::QUERY_SELECT,
		vB_dB_Query::COLUMNS_KEY 	=> array('userid'),
		vB_dB_Query::CONDITIONS_KEY => array(
			array('field' => 'userid', 'value' => $finishat, 'operator' => vB_dB_Query::OPERATOR_GTE)
		),
		vB_dB_Query::PARAM_LIMIT => 1
	)))
	{
		print_cp_redirect("thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&action=recalcrep&startat=$finishat&pp=" . $cleaned['perpage']);
		echo "<p><a href=\"thanks.php?" . vB::getCurrentSession()->get('sessionurl') . "do=maintenance&amp;action=recalcrep&amp;startat=$finishat&amp;pp=" . $cleaned['perpage'] . "\">" . new vB_Phrase('cpglobal', 'click_here_to_continue_processing') . "</a></p>";
	}
	else
	{	
		print_cp_message('Reputation Recalculated!', 'thanks.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=maintenance', 1, NULL, false);
	}
	
	print_cp_footer();
}
*/