<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ##################### DEFINE IMPORTANT CONSTANTS ######################
define('THIS_SCRIPT', 'thanks');
define('IN_THANKS', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('hooks', 'cphome', 'logging', 'threadmanage', 'banning', 'cpuser', 'cpoption', 'cppermission');

// ######################### REQUIRE BACK-END ############################
require_once(dirname(__FILE__) . '/global.php');

// ######################## CHECK ADMIN PERMISSIONS ######################
/*
if (!can_administer('canadminthanks'))
{
	print_cp_no_permission();
}
 */

// ############################# LOG ACTION ##############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

// Strip non-valid characters
$action = preg_replace('/[^\w-]/i', '', $action);

if (!file_exists(DIR . '/packages/dbtechthanks/actions/admin/' . $action . '.php'))
{
	if (!file_exists(DIR . '/packages/dbtechthanks/actions_pro/admin/' . $action . '.php'))
	{
		// Throw error from invalid action
		print_stop_message2('dbtech_thanks_invalid_action');
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/packages/dbtechthanks/actions_pro/admin/' . $action . '.php');	
	}
}
else
{
	// Include the selected file
	include_once(DIR . '/packages/dbtechthanks/actions/admin/' . $action . '.php');	
}