<?php

// #############################################################################
/**
 * Returns moderator permissions bitfield for the given forum and user
 *
 * @param	integer	Forum ID
 * @param	integer	User ID
 * @param	boolean	Include Global Permissions for Super Moderators
 *
 * @return	integer
 */
function mkp_self_moderation_fetch_moderator_permissions($forumid, $userid = -1, $useglobalperms = false)
{
	// gets permissions, depending on given userid and forumid
	global $vbulletin, $imodcache;
	static $modpermscache;
	
	$forumid = intval($forumid);
	
	if($userid == -1)
	{
		$userid = $vbulletin->userinfo['userid'];
	}
	
	if(isset($modpermscache["$forumid"]["$userid"]))
	{
		DEVDEBUG("  CACHE \$modpermscache cache result");
		return $modpermscache["$forumid"]["$userid"];
	}
	
	$globalperms = array(
		'permissions' => 0, 
		'permissions2' => 0
	);
	$getperms = array();
	$hasglobalperms = false;
	
	if(isset($imodcache))
	{
		if(isset($imodcache["$forumid"]["$userid"]))
		{
			DEVDEBUG("  CACHE first result from imodcache");
			$getperms = $imodcache["$forumid"]["$userid"];
		}
		else
		{
			$parentlist = explode(',', fetch_forum_parent_list($forumid));
			foreach ($parentlist as $parentid)
			{
				// we dont want the super perms since we'll merge them when required further down
				if(isset($imodcache["$parentid"]["$userid"]) and $parentid != -1)
				{
					DEVDEBUG("  CACHE looped result from imodcache");
					$getperms = $imodcache["$parentid"]["$userid"];
				}
			}
		}
		$globalperms['permissions'] = $imodcache['-1']["$userid"]['permissions'];
		$globalperms['permissions2'] = $imodcache['-1']["$userid"]['permissions2'];
		$hasglobalperms = isset($imodcache['-1']["$userid"]['permissions']);
	}
	else
	{
		$forumlist = fetch_forum_clause_sql($forumid, 'forumid');
		if(!empty($forumlist))
		{
			$forumlist = 'AND ' . $forumlist;
		}
		DEVDEBUG("  QUERY: get mod permissions for user $userid");
		$perms = $vbulletin->db->query_read_slave("
			(SELECT permissions, permissions2, FIND_IN_SET(forumid, '" . fetch_forum_parent_list($forumid) . "') AS pos, forumid
			FROM " . TABLE_PREFIX . "moderator
			WHERE userid = $userid $forumlist
			ORDER BY pos ASC
			LIMIT 1)
			UNION
			(SELECT permissions, permissions2, 0, forumid
			FROM " . TABLE_PREFIX . "moderator
			WHERE userid = $userid AND forumid = -1
			)
		");
		while ($perm = $vbulletin->db->fetch_array($perms))
		{
			if($perm['forumid'] == -1)
			{
				$globalperms['permissions'] = $perm['permissions'];
				$globalperms['permission2'] = $perm['permissions2'];
				$hasglobalperms = true;
			}
			else
			{
				$getperms['permissions'] = $perm['permissions'];
				$getperms['permissions2'] = $perm['permissions2'];
			}
		}
	}
	
	if($useglobalperms)
	{
		if(!$hasglobalperms)
		{
			// super mod without a record, give them all permissions
			$globalperms['permissions'] = array_sum($vbulletin->bf_misc_moderatorpermissions) - ($vbulletin->bf_misc_moderatorpermissions['newthreademail'] + $vbulletin->bf_misc_moderatorpermissions['newpostemail']);
			$globalperms['permissions2'] = array_sum($vbulletin->bf_misc_moderatorpermissions2);
		}
		$getperms['permissions'] = !empty($getperms['permissions']) ? intval($getperms['permissions']) : 0;
		$getperms['permissions'] |= intval($globalperms['permissions']);
		$getperms['permissions2'] = !empty($getperms['permissions2']) ? intval($getperms['permissions2']) : 0;
		$getperms['permissions2'] |= intval($globalperms['permissions2']);
	}
	
	$modpermscache["$forumid"]["$userid"]['permissions'] = intval($getperms['permissions']);
	$modpermscache["$forumid"]["$userid"]['permissions2'] = intval($getperms['permissions2']);
	
	return $modpermscache["$forumid"]["$userid"];

}

// #############################################################################
/**
 * Returns whether or not the given user can perform a specific moderation action in the specified forum
 *
 * @param	integer	Forum ID
 * @param	string	If you want to check a particular moderation permission, name it here
 * @param	integer	User ID
 * @param	string	Comma separated list of usergroups to which the user belongs
 *
 * @return	boolean
 */
function mkp_self_moderation_can_moderate($forumid = 0, $do = '', $userid = -1, $usergroupids = '')
{
	global $vbulletin, $imodcache;
	static $modcache;
	static $permissioncache;
	$userid = intval($userid);
	$forumid = intval($forumid);
	
	if($do)
	{
		if(isset($vbulletin->bf_misc_moderatorpermissions["$do"]))
		{
			$permission = & $vbulletin->bf_misc_moderatorpermissions["$do"];
			$set = 'permissions';
		}
		else if(isset($vbulletin->bf_misc_moderatorpermissions2["$do"]))
		{
			$permission = & $vbulletin->bf_misc_moderatorpermissions2["$do"];
			$set = 'permissions2';
		}
	}
	
	if($userid == -1)
	{
		$userid = $vbulletin->userinfo['userid'];
	}
	
	if($userid == 0)
	{
		return false;
	}
	
	$issupermod = false;
	if($userid == $vbulletin->userinfo['userid'])
	{
		if($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator'])
		{
			DEVDEBUG('  USER IS A SUPER MODERATOR');
			$issupermod = true;
		}
	}
	else
	{
		if(!$usergroupids)
		{
			$tempuser = $vbulletin->db->query_first_slave("SELECT usergroupid, membergroupids FROM " . TABLE_PREFIX . "user WHERE userid = $userid");
			if(!$tempuser)
			{
				return false;
			}
			$usergroupids = $tempuser['usergroupid'] . iif(trim($tempuser['membergroupids']), ",$tempuser[membergroupids]");
		}
		$supermodcheck = $vbulletin->db->query_first_slave("
			SELECT usergroupid
			FROM " . TABLE_PREFIX . "usergroup
			WHERE usergroupid IN ($usergroupids)
				AND (adminpermissions & " . $vbulletin->bf_ugp_adminpermissions['ismoderator'] . ") != 0
			LIMIT 1
		");
		if($supermodcheck)
		{
			DEVDEBUG('  USER IS A SUPER MODERATOR');
			$issupermod = true;
		}
	
	}
	
	if($forumid == 0)
	{ // just check to see if the user is a moderator of any forum
		if(isset($imodcache))
		{ // loop through imodcache to find user
			DEVDEBUG("looping through imodcache to find userid $userid");
			foreach ($imodcache as $forummodid => $forummods)
			{
				if(isset($forummods["$userid"]) and ($forummodid != -1 or $issupermod))
				{
					if(!$do)
					{
						return true;
					}
					else if($forummods["$userid"]["$set"] & $permission)
					{
						return true;
					}
				}
			}
			
			if($issupermod and !isset($imodcache['-1']["$userid"]))
			{
				// super mod without a record -- has all perms
				return true;
			}
			
			return false;
		}
		else
		{ // imodcache is not set - do a query
			

			if(isset($modcache["$userid"]["$do"]))
			{
				return $modcache["$userid"]["$do"];
			}
			
			if($issupermod and ($permissioncache["$userid"]['hassuperrecord'] === false))
			{
				$modcache["$userid"]["$do"] = 1;
				return $modcache["$userid"]["$do"];
			}
			
			if($do and isset($permissioncache["$userid"]["$set"]))
			{
				if($set == 'permissions2')
				{
					$modcache["$userid"]["$do"] = $permissioncache["$userid"]["$set"] & $vbulletin->bf_misc_moderatorpermissions2["$do"];
					return $modcache["$userid"]["$do"];
				}
				else
				{
					$modcache["$userid"]["$do"] = $permissioncache["$userid"]["$set"] & $vbulletin->bf_misc_moderatorpermissions["$do"];
					return $modcache["$userid"]["$do"];
				}
			}
			
			$modcache["$userid"]["$do"] = 0;
			
			DEVDEBUG('QUERY: is the user a moderator (any forum)?');
			$ismod_all = $vbulletin->db->query_read_slave("
				SELECT forumid, moderatorid, permissions, permissions2
				FROM " . TABLE_PREFIX . "moderator
				WHERE userid = $userid" . (!$issupermod ? ' AND forumid != -1' : ''));
			
			if(!isset($permissioncache["$userid"]))
			{
				$permissioncache["$userid"]['permissions'] = 0;
				$permissioncache["$userid"]['permissions2'] = 0;
			}
			
			while ($ismod = $vbulletin->db->fetch_array($ismod_all))
			{
				$permissioncache["$userid"]['permissions'] = $permissioncache["$userid"]['permissions'] | $ismod['permissions'];
				$permissioncache["$userid"]['permissions2'] = $permissioncache["$userid"]['permissions2'] | $ismod['permissions2'];
				
				if($ismod['forumid'] == '-1')
				{
					$permissioncache["$userid"]['hassuperrecord'] = true;
				}
				if($do)
				{
					if($ismod["$set"] & $permission)
					{
						$modcache["$userid"]["$do"] = 1;
					}
				}
				else
				{
					$modcache["$userid"]["$do"] = 1;
				}
			}
			$vbulletin->db->free_result($ismod_all);
			
			if($issupermod and !isset($permissioncache["$userid"]['hassuperrecord']))
			{
				$permissioncache["$userid"]['hassuperrecord'] = false;
				$modcache["$userid"]["$do"] = 1;
			}
			
			return $modcache["$userid"]["$do"];
		}
	}
	else
	{ // check to see if user is a moderator of specific forum
		$getmodperms = mkp_self_moderation_fetch_moderator_permissions($forumid, $userid, $issupermod);
		
		if(($getmodperms['permissions'] or $getmodperms['permissions2']) and empty($do))
		{ // check if user is a mod - no specific permission required
			return true;
		}
		else
		{ // check if user is a mod and has permissions to '$do'
			if($getmodperms["$set"] & $permission)
			{
				return true;
			}
			else
			{
				$return = false;
				if(!isset($permission))
				{
					($hook = vBulletinHook::fetch_hook('can_moderate_forum')) ? eval($hook) : false;
					$return = true;
				}
				return $return;
			} // if has perms for this action
		} // if is mod for forum and no action set
	} // if forumid=0
}

/**
 * 
 *  false,     
 *  true,     
 * @param int $forumid
 */
function mkp_self_moderation_on_of_forums_check($forumid)
{
	global $vbulletin;
	if($vbulletin->options['mkp_self_moderaon_excluded_forums'])
	{
		//   
		if(!$vbulletin->options['mkp_self_moderaon_ex_inc_forums'])
		{
			$excluded_forums_array = explode(',', $vbulletin->options['mkp_self_moderaon_excluded_forums']);
			if(is_array($excluded_forums_array) and !empty($excluded_forums_array))
			{
				if(array_search(intval($forumid), $excluded_forums_array) !== false)
				{
					return false;
				}
				else
				{
					return true;
				}
			}
		}
		//   
		if($vbulletin->options['mkp_self_moderaon_ex_inc_forums'] == 1)
		{
			$excluded_forums_array = explode(',', $vbulletin->options['mkp_self_moderaon_excluded_forums']);
			if(is_array($excluded_forums_array) and !empty($excluded_forums_array))
			{
				if(array_search(intval($forumid), $excluded_forums_array) !== false)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}
	}
	else
	{
		return true;
	}
}