<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits II Deluxe 2.1.0 - `credits_vbulletin.php`			   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: Darkwaltz4 {blackwaltz4@msn.com}						   # ||
|| # Copyright © 2009 - 2012 John Jakubowski. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #			 Support: http://www.dragonbyte-tech.com/			   # ||
|| ##################################################################### ||
\*=======================================================================*/

require_once(DIR . '/includes/functions_misc.php');

class VBCREDITS_VBULLETIN
{
	function memberlist(&$fields, &$hooks)
	{
		global $vbulletin, $curcols, $sqlsort, $sortfield, $sortarrow, $sorturl, $oppositesort, $perpage, $usergrouplink, $vb4, $usebgc;

		if (is_array($vbulletin->vbcredits['display']) AND array_key_exists('memberlist', $vbulletin->vbcredits['display']))
		{
			$display =& $vbulletin->vbcredits['display']['memberlist'];
			$sfield = $vbulletin->input->clean_gpc('r', 'sortfield', TYPE_STR);
			$currencies = ''; $combo = array(); $usebgc = true;

			if ($vb4)
			{	//vb4 template registration
				$t = vB_Template::create('credits_display_memberlist');
				$t->register('vb4', $vb4);
				$t->register('sorturl', $sorturl);
				$t->register('oppositesort', $oppositesort);
				$t->register('perpage', $perpage);
				$t->register('usergrouplink', $usergrouplink);
			}
			if (is_array($vbulletin->vbcredits['currency']))
			{
				if (substr($sfield, 0, 9) == 'vbcredits' AND (array_key_exists(substr($sfield, 10), $vbulletin->vbcredits['currency']) OR substr($sfield, 10) == 'combo'))
				{	//handle sorting if calling existing currency
					$sortarrow[$sfield] = $sortarrow["$sortfield"];
					unset($sortarrow["$sortfield"]);
					$sortfield = $sqlsort = $sfield;
				}
				foreach ($vbulletin->vbcredits['currency'] AS $currencyid => $currency)
				{
					$fieldname = 'vbcredits_' . $currencyid;
					if ($display['combine'] AND (empty($display['combined']) OR in_array($currencyid, $display['combined']))) $combo[] = ( in_array($currency['table'], array('user', 'userfield', 'usertextfield')) ? $currency['table'] : 'vbcreditst_' . $currencyid ) . '.' . $currency['column'];

					if ((empty($display['currencies']) OR in_array($currencyid, $display['currencies'])) AND ($currency['privacy'] == 2 OR ($currency['privacy'] == 1 AND ($user['userid'] == $vbulletin->userinfo['userid']))))
					{	//is it public or (private + (me or perms))
						$arrowsort = $sortarrow[$fieldname];
						$curcols++;

						if ($vb4)
						{
							$t->register('currency', $currency);
							$t->register('fieldname', $fieldname);
							$t->register('arrowsort', $arrowsort);
							$currencies .= $t->render();
						}
						else eval('$currencies .= "' . fetch_template('credits_display_memberlist') . '";');
					}
				}
			}
			if (sizeof($combo))
			{
				$curcols++;
				$fieldname = 'vbcredits_combo';
				$arrowsort = $sortarrow[$fieldname];
				$currency['title'] = $display['combine']; //fake it
				$fields .= ', (' . implode(' + ', $combo) . ') AS ' . $fieldname;

				if ($vb4)
				{
					$t->register('currency', $currency);
					$t->register('fieldname', $fieldname);
					$t->register('arrowsort', $arrowsort);
					$currencies .= $t->render();
				}
				else eval('$currencies .= "' . fetch_template('credits_display_memberlist') . '";');
			}
			if ($vb4)
			{
				$find = preg_quote("''; if (\$show['usergroup']) {", '/') . '\s+' . preg_quote("\$final_rendered .= '<th", '/');
				$vbulletin->templatecache['memberlist'] = preg_replace("/$find/", '"' . addslashes($currencies) . '" . $0', $vbulletin->templatecache['memberlist']);

				if (strpos($vbulletin->templatecache['memberlist'], 'foreach ($memberlistbits AS $userinfo)') !== false)
				{	//using <vb:each>
					$find = preg_quote("''; if (\$show['usergroup']) {", '/') . '\s+' . preg_quote("\$final_rendered .= '<td", '/'); $usebgc = false;
					$vbulletin->templatecache['memberlist'] = preg_replace("/$find/", '$userinfo[\'currencies\'] . $0', $vbulletin->templatecache['memberlist']);
				}	//using template
				else $vbulletin->templatecache['memberlist_resultsbit'] = str_replace($find = "''; if (\$show['usergroup']", "\$userinfo['currencies'] . $find", $vbulletin->templatecache['memberlist_resultsbit']);
			}
			else
			{
				$vbulletin->templatecache['memberlist'] = str_replace($find = '".(($show[\'usergroup\']) ? ("<td', addslashes($currencies) . $find, $vbulletin->templatecache['memberlist']);
				$vbulletin->templatecache['memberlist_resultsbit'] = str_replace($find = '".(($show[\'usergroup\']', '$userinfo[currencies]' . $find, $vbulletin->templatecache['memberlist_resultsbit']);
			}
		}
	}

	function navbartime()
	{
		global $vbulletin, $template_hook, $vb4, $vbphrase;
		$display =& $vbulletin->vbcredits['display']['navbar'];

		if ($display['hookname'] == 'navbar_end')
		{	//change vb compatible navbar hooks
			if (!$vb4) $display['hookname'] = 'navbar_buttons_right';
			else if (function_exists('render_navigation')) $display['hookname'] = 'credits_navbar';
		}
		if (!$vb4 AND $vbulletin->options['credits_enable_navtab'])
		{	// render vb3 navtab
			eval('$template_hook[\'navbar_buttons_right\'] .= "' . fetch_template('credits_navtab') . '";');
		}

		VBCREDITS::display('navbar', $vbulletin->userinfo, $template_hook);

		if ($vbulletin->userinfo['userid'] AND !$vbulletin->options['credits_cron_daily'])
		{
			$birth = explode('-', $vbulletin->userinfo['birthday']);
			$prevyear = date('Y', $vbulletin->userinfo['lastactivity']);
			$payref = explode('-', $vbulletin->options['credits_action_paycheck_start']);
			$actref = explode('-', $vbulletin->options['credits_action_activity_start']);
			$which = $vbulletin->userinfo[$vbulletin->options['credits_action_activity_require']];
			$age = ( (substr($birth[2], 0, 1) != '0') ? intval($prevyear - $birth[2]) : 0 );

			while (true)
			{	//break if in the future
				$stamp = vbmktime(0, 0, 0, intval($birth[0]), intval($birth[1]), $prevyear);
				if ($stamp > TIMENOW) break;
				if ($stamp > $vbulletin->userinfo['lastactivity']) VBCREDITS::action('birthday', $vbulletin->userinfo['userid'], null, false, array('timestamp' => $stamp, 'multiplier' => $age));
				$age += ($age > 0);
				$prevyear++;
			}

			$refdate = vbmktime(0, 0, 0, intval($payref[1]), intval($payref[2]), intval($payref[0]));
			$interval = ($vbulletin->options['credits_action_paycheck_interval'] * 86400);
			$part = (abs($vbulletin->userinfo['lastactivity'] - $refdate) % $interval);

			for ($stamp = $vbulletin->userinfo['lastactivity'] + $interval - ( ($vbulletin->userinfo['lastactivity'] < $refdate) ? $interval - $part : $part ); $stamp <= TIMENOW; $stamp += $interval)
			{	//give all the missed paycheck awards
				VBCREDITS::action('paycheck', $vbulletin->userinfo['userid'], null, false, array('timestamp' => $stamp));
			}

			$refdate = vbmktime(0, 0, 0, intval($actref[1]), intval($actref[2]), intval($actref[0]));
			$interval = ($vbulletin->options['credits_action_activity_interval'] * 86400);
			$part = (abs($vbulletin->userinfo['lastactivity'] - $refdate) % $interval);

			for ($stamp = $vbulletin->userinfo['lastactivity'] + $interval - ( ($vbulletin->userinfo['lastactivity'] < $refdate) ? $interval - $part : $part ); $stamp <= TIMENOW; $stamp += $interval)
			{	//give an activity award
				VBCREDITS::action('activity', $vbulletin->userinfo['userid'], null, !($which > ($stamp - $interval) AND $which <= $stamp), array('timestamp' => $stamp));
			}
		}
	}

	function navtabs(&$tabs)
	{	// convert navbar display for tabs
		global $template_hook, $vbphrase;
		$currencies = array();

		if ($template_hook['credits_navbar'] AND preg_match_all('/<li><a href="(.*)">(.*)<\/a><\/li>/U', $template_hook['credits_navbar'], $found))
		{	//only bother if something found
			foreach (array_keys($found[0]) AS $cid)
			{	//each dropdown link
				$currencies[$cname = 'credits_' . $cid] = array(
					'root' => 'credits_navbar',
					'type' => 'link',
					'url' => $found[1][$cid],
					'title' => $found[2][$cid],
					'name' => $cname,
					'children' => 0
				);
			}
			if (sizeof($currencies))
			{
				foreach ($tabs AS $tid => $tb)
				{	//find forum tab
					if ($tb['name'] == 'vbtab_forum')
					{
						$forumtab =& $tabs[$tid];
						if ($forumtab['children'] == 0) $forumtab['children'] = array();

						$forumtab['children']['credits_navbar'] = array(
							'root' => $tid,
							'type' => 'menu',
							'title' => $vbphrase['currency'],
							'name' => 'credits_navbar',
							'children' => $currencies
						);

						unset($forumtab);
						break;
					}
				}
			}
		}
	}

	function reputation()
	{
		global $vbulletin, $threadinfo, $score, $userid, $vbcredits, $postid;

		$insert = $vbulletin->db->query_first("
			SELECT reputationid
			FROM " . TABLE_PREFIX . "reputation
			WHERE postid = $postid AND
				whoadded = " . $vbulletin->userinfo['userid']
		);

		VBCREDITS::action('reputation', $userid, $insert['reputationid'], ($score < 0), array('forumid' => $threadinfo['forumid'], 'multiplier' => abs($score)));
		VBCREDITS::apply($vbcredits, $insert['reputationid']);
	}

	function profile()
	{
		global $vbulletin, $userinfo;
		VBCREDITS::action('profile', $vbulletin->userinfo['userid'], $userinfo['userid'], false, array('ownerid' => $userinfo['userid']));
	}

	function read()
	{
		global $vbulletin, $threadinfo;
		$extra = array('forumid' => $threadinfo['forumid'], 'ownerid' => $threadinfo['postuserid']);
		VBCREDITS::action('read', $vbulletin->userinfo['userid'], $threadinfo['threadid'], false, $extra);
	}

	function infraction($inf, $delete = false)
	{
		global $vbulletin;

		if (($reverse = ($inf->fetch_field('action') != 0 OR $delete) OR !$inf->condition) AND ($points = $inf->fetch_field('points') OR $vbulletin->options['credits_action_infraction_warning']))
		{	//warnings dont involve points
			$extra = array('multiplier' => $points);
			VBCREDITS::action('infraction', $inf->fetch_field('userid'), $inf->infraction['infractionid'], $reverse, $extra);
			VBCREDITS::action('punish', $inf->fetch_field('whoadded'), $inf->infraction['infractionid'], $reverse, $extra);
		}
	}

	function download()
	{
		global $vbulletin, $db, $attach;

		if (!$vbulletin->GPC['thumb'] AND ($vbulletin->GPC['attachmentid'] OR $vbulletin->GPC['postid']))
		{	//not thumbnail view
			if (intval($vbulletin->versionnumber) == 3)
			{	//vb3.x
				$attachmentinfo = $db->query_first_slave("
					SELECT attachmentid, attachment.userid, filesize, thread.forumid
					FROM " . TABLE_PREFIX . "attachment AS attachment
					LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = attachment.postid)
					LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
					WHERE " . ($vbulletin->GPC['postid'] ? "attachment.postid = " . $vbulletin->GPC['postid'] : "attachmentid = " . $vbulletin->GPC['attachmentid'])
				);
			}
			else# if (array_pop(explode('_', strtolower(get_class($attach)))) == 'post')
			{	//vb4.x
				$attachmentinfo = $db->query_first_slave("
					SELECT a.attachmentid, fd.userid, fd.filesize, thread.forumid
					FROM " . TABLE_PREFIX . "attachment AS a
					INNER JOIN " . TABLE_PREFIX . "filedata AS fd ON (a.filedataid = fd.filedataid)
					LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.postid = a.contentid)
					LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid)
					WHERE a.attachmentid = " . $vbulletin->GPC['attachmentid']
				);
			}
			if ($attachmentinfo)
			{	//only forum attachments
				$extra = array('forumid' => $$attachmentinfo['forumid'], 'multiplier' => $attachmentinfo['filesize'], 'ownerid' => $attachmentinfo['userid']);
				VBCREDITS::action('download', $vbulletin->userinfo['userid'], $attachmentinfo['attachmentid'], false, $extra);
			}
		}
	}

	function userfields(&$user)
	{
		$user->vbcredits_old = $user->vbcredits_new = 0;

		foreach ($user->userfield AS $field => $value)
		{
			if ($value) $user->vbcredits_new++;
			if (array_key_exists($field, $user->existing) AND $user->existing[$field] != '') $user->vbcredits_old++;
		}

		$user->vbcredits = ( ($user->vbcredits_old != $user->vbcredits_new AND $user->vbcredits_new AND $userid = $user->fetch_field('userid')) ? VBCREDITS::action('describe', $userid, true, false, array('multiplier' => $user->vbcredits_new)) : false );
	}

	function user($user, $change = false)
	{
		global $vbulletin;
		$userid = $user->fetch_field('userid');

		if ($user->vbcredits_old != $user->vbcredits_new)
		{	//give and take the fields if any were set and they changed
			if ($user->vbcredits_old) VBCREDITS::action('describe', $userid, null, true, array('multiplier' => $user->vbcredits_old));

			if ($user->vbcredits_new)
			{
				if ($user->condition) VBCREDITS::apply($user->vbcredits, null); else VBCREDITS::action('describe', $userid, null, false, array('multiplier' => $user->vbcredits_new));
			}
		}
		if ($change)
		{
			VBCREDITS::action('induction', $userid);

			if ($user->user['referrerid'] AND isset($user->user['usergroupid']) AND $user->user['usergroupid'] != $user->existing['usergroupid'] AND $user->user['usergroupid'] == $vbulletin->options['credits_action_referral_usergroup'])
			{	//primary usergroup changed and it matches the valid one and i have a refferer, give them the referral event
				$extra = array('timestamp' => $user->user['joindate']);
				VBCREDITS::action('referral', $user->user['referrerid'], $userid, false, $extra);
			}
		}
	}

	function promotion($primes, $seconds)
	{
		$primes = array_diff(array_unique(array_map('intval', explode(',', implode(',', $primes)))), array(0));
		$seconds = array_diff(array_unique(array_map('intval', explode(',', implode(',', $seconds)))), array(0));

		if ($userids = array_merge($primes, $seconds))
		{	//these people were just promoted, so process them
			global $vbulletin;
			$db =& $vbulletin->db;
			$users = $db->query_read("SELECT userid, usergroupid, membergroupids, joindate, referrerid FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', $userids) . ")");

			while ($user = $db->fetch_array($users))
			{
				VBCREDITS::action('induction', $user['userid']);

				if ($user['referrerid'] AND in_array($user['userid'], $primes) AND $user['usergroupid'] == $vbulletin->options['credits_action_referral_usergroup'])
				{	//primary usergroup changed and it matches the valid one and i have a refferer, give them the referral event
					$extra = array('timestamp' => $user['joindate']);
					VBCREDITS::action('referral', $user['referrerid'], $user['userid'], false, $extra);
					VBCREDITS::action('reference', $user['userid'], null, false, $extra);
				}
			}

			$db->free_result($users);
			VBCREDITS::shutdown();
		}
	}

	function event($event)
	{
		if ($event->condition) VBCREDITS::action('calendar', $event->fetch_field('userid'), $event->existing['eventid'], true, array('multiplier' => $event->existing['event']));
		VBCREDITS::apply($event->vbcredits, $event->fetch_field('eventid'));
	}

	function visitor($visit, $delete = false)
	{
		if (($target = $visit->fetch_field('userid')) != ($userid = $visit->fetch_field('postuserid')))
		{	//only if not yourself
			if (!$delete) VBCREDITS::apply($visit->vbcredits, $target);
		}

		if ($visit->condition) VBCREDITS::action('visitor', $userid, $target, true, array('multiplier' => $visit->existing['pagetext'], 'ownerid' => $target));
	}

	function contacts()
	{
		global $vbulletin, $add, $remove;

		foreach (array('friend', 'approvals') AS $type)
		{
			if (array_key_exists($type, $add))
			{	//remove has empty keys, this has no keys
				foreach ($add[$type] AS $userid => $userinfo) VBCREDITS::action('friend', $vbulletin->userinfo['userid'], $userid);
			}
		}
		foreach (array('friend', 'approvals') AS $type)
		{
			foreach ($remove[$type] AS $userid)
			{
				VBCREDITS::action('friend', $userid, $vbulletin->userinfo['userid'], true);
				if ($type == 'friend') VBCREDITS::action('friend', $vbulletin->userinfo['userid'], $userid, true);
			}
		}
	}

	function friend($delete = false)
	{
		global $vbulletin, $userinfo, $vbcredits;
		$vbcredits = array();

		if (!$vbulletin->GPC['deny'] AND $vbulletin->GPC['userlist'] == 'friend')
		{
			$vbcredits[] = VBCREDITS::action('friend', $vbulletin->userinfo['userid'], true, $delete);
			if ($delete) $vbcredits[] = VBCREDITS::action('friend', $userinfo['userid'], true, true);
		}
	}

	function upload()
	{
		global $vbulletin, $attachlib, $vbcredits, $threadinfo, $postinfo;
		$userid = $vbulletin->userinfo['userid'];
		$db =& $vbulletin->db;

		switch (array_pop(explode('_', strtolower(get_class($attachlib)))))
		{
			case 'album':
				$action = 'album';
				require_once(DIR . '/includes/functions_album.php');
				$attachinfo = fetch_albuminfo($vbulletin->GPC['values']['albumid']);
				if ($attachinfo['userid']) $userid = $attachinfo['userid'];
				$extra = array();
			break;
			default:
				$action = 'upload';
				if (empty($postinfo)) $postinfo = fetch_postinfo($vbulletin->GPC['values']['p']);
				if (empty($threadinfo)) $threadinfo = fetch_threadinfo($postinfo['threadid']);
				$extra = array('forumid' => $threadinfo['forumid']);
				if ($postinfo['userid']) $userid = $postinfo['userid'];
		}

		$vbulletin->input->clean_array_gpc('p', array(
			'upload'	=> TYPE_STR,
			'delete'	=> TYPE_ARRAY_STR
		));

		if (!$vbulletin->GPC['upload'])
		{
			if (!$attachlib)
			{	//query for filesize
				$attachments = $db->query_read("
					SELECT filesize
					FROM " . TABLE_PREFIX . "attachment
					WHERE posthash = '$posthash'
						AND userid = " . $vbulletin->userinfo['userid']
				);
			}
			else $attachments = $attachlib->fetch_attachments();
			$attaches = array();

			while ($attach = $db->fetch_array($attachments))
			{
				$attaches[$attach['attachmentid']] = ( ($action == 'upload') ? $attach['filesize'] : $attach['width'] * $attach['height'] );
			}
			foreach (array_keys($vbulletin->GPC['delete']) AS $file)
			{
				if (is_numeric($file))
				{
					$extra['multiplier'] = $attaches[$file];
					VBCREDITS::action($action, $userid, $file, true, $extra);
				}
			}
		}
		else
		{
			if ($aid = $vbulletin->input->clean_gpc('p', 'filedata', TYPE_ARRAY_UINT) AND $aid[0])
			{
				$file = $db->query_first("SELECT *, filesize AS size FROM " . TABLE_PREFIX . "filedata WHERE filedataid = " . intval($aid[0]));
			}
			else if ($url = $vbulletin->input->clean_gpc('p', 'attachmenturl', TYPE_ARRAY_STR) AND $url[0])
			{
				$file = array('size' => 0);
				list($file['width'], $file['height']) = getimagesize($url[0]);

				$c = curl_init($url[0]);
				curl_setopt($c, CURLOPT_NOBODY, true); curl_setopt($c, CURLOPT_HEADER, true); curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
				if (ini_get('open_basedir') == '' AND ini_get('safe_mode' == 'Off')) curl_setopt($c, CURLOPT_FOLLOWLOCATION, true); //ugh
				$data = curl_exec($c);
				curl_close($c);

				if ($data !== false AND preg_match('/Content-Length: (\d+)/', $data, $matches)) $file['size'] = floatval($matches[1]);
			}
			else
			{
				$file = $vbulletin->input->clean_gpc('f', 'attachment', TYPE_FILE);
				list($file['width'], $file['height']) = getimagesize($file['tmp_name'][0]);
				$file['size'] = $file['size'][0];
			}

			$extra['multiplier'] = ( ($action == 'upload') ? $file['size'] : $file['width'] * $file['height'] );
			$vbcredits = VBCREDITS::action($action, $userid, true, false, $extra);
		}
	}

	function prepost(&$post)
	{
		if (empty($post->info['preview']))
		{	//preview isnt posting
			$post->vbcredits = array();
			global $vbulletin, $threadinfo;
			$thread = ( $post->info['thread'] ? $post->info['thread'] : ( $post->existing['forumid'] ? $post->existing : $threadinfo ) );

			if ($post->fetch_field('visible') == 1)
			{
				$userid = $post->fetch_field('userid');
				$timespan = TIMENOW - $thread['lastpost'];
				$post->vbcredits[] = VBCREDITS::action(( ($post->condition AND ($postid = $post->fetch_field('postid')) == $thread['firstpostid']) ? 'thread' : 'post' ), $userid, true, false, array('forumid' => $thread['forumid'], 'multiplier' => ( ($pagetext = $post->fetch_field('pagetext')) ? $pagetext : ( ($postinfo = fetch_postinfo($postid)) ? $postinfo['pagetext'] : '' ) ), 'ownerid' => $thread['postuserid']));
			}
		}
	}

	function post($post)
	{
		if (empty($post->info['preview']))
		{	//preview isnt posting
			global $vbulletin, $threadinfo;
			$thread = ( $post->info['thread'] ? $post->info['thread'] : ( $post->existing['forumid'] ? $post->existing : $threadinfo ) );

			$userid = $post->fetch_field('userid');
			$postid = $post->fetch_field('postid');
			$action = ( ($post->condition AND $postid == $thread['firstpostid']) ? 'thread' : 'post' );
			$refid = ( ($action == 'thread') ? $thread['threadid'] : $postid );
			if ($post->condition AND $post->existing['visible'] == 1) VBCREDITS::action($action, $userid, $refid, true, array('forumid' => $thread['forumid'], 'multiplier' => $post->existing['pagetext'], 'ownerid' => ( $thread['postuserid'] ? $thread['postuserid'] : $threadinfo['postuserid'] )));

			if ($post->fetch_field('visible') == 1)
			{
				VBCREDITS::apply($post->vbcredits[0], $refid);
				if (sizeof($post->vbcredits) > 1) VBCREDITS::apply($post->vbcredits[1], $thread['threadid']);
			}
		}
	}

	function delpost($post)
	{	//delete any reputation?
		if ($post->existing['visible'] == 1)
		{	//need to find this data
			global $threadinfo;
			$postinfo = ( $post->existing['userid'] ? $post->existing : fetch_postinfo($post->fetch_field('postid')) );
			VBCREDITS::action('post', $postinfo['userid'], $postinfo['postid'], true, array('forumid' => $threadinfo['forumid'], 'multiplier' => $postinfo['pagetext'], 'ownerid' => $threadinfo['postuserid']));
		}
	}

	function poll($poll, $delete = false)
	{
		global $threadinfo;
		$pollid = $poll->fetch_field('pollid');
		if ($poll->condition) VBCREDITS::action('poll', $threadinfo['postuserid'], $pollid, true, array('forumid' => $threadinfo['forumid'], 'multiplier' => $poll->existing['numberoptions']));
		if (!$delete) VBCREDITS::apply($poll->vbcredits, $pollid);
	}

	function rating($rate, $delete = false)
	{
		$userid = $rate->fetch_field('userid');
		$owner = $rate->info['thread']['postuserid'];
		$threadid = $rate->fetch_field('threadid');
		$forumid = $rate->info['thread']['forumid'];
		$newvote = $rate->fetch_field('vote');
		$notmine = ($userid != $owner);

		if ($delete OR $rate->existing['vote'] != $newvote)
		{
			if ($rate->condition)
			{	//delete from self and owner
				VBCREDITS::action('rate', $userid, $threadid, true, array('forumid' => $forumid, 'multiplier' => $rate->existing['vote'], 'ownerid' => $owner));
			}
			if (!$delete AND $notmine)
			{	//give to self and owner
				VBCREDITS::apply($rate->vbcredits, $threadid);
			}
		}
	}

	function prethread(&$thread)
	{
		if ($thread->condition AND empty($thread->info['preview']))
		{
			$thread->existing = array_merge(fetch_threadinfo($thread->existing['threadid']), $thread->existing);
			if ($thread->existing['visible'] != 1 AND $thread->fetch_field('visible') == 1) $thread->vbcredits = VBCREDITS::action('thread', $thread->existing['postuserid'], true, false, array('forumid' => $thread->existing['forumid'], 'multiplier' => $thread->existing['description']));
		}
	}

	function thread($thread)
	{
		if (empty($thread->info['preview']))
		{	//preview isnt posting
			$threadid = $thread->fetch_field('threadid');
			VBCREDITS::apply($thread->vbcredits, $threadid);
		}
	}

	function delthread($thread)
	{
		//thread
		//tagging
		//sticky
		$thread->existing = array_merge(fetch_threadinfo($thread->existing['threadid']), $thread->existing);
		if ($thread->existing['visible'] == 1) VBCREDITS::action('thread', $thread->existing['postuserid'], $thread->existing['threadid'], true, array('forumid' => $thread->existing['forumid'], 'multiplier' => $thread->existing['description']));

		//if not keeping attachments, revert that?
		//if perm, delete the posts, ratings,
	}

	function premember(&$member)
	{
		$userid = $member->fetch_field('userid');
		if (empty($member->info['group'])) $member->info['group'] = fetch_socialgroupinfo($member->fetch_field('groupid'));
		if ($member->info['group']['creatoruserid'] != $userid AND $member->fetch_field('type') == 'member' AND (!$member->condition OR $member->existing['type'] != 'member')) $member->vbcredits = VBCREDITS::action('join', $userid, true);
	}

	function member($member, $delete = false)
	{
		$userid = $member->fetch_field('userid');
		$groupid = $member->fetch_field('groupid');
		$ownerid = $member->info['group']['creatoruserid'];

		if ($ownerid != $userid)
		{
			if ($delete OR ($member->fetch_field('type') != 'member' AND $member->existing['type'] == 'member'))
			{	// moderated
				VBCREDITS::action('join', $userid, $groupid, true);
			}
			else if (!is_null($member->vbcredits))
			{	// accepted
				VBCREDITS::apply($member->vbcredits, $groupid);
			}
		}
	}

	function prediscuss(&$discuss)
	{
		$discuss->info['message'] = fetch_groupmessageinfo($discuss->fetch_field('firstpostid'));
		if (empty($discuss->info['group'])) $discuss->info['group'] = fetch_socialgroupinfo($discuss->fetch_field('groupid'));
		if (!$discuss->condition) $discuss->vbcredits = VBCREDITS::action('discuss', $discuss->info['message']['postuserid'], true, false, array('ownerid' => $discuss->info['group']['creatoruserid'], 'multiplier' => $discuss->info['message']['pagetext']));
	}

	function discuss($discuss, $delete = false)
	{
		$discussid = $discuss->fetch_field('discussionid');
		$ownerid = $discuss->info['group']['creatoruserid'];
		$userid = $discuss->info['message']['postuserid'];
		$notowner = ($ownerid != $userid);

		if ($delete)
		{
			VBCREDITS::action('discuss', $userid, $discussid, true, array('ownerid' => $discuss->info['group']['creatoruserid'], 'multiplier' => $discuss->info['message']['pagetext']));
		}
		if (!$discuss->condition)
		{
			VBCREDITS::apply($discuss->vbcredits, $discussid);
		}
	}

	function prereply(&$reply)
	{
		if ($discussid = $reply->fetch_field('discussionid'))
		{
			$reply->info['discussion'] = fetch_socialdiscussioninfo($discussid);
			$isdiscuss = ($reply->fetch_field('gmid') == $reply->info['discussion']['firstpostid']);
			if ($reply->fetch_field('state') == 'visible') $reply->vbcredits = VBCREDITS::action(( $isdiscuss ? 'discuss' : 'update' ), $this->fetch_field('postuserid'), true, false, array('ownerid' => ( $isdiscuss ? $reply->info['group']['creatoruserid'] : $reply->info['discussion']['postuserid'] ), 'multiplier' => $reply->fetch_field('pagetext')));
		}
	}

	function reply($reply, $delete = false)
	{
		$gmid = $reply->fetch_field('gmid');
		$userid = $reply->fetch_field('postuserid');

		if ($gmid == $reply->info['discussion']['firstpostid'])
		{	//this is the first post of the discussion
			$groupid = $reply->info['discussion']['groupid'];
			$reply->info['group'] = fetch_socialgroupinfo($groupid);
			$ownerid = $reply->info['group']['creatoruserid'];
			$gmid = $reply->info['discussion']['discussionid'];
			$action = array('discuss');
		}
		else
		{	//just a regular post
			$ownerid = $reply->info['discussion']['postuserid'];
			$action = array('update');
		}
		if ($reply->condition)
		{
			VBCREDITS::action($action[0], $userid, $gmid, true, array('ownerid' => $ownerid, 'multiplier' => $reply->existing['pagetext']));
		}
		if (!$delete)
		{
			VBCREDITS::apply($reply->vbcredits, $gmid);
		}
	}

	function tag()
	{
		global $content, $vbulletin, $errors, $threadinfo;

		if (intval($vbulletin->versionnumber) < 4)
		{
			return;
		}

		if ($taglist = $content->filter_tag_list_content_limits($vbulletin->GPC['taglist'], $content->fetch_tag_limits(), $errors) AND is_array($taglist))
		{
			foreach ($taglist AS $tag) VBCREDITS::action('tag', $vbulletin->userinfo['userid'], $tag, false, array('ownerid' => $threadinfo['postuserid'], 'forumid' => $threadinfo['forumid']));
		}
	}

	function deltag()
	{
		global $vbulletin, $delete, $contentid, $contenttypeid, $threadinfo;
		$db =& $vbulletin->db;

		if (intval($vbulletin->versionnumber) < 4)
		{
			return;
		}

		if ($delete)
		{
			$deltags = $db->query_read("SELECT c.*, t.tagtext FROM " . TABLE_PREFIX . "tagcontent AS c LEFT JOIN " . TABLE_PREFIX . "tag AS t ON (t.tagid = c.tagid) WHERE c.contentid = $contentid AND c.contenttypeid = " . intval($contenttypeid) . " AND c.tagid IN (" . implode(',', $delete) . ")");
			while ($deltag = $db->fetch_array($deltags)) VBCREDITS::action('tag', $deltag['userid'], $deltag['tagtext'], true, array('ownerid' => $threadinfo['postuserid'], 'forumid' => $threadinfo['forumid']));
			$db->free_result($deltags);
		}
	}

	function rebuild($actionid, $user)
	{
		global $vbulletin, $vb4;
		$userinfo = ( ($vbulletin->userinfo['userid'] == $user['userid']) ? null : $user );
		$db =& $vbulletin->db;

		switch ($actionid)
		{
			case 'album':
				$actions = $db->query_read("SELECT a.*" . ( $vb4 ? ", f.width, f.height" : '' ) . " FROM " . TABLE_PREFIX . "attachment AS a" . ( $vb4 ? " LEFT JOIN " . TABLE_PREFIX . "filedata AS f ON (f.filedataid = a.filedataid)" : '' ) . " WHERE " . ( $vb4 ? "a.state = 'visible' AND a.contenttypeid = 8" : "a.visible = 1" ) . " AND a.userid = " . $user['userid'] . " AND a.dateline >= " . $vbulletin->GPC['start_date'] . " AND a.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('album', $user['userid'], $action['attachmentid'], false, array('multiplier' => $action['width'] * $action['height'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'approval':
				$actions = $db->query_read("SELECT r.*, t.forumid FROM " . TABLE_PREFIX . "reputation AS r LEFT JOIN " . TABLE_PREFIX . "post AS p ON (p.postid = r.postid) LEFT JOIN " . TABLE_PREFIX . "thread AS t ON (t.threadid = p.threadid) WHERE r.whoadded = " . $user['userid'] . " AND r.dateline >= " . $vbulletin->GPC['start_date'] . " AND r.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('approval', $user['userid'], $action['reputationid'], false, array('forumid' => $action['forumid'], 'multiplier' => ( $vbulletin->options['credits_action_approval_absolute'] ? abs($action['reputation']) : $action['reputation'] ), 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'birthday':
				$birth = explode('-', $user['birthday']);
				$start = max($vbulletin->GPC['start_date'], $user['joindate']);
				$prevyear = date('Y', $start);
				$age = ( (substr($birth[2], 0, 1) != '0') ? intval($prevyear - $birth[2]) : 0 );

				while (true)
				{	//break if in the future
					$stamp = vbmktime(0, 0, 0, intval($birth[0]), intval($birth[1]), $prevyear);
					if ($stamp > $vbulletin->GPC['end_date']) break;
					if ($stamp > $start) VBCREDITS::action('birthday', $user['userid'], null, false, array('userinfo' => $userinfo, 'timestamp' => $stamp, 'multiplier' => $age));
					$age += ($age > 0);
					$prevyear++;
				}

				break;
			case 'calendar':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "event WHERE visible = 1 AND userid = " . $user['userid'] . " AND dateline >= " . $vbulletin->GPC['start_date'] . " AND dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('calendar', $user['userid'], $action['eventid'], false, array('multiplier' => $action['event'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'discuss':
				$actions = $db->query_read("SELECT m.*, g.creatoruserid FROM " . TABLE_PREFIX . "discussion AS d LEFT JOIN " . TABLE_PREFIX . "groupmessage AS m ON (m.gmid = d.firstpostid) LEFT JOIN " . TABLE_PREFIX . "socialgroup AS g ON (g.groupid = d.groupid) WHERE m.postuserid = " . $user['userid'] . " AND m.dateline >= " . $vbulletin->GPC['start_date'] . " AND m.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('discuss', $user['userid'], $action['discussionid'], false, array('ownerid' => $action['creatoruserid'], 'multiplier' => $action['pagetext'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'group':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "socialgroup WHERE creatoruserid = " . $user['userid'] . " AND dateline >= " . $vbulletin->GPC['start_date'] . " AND dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('group', $user['userid'], $action['groupid'], false, array('userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'infraction':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "infraction WHERE action = 0 AND userid = " . $user['userid'] . " AND dateline >= " . $vbulletin->GPC['start_date'] . " AND dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('infraction', $user['userid'], $action['infractionid'], false, array('multiplier' => $action['points'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'join':
				$actions = $db->query_read("SELECT m.* FROM " . TABLE_PREFIX . "socialgroupmember AS m LEFT JOIN " . TABLE_PREFIX . "socialgroup AS g ON (g.groupid = m.groupid) WHERE m.type = 'member' AND g.creatoruserid != m.userid AND m.userid = " . $user['userid'] . " AND m.dateline >= " . $vbulletin->GPC['start_date'] . " AND m.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('join', $user['userid'], $action['groupid'], false, array('userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'message':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "pmtext WHERE fromuserid = " . $user['userid'] . " AND dateline >= " . $vbulletin->GPC['start_date'] . " AND dateline <= " . $vbulletin->GPC['end_date']);

				while ($action = $db->fetch_array($actions))
				{
					$size = $action['message'];
					$recips = unserialize($action['touserarray']);
					for ($x = ( $vbulletin->options['credits_action_message_multiple'] ? sizeof($recips['cc']) + sizeof($recips['bcc']) : 1 ); $x > 0; $x--) VBCREDITS::action('message', $user['userid'], null, false, array('multiplier' => $size, 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				}

				$db->free_result($actions);
				break;
			case 'paycheck':
				$payref = explode('-', $vbulletin->options['credits_action_paycheck_start']);
				$refdate = vbmktime(0, 0, 0, intval($payref[1]), intval($payref[2]), intval($payref[0]));
				$interval = ($vbulletin->options['credits_action_paycheck_interval'] * 86400);
				$start = max($vbulletin->GPC['start_date'], $user['joindate']);
				$part = (abs($start - $refdate) % $interval);

				for ($stamp = $start + $interval - ( ($start < $refdate) ? $interval - $part : $part ); $stamp <= $vbulletin->GPC['end_date']; $stamp += $interval)
				{	//give all the missed paycheck awards
					VBCREDITS::action('paycheck', $user['userid'], null, false, array('userinfo' => $userinfo, 'timestamp' => $stamp));
				}

				break;
			case 'poll':
				$actions = $db->query_read("SELECT p.*, t.forumid FROM " . TABLE_PREFIX . "poll AS p LEFT JOIN " . TABLE_PREFIX . "thread AS t ON (t.pollid = p.pollid) WHERE t.visible = 1 AND t.postuserid = " . $user['userid'] . " AND t.dateline >= " . $vbulletin->GPC['start_date'] . " AND t.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('poll', $user['userid'], $action['pollid'], false, array('forumid' => $action['forumid'], 'multiplier' => $action['numberoptions'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'post':
				$actions = $db->query_read("SELECT p.*, t.forumid, t.postuserid FROM " . TABLE_PREFIX . "post AS p LEFT JOIN " . TABLE_PREFIX . "thread AS t ON (t.threadid = p.threadid) WHERE p.visible = 1 AND p.postid != t.firstpostid AND p.userid = " . $user['userid'] . " AND p.dateline >= " . $vbulletin->GPC['start_date'] . " AND p.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('post', $user['userid'], $action['postid'], false, array('forumid' => $action['forumid'], 'multiplier' => $action['pagetext'], 'ownerid' => $action['postuserid'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'punish':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "infraction WHERE action = 0 AND whoadded = " . $user['userid'] . " AND dateline >= " . $vbulletin->GPC['start_date'] . " AND dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('punish', $user['userid'], $action['infractionid'], false, array('multiplier' => $action['points'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'referral':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE usergroupid = " . $vbulletin->options['credits_action_referral_usergroup'] . " AND referrerid = " . $user['userid'] . " AND joindate >= " . $vbulletin->GPC['start_date'] . " AND joindate <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('referral', $user['userid'], $action['userid'], false, array('userinfo' => $userinfo, 'timestamp' => $action['joindate']));
				$db->free_result($actions);
				break;
			case 'reputation':
				$actions = $db->query_read("SELECT r.*, t.forumid FROM " . TABLE_PREFIX . "reputation AS r LEFT JOIN " . TABLE_PREFIX . "post AS p ON (p.postid = r.postid) LEFT JOIN " . TABLE_PREFIX . "thread AS t ON (t.threadid = p.threadid) WHERE r.userid = " . $user['userid'] . " AND r.dateline >= " . $vbulletin->GPC['start_date'] . " AND r.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('reputation', $user['userid'], $action['reputationid'], ($action['reputation'] < 0), array('forumid' => $action['forumid'], 'multiplier' => abs($action['reputation']), 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'tag':
				$diff = ( $vb4 ? 'content' : 'thread' );
				$actions = $db->query_read("SELECT r.*, c.userid, c.dateline, t.tagtext FROM " . TABLE_PREFIX . "tag$diff AS c LEFT JOIN " . TABLE_PREFIX . "tag AS t ON (t.tagid = c.tagid) LEFT JOIN " . TABLE_PREFIX . "thread AS r ON (r.threadid = c." . $diff . "id) WHERE" . ( $vb4 ? " c.contenttypeid = 2 AND" : '' ) . " c.userid = " . $user['userid'] . " AND c.dateline >= " . $vbulletin->GPC['start_date'] . " AND c.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('tag', $user['userid'], $action['tagtext'], false, array('ownerid' => $action['postuserid'], 'forumid' => $action['forumid'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'thread':
				$actions = $db->query_read("SELECT t.*, p.pagetext FROM " . TABLE_PREFIX . "thread AS t LEFT JOIN " . TABLE_PREFIX . "post AS p ON (p.postid = t.firstpostid) WHERE t.visible = 1 AND t.postuserid = " . $user['userid'] . " AND t.dateline >= " . $vbulletin->GPC['start_date'] . " AND t.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('thread', $user['userid'], $action['threadid'], false, array('forumid' => $action['forumid'], 'multiplier' => $action['pagetext'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'update':
				$actions = $db->query_read("SELECT g.*, f.postuserid AS discussuserid FROM " . TABLE_PREFIX . "groupmessage AS g LEFT JOIN " . TABLE_PREFIX . "discussion AS d ON (d.discussionid = g.discussionid) LEFT JOIN " . TABLE_PREFIX . "groupmessage AS f ON (d.firstpostid = f.gmid) WHERE g.gmid != f.gmid AND g.postuserid = " . $user['userid'] . " AND g.dateline >= " . $vbulletin->GPC['start_date'] . " AND g.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('update', $user['userid'], $action['gmid'], false, array('ownerid' => $action['discussuserid'], 'multiplier' => $action['pagetext'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'upload':
				$actions = $db->query_read("SELECT a.*," . ( $vb4 ? " f.filesize," : '' ) . " t.forumid FROM " . TABLE_PREFIX . "attachment AS a LEFT JOIN " . TABLE_PREFIX . "post AS p ON (p.postid = a." . ( $vb4 ? 'content' : 'post' ) . "id) LEFT JOIN " . TABLE_PREFIX . "thread AS t ON (t.threadid = p.threadid)" . ( $vb4 ? " LEFT JOIN " . TABLE_PREFIX . "filedata AS f ON (f.filedataid = a.filedataid)" : '' ) . " WHERE " . ( $vb4 ? "a.state = 'visible' AND a.contenttypeid = 1" : "a.visible = 1" ) . " AND a.userid = " . $user['userid'] . " AND a.dateline >= " . $vbulletin->GPC['start_date'] . " AND a.dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('upload', $user['userid'], $action['attachmentid'], false, array('forumid' => $action['forumid'], 'multiplier' => $action['filesize'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'visitor':
				$actions = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "visitormessage WHERE state = 'visible' AND postuserid = " . $user['userid'] . " AND dateline >= " . $vbulletin->GPC['start_date'] . " AND dateline <= " . $vbulletin->GPC['end_date']);
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('visitor', $user['userid'], $action['userid'], false, array('multiplier' => $action['pagetext'], 'ownerid' => $action['userid'], 'userinfo' => $userinfo, 'timestamp' => $action['dateline']));
				$db->free_result($actions);
				break;
			case 'vote':
				$actions = $db->query_read("SELECT v.*, t.forumid, t.postuserid, COUNT(*) AS votes FROM " . TABLE_PREFIX . "pollvote AS v LEFT JOIN " . TABLE_PREFIX . "thread AS t ON (t.pollid = v.pollid) WHERE v.userid = " . $user['userid'] . " AND v.votedate >= " . $vbulletin->GPC['start_date'] . " AND v.votedate <= " . $vbulletin->GPC['end_date'] . " GROUP BY v.pollid");
				while ($action = $db->fetch_array($actions)) VBCREDITS::action('vote', $user['userid'], $action['pollid'], false, array('forumid' => $action['forumid'], 'multiplier' => $action['votes'], 'ownerid' => $action['postuserid'], 'userinfo' => $userinfo, 'timestamp' => $action['votedate']));
				$db->free_result($actions);
				break;
		}
	}
}
?>