<?php
class NavmanEnhancements_XML_Builder
{
	protected $xml;
	protected $attributecache;
	
	public function __construct($productid, vB_XML_Builder &$xml)
	{
		$this->xml =& $xml;
		$this->attributecache = array();
		
		$navitems = vB::$vbulletin->db->query_read_slave("
			SELECT *
			FROM " . TABLE_PREFIX . "navigation
			WHERE productid = '" . vB::$vbulletin->db->escape_string($productid) . "'
			AND state & " . NAV_DELETED . " = 0
			ORDER BY navtype, parent, displayorder
		");
		while ($navitem = vB::$vbulletin->db->fetch_array($navitems))
		{
			$attributes = array(
				'includegroups '=> $navitem['includegroups'],
				'excludegroups' => $navitem['excludegroups'],
				'styleids' => $navitem['styleids'],
			);
			
			switch ($navitem['navtype'])
			{
				case 'tab':
					$attributes['tabmenu'] = $navitem['tabmenu'];
					$attributes['nofollow'] = $navitem['nofollow'];
					$attributes['titleattrib'] = $navitem['titleattrib'];
					$attributes['target'] = $navitem['target'];
					$attributes['sections'] = $navitem['sections'];
					$attributes['baseurl'] = $navitem['baseurl'];
					break;
				case 'link':
					if ($navitem['exttype'] != 'html')
					{
						$attributes['nofollow'] = $navitem['nofollow'];
						$attributes['titleattrib'] = $navitem['titleattrib'];
						$attributes['target'] = $navitem['target'];
						$attributes['appendtabid'] = $navitem['appendtabid'];
						$attributes['baseurl'] = $navitem['baseurl'];
					}
					if (!is_null($navitem['exttype']))
					{
						$attributes['exttype'] = $navitem['exttype'];
					}
					$attributes['parents'] = $navitem['parents'];
					break;
				case 'menu':
					$attributes['parents'] = $navitem['parents'];
					break;
			}

			if (!empty($attributes))
			{
				$this->attributecache[$navitem['name']] = $attributes;
			}
		}
	}
	
	public function add_group($tag, $attr = array())
	{
		$this->xml->add_group($tag, $attr);
		
		if (in_array($tag, array('tab', 'menu', 'link')) AND isset($attr['name']) AND isset($this->attributecache[$attr['name']]))
		{
			foreach ($this->attributecache[$attr['name']] AS $name => $value)
			{
				$this->xml->add_tag($name, $value);
			}
		}
		
		if ($tag == 'codes')
		{
			$this->xml->add_group('code', array('version' => '*'));
			$this->xml->add_tag('installcode', 'if ($vbulletin->products[\'navmanager_enhancements\'])
{
	$nmea = new NavmanEnhancements_Admin();
	$nmea->importAttributes($arr[\'navigation\']);
}');
			$this->xml->add_tag('uninstallcode', '');
			$this->xml->close_group();
		}
	}
	
	public function __call($name, $arguments)
	{
		return call_user_func_array(array($this->xml, $name), $arguments);
	}
	
	public function __set($name, $value)
	{
		$xml->$name = $value;
	}
	
	public function __get($name)
	{
		return $this->xml->$name;
	}
}
?>