/*
 * Decompiled with CFR 0.152.
 */
package com.smaxe.uv.stream;

import com.smaxe.uv.stream.MediaData;
import com.smaxe.uv.stream.StreamInfo;
import java.io.Serializable;

public final class MediaStreamInfo
implements Serializable,
Cloneable {
    private static final long a = 1L;
    public final long stimestamp;
    public final StreamInfo audio;
    public final StreamInfo video;
    public final StreamInfo data;

    public static int calculateBitrate(long l2, StreamInfo streamInfo, StreamInfo streamInfo2) {
        return l2 == 0L ? 0 : (int)((streamInfo.size - streamInfo2.size) * 1000L / l2);
    }

    public static int processMediaData(StreamInfo streamInfo, MediaData mediaData) {
        if (mediaData.size() == 0) {
            ++streamInfo.frames;
            return mediaData.rtime;
        }
        long l2 = -1L;
        if (streamInfo.frames == 0L) {
            l2 = 0L;
            streamInfo.timestamp = System.currentTimeMillis();
            streamInfo.duration = 0L;
            mediaData.rtime = 0;
        } else if (mediaData.hasAbsoluteTimestamp()) {
            l2 = mediaData.timestamp - streamInfo.duration;
            streamInfo.duration = mediaData.timestamp;
        } else if (mediaData.rtime < 0) {
            l2 = 0L;
            streamInfo.duration += (long)mediaData.rtime;
        } else if (mediaData.rtime > 5000) {
            l2 = (long)mediaData.rtime - streamInfo.duration;
            streamInfo.duration = mediaData.rtime;
        } else {
            l2 = mediaData.rtime;
            streamInfo.duration += (long)mediaData.rtime;
        }
        ++streamInfo.frames;
        streamInfo.size += (long)mediaData.size();
        return (int)l2;
    }

    public static void processMediaData(StreamInfo streamInfo, long l2, int n) {
        if (streamInfo.frames == 0L) {
            streamInfo.timestamp = System.currentTimeMillis();
            streamInfo.duration = 0L;
        } else {
            streamInfo.duration = l2;
        }
        ++streamInfo.frames;
        streamInfo.size += (long)n;
    }

    public MediaStreamInfo(long l2, StreamInfo streamInfo, StreamInfo streamInfo2, StreamInfo streamInfo3) {
        this.stimestamp = l2;
        this.audio = (StreamInfo)streamInfo.clone();
        this.video = (StreamInfo)streamInfo2.clone();
        this.data = (StreamInfo)streamInfo3.clone();
    }

    public MediaStreamInfo(long l2) {
        this.stimestamp = l2;
        this.audio = new StreamInfo();
        this.video = new StreamInfo();
        this.data = new StreamInfo();
    }

    public MediaStreamInfo() {
        this(0L);
    }

    public Object clone() {
        return new MediaStreamInfo(this.stimestamp, this.audio, this.video, this.data);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MediaStreamInfo)) {
            return false;
        }
        MediaStreamInfo mediaStreamInfo = (MediaStreamInfo)object;
        if (this.stimestamp != mediaStreamInfo.stimestamp) {
            return false;
        }
        if (!this.audio.equals(mediaStreamInfo.audio)) {
            return false;
        }
        if (!this.video.equals(mediaStreamInfo.video)) {
            return false;
        }
        return this.data.equals(mediaStreamInfo.data);
    }

    public int hashCode() {
        return (int)this.stimestamp;
    }

    public String toString() {
        return "MediaStreamInfo [" + this.stimestamp + ", " + this.audio + ", " + this.video + ", " + this.data + "]";
    }
}

