/*
 * Decompiled with CFR 0.152.
 */
package com.smaxe.uv.fformat;

import com.smaxe.io.ByteArray;
import com.smaxe.io.ByteArrayInputStream;
import com.smaxe.io.d;
import com.smaxe.io.f;
import com.smaxe.uv.amf.h;
import com.smaxe.uv.amf.support.a;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Flv {
    public static void checkHeader(byte[] byArray) {
        if (byArray[0] != 70 || byArray[1] != 76 || byArray[2] != 86) {
            throw new IllegalArgumentException("Unknown FLV file header!");
        }
    }

    public static Header readHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[9];
        inputStream.read(byArray);
        Flv.checkHeader(byArray);
        int n = byArray[3] & 0xFF;
        boolean bl = (byArray[4] & 4) != 0;
        boolean bl2 = (byArray[4] & 1) != 0;
        long l2 = ((long)(byArray[5] & 0xFF) << 24) + (long)((byArray[6] & 0xFF) << 16) + (long)((byArray[7] & 0xFF) << 8) + (long)((byArray[8] & 0xFF) << 0);
        long l3 = l2 - (long)byArray.length + 4L;
        if (l3 > 0L) {
            inputStream.skip(l3);
        }
        return new Header(n, bl, bl2, l2);
    }

    public static void writeHeader(OutputStream outputStream, Header header) throws IOException {
        byte[] byArray = new byte[]{70, 76, 86, (byte)header.version, (byte)((header.audio ? 4 : 0) + (header.video ? 1 : 0)), 0, 0, 0, (byte)header.dataOffset};
        outputStream.write(byArray);
        f.c(outputStream, 0);
    }

    public static int readTag(InputStream inputStream, ITagProcessor iTagProcessor) throws IOException {
        if (inputStream.available() == 0) {
            return -1;
        }
        int n = inputStream.read();
        int n2 = f.b(inputStream);
        long l2 = (long)f.b(inputStream) + ((long)inputStream.read() << 24);
        f.b(inputStream);
        d d2 = new d(inputStream, n2);
        iTagProcessor.onTag(n, n2, l2, d2);
        d2.skip(d2.available());
        int n3 = f.c(inputStream);
        iTagProcessor.onTagSize(n3);
        return n;
    }

    public static void writeTag(OutputStream outputStream, int n, long l2, byte[] byArray, int n2, int n3) throws IOException {
        Flv.writeTagHeader(outputStream, n, l2, n3);
        outputStream.write(byArray, n2, n3);
        Flv.writeTagTrailer(outputStream, n3);
    }

    public static void writeTagHeader(OutputStream outputStream, int n, long l2, int n2) throws IOException {
        outputStream.write(n);
        f.b(outputStream, n2);
        f.b(outputStream, (int)(l2 & 0xFFFFFFL));
        outputStream.write((int)(l2 >> 24 & 0xFFL));
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
    }

    public static void writeTagTrailer(OutputStream outputStream, int n) throws IOException {
        f.c(outputStream, 11 + n);
    }

    public static ScriptData[] readScriptData(InputStream inputStream, int n) throws IOException {
        a a2;
        String string;
        ByteArray byteArray = new ByteArray(n);
        inputStream.read(byteArray.array);
        ArrayList<ScriptData> arrayList = new ArrayList<ScriptData>(4);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        while (byteArrayInputStream.available() > 0 && (string = (String)com.smaxe.uv.amf.f.a(byteArrayInputStream, a2 = new a(), null)).length() != 0) {
            LinkedHashMap linkedHashMap = com.smaxe.uv.amf.f.a(byteArrayInputStream, a2, null);
            LinkedHashMap linkedHashMap2 = linkedHashMap;
            if (linkedHashMap2 instanceof Map) {
                linkedHashMap2 = new LinkedHashMap(linkedHashMap);
            }
            arrayList.add(new ScriptData(string, linkedHashMap2));
        }
        return arrayList.toArray(new ScriptData[arrayList.size()]);
    }

    public static void writeScriptData(OutputStream outputStream, ScriptData[] scriptDataArray) throws IOException {
        a a2 = new a();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        for (ScriptData scriptData : scriptDataArray) {
            h.a((DataOutput)dataOutputStream, scriptData.name);
            h.a((DataOutput)dataOutputStream, scriptData.value, (com.smaxe.uv.amf.d)a2, null);
        }
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(9);
    }

    private Flv() {
    }

    public static class TagProcessorAdapter
    implements ITagProcessor {
        public void onTag(int n, int n2, long l2, InputStream inputStream) throws IOException {
        }

        public void onTagSize(int n) {
        }
    }

    public static interface ITagProcessor {
        public void onTag(int var1, int var2, long var3, InputStream var5) throws IOException;

        public void onTagSize(int var1);
    }

    public static class ScriptData {
        public final String name;
        public final Object value;

        public ScriptData(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String toString() {
            return "ScriptData [" + this.name + " : " + this.value + "]";
        }
    }

    public static final class Tag {
        public static final byte TYPE_AUDIO = 8;
        public static final byte TYPE_VIDEO = 9;
        public static final byte TYPE_DATA = 18;
        public final byte type;
        public final int dataSize;
        public final long timestamp;

        public Tag(byte by, int n, long l2) {
            this.type = by;
            this.dataSize = n;
            this.timestamp = l2;
        }

        public String toString() {
            return "Tag [" + this.type + ", " + this.dataSize + ", " + this.timestamp + "]";
        }
    }

    public static final class Header {
        public final int version;
        public final boolean audio;
        public final boolean video;
        public final long dataOffset;

        public Header(int n, boolean bl, boolean bl2, long l2) {
            this.version = n;
            this.audio = bl;
            this.video = bl2;
            this.dataOffset = l2;
        }

        public Header(boolean bl, boolean bl2) {
            this(1, bl, bl2, 9L);
        }

        public final int getSize() {
            return 9;
        }

        public String toString() {
            return "Header [" + this.version + ", " + this.audio + ", " + this.video + ", " + this.dataOffset + "]";
        }
    }
}

