/*
 * Decompiled with CFR 0.152.
 */
package com.smaxe.uv.amf.support;

import com.smaxe.uv.amf.ClassObject;
import com.smaxe.uv.amf.IObjectCreator;
import com.smaxe.uv.amf3.ArrayCollection;
import com.smaxe.uv.amf3.ObjectProxy;
import java.io.Externalizable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ObjectCreator
implements IObjectCreator {
    public ClassObject toClassObject(Object object) {
        if (object instanceof ArrayCollection) {
            ClassObject classObject = new ClassObject("flex.messaging.io.ArrayCollection");
            classObject.propertyValues.put("source", ((ArrayCollection)object).array);
            return classObject;
        }
        if (object instanceof ObjectProxy) {
            return new ClassObject("flex.messaging.io.ObjectProxy", ((ObjectProxy)object).object);
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        for (Field field : clazz.getFields()) {
            int n = field.getModifiers();
            if (Modifier.isFinal(n) || Modifier.isStatic(n) || Modifier.isTransient(n)) continue;
            try {
                hashMap.put(field.getName(), field.get(object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ClassObject(string, hashMap);
    }

    public Object toObject(ClassObject classObject) {
        try {
            if ("flex.messaging.io.ArrayCollection".equals(classObject.className)) {
                return new ArrayCollection((List)classObject.propertyValues.get("source"));
            }
            if ("flex.messaging.io.ObjectProxy".equals(classObject.className)) {
                return new ObjectProxy(classObject.propertyValues);
            }
            Class<?> clazz = Class.forName(classObject.className);
            Object obj = clazz.newInstance();
            for (Map.Entry<String, Object> entry : classObject.propertyValues.entrySet()) {
                Field field = clazz.getField(entry.getKey());
                if (field == null) continue;
                field.set(obj, entry.getValue());
            }
            return obj;
        }
        catch (Exception exception) {
            return classObject;
        }
    }

    public Externalizable getExternalizable(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof Externalizable) {
                return (Externalizable)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getClassName(Externalizable externalizable) {
        return externalizable.getClass().getCanonicalName();
    }
}

