/*
 * Decompiled with CFR 0.152.
 */
package com.smaxe.io;

import com.smaxe.io.ByteArray;
import com.smaxe.io.c;
import com.smaxe.io.f;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class ByteArrayOutputStream
extends OutputStream
implements DataOutput {
    private final byte[] a;
    private final int b;
    private final int c;
    private int d = 0;

    public ByteArrayOutputStream(byte[] byArray) {
        this.a = byArray;
        this.b = 0;
        this.c = byArray.length;
        this.d = this.b;
    }

    public ByteArrayOutputStream(byte[] byArray, int n) {
        this.a = byArray;
        this.b = n;
        this.c = byArray.length - n;
        this.d = n;
    }

    public ByteArrayOutputStream(ByteArray byteArray) {
        this.a = byteArray.array;
        this.b = byteArray.offset;
        this.c = byteArray.length;
        this.d = byteArray.offset;
    }

    public void write(int n) throws IOException {
        this.a[this.d++] = (byte)(n & 0xFF);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        System.arraycopy(byArray, n, this.a, this.d, n2);
        this.d += n2;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.a[this.d++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.a[this.d++] = (byte)(n & 0xFF);
    }

    public void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            this.write((byte)string.charAt(i2));
        }
    }

    public void writeChar(int n) throws IOException {
        this.a[this.d++] = (byte)(n >> 8 & 0xFF);
        this.a[this.d++] = (byte)(n >> 0 & 0xFF);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = string.charAt(i2);
            this.a[this.d++] = (byte)(c2 >> 8 & 0xFF);
            this.a[this.d++] = (byte)(c2 >> 0 & 0xFF);
        }
    }

    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public void writeInt(int n) throws IOException {
        this.a[this.d++] = (byte)(n >> 24 & 0xFF);
        this.a[this.d++] = (byte)(n >> 16 & 0xFF);
        this.a[this.d++] = (byte)(n >> 8 & 0xFF);
        this.a[this.d++] = (byte)(n >> 0 & 0xFF);
    }

    public void writeLong(long l2) throws IOException {
        this.a[this.d++] = (byte)(l2 >> 56 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 48 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 40 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 32 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 24 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 16 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 8 & 0xFFL);
        this.a[this.d++] = (byte)(l2 >> 0 & 0xFFL);
    }

    public void writeShort(int n) throws IOException {
        this.a[this.d++] = (byte)(n >> 8 & 0xFF);
        this.a[this.d++] = (byte)(n >> 0 & 0xFF);
    }

    public void writeUTF(String string) throws IOException {
        int n = f.a(string);
        this.writeShort(n);
        f.a(this.a, this.d, string);
        this.d += n;
    }

    public final ByteArray getArray() {
        return new ByteArray(this.a, this.b, this.c);
    }

    public final int getWritten() {
        return this.d - this.b;
    }

    public static void writeContent(ByteArrayOutputStream byteArrayOutputStream, c c2) throws IOException {
        int n = byteArrayOutputStream.getWritten();
        byteArrayOutputStream.writeInt(0);
        c2.a(byteArrayOutputStream);
        ByteArray byteArray = byteArrayOutputStream.getArray();
        f.a(byteArray.array, byteArray.offset + n, byteArrayOutputStream.getWritten() - n - 4);
    }
}

