/*
 * Decompiled with CFR 0.152.
 */
package com.smaxe.io;

import com.smaxe.io.ByteArray;
import com.smaxe.io.a;
import com.smaxe.io.f;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;

public final class ByteArrayInputStream
extends a
implements DataInput {
    private final byte[] a;
    private final int b;
    private final int c;
    private int d;
    private int e = -1;
    private final int f;

    public ByteArrayInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArrayInputStream(byte[] byArray, int n) {
        this(byArray, n, byArray.length);
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Illegal offset argument");
        }
        this.a = byArray;
        this.b = n;
        this.c = Math.min(byArray.length - n, n2);
        this.d = this.b;
        this.f = this.b + this.c;
    }

    public ByteArrayInputStream(ByteArray byteArray) {
        this.a = byteArray.array;
        this.b = byteArray.offset;
        this.c = byteArray.length;
        this.d = this.b;
        this.f = this.b + this.c;
    }

    public final int available() throws IOException {
        return this.f - this.d;
    }

    public int read() throws IOException {
        if (this.available() > 0) {
            return this.a[this.d++] & 0xFF;
        }
        throw new IOException("Data is not available!");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(this.available(), n2);
        System.arraycopy(this.a, this.d, byArray, n, n3);
        this.d += n3;
        return n3;
    }

    public long skip(long l2) throws IOException {
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = Math.min((long)this.available(), l2);
        this.d = (int)((long)this.d + l3);
        return l3;
    }

    public void mark(int n) {
        this.e = this.d;
    }

    public void reset() throws IOException {
        if (this.e < 0) {
            return;
        }
        this.d = this.e;
        this.e = -1;
    }

    public boolean markSupported() {
        return true;
    }

    public long getPosition() throws IOException {
        return this.d - this.b;
    }

    public void seek(long l2) throws IOException {
        if (l2 < 0L || l2 >= (long)this.c) {
            throw new IOException("Parameter 'pos' is out of range");
        }
        this.d = this.b + (int)l2;
    }

    public boolean readBoolean() throws EOFException, IOException {
        if (this.available() > 0) {
            return this.a[this.d++] != 0;
        }
        throw new EOFException("Data is not available!");
    }

    public byte readByte() throws EOFException, IOException {
        if (this.available() > 0) {
            return this.a[this.d++];
        }
        throw new EOFException("Data is not available!");
    }

    public char readChar() throws EOFException, IOException {
        if (this.available() > 1) {
            int n;
            int n2;
            if (((n2 = this.a[this.d++] & 0xFF) | (n = this.a[this.d++] & 0xFF)) < 0) {
                throw new EOFException("Unknown char");
            }
            return (char)((n2 << 8) + (n << 0));
        }
        throw new EOFException("Data is not available!");
    }

    public double readDouble() throws EOFException, IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws EOFException, IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws EOFException, IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws EOFException, IOException {
        if (this.available() >= n2) {
            System.arraycopy(this.a, this.d, byArray, n, n2);
            this.d += n2;
        } else {
            throw new EOFException("Data is not available!");
        }
    }

    public int readInt() throws EOFException, IOException {
        if (this.available() > 3) {
            return ((this.a[this.d++] & 0xFF) << 24) + ((this.a[this.d++] & 0xFF) << 16) + ((this.a[this.d++] & 0xFF) << 8) + ((this.a[this.d++] & 0xFF) << 0);
        }
        throw new EOFException("Data is not available!");
    }

    public String readLine() throws EOFException, IOException {
        throw new IOException("Method is not supported");
    }

    public long readLong() throws EOFException, IOException {
        if (this.available() > 7) {
            return ((long)(this.a[this.d++] & 0xFF) << 56) + ((long)(this.a[this.d++] & 0xFF) << 48) + ((long)(this.a[this.d++] & 0xFF) << 40) + ((long)(this.a[this.d++] & 0xFF) << 32) + ((long)(this.a[this.d++] & 0xFF) << 24) + (long)((this.a[this.d++] & 0xFF) << 16) + (long)((this.a[this.d++] & 0xFF) << 8) + (long)((this.a[this.d++] & 0xFF) << 0);
        }
        throw new EOFException("Data is not available!");
    }

    public short readShort() throws EOFException, IOException {
        if (this.available() > 1) {
            return (short)(((this.a[this.d++] & 0xFF) << 8) + ((this.a[this.d++] & 0xFF) << 0));
        }
        throw new EOFException("Data is not available!");
    }

    public String readUTF() throws EOFException, IOException {
        short s = this.readShort();
        String string = com.smaxe.io.f.b(this.a, this.d, s);
        this.d += s;
        return string;
    }

    public int readUnsignedByte() throws EOFException, IOException {
        if (this.available() > 0) {
            return this.a[this.d++] & 0xFF;
        }
        throw new EOFException("Data is not available!");
    }

    public int readUnsignedShort() throws EOFException, IOException {
        if (this.available() > 1) {
            return ((this.a[this.d++] & 0xFF) << 8) + ((this.a[this.d++] & 0xFF) << 0);
        }
        throw new EOFException("Data is not available!");
    }

    public int skipBytes(int n) throws EOFException, IOException {
        return (int)this.skip(n);
    }

    public final ByteArray getArray() {
        return new ByteArray(this.a, this.b, this.c);
    }

    public final int getRead() {
        return this.d - this.b;
    }

    public ByteArray read(long l2) throws IOException {
        int n = this.d;
        long l3 = this.skip(l2);
        return new ByteArray(this.a, n, (int)l3);
    }
}

