<?php

class DoublePostings_ControllerPublic_Thread extends XenForo_ControllerPublic_Thread
{
	/**
	 * Inserts a new reply into an existing thread.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	
	public function actionAddReply()
	{
		$this->_assertPostOnly();

		if ($this->_input->inRequest('more_options'))
		{
			return $this->responseReroute(__CLASS__, 'reply');
		}

		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);

		$visitor = XenForo_Visitor::getInstance();

		$ftpHelper = $this->getHelper('ForumThreadPost');
		$threadFetchOptions = array('readUserId' => $visitor['user_id']);
		$forumFetchOptions = array('readUserId' => $visitor['user_id']);
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId, $threadFetchOptions, $forumFetchOptions);

		$this->_assertCanReplyToThread($thread, $forum);

		if (!XenForo_Captcha_Abstract::validateDefault($this->_input))
		{
			return $this->responseCaptchaFailed();
		}


		$input = $this->_input->filter(array(
			'attachment_hash' => XenForo_Input::STRING,

			'watch_thread_state' => XenForo_Input::UINT,
			'watch_thread' => XenForo_Input::UINT,
			'watch_thread_email' => XenForo_Input::UINT,

			'_set' => array(XenForo_Input::UINT, 'array' => true),
			'discussion_open' => XenForo_Input::UINT,
			'sticky' => XenForo_Input::UINT,
		));
		$input['message'] = $this->getHelper('Editor')->getMessageText('message', $this->_input);
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);

		$writer = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
		$writer->set('user_id', $visitor['user_id']);
		$writer->set('username', $visitor['username']);
		$writer->set('message', $input['message']);
		$writer->set('message_state', $this->_getPostModel()->getPostInsertMessageState($thread, $forum));
		$writer->set('thread_id', $threadId);
		$writer->setExtraData(XenForo_DataWriter_DiscussionMessage::DATA_ATTACHMENT_HASH, $input['attachment_hash']);
		$writer->setExtraData(XenForo_DataWriter_DiscussionMessage_Post::DATA_FORUM, $forum);
		$writer->preSave();

		if (!$writer->hasErrors())
		{
			$this->assertNotFlooding('post');
		}

		$writer->save();
		$post = $writer->getMergedData();

		$this->_getThreadWatchModel()->setVisitorThreadWatchStateFromInput($threadId, $input);

		$threadUpdateData = array();

		if (!empty($input['_set']['discussion_open']) && $this->_getThreadModel()->canLockUnlockThread($thread, $forum))
		{
			if ($thread['discussion_open'] != $input['discussion_open'])
			{
				$threadUpdateData['discussion_open'] = $input['discussion_open'];
			}
		}

		// discussion sticky state - moderator permission required
		if (!empty($input['_set']['sticky']) && $this->_getForumModel()->canStickUnstickThreadInForum($forum))
		{
			if ($thread['sticky'] != $input['sticky'])
			{
				$threadUpdateData['sticky'] = $input['sticky'];
			}
		}

		if ($threadUpdateData)
		{
			$threadWriter = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$threadWriter->setExistingData($thread['thread_id']);
			$threadWriter->bulkSet($threadUpdateData);
			$threadWriter->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
			$threadWriter->save();
		}

		$canViewPost = $this->_getPostModel()->canViewPost($post, $thread, $forum);

		$page = floor(($thread['reply_count'] + 1) / XenForo_Application::get('options')->messagesPerPage) + 1;
		
		$redirect_need = 0;
		
		if(isset($post['old_post_message']))
		{
			if( XenForo_Application::get('options')->refresh_page_if_double_post)
			{
				$redirect_need = 1;	
			}
		}
		
		// this is a standard redirect
		if (!$this->_noRedirect() || !$this->_input->inRequest('last_date') || !$canViewPost || $redirect_need)
		{
			$this->_getThreadModel()->markThreadRead($thread, $forum, XenForo_Application::$time);

			if (!$canViewPost)
			{
				$return = XenForo_Link::buildPublicLink('threads', $thread, array('page' => $page, 'posted' => 1));
			}
			else
			{
				$return = XenForo_Link::buildPublicLink('posts', $post);
			}

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$return,
				new XenForo_Phrase('your_message_has_been_posted')
			);
		}
		else
		{
			// load a selection of posts that are newer than the last post viewed
			$threadModel = $this->_getThreadModel();
			$postModel = $this->_getPostModel();

			// the max number of posts we want to fetch
			$limit = 3;

			$postFetchOptions = $this->_getPostFetchOptions($thread, $forum);
			$postFetchOptions += array(
				'limit' => ($limit + 1),
			);

			$lastDate = $this->_input->filterSingle('last_date', XenForo_Input::UINT);

			$posts = $postModel->getNewestPostsInThreadAfterDate(
				$threadId, $lastDate, $postFetchOptions
			);

			// We fetched one more post than needed, if more than $limit posts were returned,
			// we can show the 'there are more posts' notice
			if (count($posts) > $limit)
			{
				$postPermissionOptions = $postModel->getPermissionBasedPostFetchOptions($thread, $forum);
				$firstUnshownPost = $postModel->getNextPostInThread($threadId, $lastDate, $postPermissionOptions);

				// remove the extra post
				array_pop($posts);
			}
			else
			{
				$firstUnshownPost = false;
			}

			// put the posts into oldest-first order
			$posts = array_reverse($posts, true);

			$posts = $postModel->getAndMergeAttachmentsIntoPosts($posts);

			$permissions = $visitor->getNodePermissions($thread['node_id']);
			
			$post_old_message_id = -1;
			
			if(isset($post['old_post_message']))
			{
				$post_old_message 	= $post['old_post_message'];
				$post_old_message_id= $post['post_id'];
			}
			
			foreach ($posts AS &$post)
			{
				$post = $postModel->preparePost($post, $thread, $forum, $permissions);
				
				if($post_old_message_id == $post['post_id'])
				{
					$post['message'] = $post_old_message;
				}
			}

			// mark thread as read if we're showing the remaining posts in it or they've been read
			if ($visitor['user_id'])
			{
				if (!$firstUnshownPost || $firstUnshownPost['post_date'] <= $thread['thread_read_date'])
				{
					$this->_getThreadModel()->markThreadRead($thread, $forum, XenForo_Application::$time);
				}
			}

			$viewParams = $this->_getDefaultViewParams($forum, $thread, $posts, $page, array(
				'firstUnshownPost' => $firstUnshownPost,
				'lastPost' => end($posts),
			));

			return $this->responseView(
				'XenForo_ViewPublic_Thread_ViewNewPosts',
				'thread_reply_new_posts',
				$viewParams
			);
		}
	}
}