<?php
class Esthetic_BannerSystem_Controller_Admin extends XenForo_ControllerAdmin_Abstract {

	protected function _preDispatch($action) {
		$this->assertAdminPermission('user');
        return true;
	}

    /**
     * <b>:</b><br />
     *   Index
     *
     * @param   string      $errorMessage
     * @return  XenForo_ControllerResponse_Abstract
     */
	public function actionIndex ($errorMessage = false) {
    
		$viewParams = array ( );
        
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
        
        $records = $db->fetchAll ('SELECT t.* FROM `est_banner` t ORDER BY t.id ASC');
        
        XenForo_Db::commit($db);
        
        if (is_array ($records)) {
            $viewParams['records']  = $records;
            $viewParams['empty']    = false;
        } else {
            $viewParams['records']  = false;
            $viewParams['empty']    = true;
        }
        
        if ($errorMessage !== false) {
            $viewParams['isError']      = true;
            $viewParams['errorMessage'] = $errorMessage;
        }
        
        return $this->responseView(
            'Esthetic_BannerSystem_View_Admin_Statistics', 
            'esthetic_bannerSystem_statistics', 
            $viewParams
        );
	}

    /**
     * <b>:</b><br />
     *   Create
     * 
     * @return  XenForo_ControllerResponse_Abstract
     */
	public function actionCreate ( ) {
        
        $rules = array ( );
        
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
        $_rules = $db->fetchAll ('SELECT t.* FROM `est_banner_rule` t ORDER BY t.id ASC');
        XenForo_Db::commit($db);
        
        if (is_array ($_rules)) {
            $rules = $_rules;
        }
    
		$viewParams = array (
            'banner' => array (
                'id'        => false,
                'title'     => '',
                'code'      => ''
            ),
            'rules' => $rules
        );
        
        return $this->responseView(
            'Esthetic_BannerSystem_View_Admin_Create', 
            'esthetic_bannerSystem_banner_edit', 
            $viewParams
        );
	}
    
    /**
     * <b>:</b><br />
     *   Edit
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionEdit () {
    
        $response_layout    = 'Esthetic_BannerSystem_View_Admin_Edit';
        $response_template  = 'esthetic_bannerSystem_banner_edit';
        $rules              = array ( );
        
        /**
         *   ,   
         */
        $data = $this->_input->filter(array(
            'id' => XenForo_Input::UINT
        ));
        
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
        $record = $db->fetchRow (sprintf('SELECT t.* FROM `est_banner` t WHERE t.id = %s', $data['id']));
        $_rules = $db->fetchAll ('SELECT t.* FROM `est_banner_rule` t ORDER BY t.id ASC');
        XenForo_Db::commit($db);
        
        if (is_array ($_rules)) {
            $rules = $_rules;
        }
        
        if (false === (isset ($record['id']) && isset ($record['title']) && isset ($record['code']))) {
            return $this->actionIndex(new XenForo_Phrase('esthetic_bannerSystem_benner_not_found'));
        }
        
        $record['title']     = stripslashes($record['title']);
        $record['code']      = stripslashes($record['code']);
        $record['link']      = stripslashes($record['link']);
        $record['image']     = stripslashes($record['image']);
        
        return $this->responseView(
            $response_layout,
            $response_template,
            array(
                'banner'    => $record,
                'rules'     => $rules
            )
        );
    }
    
    /**
     * <b>:</b><br />
     *   Save
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionSave ( ) {

        $response_layout    = 'Esthetic_BannerSystem_View_Admin_Create';
        $response_template  = 'esthetic_bannerSystem_banner_edit';
        $viewParams         = array ( );
        $isError            = false;
        $errorMessage       = '';
        $rules              = array ( );
        
		$this->_assertPostOnly();

        /**
         *   ,   
         */
        $data = $this->_input->filter(array(
            'id'            => XenForo_Input::UINT,
            'rule_id'       => XenForo_Input::UINT,
            'link'          => array(XenForo_Input::STRING, 'noTrim' => true),
            'image'         => array(XenForo_Input::STRING, 'noTrim' => true),
            'title'         => array(XenForo_Input::STRING, 'noTrim' => true),
            'code'          => array(XenForo_Input::STRING, 'noTrim' => true),
            'is_active'     => XenForo_Input::UINT
        ));

        /* *************************     ************************* */
        
        if (strlen(utf8_decode($data['title'])) > 100) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_banner_title_require') . ' ';
            $isError        = true;
        }
        
        if (strlen(utf8_decode($data['link'])) > 1000) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_banner_link_require') . ' ';
            $isError        = true;
        }
        
        if (strlen(utf8_decode($data['image'])) > 1000) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_banner_image_require') . ' ';
            $isError        = true;
        }
        
        if (strlen(utf8_decode($data['code'])) > 4000) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_banner_code_require') . ' ';
            $isError        = true;
        }

        $viewParams         = array (
            'banner' => $data
        );

        /**
         * @var Zend_Db_Adapter_Abstract
         */
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
        
        $_rules = $db->fetchAll ('SELECT t.* FROM `est_banner_rule` t ORDER BY t.id ASC');
        if (is_array ($_rules)) {
            $rules = $_rules;
        }

        /**
         *   (, )
         */
        if ($isError !== true) {
            if ((int)$data['id'] > 0) {
                $result = $db->query('
                    UPDATE `est_banner` SET
                        `rule_id`    = ' . (int)$data['rule_id'] . ',
                        `title`      = \'' . addslashes ($data['title']) . '\', 
                        `link`       = \'' . addslashes ($data['link']) . '\', 
                        `image`      = \'' . addslashes ($data['image']) . '\', 
                        `code`       = \'' . addslashes ($data['code']) . '\', 
                        `created_at` = \'' . date ('Y-m-d H:i:s', time ()) . '\',
                        `is_active`  = ' . (int)$data['is_active'] . '
                    WHERE `id` = ' . (int)$data['id']
                );
                $check = $db->fetchRow ('SELECT b.* FROM `est_banner` b WHERE b.id = ' . (int)$data['id']);
            } else {
                $result = $db->query('
                    INSERT INTO `est_banner` (`rule_id`, `title`, `link`, `image`, `code`, `created_at`, `is_active`)
                    VALUES (
                        ' . (int)$data['rule_id'] . ',
                        \'' . addslashes ($data['title']) . '\', 
                        \'' . addslashes ($data['link']) . '\', 
                        \'' . addslashes ($data['image']) . '\', 
                        \'' . addslashes ($data['code']) . '\', 
                        \'' . date ('Y-m-d H:i:s', time ()) . '\',
                        ' . (int)$data['is_active'] . '
                    )
                ');
                $check = $db->fetchRow ('SELECT b.* FROM `est_banner` b WHERE b.id = LAST_INSERT_ID()');
            }
            
            XenForo_Db::commit($db);
            
            if (is_array ($check)) {
                $check['title']     = stripslashes($check['title']);
                $check['code']      = stripslashes($check['code']);
                $check['image']     = stripslashes($check['image']);
                $check['link']      = stripslashes($check['link']);
                
                /**
                 *  
                 */
                if ($data['title'] != $check['title'] || $data['code'] != $check['code']) {
                    $errorMessage   = new XenForo_Phrase('esthetic_bannerSystem_db_save_error');
                    $isError        = true;
                } else {
                    $viewParams         = array (
                        'banner' => $check
                    );
                }
            } else {
                $errorMessage   = new XenForo_Phrase('esthetic_bannerSystem_db_save_error');
                $isError        = true;
            }
        }

        $viewParams['isError']      = $isError;
        $viewParams['errorMessage'] = $errorMessage;
        $viewParams['rules']        = $rules;
        
        if (!$isError) {
            $viewParams['message'] = new XenForo_Phrase('esthetic_bannerSystem_banner_stored');
        }
        
        return $this->responseView($response_layout, $response_template, $viewParams);
    }
    
    /**
     * <b>:</b><br />
     *   Rules
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionRules ($errorMessage = false) {
        $response_layout            = 'Esthetic_BannerSystem_View_Rules';
        $response_template          = 'esthetic_bannerSystem_rules';
        $viewParams                 = array ( );
        $viewParams['isError']      = false;
        $viewParams['errorMessage'] = $errorMessage;
        
		$viewParams = array ( );
        
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
        
        $records = $db->fetchAll ('SELECT t.* FROM `est_banner_rule` t ORDER BY t.id ASC');
        
        XenForo_Db::commit($db);
        
        if (is_array ($records)) {
            foreach ($records as &$record) {
                $record['size'] = sprintf (
                    '%sx%s',
                    $record['width'] > 0 ? $record['width'] : new XenForo_Phrase ('esthetic_bannerSystem_size_any'),
                    $record['height'] > 0 ? $record['height'] : new XenForo_Phrase ('esthetic_bannerSystem_size_any')
                );
            }
            $viewParams['rules']  = $records;
        }
        
        if ($errorMessage !== false) {
            $viewParams['isError']      = true;
            $viewParams['errorMessage'] = $errorMessage;
        }

        return $this->responseView($response_layout, $response_template, $viewParams);
    }
    
    /**
     * <b>:</b><br />
     *   Rules
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionCreateRule ( ) {
        $response_layout    = 'Esthetic_BannerSystem_View_Create_Rule';
        $response_template  = 'esthetic_bannerSystem_rule_edit';
		$viewParams = array (
            'rule' => array (
                'id'        => false,
                'title'     => ''
            )
        );
        
        return $this->responseView($response_layout, $response_template, $viewParams);
    }
    
    /**
     * <b>:</b><br />
     *   RuleSave
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionRuleSave ( ) {
        $response_layout    = 'Esthetic_BannerSystem_View_Create_Rule';
        $response_template  = 'esthetic_bannerSystem_rule_edit';
        $viewParams         = array ( );
        $isError            = false;
        $errorMessage       = '';
        
		$this->_assertPostOnly();

        /**
         *   ,   
         */
        $data = $this->_input->filter(array(
            'id'            => XenForo_Input::UINT,
            'title'         => array(XenForo_Input::STRING, 'noTrim' => true),
            'description'   => array(XenForo_Input::STRING, 'noTrim' => true),
            'width'         => XenForo_Input::UINT,
            'height'        => XenForo_Input::UINT,
            'is_active'     => XenForo_Input::INT
        ));
        $data['is_active'] = (bool)$data['is_active'];
        
        /* *************************     ************************* */
        
        if (strlen(utf8_decode($data['title'])) < 6 || strlen(utf8_decode($data['title'])) > 32) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_rule_title_require') . ' ';
            $isError        = true;
        }
        
        if (preg_match ('/[^a-zA-Z0-9\.\_\-]/', $data['title'])) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_rule_title_wrong') . ' ';
            $isError        = true;
        }
        
        if (strlen(utf8_decode($data['description'])) > 2048) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_rule_description_long') . ' ';
            $isError        = true;
        }
        
        if ($data['width'] > 1600) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_rule_width_error') . ' ';
            $isError        = true;
        }
        
        if ($data['height'] > 1200) {
            $errorMessage   .= new XenForo_Phrase('esthetic_bannerSystem_rule_height_error') . ' ';
            $isError        = true;
        }
        
        $viewParams['rule']         = $data;
        $viewParams['isError']      = $isError;
        $viewParams['errorMessage'] = $errorMessage;
        
        if ($isError) return $this->responseView($response_layout, $response_template, $viewParams);
        
        /* *************************    ************************* */

        /**
         * @var Zend_Db_Adapter_Abstract
         */
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
            
        $check_a = $db->fetchRow(sprintf('SELECT b.* FROM `est_banner_rule` b WHERE b.title = \'%s\'', $data['title']));
        if (isset ($check_a['id']) && (int)$check_a['id'] !== $data['id']) {
            $viewParams['isError']      = true;
            $viewParams['errorMessage'] = new XenForo_Phrase('esthetic_bannerSystem_rule_title_dupe');
            XenForo_Db::commit($db);
            return $this->responseView($response_layout, $response_template, $viewParams);
        }
        
        if ($data['id'] > 0) {
            $check_b = $db->fetchRow(sprintf('SELECT b.* FROM `est_banner_rule` b WHERE b.id = %s', $data['id']));
            if (isset ($check_b['id']) && $check_b['title'] != $data['title'] && $check_b['is_autogenerated'] == 1) {
                $viewParams['isError']      = true;
                $viewParams['errorMessage'] = new XenForo_Phrase('esthetic_bannerSystem_rule_is_auto');
                XenForo_Db::commit($db);
                $viewParams['rule']['title'] = stripslashes($check_b['title']);
                return $this->responseView($response_layout, $response_template, $viewParams);
            }
        }
        
        if ((int)$data['id'] > 0) {
            $result = $db->query('
                UPDATE `est_banner_rule` SET
                    `title`         = \'' . addslashes ($data['title']) . '\', 
                    `description`   = \'' . addslashes ($data['description']) . '\', 
                    `width`         = ' . (int)$data['width'] . ', 
                    `height`        = ' . (int)$data['height'] . ', 
                    `is_active`     = ' . (int)$data['is_active'] . '
                WHERE `id` = ' . (int)$data['id']
            );
            $check = $db->fetchRow ('SELECT b.* FROM `est_banner_rule` b WHERE b.id = ' . (int)$data['id']);
        } else {
            $result = $db->query('
                INSERT INTO `est_banner_rule` (`title`, `description`, `width`, `height`, `is_active`)
                VALUES (
                    \'' . addslashes ($data['title']) . '\', 
                    \'' . addslashes ($data['description']) . '\', 
                    ' . (int)$data['width'] . ', 
                    ' . (int)$data['height'] . ', 
                    ' . (int)$data['is_active'] . '
                )
            ');
            $check = $db->fetchRow ('SELECT b.* FROM `est_banner_rule` b WHERE b.id = LAST_INSERT_ID()');
        }
        
        XenForo_Db::commit($db);
        
        if (is_array ($check)) {
            $check['title']     = stripslashes($check['title']);
            
            /**
             *  
             */
            if ($data['title'] != $check['title']) {
                $errorMessage   = new XenForo_Phrase('esthetic_bannerSystem_db_save_error');
                $isError        = true;
            } else {
                
                $this->_addRuleCode($check);
                
                $viewParams         = array (
                    'rule' => $check
                );
            }
        } else {
            $errorMessage   = new XenForo_Phrase('esthetic_bannerSystem_db_save_error');
            $isError        = true;
        }
        
        $viewParams['isError']      = $isError;
        $viewParams['errorMessage'] = $errorMessage;
        
        if (!$isError) {
            $viewParams['message'] = new XenForo_Phrase('esthetic_bannerSystem_rule_stored');
        }
        
        return $this->responseView($response_layout, $response_template, $viewParams);
    }

    /**
     * <b> :</b><br />
     *      
     * @param   array   $rule    
     * @return  bool
     */
    private function _addRuleCode (&$rule) {
        if (isset ($rule['title']) && isset ($rule['id'])) {
            $rule['code'] = sprintf (
                '<!--[ebs:%s.%s]-->',
                $rule['title'],
                $rule['id']
            );
            return true;
        }
        return false;
    }

    /**
     * <b>:</b><br />
     *   RuleEdit
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionRuleEdit ( ) {

        $response_layout    = 'Esthetic_BannerSystem_View_Rule_Edit';
        $response_template  = 'esthetic_bannerSystem_rule_edit';
        
        /**
         *   ,   
         */
        $data = $this->_input->filter(array(
            'id' => XenForo_Input::UINT
        ));
        
        $db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction($db);
        $record = $db->fetchRow (sprintf('SELECT t.* FROM `est_banner_rule` t WHERE t.id = %s', $data['id']));
        XenForo_Db::commit($db);
        
        if (false === (isset ($record['id']) && isset ($record['title']))) {
            return $this->actionRules(new XenForo_Phrase('esthetic_bannerSystem_rule_not_found'));
        }
        
        $this->_addRuleCode($record);
        $record['description'] = stripslashes($record['description']);
        
        return $this->responseView(
            $response_layout,
            $response_template,
            array(
                'rule' => $record
            )
        );
    }
    
    /**
     * <b>:</b><br />
     *   Delete
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionDelete ( ) {
        $bannerId = $this->_input->filterSingle('id', XenForo_Input::UINT);
        
		if ($this->isConfirmedPost()) {
            $db = XenForo_Application::get('db');
            XenForo_Db::beginTransaction($db);
            $db->query ('DELETE FROM `est_banner` WHERE `id` = ' . $bannerId);
            XenForo_Db::commit($db);
            
            return $this->responseRedirect(
                XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('banner-system/index')
            );
		}
		else {

            $db = XenForo_Application::get('db');
            XenForo_Db::beginTransaction($db);
            $banner = $db->fetchRow ('SELECT t.* FROM `est_banner` t WHERE t.id = ' . $bannerId);
            XenForo_Db::commit($db);
            
            if (!isset ($banner['id']) || !isset ($banner['title'])) {
                return $this->responseRedirect(
                    XenForo_ControllerResponse_Redirect::SUCCESS,
                    XenForo_Link::buildAdminLink('banner-system/index')
                );
            }
            
			$viewParams = array(
				'banner' => $banner
			);

			return $this->responseView(
                'Esthetic_BannerSystem_View_Banner_Delete', 
                'esthetic_bannerSystem_banner_delete', 
                $viewParams
            );
		}
    }
    
    /**
     * <b>:</b><br />
     *   RuleDelete
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public function actionRuleDelete ( ) {
        $bannerId = $this->_input->filterSingle('id', XenForo_Input::UINT);
        
		if ($this->isConfirmedPost()) {
            $db = XenForo_Application::get('db');
            XenForo_Db::beginTransaction($db);
            $db->query ('DELETE FROM `est_banner_rule` WHERE `id` = ' . $bannerId);
            $db->query ('UPDATE `est_banner` t SET t.rule_id = 0 WHERE t.rule_id = ' . $bannerId);
            XenForo_Db::commit($db);
            
            return $this->responseRedirect(
                XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('banner-system/rules')
            );
		}
		else {

            $db = XenForo_Application::get('db');
            XenForo_Db::beginTransaction($db);
            $rule = $db->fetchRow ('SELECT t.* FROM `est_banner_rule` t WHERE t.id = ' . $bannerId);
            XenForo_Db::commit($db);
            
            if (!isset ($rule['id']) || !isset ($rule['title'])) {
                return $this->responseRedirect(
                    XenForo_ControllerResponse_Redirect::SUCCESS,
                    XenForo_Link::buildAdminLink('banner-system/rules')
                );
            }
            
			$viewParams = array(
				'rule' => $rule
			);

			return $this->responseView(
                'Esthetic_BannerSystem_View_Rule_Delete', 
                'esthetic_bannerSystem_rule_delete', 
                $viewParams
            );
		}
    }
}