<?php
class Esthetic_BannerSystem_Listener {

    protected static $db        = false;

    /**
     * <b>:</b><br />
     *   Edit
     *
     * @return  XenForo_ControllerResponse_Abstract
     */
    public static function listen(XenForo_FrontController $fc, &$output) {
        
        self::$db = XenForo_Application::get('db');
        XenForo_Db::beginTransaction(self::$db);
        
        if (is_array(json_decode ($output, true))) return false;
        
        /**
         *      
         */
        if (!preg_match_all ('/\<\!\-\-\[ebs\:([a-zA-Z0-9\.\-\_]+)\.([0-9]+)\]\-\-\>/', $output, $matches)) return true;

        if (false === ($rules = self::getRules( ))) return false;
        if (false === ($banners = self::getBanners( ))) return false;

        
        foreach ($matches[0] as $key => $val) {
            $code       = (string)$val;
            $rule_title = (string)$matches[1][$key];
            $rule_id    = (int)$matches[2][$key];
            
            if (!isset($banners[$rule_id])) continue;
            if (!count($banners[$rule_id])) continue;
            
            $first_banner = false;
            $match_banner = false;

            foreach ($banners[$rule_id] as $banner) {
                if (false === $first_banner) $first_banner = $banner;
                if ((int)$banner['id'] > (int)$rules[$rule_id]['last_banner_id']) {
                    $match_banner = $banner;
                    break;
                }
            }

            if (false === $match_banner) $match_banner = $first_banner;
            if (!is_array($match_banner)) continue;
            
            $insert = sprintf (
                '<a href="/index.php?banner-system-redirect/%s/link" title="%s" target="_blank"><img id="%s" src="%s" alt="%s"%s%s /></a>%s',
                $match_banner['id'],
                $match_banner['title'],
                rand (100000, 999999),
                $match_banner['image'],
                $match_banner['title'],
                (int)$rules[$rule_id]['width'] > 0 ? sprintf (' width="%spx"', $rules[$rule_id]['width']) : '',
                (int)$rules[$rule_id]['height'] > 0 ? sprintf (' height="%spx"', $rules[$rule_id]['height']) : '',
                $match_banner['code']
            );
            
            $output = preg_replace ('/\<\!\-\-\[ebs\:' . $rule_title . '\.' . $rule_id . '\]\-\-\>/', $insert, $output);
            
            $sql = (string)sprintf(
                'UPDATE `est_banner_rule` SET `last_banner_id` = %s WHERE `id` = %s',
                $match_banner['id'], 
                $rule_id
            );
            self::$db->query ($sql);
            
            $sql = (string)sprintf(
                'UPDATE `est_banner` t SET t.views = t.views + 1 WHERE t.id = %s',
                $match_banner['id']
            );
            self::$db->query ($sql);
            
            unset ($sql);
        }

        XenForo_Db::commit(self::$db);
        return true;
    }
    
    /**
     * <b>:</b><br />
     *   
     *
     * @return  array
     */
    protected static function getRules ( ) {
        try {
            $_rules = self::$db->fetchAll ('SELECT t.* FROM `est_banner_rule` t WHERE t.is_active = 1 ORDER BY t.id ASC');
            if (!is_array ($_rules)) return false;
            
            $rules = array ();
            foreach ($_rules as $rule) {
                $rules[(int)$rule['id']] = $rule;
            }
        } catch (Exception $e) {
            return false;
        }
        return $rules;
    }
    
    /**
     * <b>:</b><br />
     *   
     *
     * @return  array
     */
    protected static function getBanners ( ) {
        try {
            $_banners = self::$db->fetchAll ('SELECT t.* FROM `est_banner` t WHERE t.is_active = 1 ORDER BY t.id ASC');
            if (!is_array ($_banners)) return false;
            
            $banners = array ();
            foreach ($_banners as $banner) {
                $banners[(int)$banner['rule_id']][(int)$banner['id']] = $banner;
            }
        } catch (Exception $e) {
            return false;
        }
        return $banners;
    }
}
?>