<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.3.1
 * Editor Library: Core Class
 * Last Updated: $Date: 2011-05-05 07:03:47 -0400 (Thu, 05 May 2011) $
 * </pre>
 *
 * @author 		$Author: ips_terabyte $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @link		http://www-club.net/
 * @since		9th March 2005 11:03
 * @version		$Revision: 8644 $
 *
 * EXAMPLE USAGE
 * <code>
 * $han_editor           = new han_editor();
 * 
 * $han_editor->init();
 * 
 * # To generate the HTML for the editor:
 * $editor_html = $han_editor->showEditor( $raw_post, 'Post' );
 * 
 * # $raw_post is either raw HTML for the rich text editor or raw BBCode tagged text when
 * #  using the standard editor. (See the document on the BBCode parser for more information)
 * # 'Post' is the name of the form field you wish use. In this case it'll return $_POST['Post'].
 * 
 * #To process the editor's text into tagged BBCode text:
 * $post = $han_editor->processRawPost( 'Post' );
 * 
 * #'Post' is the name of the form field you used when displaying the editor. As in $_POST['Post']
 * 
 * # To use the HTML generated by editor class for displaying the actual editor (in our example; $editor_html)
 * # you'll need to use it like this:
 * 
 * <form id='postingform' onsubmit='return ValidateForm()' action="$url" method="post" name="REPLIER">
 * {$editor_html}
 * <br /><input type="submit" value="Post" /></div>
 * </form>
 * 
 * The form tag MUST have: id='postingform' onsubmit='return ValidateForm()' otherwise the editor will fail.
 * </code>
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class class_editor
{	
	/**
	 * Allow unicode setting
	 *
	 * @access	public
	 * @var		boolean
	 */
	public $allow_unicode;
	
	/**
	 * Get magic quotes
	 *
	 * @access	public
	 * @var		boolean
	 */
	public $get_magic_quotes;
	
	/**
	 * Reverse font sizes
	 *
	 * @access	public
	 * @var		array
	 */
	public $rev_font_sizes = array();
	
	/**
	 * Registry object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $registry;
	
	/**
	 * Database object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $DB;
	
	/**
	 * Settings object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $settings;
	
	/**
	 * Request object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $request;
	
	/**
	 * Language object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $lang;
	
	/**
	 * Member object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $member;
	protected $memberData;
	
	/**
	 * Cache object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $cache;
	protected $caches;
	
	/**
	 * Main font sizes
	 *
	 * @access	protected
	 * @var		array
	 */
	protected $font_sizes     = array( 1 => 8,
										 2 => 10,
										 3 => 12,
										 4 => 14,
										 5 => 18,
										 6 => 24,
										 7 => 36 );
	
	/**
	 * Constructor
	 *
	 * @access	public
	 * @param	object		Registry object
	 * @return	@e void
	 */
	public function __construct( ipsRegistry $registry )
	{
		/* Make object */
		$this->registry = $registry;
		$this->DB	   = $this->registry->DB();
		$this->settings =& $this->registry->fetchSettings();
		$this->request  =& $this->registry->fetchRequest();
		$this->lang	 = $this->registry->getClass('class_localization');
		$this->member   = $this->registry->member();
		$this->memberData =& $this->registry->member()->fetchMemberData();
		$this->cache	= $this->registry->cache();
		$this->caches   =& $this->registry->cache()->fetchCaches();
	}								 

	/**
	 * Main init: Prep font sizes
	 *
	 * @access	public
	 * @return	@e void
	 */
	public function editorInit( )
	{
		foreach( $this->font_sizes as $bbcode => $real )
		{
			$this->rev_font_sizes[ $real ] = $bbcode;
		}
	}

	/**
	 * Get BBCode font size from real PX size
	 *
	 * @access	public
	 * @param	integer		PX Size
	 * @return	integer		BBCode size
	 */
	public function convertRealsizeToBbsize( $real )
	{
		$real = intval( $real );
		
		if ( $this->rev_font_sizes[ $real ] )
		{
			return $this->rev_font_sizes[ $real ];
		}
		else
		{
			return 2;
		}
	}

	/**
	 * Clean up and make the post safe for the DB
	 *
	 * @access	protected
	 * @param	string		Raw text
	 * @return	string		Converted text
	 */
	protected function _cleanPost( $t )
    {
    	if ( $t == "" )
    	{
    		return "";
    	}
    	
    	//-----------------------------------------
    	// Make it safe
    	//-----------------------------------------
    	
    	$t = str_replace( "&"			, "&amp;"         , $t );
    	$t = str_replace( "<!--"		, "&#60;&#33;--"  , $t );
    	$t = str_replace( "-->"			, "--&#62;"       , $t );
    	$t = str_ireplace( "<script"	, "&#60;script"   , $t );
    	$t = str_replace( ">"			, "&gt;"          , $t );
    	$t = str_replace( "<"			, "&lt;"          , $t );
    	$t = str_replace( '"'			, "&quot;"        , $t );
    	$t = str_replace( "\n"			, "<br />"        , $t );
    	$t = str_replace( '$'			, "&#036;"        , $t );
    	$t = str_replace( "\r"			, ""              , $t );
    	$t = str_replace( "!"			, "&#33;"         , $t );
    	$t = str_replace( "'"			, "&#39;"         , $t );
    	
    	//-----------------------------------------
    	// Ensure unicode chars are OK
    	//-----------------------------------------
    	
    	if ( $this->allow_unicode )
		{
			$t = preg_replace("/&amp;#([0-9]+);/s", "&#\\1;", $t );
		}
		
		//-----------------------------------------
		// Strip slashes if not already done so.
		//-----------------------------------------
		
    	/*if ( $this->get_magic_quotes )
    	{
    		$t = stripslashes($t);
    	}*/
    	
    	//-----------------------------------------
    	// Swap user inputted backslashes
    	//-----------------------------------------
    	
    	$t = preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $t ); 
    	
    	return $t;
    }
	
}