<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v3.3.1
 * Installer: License Key
 * Last Updated: $LastChangedDate: 2011-12-30 11:20:59 -0500 (Fri, 30 Dec 2011) $
 * </pre>
 *
 * @author 		$Author: mark $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @link		http://www-club.net/
 * @version		$Rev: 10077 $
 *
 */


class upgrade_license extends ipsCommand
{	
	/**
	 * Execute selected method
	 *
	 * @access	public
	 * @param	object		Registry object
	 * @return	@e void
	 */
	public function doExecute( ipsRegistry $registry ) 
	{
		/* If less than 3, just bounce out as settings tables won't be here, etc */
		if ( IPSSetUp::is300plus() !== TRUE )
		{
			$this->registry->autoLoadNextAction( 'upgrade' );
			return;
		}

		if ( $this->request['do'] == 'check' )
		{
			$lcheck = $this->check();
			if ( $lcheck === TRUE )
			{
				$this->registry->autoLoadNextAction( 'upgrade' );
				return;
			}
		}
		else
		{
			$lcheck = $this->check( TRUE );
			if ( $lcheck === TRUE )
			{
				$this->registry->autoLoadNextAction( 'upgrade' );
				return;
			}
		}
	
		$this->registry->output->setTitle( "Ключ лицензии" );
		$this->registry->output->setNextAction( "license&do=check" );
		$this->registry->output->addContent( $this->registry->output->template()->page_license( $lcheck ) );
		$this->registry->output->sendOutput();
	}
	
	/**
	 * Check License Key
	 *
	 * @access	public
	 * @return	bool
	 */
	private function check( $init=FALSE )
	{
		$this->request['lkey'] = ( $init ) ? ipsRegistry::$settings['ipb_reg_number'] : trim( $this->request['lkey'] );

		if ( !$this->request['lkey'] and !$init )
		{
			return true;
		}
							
		$url = ipsRegistry::$settings['board_url'] ? ipsRegistry::$settings['board_url'] : ipsRegistry::$settings['base_url'];
		
		require_once( IPS_KERNEL_PATH . 'classFileManagement.php' );/*noLibHook*/
		$query = new classFileManagement();
		$query->use_sockets = 1;
		$response = $query->getFileContents( "http://ipbcore.ru/lifo.php?api=activateKey&lk={$this->request['lkey']}&domain=".urlencode($url) );
		$response = json_decode( $response, true );
						
		if( $response['error'] )
		{
			if ( $this->request['ignoreError'] )
			{
				return TRUE;
			}
			else
			{
				return "Проверка ключа не удалась, нажмите Дальше для продолжения установки.";
			}
		}
		else
		{
			IPSLib::updateSettings( array( 'ipb_reg_number' => $this->request['lkey'] ) );
			return TRUE;
		}
						
	}
}