<?php

class Minimalism_OnlineStatus_Plugin
{
	
	    protected static $_session_timeout;
	    protected static $_online_status_template;
	
	    public static function extendModel($class, array &$extend)
	    {
	        if($class == 'XenForo_Model_Post')
	        {
	            $extend[] = 'Minimalism_OnlineStatus_Index';
	        }
	    }
	
	    public static function messageUserInfo_TemplateHook($name, &$contents, $params, XenForo_Template_Abstract $template)
	    {

			$options = XenForo_Application::get('options');
			if ($options->MinimalismUserStatus) 	{ 

		        if(in_array($name, array('message_user_info_avatar')) && isset($params['user']['message']) && !isset($params['user']['conversation_id']))
		        {
		            $visitor = XenForo_Visitor::getInstance();
		            //         -    
		            if(($params['user']['view_date'] > self::_getSessionTimeout()) && $params['user']['visible'])
		            {
		                $userStatus['text'] = new XenForo_Phrase('online');
		                $userStatus['class'] = 'UserOnline';
		            }
					//	      ,            -   " "
		            else if(($params['user']['view_date'] > self::_getSessionTimeout()) && ($params['user']['visible'] == 0) && ($visitor['is_admin'] || $visitor['user_id'] == $params['user']['user_id']))
		            {
		                $userStatus['text'] = new XenForo_Phrase('online_invisible');
		                $userStatus['class'] = 'UserOnlineInvisible';
		            }
		            //	  ,   ,    -    " "
		            else if($params['user']['view_date'] > self::_getSessionTimeout() && $params['user']['visible'] == 0 && $params['user']['is_admin'] && $visitor['is_moderator'])
		            {
		                $userStatus['text'] = new XenForo_Phrase('online_invisible');
		                $userStatus['class'] = 'UserOnlineInvisible';
		            }
		            //      -   ""
		            else
		            {
		               if ($options->MinimalismUserStatusOffline) 	
		               { 
		               		$userStatus['text'] = new XenForo_Phrase('offline');
		                	$userStatus['class'] = 'UserOffline';
 		               }    
		            }
		
		            self::_getOnlineStatusTemplate()->setParam('userStatus', $userStatus);
		
		                if($name == 'message_user_info_avatar')
		                {
 		                        $contents .= self::_getOnlineStatusTemplate();
		                }
		        }
		    }
	    }
	
	    protected static function _getOnlineStatusTemplate()
	    {
	        if(!isset(self::$_online_status_template))
	        {
	            self::$_online_status_template = new XenForo_Template_Public('MinimalismUserStatus');
	        }
	
	        return self::$_online_status_template;
	    }
	
	    protected static function _getSessionTimeout()
	    {
	        if(!isset(self::$_session_timeout))
	        {
	            self::$_session_timeout = XenForo_Model::create('XenForo_Model_Session')->getOnlineStatusTimeout();
	        }
	
	        return self::$_session_timeout;
	    }
}

