<?PHP

class Minimalism_Listener
{
	public static function templateHook( $hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template )
	{
		$options = XenForo_Application::get( 'options' );

		if( $options->MinimalismEnabled )
		{
			if( $options->MinimalismMainContentWide AND $hookName == 'ad_sidebar_bottom' ) $contents = '<div id="sidebar_end"></div>';

			switch( $hookName )
			{
				case 'page_container_js_body':
				{
					if( $options->MinimalismSidebar )
					{
						$contents .= $template->create( 'MinimalismSidebar_js', $template->getParams( ) );
					}

					if( $options->MinimalismNodes )
					{
						$contents .= $template->create( 'MinimalismNodes_js', $template->getParams( ) );
					}

					if( $options->MinimalismPoll )
					{
						$contents .= $template->create( 'MinimalismPoll_js', $template->getParams( ) );
					}

					if( $options->MinimalismAvatar AND $options->MinimalismAvatarHC )
					{
						$contents .= $template->create( 'MinimalismAvatarHover_js', $template->getParams( ) );
					}

					if( $options->MinimalismAvatar AND ! $options->MinimalismAvatarHC )
					{
						$contents .= $template->create( 'MinimalismAvatarClick_js', $template->getParams( ) );
					}

					if( $options->MinimalismMessageMeta )
					{
						$contents .= $template->create( 'MinimalismMessageMeta_js', $template->getParams( ) );
					}

					if( $options->MinimalismToTop )
					{
						$contents .= $template->create( 'MinimalismToTop_js', $template->getParams( ) );
					}

					if( $options->MinimalismMainContentWide AND $GLOBALS['fc']->route( )->getControllerName( ) == 'XenForo_ControllerPublic_Index' )
					{
						$contents .= $template->create( 'MinimalismMainContentWide_js', $template->getParams( ) );
					}

					break;
				}

				case 'page_container_content_top':
				{
					if( $options->MinimalismExtraUserInfo )
					{
						$contents = $template->create( 'MinimalismExtraUserInfo', $template->getParams( ) ) . $contents;
					}

					if( $options->MinimalismSidebar )
					{
						$contents = $template->create( 'MinimalismSidebarArrow', $template->getParams( ) ) . $contents;
					}

					if( $options->MinimalismSidebarToLeft )
					{
						$contents = $template->create( 'MinimalismSidebarToLeft', $template->getParams( ) ) . $contents;
					}

					break;
				}
			}
		}
	}
}