<?php
// Reverted Tables
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->drop_field('dbtech_vbshoutadminperms');
	self::report('Reverted Table', 'administrator');
}

// Clean up
$db->assertQuery('datastore', array(
	vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE, 
	vB_dB_Query::CONDITIONS_KEY => array(
		array(
			'field' => 'title',
			'value' => 'dbtech_vbshout_',
			'operator' => vB_dB_Query::OPERATOR_BEGINS
		)
	)
));
self::report('Reverted Table', 'datastore');

$db->assertQuery('routenew', array(
	vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE, 
	vB_dB_Query::CONDITIONS_KEY => array(
		array(
			'field' => 'guid',
			'value' => 'dbtechvbshout-',
			'operator' => vB_dB_Query::OPERATOR_BEGINS
		)
	)
));
self::report('Reverted Table', 'routenew');

// Drop
if (self::$db_alter->fetch_table_info('forum'))
{
	self::$db_alter->drop_field('dbtech_vbshout_newthread');
	self::$db_alter->drop_field('dbtech_vbshout_newreply');
	self::report('Reverted Table', 'forum');	
}

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->drop_field('dbtech_vbshout_banned');
	self::$db_alter->drop_field('dbtech_vbshout_settings');
	self::$db_alter->drop_field('dbtech_vbshout_shouts');
	self::$db_alter->drop_field('dbtech_vbshout_shouts_lifetime');
	self::$db_alter->drop_field('dbtech_vbshout_shoutstyle');
	self::$db_alter->drop_field('dbtech_vbshout_silenced');
	self::$db_alter->drop_field('dbtech_vbshout_shoutarea');	
	self::$db_alter->drop_field('dbtech_vbshout_pm');
	self::$db_alter->drop_field('dbtech_vbshout_soundsettings');
	self::$db_alter->drop_field('dbtech_vbshout_shoutboxsize');
	self::$db_alter->drop_field('dbtech_vbshout_shoutboxsize_detached');
	self::$db_alter->drop_field('dbtech_vbshout_displayorder');
	self::report('Reverted Table', 'user');	
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->drop_field('dbtech_vbshoutpermissions');
	self::report('Reverted Table', 'usergroup');
}

// Deleted Tables

// Drop
$tables = array(
	'chatroom',
	'chatroommember',
	'deeplog',
	'ignorelist',
	'instance',
	'log',
	'report',
	'shout',
);
foreach ($tables as $table)
{
	self::$db->query_write("DROP TABLE IF EXISTS `" . TABLE_PREFIX . "dbtech_vbshout_{$table}`");
	self::report('Deleted Table', 'dbtech_vbshout_' . $table);
}
?>