<?php if (!defined('VB_ENTRY')) die('Access denied.');

class DBTechvBShout_dB_MYSQL_QueryDefs extends vB_dB_QueryDefs
{
	protected $db_type = 'MYSQL';

	protected static $permission_string = false;

	/**
	 * This is the definition for tables.
	 */
	protected $table_data = array(
		'dbtech_vbshout_chatroom' => array(
			'key' => 'chatroomid',
			'structure' => array(
				'chatroomid', 'title', 'membergroupids', 'instanceid', 'active', 'creator', 'creator'
			),
			'_isCacheable' 	=> true,
			'_tableShort' 	=> 'chatroom',
			'_unserialize' 	=> array(
				'members',
			),
		),
		'dbtech_vbshout_chatroommember' => array(
			'key' => array('userid', 'chatroomid'),
			'structure' => array(
				'userid', 'chatroomid', 'status', 'invitedby'
			),
		),
		'dbtech_vbshout_command' => array(
			'key' => 'commandid',
			'structure' => array(
				'commandid', 'userid', 'command', 'useinput', 'output'
			),
		),
		'dbtech_vbshout_deeplog' => array(
			'key' => 'deeplogid',
			'structure' => array(
				'deeplogid', 'shoutid', 'userid', 'username', 'dateline', 'message', 'type', 'id', 'notification'
			),
		),
		'dbtech_vbshout_ignorelist' => array(
			'key' => array('userid', 'ignoreuserid'),
			'structure' => array(
				'userid', 'ignoreuserid'
			),
		),
		'dbtech_vbshout_instance' => array(
			'key' => 'instanceid',
			'structure' => array(
				'blockid', 'title', 'description', 'active', 'blocktypeid', 'permissions', 'code'
			),
			'_isCacheable' 	=> true,
			'_tableShort' 	=> 'instance',
			'_unserialize' 	=> array(
				'permissions',
				'bbcodepermissions',
				'notices',
				'options',
				'forumids',
			),
		),
		'dbtech_vbshout_log' => array(
			'key' => 'logid',
			'structure' => array(
				'logid', 'userid', 'username', 'dateline', 'ipaddress', 'command', 'comment'
			),
		),
		'dbtech_vbshout_report' => array(
			'key' => 'reportid',
			'structure' => array(
				'reportid', 'userid', 'shoutid', 'shout', 'reportreason', 'instanceid', 'reportuserid', 'handled', 'modnotes'
			),
		),
		'dbtech_vbshout_shout' => array(
			'key' => 'shoutid',
			'structure' => array(
				'shoutid', 'userid', 'dateline', 'message', 'message_raw', 'type', 'id', 'notification', 'forumid', 'instanceid', 'chatroomid'
			),
		),
	);

	/** This is the definition for queries we will process through.  We could also
	 * put them in the database, but this eliminates a query.
	 * * */
	protected $query_data = array(
		'getDataForCache-chatroom' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT *
				FROM {TABLE_PREFIX}dbtech_vbshout_chatroom
			"
		),
		'getDataForCache-instance' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT *
				FROM {TABLE_PREFIX}dbtech_vbshout_instance
			"
		),
		'fetchBannedUsers' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT
					commandlog.comment,
					commandlog.userid AS banneruserid,	
					commandlog.dateline,
					commandlog.username AS cmdusername,
					banneduser.userid,
					banneduser.dbtech_vbshout_shouts AS shouts,
					banneduser.username,
					bannedusergroup.title,		
					banneruser.username AS bannerusername,
					bannerusergroup.title AS bannertitle		
				FROM {TABLE_PREFIX}dbtech_vbshout_log AS commandlog
				LEFT JOIN {TABLE_PREFIX}user AS banneduser ON(banneduser.userid = commandlog.comment)
				LEFT JOIN {TABLE_PREFIX}user AS banneruser ON(banneruser.userid = commandlog.userid)
				LEFT JOIN {TABLE_PREFIX}usergroup AS bannedusergroup ON(bannedusergroup.usergroupid = banneduser.usergroupid)
				LEFT JOIN {TABLE_PREFIX}usergroup AS bannerusergroup ON(bannerusergroup.usergroupid = banneruser.usergroupid)
				WHERE commandlog.command = 'ban'
					AND banneduser.dbtech_vbshout_banned = 1
				ORDER BY banneduser.username ASC
			"
		),
		'fetchCommandLogUsers' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT DISTINCT commandlog.userid, IFNULL(user.username, commandlog.username) AS username
				FROM {TABLE_PREFIX}dbtech_vbshout_log AS commandlog
				LEFT JOIN {TABLE_PREFIX}user AS user ON(user.userid = commandlog.userid)
				ORDER BY username
			"
		),
		'fetchCommandLogUsers2' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT user.userid, user.username
				FROM {TABLE_PREFIX}dbtech_vbshout_log AS commandlog
				LEFT JOIN {TABLE_PREFIX}user AS user ON (user.userid = commandlog.comment)
				WHERE command IN('ban', 'unban', 'pruneuser', 'silence', 'unsilence')
			"
		),
		'getChatRooms' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT chatroomid, IFNULL(user.username, 'N/A') AS username
				FROM {TABLE_PREFIX}dbtech_vbshout_chatroommember AS chatroommember
				LEFT JOIN {TABLE_PREFIX}user AS user ON(user.userid = chatroommember.invitedby)
				WHERE chatroommember.userid = {userid}
					AND chatroommember.status = 0
			"
		),
		'autoDeleteShouts' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_DELETE,
			'query_string' => "
				DELETE FROM {TABLE_PREFIX}dbtech_vbshout_shout
				WHERE `instanceid` IN(0, {instanceid})
					AND dateline <= (UNIX_TIMESTAMP() - {cutoff})		
			"
		),
		'incrementShouts' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_UPDATE,
			'query_string' => "
				UPDATE {TABLE_PREFIX}user
				SET 
					dbtech_vbshout_shouts = dbtech_vbshout_shouts + 1,
					dbtech_vbshout_shouts_lifetime = dbtech_vbshout_shouts_lifetime + 1
				WHERE userid = {userid}
			"
		),
		'decrementShouts' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_UPDATE,
			'query_string' => "
				UPDATE {TABLE_PREFIX}user
				SET dbtech_vbshout_shouts = dbtech_vbshout_shouts - 1
				WHERE userid = {userid}
			"
		),
		'buildShoutsCounter' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_UPDATE,
			'query_string' => "
				UPDATE {TABLE_PREFIX}user AS user
				SET dbtech_vbshout_shouts = (
					SELECT COUNT(*)
					FROM {TABLE_PREFIX}dbtech_vbshout_shout AS shout
					WHERE shout.userid = user.userid
				)
			"
		),
		'fetchIgnoredUsers' => array(
			vB_dB_Query::QUERYTYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'query_string' => "
				SELECT ignorelist.ignoreuserid AS userid, user.username
				FROM {TABLE_PREFIX}dbtech_vbshout_ignorelist AS ignorelist
				LEFT JOIN {TABLE_PREFIX}user AS user ON(user.userid = ignorelist.ignoreuserid)
				WHERE ignorelist.userid = {userid}
				ORDER BY username
			",
		),
	);

	/** Fetch settings by group
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function fetchSettingsByGroup($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		$sql = "SELECT setting.*, settinggroup.grouptitle
			FROM " . TABLE_PREFIX . "settinggroup AS settinggroup
			LEFT JOIN " . TABLE_PREFIX . "setting AS setting USING(grouptitle)
			WHERE 1=1";
		if ($params['product'])
		{
			$sql .= "
			    AND settinggroup.product LIKE '" . $params['product'] . "%'
			";
		}
		if (!$params['debug'])
		{
			$sql .= "
			    AND settinggroup.displayorder <> 0
			";
		}
		$sql .= "ORDER BY settinggroup.displayorder, setting.displayorder";

		return $this->_wrapper($sql, $db, $check_only);
	}

	/** Fetch the downloads rows
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function fetchDownloadEntries($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		if ($params['startdate'])
		{
			$sqlconds[] = "vbshout.dateline >= " . $params['startdate'];
		}
		
		if ($params['enddate'])
		{
			$sqlconds[] = "vbshout.dateline <= " . $params['enddate'];
		}
		
		if ($params['instanceid'])
		{
			$sqlconds[] = "vbshout.instanceid = " . $params['instanceid'];
		}

		$sql = "
			SELECT vbshout.*, user.username
			FROM " . TABLE_PREFIX . "dbtech_vbshout_shout AS vbshout
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = vbshout.userid)
			" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
			ORDER BY instanceid ASC, dateline ASC

		";

		return $this->_wrapper($sql, $db, $check_only);
	}

	/** Count the commandlog rows
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function countCommandLogEntries($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		// Grab our sql conditions
		$sqlconds = $this->_commandLogPrepare($params, $db, $check_only);

		$sql = "
			SELECT COUNT(*) AS total
			FROM " . TABLE_PREFIX . "dbtech_vbshout_log AS commandlog
			" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
		";

		return $this->_wrapper($sql, $db, $check_only);
	}


	 /** Fetch the commandlog rows
	 * 
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function fetchCommandLogEntries($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		switch ($params['orderby'])
		{
			case 'user':
				$params['order'] = 'user.username ASC, dateline DESC';
				break;
			case 'modaction':
				$params['order'] = 'command ASC, dateline DESC';
				break;
			case 'date':
			default:
				$params['order'] = 'dateline DESC';
		}

		// Grab our sql conditions
		$sqlconds = $this->_commandLogPrepare($params, $db, $check_only);

		$sql = "
			SELECT commandlog.*, IFNULL(user.username, commandlog.username) AS username, user.userid
			FROM " . TABLE_PREFIX . "dbtech_vbshout_log AS commandlog
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = commandlog.userid)
			" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
			ORDER BY " . $params['order'] . "
			LIMIT " . $params['startat'] . ", " . $params['perpage'] . "
		";

		return $this->_wrapper($sql, $db, $check_only);
	}

	/** Fetch the shouts
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function fetchShouts($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		// Shorthand
		$userInfo = vB_User::fetchUserinfo();		

		// Various SQL hooks
		$hook_query_select = $hook_query_join = $hook_query_and = '';
		
		if ($params['types'] == -1)
		{
			// Everything
			$hook_query_and .= 'AND (
				vbshout.userid IN(-1, ' . $userInfo['userid'] . ') OR
				vbshout.id IN(0, ' . $userInfo['userid'] . ')
			)';				// That either system or us posted, or was a message to us/anybody
			
			if (array_key_exists('excludetypes', $params))
			{
				// Exclude types
				$hook_query_and .= 'AND vbshout.type NOT IN(' . implode(',', $params['excludetypes']) . ')';
			}
		}
		else
		{
			$types = array();
			foreach (vB_Api::instance('vbshout_shoutbox')->getShoutTypes() as $key => $val)
			{
				// Go through all shout types
				if ($params['types'] & $val)
				{
					switch ($key)
					{
						case 'shout':
							if ($params['onlyuser'])
							{
								// Every PM posted by us to the user
								// or to us
								$hook_query_and .= "AND vbshout.userid = '" . intval($params['onlyuser']) . "'";
							}
							break;
						
						case 'pm':
							if ($params['onlyuser'])
							{
								// Every PM posted by us to the user
								// or to us
								$hook_query_and .= 'AND (
									vbshout.userid = ' . $userInfo['userid'] . ' AND
										vbshout.id = ' . intval($params['onlyuser']) . '
								) OR (
									vbshout.id = ' . $userInfo['userid'] . ' AND
										vbshout.userid = ' . intval($params['onlyuser']) . '
								)';
							}
							break;
					}
					
					// Set the type
					$types[] = $val;
				}
			}
			
			// Include all our types
			$hook_query_and .= 'AND vbshout.type IN(' . implode(',', $types) . ')';
		}
		
		$hook_query_and .= " AND vbshout.chatroomid = " . intval($params['chatroomid']);

		
		

		// Legacy hook 'dbtech_vbshout_fetch_shouts_query' removed

		// Grab some important stuff
		$readChannels = vB::getUserContext()->getReadChannels();

		// Query the shouts
		$sql = "
			SELECT
				user.*,
				user.dbtech_vbshout_settings AS shoutsettings,
				user.dbtech_vbshout_shoutstyle AS shoutstyle,
				vbshout.*,
				pmuser.username AS pmusername
				$hook_query_select
			FROM " . TABLE_PREFIX . "dbtech_vbshout_shout AS vbshout
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = vbshout.userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS pmuser ON(pmuser.userid = vbshout.id)			
			$hook_query_join
			WHERE vbshout.instanceid IN(-1, 0, " . intval($params['instance']['instanceid']) . ")
				AND vbshout.userid NOT IN(
					SELECT ignoreuserid
					FROM " . TABLE_PREFIX . "dbtech_vbshout_ignorelist AS ignorelist
					WHERE userid = " . $userInfo['userid'] . "
				)
				AND vbshout.forumid IN(" . implode(',', array(0) + $readChannels['canRead']) . ")
				AND (
					user.dbtech_vbshout_banned = '0' OR
					vbshout.userid = -1
				)
				$hook_query_and
			ORDER BY shoutid DESC
			LIMIT " . ($params['instance']['options']['maxshouts'] ? $params['instance']['options']['maxshouts'] : 20)
		;

		return $this->_wrapper($sql, $db, $check_only);
	}

	 /** Get the active user rows
	 * 
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	public function getActiveUsers($params, $db, $check_only = false)
	{
		if ($check_only)
		{
			return true;
		}

		$sql = "
			SELECT user.*
			FROM " . TABLE_PREFIX . "dbtech_vbshout_shout AS shout
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = shout.userid)
			WHERE shout.dateline >= " . intval($params['dateline']) . "
				AND shout.userid > 0	
				" . (!$params['chatroomid'] ? "AND shout.instanceid = " . intval($params['instanceid']) : '') . 
				" AND shout.chatroomid = " . intval($params['chatroomid'])
		;

		return $this->_wrapper($sql, $db, $check_only);
	}



	/** Returns sql conds for the command log
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	protected function _commandLogPrepare($params, vB_Database $db, $check_only = false)
	{
		$sqlconds = array();

		if (array_key_exists('userid', $params) AND $params['userid'])
		{
			$sqlconds[] = "commandlog.userid = " . $params['userid'];
		}

		if (array_key_exists('modaction', $params) AND $params['modaction'])
		{
			$sqlconds[] = "commandlog.command LIKE '%" . $db->escape_string_like($params['modaction']) . "%'";
		}
		
		if (array_key_exists('startdate', $params) AND $params['startdate'])
		{
			$sqlconds[] = "commandlog.dateline >= " . $params['startdate'];
		}
		
		if (array_key_exists('enddate', $params) AND $params['enddate'])
		{
			$sqlconds[] = "commandlog.dateline <= " . $params['enddate'];
		}

		return $sqlconds;
	}

	/** Construct query list
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *
	 *	@result	mixed
	 */
	protected function _queryList($arr, vB_Database $db)
	{
		$values = array();
		foreach ($arr as $val)
		{
			// Ensure the value is escaped properly
			$values[] = (is_numeric($val) ? $val : "'" . $db->escape_string($val) . "'");
		}
		
		if (!count($values))
		{
			// Ensure there's no SQL errors
			$values[] = 0;
		}

		return 'IN(' . implode(', ', $values) . ')';
	}

	/** Wrapper function for query results
	 *
	 *	@param	mixed
	 *	@param	mixed 	a db pointer
	 *	@param	bool
	 *
	 *	@result	mixed
	 */
	protected function _wrapper($sql, vB_Database $db, $check_only = false)
	{
		$resultclass = 'vB_dB_' . $this->db_type . '_result';
		$config = vB::get_config();

		if (isset($config['Misc']['debug_sql']) AND $config['Misc']['debug_sql'])
		{
			echo "sql: $sql<br />\n";
		}

		$result = new $resultclass($db, $sql);
		return $result;
	}
}