<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTechvBShout_DataManager_Shout extends vB_DataManager
{
	/**
	* Array of recognised and required fields for chatrooms, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'shoutid' 		=> array(vB_Cleaner::TYPE_UINT,       vB_DataManager_Constants::REQ_INCR,	vB_DataManager_Constants::VF_METHOD, 'verify_nonzero'),
		'userid' 		=> array(vB_Cleaner::TYPE_INT,        vB_DataManager_Constants::REQ_AUTO),
		'dateline' 		=> array(vB_Cleaner::TYPE_UNIXTIME,   vB_DataManager_Constants::REQ_AUTO),
		'message' 		=> array(vB_Cleaner::TYPE_STR,        vB_DataManager_Constants::REQ_YES,	vB_DataManager_Constants::VF_METHOD),
		'message_raw'	=> array(vB_Cleaner::TYPE_STR,        vB_DataManager_Constants::REQ_YES),
		'type' 			=> array(vB_Cleaner::TYPE_UINT,       vB_DataManager_Constants::REQ_AUTO),
		'id' 			=> array(vB_Cleaner::TYPE_INT,        vB_DataManager_Constants::REQ_NO),
		'notification' 	=> array(vB_Cleaner::TYPE_STR,        vB_DataManager_Constants::REQ_NO,		'if (!in_array($data, array(\'\', \'thread\', \'reply\'))) { return false; } return true;'),
		'forumid' 		=> array(vB_Cleaner::TYPE_INT,        vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD),
		'instanceid' 	=> array(vB_Cleaner::TYPE_INT,        vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD),
		'chatroomid' 	=> array(vB_Cleaner::TYPE_INT,        vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD),
		'allowsmilie'   => array(vB_Cleaner::TYPE_UINT,       vB_DataManager_Constants::REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'DBTechvBShout:dbtech_vbshout_shout';

	//Primary Key
	protected $keyField = 'shoutid';

	/**
	* Verifies that a message is valid
	*
	* @param	integer	The message
	*
	* @return	boolean
	*/
	function verify_message(&$message)
	{
		$message = vB_String::unHtmlSpecialChars(str_replace(array("\n"), '', trim($message)));
		if (empty($message))
		{
			$this->error('dbtech_vbshout_invalid_message_specified');			
			return false;
		}
		
		// Strip out some characters we can't deal with
		$message = preg_replace('/[\x00-\x1F]/', '', $message);
		
		return true;
	}

	/**
	* Verifies that a forum exists
	*
	* @param	integer	The forum id
	*
	* @return	boolean
	*/
	function verify_forumid(&$forumid)
	{
		if ($forumid === 0)
		{
			// Forumid 0 is valid
			return true;
		}
		
		$channels = vB_Api::instance('search')->getChannels(true);
		if (!array_key_exists($forumid, $channels))
		{
			$this->error('invalid_forum_specified');
			return false;
		}
		return true;
	}

	/**
	* Verifies that the instanceid is valid
	*
	* @param	integer	instanceid of the chatroom
	*
	* @return	boolean
	*/
	function verify_instanceid(&$instanceid)
	{
		if ($instanceid === 0)
		{
			// 0 is a valid instance
			return true;
		}

		if (!is_array(vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid)))
		{
			$this->error('dbtech_vbshout_invalid_instanceid_specified');
			return false;
		}
		return true;
	}

	/**
	* Verifies that an image filename prefix is valid
	*
	* @param	string	The image prefix filename
	*
	* @return	boolean
	*/
	function verify_chatroomid(&$chatroomid)
	{
		if ($chatroomid === 0)
		{
			// 0 is a valid chat room
			return true;
		}
		
		if (!is_array(vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid)))
		{
			$this->error('dbtech_vbshout_invalid_chatroomid_specified');
			return false;
		}
		return true;
	}

	/**
	* Verifies the number of images in the post text. Call it from pre_save() after pagetext/allowsmilie has been set
	*
	* @return	bool	Whether the post passes the image count check
	*/
	function verify_image_count($pagetext = 'pagetext', $allowsmilie = 'allowsmilie', $parsetype = 'nonforum', $table = null)
	{
		$_allowsmilie =& $this->fetch_field($allowsmilie, $table);
		$_pagetext =& $this->fetch_field($pagetext, $table);

		if ($_allowsmilie !== null AND $_pagetext !== null)
		{
			// check max images
			$bbcode_parser = new vB5_Template_BbCode_Imgcheck();
			$bbcode_parser->setParseUserinfo($this->fetch_field('userid'));

			if (vB::getDatastore()->getOption('maximages') AND !$this->info['is_automated'])
			{
				$imagecount = substr_count(strtolower($bbcode_parser->parse($_pagetext, $parsetype, $_allowsmilie, true)), '<img');
				if ($imagecount > vB::getDatastore()->getOption('maximages'))
				{
					$this->error('toomanyimages', $imagecount, vB::getDatastore()->getOption('maximages'));
					return false;
				}
			}
		}

		return true;
	}

	/**
	* Checks for various chat commands that may interrupt saving
	*
	* @return	boolean
	*/
	function parseActionCodes()
	{
		if ($this->fetch_field('type') != vB_Api::instance('vbshout_shoutbox')->getShoutType('shout'))
		{
			// We're not doing anything with a non-shout type
			// Notifications / PMs are already parsed and ready
			return true;
		}
		
		$instanceid = $this->fetch_field('instanceid');
		if ($instanceid)
		{
			$this->info['instance'] = !array_key_exists('instance', $this->info) ? vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid) : $this->info['instance'];
		}

		// Grab the userinfo for current user
		$userInfo = vB_User::fetchUserinfo();

		// Shorthand
		$assertor = vB::getDbAssertor();

		// The PM command is special and can't be prettified.
		// It's also the only 3-stage command we have, so it doesn't matter
		if (preg_match("#^(\/pm)\s+?(.+?);\s+?(.+?)$#i", $this->fetch_field('message'), $matches))
		{
			if (!$this->info['instance']['permissions_parsed']['canpm'])
			{
				// We has an error
				$this->error('dbtech_vbshout_pming_disabled_usergroup');
				return false;
			}
			
			if ($matches[2] == $userInfo['username'])
			{
				// We has an error
				$this->error('dbtech_vbshout_cannot_pm_self');
				return false;
			}
			
			if (!$exists = $assertor->getRow('user', array( 
				'username' => $assertor->escape_string(vB_String::htmlSpecialCharsUni($matches[2]))
			)))
			{
				// We has an error
				$this->error('dbtech_vbshout_invalid_user');
				return false;
			}
			
			$return_value = true;
			
			
			// Legacy hook 'dbtech_vbshout_parsecommand_pm' removed
	
			if (!$return_value)
			{
				// We're ending it early
				return $return_value;
			}
			
			// Override some values
			$this->set('id', 			$exists['userid']);
			$this->set('type', 			vB_Api::instance('vbshout_shoutbox')->getShoutType('pm'));
			$this->set('message', 		$matches[3]);
			$this->set('chatroomid', 	0);
		}
		else if (preg_match("#^(\/[a-z0-9]*?)$#i", $this->fetch_field('message'), $matches))
		{
			// 1-stage command
			switch ($matches[1])
			{
				case '/prune':
					
					if (!$this->fetch_field('chatroomid'))
					{
						if (!$this->info['instance']['permissions_parsed']['canprune'])
						{
							// We has an error
							$this->error('dbtech_vbshout_cannot_prune');
							return false;
						}
					}
					else
					{
						$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $this->fetch_field('chatroomid'));
						if ($chatroom['creator'] != $userInfo['userid'] AND !$this->info['instance']['permissions_parsed']['canprune'])
						{
							// Only chat room creators can prune
							$this->error('dbtech_vbshout_cannot_prune');
							return false;
						}
					}
					
					// Now get rid of the shouts
					$assertor->delete('DBTechvBShout:dbtech_vbshout_shout', array(
						'instanceid' => intval($this->fetch_field('instanceid')),
						'chatroomid' => intval($this->fetch_field('chatroomid'))
					));
					
					// Rebuild shout counts
					vB::getDbAssertor()->assertQuery('DBTechvBShout:buildShoutsCounter', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED));
					
					// Log the prune command
					vB_Api::instance('vbshout_shoutbox')->logCommand('prune');
					
					// Blank out the message and change type
					$this->set('type', 		vB_Api::instance('vbshout_shoutbox')->getShoutType('system'));
					$this->set('message', 	(string) new vB_Phrase('hooks', 'dbtech_vbshout_shoutbox_pruned'));
					if (!$this->info['instance']['permissions_parsed']['showaction'])
					{
						// We're not showing action
						$this->set('userid', 	-1);
					}
					break;
				
				case '/editsticky':
					if (!$this->info['instance']['permissions_parsed']['cansticky'])
					{
						$this->error('dbtech_vbshout_cannot_sticky');
						return false;
					}

					// What we need to put in the editor
					vB_Api::instance('vbshout_shoutbox')->setFetchedValue('chatroom', '/editor ' . $this->info['instance']['sticky_raw']);					
					
					// We're not continuing
					return false;
					break;
					
				case '/createchat':
					$this->error('dbtech_vbshout_invalid_chatroom_name');
					return false;
					break;
					
				case '/removenotice':
				case '/removesticky':
				case '/sticky':
					if (!$this->info['instance']['permissions_parsed']['cansticky'])
					{
						$this->error('dbtech_vbshout_cannot_sticky');
						return false;
					}
					
					// Remove the sticky note
					vB_Api::instance('vbshout_shoutbox')->setSticky('');
					
					// Log the removesticky command
					vB_Api::instance('vbshout_shoutbox')->logCommand('removesticky');						
						
						// Blank out the message
					$this->set('type', 		vB_Api::instance('vbshout_shoutbox')->getShoutType('system'));
					$this->set('message', 	(string) new vB_Phrase('hooks', 'dbtech_vbshout_sticky_note_removed'));
					if (!$this->info['instance']['permissions_parsed']['showaction'])
					{
						// We're not showing action
						$this->set('userid', 	-1);
					}
					break;
					
				case '/banlist':
					if (!$this->info['instance']['permissions_parsed']['canban'])
					{
						$this->error('dbtech_vbshout_cannot_ban');
						return false;
					}
					
					$users = $assertor->getRows('user', array( 
						'dbtech_vbshout_banned' => '1'
					));

										
					
					$message = array();
					foreach ($users as $user)
					{
						// Grab the markup username for this user
						$user['musername'] = vB_Api::instance('user')->fetchMusername($user);
						
						

						// Store silenced user
						$message[] = $user['musername'];			
					}
					
					// Blank out the message and change type
					$this->set('userid', 	$userInfo['userid']);
					$this->set('id', 		$userInfo['userid']);
					$this->set('type', 		vB_Api::instance('vbshout_shoutbox')->getShoutType('pm'));
					$this->set('message', 	(count($message) ? implode(', ', $message) : (string) new vB_Phrase('hooks', 'dbtech_vbshout_no_banned_users')));					
					break;
				
				default:
					$return_value = true;
					$handled = false;

					
					
					// Legacy hook 'dbtech_vbshout_command_1' removed
					
					if (!$handled)
					{
						// We didn't have any errors, we just returned false
						//$this->error('dbtech_vbshout_invalid_command');
						//return false;
					}
					return $return_value;
					break;
			}
		}
		else if (preg_match("#^(\/[a-z0-9]*?)\s(.+?)$#i", $this->fetch_field('message'), $matches))
		{
			// 2-stage command
			switch ($matches[1])
			{
				case '/me':
					// ZE ME COMMAND, IT DOEZ NOZING
					break;
					
				case '/invite':
				case '/chatinvite':
					// Invite an user to chat
					$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $this->fetch_field('chatroomid'));

					if (!$chatroom['title'] OR $chatroom['membergroupids'])
					{
						$this->error('dbtech_vbshout_invalid_chat_room');
						return false;
					}

					if (!$exists = $assertor->getRow('user', array( 
						'username' => vB::getDbAssertor()->escape_string(vB_String::htmlSpecialCharsUni($matches[2]))
					)))
					{
						$this->error('dbtech_vbshout_invalid_user');
						return false;
					}

					// Invite to join the chat room
					$assertor->assertQuery('DBTechvBShout:dbtech_vbshout_chatroommember', array( 
						vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERTIGNORE, 
						'chatroomid' 	=> intval($chatroom['chatroomid']),
						'userid' 		=> intval($exists['userid']),
						'status' 		=> 0,
						'invitedby' 	=> $userInfo['userid'],
					));
					if ($assertor->affected_rows())
					{
						// init data manager
						$dm = new DBTechvBShout_DataManager_Chatroom(vB_DataManager_Constants::ERRTYPE_SILENT);
							$dm->set_existing($chatroom);
							
						// We're now fully joined
						$chatroom['members'][$exists['userid']] = '0';
							
							$dm->set('members', 	$chatroom['members']);
						$dm->save();
					}

					//$this->fetched['success'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_chat_invited_successfully');
					
					return false;
					break;
					
				case '/ignore':
				case '/unignore':
					// Ignore an user
					if (!$exists = $assertor->getRow('user', array( 
						'username' => vB::getDbAssertor()->escape_string(vB_String::htmlSpecialCharsUni($matches[2]))
					)))
					{
						// We has an error
						$this->error('dbtech_vbshout_invalid_user');
						return false;
					}
					
					if ($exists['userid'] == $userInfo['userid'])
					{
						// Ourselves, duh
						$this->error('dbtech_vbshout_cannot_ignore_self');
						return false;
					}
					
					if (vB_Api::instance('vbshout_shoutbox')->isProtected($exists, true))
					{
						// We had an error
						$this->error('dbtech_vbshout_protected_usergroup');
						return false;
					}
					
					if ($matches[1] == '/ignore')
					{
						// Ignore the user
						$assertor->assertQuery('DBTechvBShout:dbtech_vbshout_ignorelist', array( 
							vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERTIGNORE,
							'userid' => intval($userInfo['userid']),
							'ignoreuserid' => intval($exists['userid']),
						));
					}
					else
					{
						// Now get rid of the shouts
						$assertor->delete('DBTechvBShout:dbtech_vbshout_ignorelist', array(
							'userid' => intval($userInfo['userid']),
							'ignoreuserid' => intval($exists['userid'])
						));
					}
					// Print success message
					//$this->fetched['success'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_ignored_successfully', $matches[2]);
					//$this->fetched['success'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_ignored_successfully', $matches[2]);
					//$message = false;
					return false;
					break;
					
				case '/notice':
				case '/setnotice':
				case '/sticky':
				case '/setsticky':
					if (!$this->info['instance']['permissions_parsed']['cansticky'])
					{
						$this->error('dbtech_vbshout_cannot_sticky');
						return false;
					}

					// Set the sticky note
					vB_Api::instance('vbshout_shoutbox')->setSticky($matches[2]);
					
					// Log the setsticky command
					vB_Api::instance('vbshout_shoutbox')->logCommand('setsticky', $matches[2]);						
					
					// Blank out the message
					$this->set('type', 		vB_Api::instance('vbshout_shoutbox')->getShoutType('system'));
					$this->set('message', 	(string) new vB_Phrase('hooks', 'dbtech_vbshout_sticky_note_set'));
					if (!$this->info['instance']['permissions_parsed']['showaction'])
					{
						// We're not showing action
						$this->set('userid', 	-1);
					}
					break;
					
				case '/ban':
				case '/unban':				
					if (!$this->info['instance']['permissions_parsed']['canban'])
					{
						$this->error('dbtech_vbshout_cannot_ban');
						return false;
					}
					
					// Banning an user
					if (!$exists = $assertor->getRow('user', array( 
						'username' => vB::getDbAssertor()->escape_string(vB_String::htmlSpecialCharsUni($matches[2]))
					)))
					{
						// We has an error
						$this->error('dbtech_vbshout_invalid_user');
						return false;
					}
					
					if ($exists['userid'] == $userInfo['userid'])
					{
						// Ourselves, duh
						$this->error('dbtech_vbshout_cannot_ban_self');
						return false;
					}
					
					if (vB_Api::instance('vbshout_shoutbox')->isProtected($exists, true))
					{
						// We had an error
						$this->error('dbtech_vbshout_protected_usergroup');
						return false;
					}
					
					// Log the ban command
					vB_Api::instance('vbshout_shoutbox')->logCommand(($matches[1] == '/ban' ? 'ban' : 'unban'), $exists['userid']);		
					
					// Ban the user
					$assertor->update('user', array(
						'dbtech_vbshout_banned' => ($matches[1] == '/ban' ? '1' : '0'),
					), array('userid' => intval($exists['userid'])));

					
					if ($this->info['instance']['permissions_parsed']['showaction'])
					{					
						// Print success message
						$this->set('type', 		vB_Api::instance('vbshout_shoutbox')->getShoutType('system'));
						$this->set('message', 	(string) ($matches[1] == '/ban' ? new vB_Phrase('hooks', 'dbtech_vbshout_banned_successfully', $matches[2]) : new vB_Phrase('hooks', 'dbtech_vbshout_unbanned_successfully', $matches[2])));
					}
					else
					{
						//$this->fetched['success'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_banned_successfully', $matches[2]);
						//$this->fetched['success'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_unbanned_successfully', $matches[2]);
						//$message = false;
						return false;
					}
					break;
					
				case '/createchat':
					if (!$this->info['instance']['permissions_parsed']['cancreatechat'])
					{
						$this->error('dbtech_vbshout_cant_create_chat');
						return false;
					}
					
					if ($this->info['instance']['options']['maxchats'])
					{
						$i = 0;
						foreach (vB_Api::instance('vbshout_core')->getCache('chatroom') as $chatroomid => $chatroom)
						{
							if (!$chatroom['active'])
							{
								// Don't count closed rooms
								continue;
							}
							
							if ($chatroom['creator'] == $userInfo['userid'])
							{
								// We're the creator
								$i++;
							}
						}
						
						if ($i >= $this->info['instance']['options']['maxchats'])
						{
							// Waaaay too many chats, slow down tiger!
							$this->error('dbtech_vbshout_too_many_chats');							
							return false;
						}
					}

					// Grab the title
					$title = $matches[2];
					
					// init data manager
					$dm = new DBTechvBShout_DataManager_Chatroom(vB_DataManager_Constants::ERRTYPE_SILENT);
						$dm->set('title', 		$title);
						$dm->set('instanceid', 	$this->info['instance']['instanceid']);
						$dm->set('creator', 	$userInfo['userid']);
						$dm->set('members', 	array($userInfo['userid'] => '1'));
					$chatroomid = $dm->save();
					unset($dm);					
					
					$assertor->assertQuery('DBTechvBShout:dbtech_vbshout_chatroommember', array( 
						vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERTIGNORE,
						'chatroomid' 	=> intval($chatroomid),
						'userid' 		=> intval($userInfo['userid']),
						'status' 		=> 1,
					));

					// Set chat room info
					vB_Api::instance('vbshout_shoutbox')->setFetchedValue('chatroom', array(
						'chatroomid' 	=> $chatroomid,
						'title' 		=> $title
					));

					return false;
					break;

				default:
					$return_value = true;
					$handled = false;
					
					

					// Legacy hook 'dbtech_vbshout_command_2' removed
					
					if (!$handled)
					{
						//$this->error('dbtech_vbshout_invalid_command');
						//return false;
					}
					return $return_value;
					break;
			}
		}
		
		return true;
	}

	/**
	* Determines the replacement for the BBCode SIZE limiter.
	*
	* @param	integer	The attempted SIZE value.
	*
	* @return	string	The new SIZE BBCode.
	*/
	function process_bbcode_size($size)
	{
		// Returns the prepared string
		return '[size=' . (intval($size) > $this->info['instance']['options']['maxsize'] ? $this->info['instance']['options']['maxsize'] : $size) . ']';
	}	

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$instanceid = $this->fetch_field('instanceid');
		if ($instanceid)
		{
			$this->info['instance'] = !array_key_exists('instance', $this->info) ? vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid) : $this->info['instance'];
		}

		// Grab userinfo
		$userInfo = vB_User::fetchUserinfo();

		if (!$this->condition)
		{
			if ($this->fetch_field('dateline') === null)
			{
				$time = vB::getRequest()->getTimeNow();
				$this->set('dateline', $time);
			}
			
			if ($this->fetch_field('type') === null)
			{
				$shouttype = vB_Api::instance('vbshout_shoutbox')->getShoutType('shout');
				$this->set('type', $shouttype);
			}
			
			if ($this->fetch_field('userid') === null)
			{
				$this->set('userid', $userInfo['userid']);
			}
		}

		// Shorthand
		$message = $this->fetch_field('message');

		if (count($this->info['instance']) AND $this->fetch_field('userid') > 0)
		{
			// Grab userinfo
			$userinfo = vB_Api::instance('user')->fetchUserinfo($this->fetch_field('userid'));
			
			// Initialise BBCode Permissions
			$permarray = array(
				'permissions_parsed' 		=> vB_Api::instance('vbshout_shoutbox')->buildPermissionsArray($this->info['instance'], $userinfo),
				'bbcodepermissions_parsed' 	=> vB_Api::instance('vbshout_shoutbox')->buildBbcodePermissionsArray($this->info['instance'], $userinfo)
			);
			
			if (!$this->info['is_automated'])
			{
				// Do character count checking
				if ($this->info['instance']['options']['maxchars'] != 0 AND ($postlength = vB_String::vbStrlen($message)) > $this->info['instance']['options']['maxchars'] AND !$this->info['instance']['permissions_parsed']['ismanager'])
				{
					$this->error('dbtech_vbshout_charlimit', $postlength, $this->info['instance']['options']['maxchars']);
					return false;
				}
		
				if ($this->info['instance']['options']['maximages'])
				{
					// Set whether we're allowed to use smilies
					$this->set('allowsmilie', $this->info['instance']['options']['allowsmilies']);
					
					// Hack this
					$maximages = $this->registry->options['maximages'];
					$this->registry->options['maximages'] = $this->info['instance']['options']['maximages'];
					
					if (!$this->verify_image_count('message', 'allowsmilie', 'nonforum'))
					{
						return false;
					}
					
					// Restore hack
					$this->registry->options['maximages'] = $maximages;
				}
				
				if ($this->info['instance']['options']['maxsize'])
				{
					// Replace the SIZE BBCode if needed
					$message = preg_replace("#\[size=(\d+)\]#ie", "\$this->process_bbcode_size('\\1')", $message);
					$message = preg_replace("#\[size=\"(\d+)\"\]#ie", "\$this->process_bbcode_size('\\1')", $message);
					$message = preg_replace("#\[size=\'(\d+)\'\]#ie", "\$this->process_bbcode_size('\\1')", $message);
					
					// Set raw message
					$this->set('message', $message);
				}
			}
			
			if ($this->condition)
			{
				// Update
				if ($this->existing['userid'] == $userInfo['userid'] AND (!$this->info['instance']['permissions_parsed']['caneditown'] AND $this->fetch_field('instanceid') > 0))
				{
					// We can't edit our own shouts
					$this->error('dbtech_vbshout_may_not_edit_own');
					return false;
				}
				
				if ($this->existing['userid'] != $userInfo['userid'] AND (!$this->info['instance']['permissions_parsed']['caneditothers'] AND $this->fetch_field('instanceid') > 0))
				{
					// We can't edit our own shouts
					$this->error('dbtech_vbshout_may_not_edit_others');
					return false;
				}
			}
			else
			{
				if (!$this->info['instance']['permissions_parsed']['canshout'] AND $this->fetch_field('instanceid') != 0 AND !$this->info['is_automated'])
				{
					// We aren't allowed to post shouts
					$this->error('dbtech_vbshout_may_not_shout');
					return false;
				}
			}			
		}
		
		// Set raw message
		$this->set('message_raw', $message);
				
		// Parse message for /pm command and other on-the-fly messages that's not supposed to return true
		if (!$this->parseActionCodes())
		{
			// We had sum error
			return false;
		}
		
		// Re-grab this (custom command support pretty much)
		$message = $this->fetch_field('message');
		
		// This is no longer needed
		$this->do_unset('allowsmilie');
		
		if (count($this->info['instance']) AND !$this->info['is_automated'] AND $this->fetch_field('userid') > 0)
		{
			// Shorthand
			$instance = $this->info['instance'];
			
			if ($permarray['bbcodepermissions_parsed']['bit'] & 64)
			{
				// We can use the URL BBCode, so convert links
				$message = vB_Api::instance('bbcode')->convertUrlToBbcode($message);	
			}

			// Write this to the cache
			vB_Cache::instance(vB_Cache::CACHE_FAST)->write('DBTvBShout.tagList', vB_Api::instance('vbshout_shoutbox')->getTagList(vB_Api::instance('vbshout_shoutbox')->fetchTagList(), $permarray), 5, 'DBTvBShout_readTagList');

			// Init the parser
			$parser = new vB5_Template_BbCode();

			$message = $parser->doParse(
				$message,
				false, 													// allowhtml
				 $instance['options']['allowsmilies'], 					// allowsmilies
				true, 													// allowbbcode
				($permarray['bbcodepermissions_parsed']['bit'] & 1024),	// allowbbimagecode
				false 													// nl2br
			);
		}
		else
		{
			// Init the parser
			$parser = new vB5_Template_BbCode();
			
			if (vB::getDatastore()->getOption('allowedbbcodes') & 64)
			{
				// We can use the URL BBCode, so convert links
				$message = vB_Api::instance('bbcode')->convertUrlToBbcode($message);	
			}
			
			// BBCode parsing
			$message = $parser->doParse(
				$message,
				false, 												// allowhtml
				$this->info['instance']['options']['allowsmilies'], // allowsmilies
				true, 												// allowbbcode
				true,												// allowbbimagecode
				false 												// nl2br
			);
		}
		
		// Set raw message
		$this->set('message', vB_String::htmlSpecialCharsUni($message));		

		$return_value = true;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Saves the data from the object into the specified database tables
	*
	* @param	boolean	Do the query?
	* @param	mixed	Whether to run the query now; see db_update() for more info
	* @param bool 	Whether to return the number of affected rows.
	* @param bool		Perform REPLACE INTO instead of INSERT
	* @param bool		Perfrom INSERT IGNORE instead of INSERT
	*
	* @return	mixed	If this was an INSERT query, the INSERT ID is returned
	*/
	function save($doquery = true, $delayed = false, $affected_rows = false, $replace = false, $ignore = false)
	{
		if (!$this->pre_save($doquery))
		{
			// Pre-save failed
			if (!empty($this->errors))
			{
				// Set the errors
				vB_Api::instance('vbshout_shoutbox')->setFetchedValue('errors', $this->errors);
				
				return false;
			}
			
			return false;
		}
		
		// Call and get the new id
		$result = parent::save($doquery, $delayed, $affected_rows, $replace, $ignore);
		
		// Legacy hook 'dbtech_vbshout_shout_insert' removed				

		return $result;		
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed once after all records are updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_once($doquery = true)
	{
		$instanceid = $this->fetch_field('instanceid');
		if ($instanceid)
		{
			$this->info['instance'] = !array_key_exists('instance', $this->info) ? vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid) : $this->info['instance'];
		}

		
		
		$return_value = true;
		// Legacy hook 'dbtech_vbshout_shout_post_save_once' removed

		return $return_value;		
	}	

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		$instanceid = $this->fetch_field('instanceid');
		if ($instanceid)
		{
			$this->info['instance'] = !array_key_exists('instance', $this->info) ? vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid) : $this->info['instance'];
		}

		

		// Legacy hook 'dbtech_vbshout_shout_post_save_each' removed				
		
		if ($this->condition)
		{
			// Log this command
			vB_Api::instance('vbshout_shoutbox')->logCommand('shoutedit', serialize(array('old' => $this->existing['message'], 'new' => $this->fetch_field('message'))));
			
			// And a winrar is us
			//$this->fetched['success'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_edited_shout_successfully');
		}
		else
		{
			if ($this->fetch_field('id') > 0)
			{
				// We sent this to someone
				vB::getDbAssertor()->update('user', array(
					'dbtech_vbshout_pm' => $this->fetch_field('dateline'),
				), array('userid' => intval($this->fetch_field('id'))));
			}
			
			if ($this->fetch_field('userid') > 0)
			{
				// increment shouts count
				vB::getDbAssertor()->assertQuery('DBTechvBShout:incrementShouts', array(
					vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED,
					'userid' 		=> intval($this->fetch_field('userid'))
				));
				
				
			}
		}
		
		if ($this->fetch_field('chatroomid'))
		{
			// Update the AOP
			$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $this->fetch_field('chatroomid'), true, true);
			vB_Api::instance('vbshout_shoutbox')->setAop('chatroom_' . $this->fetch_field('chatroomid') . '_', $chatroom['instanceid'], true, true);
		}
		else if ($this->fetch_field('id'))
		{
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('pm_' . $this->fetch_field('id') . '_' . $this->fetch_field('instanceid'), $this->fetch_field('instanceid'), true, true);
			vB_Api::instance('vbshout_shoutbox')->setAop('shouts', $this->fetch_field('instanceid'), true, true);
		}
		else
		{
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('shouts', $this->fetch_field('instanceid'), true, true);
		}
		
		if ($this->fetch_field('type') == vB_Api::instance('vbshout_shoutbox')->getShoutType('notif'))
		{
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('shoutnotifs', $this->fetch_field('instanceid'), false, true);
		}
		else if ($this->fetch_field('type') == vB_Api::instance('vbshout_shoutbox')->getShoutType('system'))
		{
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('systemmsgs', $this->fetch_field('instanceid'), false, true);
		}

		return true;
	}

	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;

		$instanceid = $this->fetch_field('instanceid');
		if ($instanceid)
		{
			$this->info['instance'] = !array_key_exists('instance', $this->info) ? vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid) : $this->info['instance'];
		}
		
		if ($this->existing['userid'] == vB::getUserContext()->fetchUserId() AND (!$this->info['instance']['permissions_parsed']['caneditown'] AND $this->fetch_field('instanceid') > 0))
		{
			// We can't edit our own shouts
			$this->error('dbtech_vbshout_may_not_edit_own');
			return false;
		}
		
		if ($this->existing['userid'] != vB::getUserContext()->fetchUserId() AND (!$this->info['instance']['permissions_parsed']['caneditothers'] AND $this->fetch_field('instanceid') > 0))
		{
			// We don't have permission to edit others' shouts
			$this->error('dbtech_vbshout_may_not_edit_others');
			return false;
		}

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Deletes the specified data item from the database
	*
	* @return	integer	The number of rows deleted
	*/
	function delete($doquery = true)
	{
		if (!$this->pre_delete($doquery))
		{
			// Pre-save failed
			if (!empty($this->errors))
			{
				// Set the errors
				vB_Api::instance('vbshout_shoutbox')->setFetchedValue('errors', $this->errors);
				
				return false;
			}
			
			return false;
		}
		
		$result = parent::delete($doquery);
		
		return $result;
	}	

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		// Decrement shout counters
		vB::getDbAssertor()->assertQuery('DBTechvBShout:decrementShouts', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED,
			'userid' 		=> intval($this->existing['userid'])
		));
		
		// Log this command
		vB_Api::instance('vbshout_shoutbox')->logCommand('shoutdelete', $this->existing['message']);
		
		// Update the AOP
		vB_Api::instance('vbshout_shoutbox')->setAop('shouts', $this->existing['instanceid'], false, true);
		
		if ($this->existing['type'] == vB_Api::instance('vbshout_shoutbox')->getShoutType('notif'))
		{
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('shoutnotifs', $this->existing['instanceid'], false, true);
		}
		else if ($this->existing['type'] == vB_Api::instance('vbshout_shoutbox')->getShoutType('system'))
		{
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('systemmsgs', $this->existing['instanceid'], false, true);
		}
		
		return true;
	}
}