<?php if (!defined('VB_ENTRY')) die('Access denied.');

require_once(DIR . '/packages/dbtechvbshout/class_api_core.php');

/**
 * vB_Api_DBTechvBShout
 *
 * @package DBTechvBShout
 * @access public
 */
class DBTechvBShout_Api_Vbshout_Core extends DBTechvBShout_Core
{
	public $title = 'Core API';
	public $version = '3.0.0';	
	public $extensionOrder = 9;

	/**
	* Version info
	*
	* @protected	mixed
	*/	
	protected static $_version 		 	= '6.1.0 Alpha 5';
	protected static $_versionNumber 	= '610a5';

	/**
	* Whether we have the pro version or not
	*
	* @protected	boolean
	*/		
	protected static $_isPro			= false;

	/**
	* Array of table data
	*
	* @protected	array
	*/	
	protected static $_cachedTables 	= array();


	protected function __construct($prevResult)
	{
		parent::__construct($prevResult);

		

		$classname = 'DBTechvBShout_dB_' . vB::getDbAssertor()->getDbType() . "_QueryDefs";
		$filename = DIR . '/packages/' . strtolower(str_replace('_', '/', $classname)) . '.php';

		if (file_exists($filename))
		{
			include_once($filename);
		}

		//make sure this is valid
		if (!class_exists($classname, false))
		{
			// We have no querydefs file
			return true;
		}

		$queryDef = new $classname();
		$tableData = $queryDef->getTableData();
		unset($queryDef);

		if (!count($tableData) OR !is_array($tableData))
		{
			// We have no tables to fetch data for
			return true;
		}

		foreach ($tableData as $table => $info)
		{
			if (!array_key_exists('_isCacheable', $info))
			{
				// Skip this
				continue;
			}

			// Set this table to be cached
			self::$_cachedTables[$info['_tableShort']] = $info;
		}
	}

	/**
	 * Returns an element from the cache
	 *
	 * @return	array
	 */
	public static function getCache($prevResult, $element)
	{
		$_cache = vB_Cache::instance(vB_Cache::CACHE_LARGE)->read('DBTVBS.cache.' . $element);

		if ($_cache === FALSE)
		{
			// We need a rebuild
			$_cache = vB_Api::instance('vbshout_core')->buildCache($element);
		}

		// Ensure this is an array
		$_cache = is_array($_cache) ? $_cache : array();

		switch ($element)
		{
			case 'instance':
				foreach ($_cache as $instanceid => &$instance)
				{
					// Load default options
					$instance = vB_Api::instance('vbshout_shoutbox')->loadDefaultOptions($instance);
					
					// Load instance permissions
					$instance = vB_Api::instance('vbshout_shoutbox')->loadDefaultPermissions($instance);
					
					// Load BBCode permissions
					$instance = vB_Api::instance('vbshout_shoutbox')->loadDefaultBbcodePermissions($instance);
				}
				break;
		}

		// Fix the cache and return it
		return $_cache;
	}

	/**
	 * Returns a sub-ement from an element in the cache
	 *
	 * @return	array
	 */
	public static function getCacheElement($prevResult, $element, $subElement)
	{
		// Grab the cache
		$_cache = vB_Api::instance('vbshout_core')->getCache($element);

		return array_key_exists($subElement, $_cache) ? $_cache[$subElement] : array();

	}

	/**
	 * Rebuilds the cache for a specific table
	 *
	 * @return	boolean
	 */
	public static function buildCache($prevResult, $tableShort)
	{
		$keyField = '';
		if (!isset(self::$_cachedTables[$tableShort]['_keyField']))
		{
			// Default key field
			$keyField = $tableShort . 'id';
		}
		else if (count(self::$_cachedTables[$tableShort]['_keyField']) == 1)
		{
			// We're using a singular key field
			$keyField = self::$_cachedTables[$tableShort]['_keyField'][0];
		}

		try
		{
			// Grab the data
			$data = vB::getDbAssertor()->getRows('DBTechvBShout:getDataForCache-' . $tableShort, array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED), false, $keyField);
		}
		catch (Exception $e)
		{
			// Should never happen but debug purposes, never know
			echo "<pre>";
			print_r($e);
			die();
		}

		if (isset(self::$_cachedTables[$tableShort]['_unserialize']))
		{
			// We need to unserialize something
			foreach ($data as $key => &$arr)
			{
				// Walk through all the values and apply unserialize where needed
				array_walk($arr, function(&$value, $key, $unserialize)
				{
					if (!in_array($key, $unserialize))
					{
						// Skip this
						return true;
					}

					// We found unserialize needed
					$value = @unserialize($value);
					$value = is_array($value) ? $value : array();

				}, self::$_cachedTables[$tableShort]['_unserialize']);
			}
		}

		// Now build the datastore
		vB_Cache::instance(vB_Cache::CACHE_LARGE)->write('DBTVBS.cache.' . $tableShort, $data, 0, "DBTVBS.cacheChg");
		
		return $data;
	}

	/**
	 * Rebuilds all cache elements
	 *
	 * @return	boolean
	 */
	public static function buildAllCaches($prevResult)
	{
		foreach (self::$_cachedTables as $tableShort => $info)
		{
			// We need a rebuild
			vB_Api::instance('vbshout_core')->buildCache($tableShort);
		}
	}

	/**
	 * Fetches the full literal version number
	 *
	 * @return	string
	 */
	public static function getVersion($prevResult)
	{
		return self::$_version;
	}

	/**
	 * Fetches the version number (short version)
	 *
	 * @return	string
	 */
	public static function getVersionNumber($prevResult)
	{
		return self::$_versionNumber;
	}

	/**
	 * Checks whether we're using the Pro version
	 *
	 * @return	boolean
	 */
	public static function isPro($prevResult)
	{
		return self::$_isPro;
	}

	/**
	 * Checks whether we should write copyright and returns the string
	 *
	 * @return	boolean
	 */
	public static function getCopyright($prevResult)
	{
		if (vB::getDatastore()->getOption('dbtech_vbshout_branding_free') == '25599748-ea0f1f752375abaade8e08dc6eff634f')
		{
			$check = explode('-', vB::getDatastore()->getOption('dbtech_vbshout_branding_free'));
			if ($check[0] > 25632516)
			{
				// We have BF
				return false;
			}
		}

		// Shorthand
		$referral = vB::getDatastore()->getOption('dbtech_vbshout_referral');		

		return 'Shoutbox by <a rel="nofollow" href="http://www.dragonbyte-tech.com/product.php?dbtechvbshout' . ($referral ? '&referrerid=' . $referral : '') . '" target="_blank">
			vBShout' . (vB::getDatastore()->getOption('dbtech_vbshout_displayversion') ? ' v' . vB_Api::instance('vbshout_core')->getVersion() : '') . (vB_Api::instance('vbshout_core')->isPro() ? ' (Pro)' : ' (Lite)') . '</a> - 
			<a href="http://www.dragonbyte-tech.com' . ($referral ? '?referrerid=' . $referral : '') . '" target="_blank">
				vBulletin Mods &amp; Addons
			</a> 
			Copyright &copy; ' . date('Y') . ' DragonByte Technologies Ltd.'
			/* . (!vB_Api::instance('vbshout_core')->isPro() AND !vB::getDatastore()->getOption('dbtech_vbshout_nohivel') ? ' Runs best on 
			<a href="http://www.hivelocity.net/?utm_source=Iain%2BKidd&utm_medium=back%2Blink&utm_term=Dedicated%2BServer%2BSponsor&utm_campaign=Back%2BLinks%2Bfrom%2BIain%2BKidd" target="_blank">
				HiVelocity Hosting
			</a>.' : '')*/ . '<br />';		
	}

	/**
	 * Fetches the cache data for a specified option
	 *
	 * @param string 	$hashKey 	The field name to read from the cache
	 *
	 * @return mixed 				The data read back from the cache
	 */
	public static function _getCache($prevResult, $hashkey, $cacheType = vB_Cache::CACHE_STD)
	{
		$minutes = vB::getDatastore()->getOption('dbtech_vbshout_counter_ttl');
		if (!$minutes)
		{
			// We're not caching
			return false;
		}

		$write_lock = true;
		return vB_Cache::instance($cacheType)->read('DBTVBS.' . $hashkey, $write_lock);
	}

	/**
	 * Writes the cache data for a specified option
	 *
	 * @param string 	$hashKey 	The field name to write to the cache
	 * @param array 	$result 	The data to write
	 */
	public static function _writeCache($prevResult, $hashKey, $result, $minute = false, $events = array(), $cacheType = vB_Cache::CACHE_STD)
	{
		$minutes = ($minute ? $minute : vB::getDatastore()->getOption('dbtech_vbshout_counter_ttl'));
		if (!$minutes)
		{
			// We're not caching
			return false;
		}

		return vB_Cache::instance($cacheType)->write('DBTVBS.' . $hashKey, $result, $minutes, $events);
	}

	/**
	 * Executes a specific cache event
	 *
	 * @param string 	$event 	The cache event to purge the cache for
	 */
	public static function _execEvent($prevResult, $event, $cacheType = vB_Cache::CACHE_STD)
	{
		vB_Cache::instance($cacheType)->event($event);
		vB_Cache::instance()->event($event);

		return true;
	}

	/**
	* Check if we have permissions to perform an action
	*
	* @param	array		User info
	* @param	array		Permissions info
	*/		
	public static function checkPermissions($prevResult, $user, $permissions, $bitIndex)
	{
		if (!array_key_exists('usergroupid', $user) OR !$user['usergroupid'] OR (!isset($user['membergroupids']) AND $user['userid']))
		{
			// Ensure we have this
			$user = vB_Api::instance('user')->fetchUserinfo($user['userid']);
		}

		if (!empty($user['membergroupids']))
		{
			$membergroups = explode(',', str_replace(' ', '', $user['membergroupids']));
		}
		else
		{
			$membergroups = array();
		}
		$membergroups[] = $user['usergroupid'];

		$ugs = array_unique($membergroups);

		if (!$ugs[0])
		{
			// Hardcode guests
			$ugs[0] = 1;
		}
		
		foreach ($ugs as $usergroupid)
		{
			$value = $permissions[$usergroupid][$bitIndex];
			$value = (isset($value) ? $value : 0);
			
			switch ($value)
			{
				case 1:
					// Allow
					return true;
					break;
			}
		}
		
		// We didn't make it
		return false;
	}

	/**
	 * Install custom stuff
	 *
	 * @return	boolean
	 */
	public static function installCustomStuff($prevResult, $pagetemplates, $routes, $pages)
	{
		// Shorthand
		$assertor = vB::getDbAssertor();

		foreach ($pagetemplates as $key => $pagetemplate)
		{
			if (!$existing = $assertor->getRow('pagetemplate', array('guid' => $pagetemplate['guid'])))
			{
				// Save the pagetemplate and store the pagetemplateid
				$pagetemplates[$key]['pagetemplateid'] = $assertor->insert('pagetemplate', $pagetemplate);
			}
			else
			{
				// Store the pagetemplateid
				$pagetemplates[$key]['pagetemplateid'] = $existing['pagetemplateid'];
			}
		}

		foreach ($routes as $key => $route)
		{
			if (!$existing = $assertor->getRow('routenew', array('guid' => $route['guid'])))
			{
				if (isset($route['arguments']))
				{
					// Serialize this
					$route['arguments'] = trim(serialize($route['arguments']));
				}

				// Save the route and store the routeid
				$routes[$key]['routeid'] = $assertor->insert('routenew', $route);
			}
			else
			{
				// Store the routeid
				$routes[$key]['routeid'] = $existing['routeid'];
			}
		}

		foreach ($pages as $key => $page)
		{
			// Store the things we're referencing
			$pageTemplateKey 	= $page['pagetemplateid'];
			$routeKey 			= $page['routeid'];

			// Get back the real one
			$page['pagetemplateid'] = $pagetemplates[$pageTemplateKey]['pagetemplateid'];
			$page['routeid'] 		= $routes[$routeKey]['routeid'];

			if (!$existing = $assertor->getRow('page', array('guid' => $page['guid'])))
			{
				// Save the page and store the pageid
				$pages[$key]['pageid'] = $assertor->insert('page', $page);
			}
			else
			{
				// Store the pageid
				$pages[$key]['pageid'] = $existing['pageid'];
			}

			if (isset($routes[$routeKey]['arguments']))
			{
				// Save the pageid
				$routes[$routeKey]['arguments']['pageid'] = $pages[$key]['pageid'];

				// Update the route with the new pageid
				 $assertor->update('routenew', array(
					'arguments' 	=> trim(serialize($routes[$routeKey]['arguments'])),
				), array('routeid' => $page['routeid']));
			}
		}

		return true;
	}
}
?>