<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'instance' 	=> vB_Api::instance('vbshout_core')->getCache('instance'),
);
$vb5_config =& vB::getConfig();
	
// Store the bitfield defs we need
$bitfields = array(
	'logging' 		=> 'dbtech_vbshout_commands',
	'editors' 		=> 'dbtech_vbshout_editors',
	'notices' 		=> 'dbtech_vbshout_notices',
	'shoutboxtabs' 	=> 'dbtech_vbshout_shoutboxtabs',
);

// #############################################################################
if ($_REQUEST['action'] == 'instance' OR empty($_REQUEST['action']))
{
	$displays = array(
		0 => new vB_Phrase('global', 'disabled'),
		1 => new vB_Phrase('hooks', 'dbtech_vbshout_after_navbar'),
		2 => new vB_Phrase('hooks', 'dbtech_vbshout_above_footer')
	);
	
	print_cp_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_instance_management'));
	
	print_form_header('', '');
	print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_additional_functions'));
	print_description_row("<b>
		<a href=\"vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=instance&amp;action=permissions\">" . new vB_Phrase('hooks', 'dbtech_vbshout_view_instance_permissions') . "</a>
		"  . "
	</b>", 0, 2, '', 'center');
	print_table_footer();
	
	// Table header
	$headings = array();
	$headings[] = new vB_Phrase('cpglobal', 'varname');
	$headings[] = new vB_Phrase('global', 'title');
	$headings[] = new vB_Phrase('global', 'description');
	$headings[] = new vB_Phrase('global', 'active');
	$headings[] = new vB_Phrase('cpglobal', 'display_order');
	$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_sticky');
	//$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_auto_display');
	//$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_deployment');
	//$headings[] = new vB_Phrase('cpglobal', 'templates');
	//$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_sounds_shout');
	//$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_sounds_invite');
	//$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_sounds_pm');
	
	// Hook goes here
	
	$headings[] = new vB_Phrase('global', 'edit');
	$headings[] = new vB_Phrase('global', 'delete');
	
	if (count($_cache['instance']))
	{
		print_form_header('vbshout', 'instance');
		construct_hidden_code('action', 'displayorder');
		print_table_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_instance_management'), count($headings));
		print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_instance_management_descr'), false, count($headings));	
		
		print_cells_row($headings, 0, 'thead');
		
		foreach ($_cache['instance'] as $instanceid => $instance)
		{
			// Table data
			$cell = array();
			$cell[] = $instance['varname'];
			$cell[] = $instance['name'];
			$cell[] = $instance['description'];
			$cell[] = ($instance['active'] ? new vB_Phrase('global', 'yes') : '<span class="col-i"><strong>' . new vB_Phrase('global', 'no') . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$instanceid]\" value=\"$instance[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . new vB_Phrase('forum', 'edit_display_order') . "\" />";
			$cell[] = $instance['sticky'];
			//$cell[] = $displays[$instance['autodisplay']];
			//$cell[] = $instance['deployment'];
			//$cell[] = $instance['templates'];
			//$cell[] = $instance['shoutsound'];
			//$cell[] = $instance['invitesound'];
			//$cell[] = $instance['pmsound'];
			
			// Hook goes here
			
			$cell[] = construct_link_code(new vB_Phrase('global', 'edit'), 'vbshout.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=instance&amp;action=modify&amp;instanceid=' . $instanceid);
			$cell[] = ($instanceid != 1 ? construct_link_code(new vB_Phrase('global', 'delete'), 'vbshout.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=instance&amp;action=delete&amp;instanceid=' . $instanceid) : '[N/A]');
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row(new vB_Phrase('cpglobal', 'save_display_order'), false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance'), 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbshout.php?do=instance&amp;action=modify'\" />");	
	}
	else
	{
		print_form_header('vbshout', 'instance');
		construct_hidden_code('action', 'modify');
		print_table_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_instance_management'), count($headings));
		print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_no_instances'), false, count($headings));
		print_submit_row(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance'), false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	// Ensure we can fetch bitfields
	require_once(DIR . '/packages/dbtechvbshout/adminfunctions.php');

	$cleaned = vB::getCleaner()->clean($_REQUEST, 'instanceid', vB_Cleaner::TYPE_UINT);
	$instanceid = $cleaned['instanceid'];
	$instance = ($instanceid ? $_cache['instance'][$cleaned['instanceid']] : false);
	
	if (!is_array($instance))
	{
		// Non-existing instance
		$instanceid = 0;
	}
	
	$permissions = $bbcodepermissions = array();
	$bitfielddefss = array(
		'adminpermissions' 	=> vB::getDatastore()->getValue('bf_ugp_adminpermissions'),
		'genericoptions' 	=> vB::getDatastore()->getValue('bf_ugp_genericoptions'),
	);

	foreach (vB::getDatastore()->get_value('usergroupcache') as $usergroupid => $usergroup)
	{
		$bit = 10300;
		$bit2 = 67;
		if ($usergroup['adminpermissions'] & $bitfielddefss['adminpermissions']['cancontrolpanel'])
		{
			// Admin
			$bit = 61436;
		}
		else if ($usergroup['adminpermissions'] & $bitfielddefss['adminpermissions']['ismoderator'])
		{
			// SMod
			$bit = 61436;
		}
		else if ($usergroupid == 5)
		{
			$bit = 61308;
		}
		else if (!($usergroup['genericoptions'] & $bitfielddefss['genericoptions']['isnotbannedgroup']) OR in_array($usergroupid, array(1, 3, 4)))
		{
			// Banned, guest, email conf, COPPA
			$bit 	= 0;
			$bit2 	= 0;
		}
		
		$permissions[$usergroupid] 			= $bit;		
		$bbcodepermissions[$usergroupid] 	= $bit2;		
	}
	
	$defaults = array(
		'varname' 			=> 'shoutbox',
		'name' 				=> 'Shoutbox',
		'description' 		=> 'A shoutbox instance.',
		'sticky' 			=> 'The defauly sticky note.',
		'active' 			=> 1,
		'autodisplay'		=> 1,
		'permissions'		=> $permissions,
		'bbcodepermissions'	=> $bbcodepermissions,
		'options'			=> array(),
	);
	
	if (extension_loaded('suhosin') AND (ini_get('suhosin.post.max_vars') > 0) AND (ini_get('suhosin.post.max_vars') < 2048))
	{
		$hasSuhosin = '
			You appear to have <strong>Suhosin</strong> installed on your server and configured to be too restrictive for vBulletin and vBShout to work correctly.<br />
			<br />
			Please note that if you have a large number of usergroups, certain parts of this page may not work as intended.<br />
			<br />
			If you encounter this issue, you can work around this by adding the following code to your .htaccess file:<br />
			<br />
<pre>php_flag suhosin.cookie.encrypt Off
php_value suhosin.request.max_vars 2048
php_value suhosin.get.max_vars 2048
php_value suhosin.post.max_vars 2048</pre>
			<br />
			These are the values vBulletin Support Staff suggest.';
	}
	if (version_compare(PHP_VERSION, '5.3.9') >= 0 AND ini_get('max_input_vars') < 10000)
	{
		$hasSuhosin = '
			You appear to have <strong>PHP 5.3.9</strong> or higher installed on your server and configured to be too restrictive for vBulletin and vBShout to work correctly.<br />
			<br />
			Please note that if you have a large number of usergroups, certain parts of this page may not work as intended.<br />
			<br />
			If you encounter this issue, you can work around this by adding the following code to your .htaccess file:<br />
			<br />
<pre>php_value max_input_vars 10000</pre>
			<br />
			or altering your php.ini file to increase max_input_vars to 10000.';
	}
	
	if ($instanceid)
	{
		// Edit
		print_cp_header(strip_tags(new vB_Phrase('hooks', 'dbtech_vbshout_editing_x_y', new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $instance['name'])));
		print_form_header('vbshout', 'instance');
		construct_hidden_code('action', 'update');
		construct_hidden_code('instanceid', $instanceid);
		if ($hasSuhosin)
		{
			print_table_start();
			print_description_row($hasSuhosin);
			print_table_break();
		}
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_editing_x_y', new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $instance['name']));
	}
	else
	{
		// Add
		print_cp_header(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance'));
		print_form_header('vbshout', 'instance');
		construct_hidden_code('action', 'update');
		if ($hasSuhosin)
		{
			print_table_start();
			print_description_row($hasSuhosin);
			print_table_break();
		}
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance'));
		
		$instance = $defaults;
		
		// Ensure we always have the default options
		$instance = vB_Api::instance('vbshout_shoutbox')->loadDefaultOptions($instance);
	}
	
	print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_main_settings'), false, 2, 'optiontitle');	
	if ($instanceid)
	{
		print_label_row(new vB_Phrase('hooks', 'dbtech_vbshout_varname'), 																		$instance['varname']);
	}
	else
	{
		print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_varname'), 					'instance[varname]', 												$instance['varname']);
	}
	print_input_row(new vB_Phrase('global', 'title'), 										'instance[name]', 													$instance['name']);
	print_textarea_row(new vB_Phrase('global', 'description'),								'instance[description]',											$instance['description']);
	print_yes_no_row(new vB_Phrase('global', 'active'),										'instance[active]',													$instance['active']);
	print_input_row(new vB_Phrase('cpglobal', 'display_order'),								'instance[displayorder]',											$instance['displayorder']);
	print_textarea_row(new vB_Phrase('hooks', 'dbtech_vbshout_sticky'),						'instance[sticky_raw]',												$instance['sticky_raw']);	
	print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_sound_settings'), false, 2, 'optiontitle');	
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_disable_shout_sound'),			'instance[options][disableshoutsound]', 							$instance['options']['disableshoutsound']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_disable_invite_sound'),			'instance[options][disableinvitesound]', 							$instance['options']['disableinvitesound']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_disable_pm_sound'),				'instance[options][disablepmsound]', 								$instance['options']['disablepmsound']);
	print_description_row(new vB_Phrase('global', 'options'), false, 2, 'optiontitle');	
	print_bitfield_row(new vB_Phrase('hooks', 'dbtech_vbshout_logging_descr'), 				'instance[options][logging]', 	$bitfields['logging'], 				$instance['options']['logging']);
	print_bitfield_row(new vB_Phrase('hooks', 'dbtech_vbshout_editors_descr'), 				'instance[options][editors]', 	$bitfields['editors'], 				$instance['options']['editors']);
	print_bitfield_row(new vB_Phrase('hooks', 'dbtech_vbshout_notices_descr'), 				'instance[options][notices]', 	$bitfields['notices'], 				$instance['options']['notices']);
	//print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_optimisation_descr'), 		'instance[options][optimisation]', 						$instance['options']['optimisation']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_allowsmilies_descr'), 			'instance[options][allowsmilies]', 									$instance['options']['allowsmilies']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_activeusers_descr'), 			'instance[options][activeusers]', 									$instance['options']['activeusers']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_sounds_descr'), 				'instance[options][sounds]', 										$instance['options']['sounds']);
	//print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_enablemenu_descr'), 			'instance[options][enablemenu]', 						$instance['options']['enablemenu']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_altshouts_descr'), 				'instance[options][altshouts]', 									$instance['options']['altshouts']);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_enableaccess_descr'), 			'instance[options][enableaccess]', 									$instance['options']['enableaccess']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_maxshouts_descr'), 				'instance[options][maxshouts]', 									$instance['options']['maxshouts']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_maxarchiveshouts_descr'), 		'instance[options][maxarchiveshouts]', 								$instance['options']['maxarchiveshouts']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_height_descr'), 					'instance[options][height]', 										$instance['options']['height']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_floodchecktime_descr'), 			'instance[options][floodchecktime]', 								$instance['options']['floodchecktime']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_maxchars_descr'), 				'instance[options][maxchars]', 										$instance['options']['maxchars']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_maximages_descr'), 				'instance[options][maximages]', 									$instance['options']['maximages']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_idletimeout_descr'), 			'instance[options][idletimeout]', 									$instance['options']['idletimeout']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_refresh_descr'), 				'instance[options][refresh]', 										$instance['options']['refresh']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_maxchats_descr'), 				'instance[options][maxchats]', 										$instance['options']['maxchats']);
	print_select_row(new vB_Phrase('hooks', 'dbtech_vbshout_shoutorder_descr'),				'instance[options][shoutorder]', array(
																												'DESC' 	=> new vB_Phrase('hooks', 'dbtech_vbshout_newest_first'),
																												'ASC' 	=> new vB_Phrase('hooks', 'dbtech_vbshout_oldest_first')
																											),													$instance['options']['shoutorder']);
	print_select_row(new vB_Phrase('hooks', 'dbtech_vbshout_maxsize_descr'),				'instance[options][maxsize]', 	array(
																												3 => 3,
																												4 => 4,
																												5 => 5,
																												6 => 6,
																												7 => 7
																											),													$instance['options']['maxsize']);
	print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_forum_milestones'), false, 2, 'optiontitle');	
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_postping_interval_descr'), 		'instance[options][postping_interval]', 							$instance['options']['postping_interval']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_threadping_interval_descr'), 	'instance[options][threadping_interval]', 							$instance['options']['threadping_interval']);
	print_input_row(new vB_Phrase('hooks', 'dbtech_vbshout_memberping_interval_descr'), 	'instance[options][memberping_interval]', 							$instance['options']['memberping_interval']);

	
	
	if ($hasSuhosin)
	{
		print_submit_row(($instanceid ? new vB_Phrase('global', 'save') : new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance')), false, count($headings));
	}
	else
	{
		print_table_break();
	}
	
	if ($instanceid OR !$hasSuhosin)
	{
		// Bitfields
		$permissions = vB::getDatastore()->getValue('bf_misc_dbtech_vbshoutpermissions');
		
		// Table header
		$headings = array();
		$headings[] = new vB_Phrase('global', 'usergroup');
		foreach ((array)$permissions as $permissionname => $bit)
		{
			$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_permission_' . $permissionname);
		}
		
		if ($hasSuhosin)
		{
			print_form_header('vbshout', 'instance');
			construct_hidden_code('action', 'updateinstancepermissions');
			construct_hidden_code('instanceid', $instanceid);
		}
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_instance_permissions'), count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach (vB::getDatastore()->get_value('usergroupcache') as $usergroupid => $usergroup)
		{
			// Table data
			$cell = array();
			$cell[] = $usergroup['title'];	
			foreach ((array)$permissions as $permissionname => $bit)
			{
				$cell[] = '<center>
					<input type="hidden" name="permissions[' . $usergroupid . '][' . $permissionname . ']" value="0" />
					<input type="checkbox" name="permissions[' . $usergroupid . '][' . $permissionname . ']" value="1"' . ($instance['permissions'][$usergroupid] & $bit ? ' checked="checked"' : '') . ($vb5_config['Misc']['debug'] ? ' title="name=&quot;permissions[' . $usergroupid . '][' . $permissionname . ']&quot;"' : '') . '/>
				</center>';
			}
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		if ($hasSuhosin)
		{
			print_submit_row(($instanceid ? new vB_Phrase('global', 'save') : new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance')), false, count($headings));
		}
		else
		{
			print_table_break();
		}
		
		// Bitfields
		$permissions = vB::getDatastore()->getValue('bf_misc_dbtech_vbshout_allowedbbcodesfull');
		
		// Table header
		$headings = array();
		$headings[] = new vB_Phrase('global', 'usergroup');
		foreach ((array)$permissions as $permissionname => $bit)
		{
			$headings[] = new vB_Phrase('cppermission', $permissionname);
		}
		
		if ($hasSuhosin)
		{
			print_form_header('vbshout', 'instance');
			construct_hidden_code('action', 'updatebbcodepermissions');
			construct_hidden_code('instanceid', $instanceid);
		}
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_bbcode_permissions'), count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach (vB::getDatastore()->get_value('usergroupcache') as $usergroupid => $usergroup)
		{
			// Table data
			$cell = array();
			$cell[] = $usergroup['title'];	
			foreach ((array)$permissions as $permissionname => $bit)
			{
				$cell[] = '<center>
					<input type="hidden" name="bbcodepermissions[' . $usergroupid . '][' . $permissionname . ']" value="0" />
					<input type="checkbox" name="bbcodepermissions[' . $usergroupid . '][' . $permissionname . ']" value="1"' . ($instance['bbcodepermissions'][$usergroupid] & $bit ? ' checked="checked"' : '') . ($vb5_config['Misc']['debug'] ? ' title="name=&quot;bbcodepermissions[' . $usergroupid . '][' . $permissionname . ']&quot;"' : '') . '/>
				</center>';
			}
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}	
		if ($hasSuhosin)
		{
			print_submit_row(($instanceid ? new vB_Phrase('global', 'save') : new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance')), false, count($headings));
		}
		else
		{
			print_table_break();
		}
	}
	
	if (!$hasSuhosin)
	{
		print_submit_row(($instanceid ? new vB_Phrase('global', 'save') : new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance')), false);
	}
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'instanceid' 		=> vB_Cleaner::TYPE_UINT,
		'instance' 			=> vB_Cleaner::TYPE_ARRAY,
		'permissions' 		=> vB_Cleaner::TYPE_ARRAY,
		'bbcodepermissions' => vB_Cleaner::TYPE_ARRAY,
	));
	
	// Store raw sticky
	$sticky_raw = $cleaned['instance']['sticky'] = $cleaned['instance']['sticky_raw'];
	
	// Init the parser
	$parser = new vB5_Template_BbCode();
	
	if (vB::getDatastore()->getOption('allowedbbcodes') & 64)
	{
		// We can use the URL BBCode, so convert links
		$cleaned['instance']['sticky'] = vB_Api::instance('bbcode')->convertUrlToBbcode($cleaned['instance']['sticky_raw']);
	}	
	
	// BBCode parsing
	$cleaned['instance']['sticky'] = $parser->doParse(
		$cleaned['instance']['sticky'],
		false, 	// allowhtml
		true, 	// allowsmilies
		true, 	// allowbbcode
		false,	// allowbbimagecode
		false 	// nl2br
	);
	
	foreach ($bitfields as $key => $fieldname)
	{
		$bit = 0;
		foreach ((array)$cleaned['instance']['options'][$key] as $value)
		{
			// Update the options array
			$bit += $value;
		}
		$cleaned['instance']['options'][$key] = $bit;
	}
	
	$bitfields = vB::getDatastore()->getValue('bf_misc_dbtech_vbshoutpermissions');
	$bitfields2 = vB::getDatastore()->getValue('bf_misc_dbtech_vbshout_allowedbbcodesfull');
	
	if (count($cleaned['permissions']))
	{
		$permarray = array();
		foreach ((array)$cleaned['permissions'] as $usergroupid => $permvalues)
		{
			
			$permarray[$usergroupid] = 0;
			foreach ((array)$permvalues as $bitfield => $bit)
			{
				// Update the permissions array
				$permarray[$usergroupid] += ($bit ? $bitfields[$bitfield] : 0);
			}
		}
	
		// Set the perm array
		$cleaned['instance']['permissions'] = $permarray;
	}
	
	if (count($cleaned['bbcodepermissions']))
	{
		$permarray = array();
		foreach ((array)$cleaned['bbcodepermissions'] as $usergroupid => $permvalues)
		{
			$permarray[$usergroupid] = 0;
			foreach ((array)$permvalues as $bitfield => $bit)
			{
				// Update the permissions array
				$permarray[$usergroupid] += ($bit ? $bitfields2[$bitfield] : 0);
			}
		}
		
		// Set the perm array
		$cleaned['instance']['bbcodepermissions'] = $permarray;
	}
	
	// init data manager
	$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($cleaned['instanceid'])
	{
		if (!$existing = $_cache['instance'][$cleaned['instanceid']])
		{
			// Couldn't find the instance
			print_stop_message2(array('dbtech_vbshout_invalid_x', new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $cleaned['instanceid']));
		}
		
		// Set existing
		$dm->set_existing($existing);
	}
	
	// instance fields
	foreach ($cleaned['instance'] AS $key => $val)
	{
		// set values
		$dm->set($key, $val);
	}
	
	// Save! Hopefully.
	$dm->save();
	
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_instance'),
		new vB_Phrase('hooks', ($cleaned['instanceid'] ? 'dbtech_vbshout_edited' : 'dbtech_vbshout_added'))
	), 'vbshout', array(
		'do' => 'instance',
	));
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$cleaned = vB::getCleaner()->clean($_POST, 'order', vB_Cleaner::TYPE_ARRAY);
	$order = $cleaned['order'];
	
	foreach ((array)$order as $instanceid => $displayorder)
	{
		if (!$existing = $_cache['instance'][$instanceid])
		{
			// Couldn't find the instance
			continue;
		}
		
		if ($existing['displayorder'] == $displayorder)
		{
			// No change
			continue;
		}
		
		// init data manager
		$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_CP);
			$dm->set_existing($existing);
			$dm->set('displayorder', $displayorder);
		$dm->save();
		unset($dm);	
	}
	
	print_stop_message2('saved_display_order_successfully', 'vbshout', array(
		'do' => 'instance',
	));
}

// #############################################################################
if ($_POST['action'] == 'updateinstancepermissions')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'instanceid'		=> vB_Cleaner::TYPE_UINT,
		'permissions' 		=> vB_Cleaner::TYPE_ARRAY,
	));
	
	$bitfields = vB::getDatastore()->getValue('bf_misc_dbtech_vbshoutpermissions');
	
	$permarray = array();
	foreach ((array)$cleaned['permissions'] as $usergroupid => $permvalues)
	{
		
		$permarray[$usergroupid] = 0;
		foreach ((array)$permvalues as $bitfield => $bit)
		{
			// Update the permissions array
			$permarray[$usergroupid] += ($bit ? $bitfields[$bitfield] : 0);
		}
	}
	
	// Set the perm array
	$cleaned['instance']['permissions'] = $permarray;
	
	// init data manager
	$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($cleaned['instanceid'])
	{
		if (!$existing = $_cache['instance'][$cleaned['instanceid']])
		{
			// Couldn't find the instance
			print_stop_message2(array('dbtech_vbshout_invalid_x', new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $cleaned['instanceid']));
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = new vB_Phrase('hooks', 'dbtech_vbshout_edited');
	}
	else
	{
		// Added
		$phrase = new vB_Phrase('hooks', 'dbtech_vbshout_added');
	}
	
	// instance fields
	foreach ($cleaned['instance'] AS $key => $val)
	{
		// set values
		$dm->set($key, $val);
	}
	
	// Save! Hopefully.
	$dm->save();
		
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_instance'),
		new vB_Phrase('hooks', 'dbtech_vbshout_edited')
	), 'vbshout', array(
		'do' => 'instance',
	));
}


// #############################################################################
if ($_POST['action'] == 'updatebbcodepermissions')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'instanceid'		=> vB_Cleaner::TYPE_UINT,
		'bbcodepermissions' => vB_Cleaner::TYPE_ARRAY,
	));
	
	$bitfields = vB::getDatastore()->getValue('bf_misc_dbtech_vbshout_allowedbbcodesfull');

	$permarray = array();
	foreach ((array)$cleaned['bbcodepermissions'] as $usergroupid => $permvalues)
	{
		$permarray[$usergroupid] = 0;
		foreach ((array)$permvalues as $bitfield => $bit)
		{
			// Update the permissions array
			$permarray[$usergroupid] += ($bit ? $bitfields[$bitfield] : 0);
		}
	}
	
	// Set the perm array
	$cleaned['instance']['bbcodepermissions'] = $permarray;
	
	// init data manager
	$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($cleaned['instanceid'])
	{
		if (!$existing = $_cache['instance'][$cleaned['instanceid']])
		{
			// Couldn't find the instance
			print_stop_message2(array('dbtech_vbshout_invalid_x', new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $cleaned['instanceid']));
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = new vB_Phrase('hooks', 'dbtech_vbshout_edited');
	}
	else
	{
		// Added
		$phrase = new vB_Phrase('hooks', 'dbtech_vbshout_added');
	}
	
	// instance fields
	foreach ($cleaned['instance'] AS $key => $val)
	{
		// set values
		$dm->set($key, $val);
	}
	
	// Save! Hopefully.
	$dm->save();
			
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_instance'),
		new vB_Phrase('hooks', 'dbtech_vbshout_edited')
	), 'vbshout', array(
		'do' => 'instance',
	));
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$cleaned = vB::getCleaner()->clean($_REQUEST, 'instanceid', vB_Cleaner::TYPE_UINT);
	
	print_cp_header(new vB_Phrase('hooks', 'dbtech_vbshout_delete_x', new vB_Phrase('hooks', 'dbtech_vbshout_instance')));
	print_delete_confirmation('DBTechvBShout:dbtech_vbshout_instance', $cleaned['instanceid'], 'vbshout', 'instance', 'dbtech_vbshout_instance', array('action' => 'kill'), '', 'name', 'instanceid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'instanceid' => vB_Cleaner::TYPE_UINT,
		'kill' 		 => vB_Cleaner::TYPE_BOOL
	));
	
	if (!$existing = $_cache['instance'][$cleaned['instanceid']])
	{
		// Couldn't find the instance
		print_stop_message2(array('dbtech_vbshout_invalid_x', new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $cleaned['instanceid']));
	}
	
	// init data manager
	$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_instance'),
		new vB_Phrase('hooks', 'dbtech_vbshout_deleted')
	), 'vbshout', array(
		'do' => 'instance',
	));
}


// #############################################################################
if ($_REQUEST['action'] == 'permissions')
{
	$permissions = vB::getDatastore()->getValue('bf_misc_dbtech_vbshoutpermissions');
	
	print_cp_header(new vB_Phrase('hooks', 'dbtech_vbshout_instance_permissions'));
	
	// Table header
	$headings = array();
	$headings[] = new vB_Phrase('global', 'usergroup');
	foreach ((array)$permissions as $permissionname => $bit)
	{
		$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_permission_' . $permissionname);
	}
	$headings[] = new vB_Phrase('global', 'edit');
	
	if (count($_cache['instance']))
	{
		print_form_header('', '');	
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_instance_permissions'), count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach ($_cache['instance'] as $instanceid => $instance)
		{
			print_description_row($instance['name'] . ' - ' . $instance['description'], false, count($headings), 'optiontitle');
			
			foreach (vB::getDatastore()->get_value('usergroupcache') as $usergroupid => $usergroup)
			{
				// Table data
				$cell = array();
				$cell[] = $usergroup['title'];
				foreach ((array)$permissions as $permissionname => $bit)
				{
					$cell[] = ($instance['permissions'][$usergroupid] & $bit ? new vB_Phrase('global', 'yes') : '<span class="col-i"><strong>' . new vB_Phrase('global', 'no') . '</strong></span>');
				}
				$cell[] = construct_link_code(new vB_Phrase('global', 'edit'), 'vbshout.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=instance&amp;action=modify&amp;instanceid=' . $instanceid);
				
				// Print the data
				print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
			}
		}
		
		print_table_footer();
	}
	else
	{
		print_form_header('vbshout', 'instance');	
		construct_hidden_code('action', 'modify');
		print_table_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_instance_management'), count($headings));
		print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_no_instances'), false, count($headings));
		print_submit_row(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_instance'), false, count($headings));	
	}
}



print_cp_footer();