<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'chatroom' 	=> vB_Api::instance('vbshout_core')->getCache('chatroom'),
	'instance' 	=> vB_Api::instance('vbshout_core')->getCache('instance'),
);

// #############################################################################
if ($_REQUEST['action'] == 'chatroom' OR empty($_REQUEST['action']))
{
	$chatrooms_by_type 	= array();
	foreach ((array)$_cache['chatroom'] as $chatroomid => $chatroom)
	{
		// Index by categoryid
		$chatrooms_by_type[($chatroom['membergroupids'] ? 'global' : 'user_created')][$chatroomid] = $chatroom;
	}

	print_cp_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_chatroom_management'));
	
	// Table header
	$headings = array();
	$headings[] = new vB_Phrase('global', 'title');
	$headings[] = new vB_Phrase('global', 'usergroups');
	$headings[] = new vB_Phrase('hooks', 'dbtech_vbshout_instance');
	$headings[] = new vB_Phrase('global', 'active');
	$headings[] = new vB_Phrase('global', 'edit');
	
	$usergroupcache = vB::getDatastore()->get_value('usergroupcache');
	if (count($chatrooms_by_type))
	{
		print_form_header('vbshout', 'chatroom');	
		construct_hidden_code('action', 'modify');	
		print_table_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_chatroom_management'), count($headings));
		print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_chatroom_management_descr'), false, count($headings));	
		
		foreach ($chatrooms_by_type as $typeid => $chatrooms)
		{
			print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_chatroom_' . $typeid), false, count($headings), 'optiontitle');
			print_cells_row($headings, 0, 'thead');
			
			foreach ($chatrooms as $chatroomid => $chatroom)
			{
				$usergroups = array();
				foreach(explode(',', $chatroom['membergroupids']) as $usergroupid)
				{
					// Usergroup cache
					$usergroups[] = $usergroupcache[$usergroupid]['title'];
				}

				if (!$usergroups[0])
				{
					$usergroups = array(new vB_Phrase('global', 'n_a'));
				}
				
				// Table data
				$cell = array();
				$cell[] = $chatroom['title'];
				$cell[] = implode(', ', $usergroups);
				$cell[] = ($chatroom['instanceid'] ? $_cache['instance'][$chatroom['instanceid']]['name'] : new vB_Phrase('hooks', 'dbtech_vbshout_all_instances'));
				$cell[] = ($chatroom['active'] ? new vB_Phrase('global', 'yes') : '<span class="col-i"><strong>' . new vB_Phrase('global', 'no') . '</strong></span>');
				$cell[] = construct_link_code(new vB_Phrase('global', 'edit'), 'vbshout.php?' . vB::getCurrentSession()->get('sessionurl') . 'do=chatroom&amp;action=modify&amp;chatroomid=' . $chatroomid);
				
				// Print the data
				print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
			}
		}
		print_submit_row(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_chatroom'), false, count($headings));	
	}
	else
	{
		print_form_header('vbshout', 'chatroom');	
		construct_hidden_code('action', 'modify');	
		print_table_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_chatroom_management'), count($headings));
		print_description_row(new vB_Phrase('hooks', 'dbtech_vbshout_no_chatrooms'), false, count($headings));
		print_submit_row(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_chatroom'), false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$instances = array();
	$instances[0] = new vB_Phrase('hooks', 'dbtech_vbshout_all_instances');
	
	asort($instances);
	
	$cleaned = vB::getCleaner()->clean($_REQUEST, 'chatroomid', vB_Cleaner::TYPE_UINT);
	$chatroomid = $cleaned['chatroomid'];
	$chatroom = ($chatroomid ? $_cache['chatroom'][$chatroomid] : false);
	
	if (!is_array($chatroom))
	{
		// Non-existing chatroom
		$chatroomid = 0;
	}
	
	if ($chatroomid)
	{
		// Edit
		print_cp_header(strip_tags(new vB_Phrase('hooks', 'dbtech_vbshout_editing_x_y', new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'), $chatroom['title'])));
		print_form_header('vbshout', 'chatroom');
		construct_hidden_code('action', 'update');
		construct_hidden_code('chatroomid', $chatroomid);
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_editing_x_y', new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'), $chatroom['title']));
	}
	else
	{
		// Add
		print_cp_header(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_chatroom'));
		print_form_header('vbshout', 'chatroom');
		construct_hidden_code('action', 'update');
		construct_hidden_code('chatroom[creator]', vB::getUserContext()->fetchUserId());
		print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_add_new_chatroom'));
	}
	
	print_input_row(new vB_Phrase('global', 'title'), 					'chatroom[title]', 					vB_String::unHtmlSpecialChars($chatroom['title']));
	print_yes_no_row(new vB_Phrase('global', 'active'),					'chatroom[active]',					$chatroom['active']);
	print_membergroup_row(new vB_Phrase('global', 'usergroups'), 			'chatroom[membergroupids]', 2, 		$chatroom);
	print_select_row(new vB_Phrase('hooks', 'dbtech_vbshout_instance'), 	'chatroom[instanceid]', $instances,	$chatroom['instanceid']);
	
	print_submit_row(($chatroomid ? new vB_Phrase('global', 'save') : new vB_Phrase('hooks', 'dbtech_vbshout_add_new_chatroom')));
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'chatroomid' 		=> vB_Cleaner::TYPE_UINT,
		'chatroom' 			=> vB_Cleaner::TYPE_ARRAY,
		'permissions' 		=> vB_Cleaner::TYPE_ARRAY,
		'bbcodepermissions' => vB_Cleaner::TYPE_ARRAY,
	));

	// init data manager
	$dm = new DBTechvBShout_DataManager_Chatroom(vB_DataManager_Constants::ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($cleaned['chatroomid'])
	{
		if (!$existing = $_cache['chatroom'][$cleaned['chatroomid']])
		{
			// Couldn't find the chatroom
			print_stop_message2(array('dbtech_vbshout_invalid_x', new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'), $cleaned['chatroomid']));
		}
		
		// Set existing
		$dm->set_existing($existing);
	}
	
	// chatroom fields
	foreach ($cleaned['chatroom'] AS $key => $val)
	{
		// set values
		$dm->set($key, $val);
	}
	
	// Save! Hopefully.
	$dm->save();
	
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'),
		new vB_Phrase('hooks', ($cleaned['chatroomid'] ? 'dbtech_vbshout_edited' : 'dbtech_vbshout_added'))
	), 'vbshout', array(
		'do' => 'chatroom',
	));
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$cleaned = vB::getCleaner()->clean($_REQUEST, 'chatroomid', vB_Cleaner::TYPE_UINT);
	$chatroomid = $cleaned['chatroomid'];
	
	print_cp_header(new vB_Phrase('hooks', 'dbtech_vbshout_delete_x', new vB_Phrase('hooks', 'dbtech_vbshout_chatroom')));
	print_delete_confirmation('DBTechvBShout:dbtech_vbshout_chatroom', $chatroomid, 'vbshout', 'chatroom', 'dbtech_vbshout_chatroom', array('action' => 'kill'), '', 'title', 'chatroomid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'chatroomid' => vB_Cleaner::TYPE_UINT,
		'kill' 		 => vB_Cleaner::TYPE_BOOL
	));
	
	if (!$existing = $_cache['chatroom'][$cleaned['chatroomid']])
	{
		// Couldn't find the chatroom
		print_stop_message2(array('dbtech_vbshout_invalid_x', new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'), $cleaned['chatroomid']));
	}
	
	// init data manager
	$dm = new DBTechvBShout_DataManager_Chatroom(vB_DataManager_Constants::ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'),
		new vB_Phrase('hooks', 'dbtech_vbshout_deleted')
	), 'vbshout', array(
		'do' => 'chatroom',
	));
}

print_cp_footer();