<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'instance' 	=>vB_Api::instance('vbshout_core')->getCache('instance'),
);

// #############################################################################
if ($_REQUEST['action'] == 'banned' OR empty($_REQUEST['action']))
{
	print_cp_header(new vB_Phrase('hooks', 'dbtech_vbshout_ban_management'));
	
	$users = $assertor->getRows('DBTechvBShout:fetchBannedUsers', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED));
	if (!$numusers = count($users))
	{
		print_stop_message2('no_users_matched_your_query');
	}

	// Begin ugly hack
	$loguser = array();
	foreach ($users as $user)
	{
		if (!is_array($loguser[$user['userid']]) OR $loguser[$user['userid']]['dateline'] < $user['dateline'])
		{
			// Overwrite array as needed
			$loguser[$user['userid']] = $user;
		}
	}
	$numusers = count($loguser);
	// End ugly hack
	
	print_form_header('vbshout', 'banned');
	construct_hidden_code('action', 'update');
	print_table_header(new vB_Phrase('cpuser', 'showing_users_x_to_y_of_z', 1, $numusers, $numusers), 6);
	print_cells_row(array(
		new vB_Phrase('global', 'userid'),
		new vB_Phrase('global', 'username'),
		new vB_Phrase('banning', 'banned_by'),
		new vB_Phrase('banning', 'banned_on'),
		new vB_Phrase('hooks', 'dbtech_vbshout_shout_count'),
		'<input type="checkbox" name="allbox" onclick="js_check_all(this.form)" title="' . new vB_Phrase('cpglobal', 'check_all') . '" />'
	), 1);

	$phrase = vB5_Template_Phrase::instance();

	foreach ($loguser as $user)
	{
		$cell = array();
		$cell[] = $user['userid'];
		$cell[] = "<a href=\"user.php?" . vB::getCurrentSession()->get('sessionurl') . "do=edit&u=$user[userid]\" target=\"_blank\">$user[username]</a><br /><span class=\"smallfont\">$user[title]</span>";
		$cell[] = "<a href=\"user.php?" . vB::getCurrentSession()->get('sessionurl') . "do=edit&u=$user[banneruserid]\" target=\"_blank\">$user[bannerusername]</a><br /><span class=\"smallfont\">$user[bannertitle]</span>";
		$cell[] = vbdate(vB::getDatastore()->getOption('dateformat') . ' ' . vB::getDatastore()->getOption('timeformat'), $user['dateline']);
		$cell[] = vb_number_format($user['shouts']);
		$cell[] = "<input type=\"checkbox\" name=\"users[$user[userid]]\" value=\"1\" tabindex=\"1\" />";
		print_cells_row($cell);
	}
	print_submit_row(new vB_Phrase('banning', 'lift_ban'), false, 6);
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	// Fetch the list of users
	$cleaned = vB::getCleaner()->clean($_POST, 'users', vB_Cleaner::TYPE_ARRAY_UINT);
	$users = $cleaned['users'];
	
	if (!count($users))
	{
		// We weren't unbanning anything
		print_stop_message2('nothing_to_do');
	}
	
	// Grab all the userids
	$users = array_keys($users);
	array_unique($users);

	if (!count($users))
	{
		// Bleh
		print_stop_message2('nothing_to_do');
	}
	
	// Unban all the users
	$assertor->update('user', array(
		'dbtech_vbshout_banned' => '0'
	), array('userid' => $users));

	foreach ($users as $userid)
	{
		// Log the unbanning
		vB_Api::instance('vbshout_core')->logCommand('unban', $userid);
	}
	
	foreach ((array)$_cache['instance'] as $instanceid => $instance)
	{
		// We've changed shit
		vB_Api::instance('vbshout_core')->setAop('shouts', 		$instanceid, false);
		vB_Api::instance('vbshout_core')->setAop('shoutnotifs', $instanceid, false, true);
	}
	
	print_stop_message2('dbtech_vbshout_users_unbanned', 'vbshout', array(
		'do' => 'banned',
	));
}

print_cp_footer();