<?php
// Prune old entries
$db->delete('routenew', array('guid' => 'dbtechvbshout-5079dbe8a10967.25950921'));

if (!$route = $db->getRow('routenew', array('guid' => 'dbtechvbshout-5079dbe8a10967.25950921')))
{
	// Begin this data
	$route = array( 
		'name' 			=> 'settings',
		'prefix' 		=> 'settings',
		'regex' 		=> 'settings/(?P<tab>dbtech-vbshout-settings|dbtech-vbshout-ignorelist|dbtech-vbshout-customcommands)',
		'class' 		=> 'vB5_Route_Settings',
		'controller' 	=> 'page',
		'action' 		=> 'index',
		'template' 		=> '',
		'contentid' 	=> 0,
		'guid' 			=> 'dbtechvbshout-5079dbe8a10967.25950921'
	);

	// Save the route and store the routeid
	$route['routeid'] = $db->insert('routenew', $route);

	self::report('Populated Table', 'routenew');
}

if (!$page = $db->getRow('page', array('guid' => 'dbtechvbshout-50895833bce6f7.61351368')))
{
	// Grab the page template
	$pageTemplate = $db->getRow('pagetemplate', array('guid' => 'vbulletin-4ecbdac9373b62.95194677'));
	
	// Begin this data
	$page = array( 
		'parentid' 			=> 0,
		'pagetemplateid' 	=> $pageTemplate['pagetemplateid'],
		'title' 			=> 'Shoutbox Settings',
		'metakeywords' 		=> 'dbtech vbshout settings',
		'metadescription' 	=> 'DragonByte Tech: vBShout Settings',
		'routeid' 			=> $route['routeid'],
		'moderatorid' 		=> 0,
		'displayorder' 		=> 0,
		'pagetype' 			=> vB_Page::TYPE_CUSTOM,
		'guid' 				=> 'dbtechvbshout-50895833bce6f7.61351368'
	);

	// Save the page and store the pageid
	$page['pageid'] = $db->insert('page', $page);

	self::report('Populated Table', 'page');

	// Update the route with the new pageid
	 $db->update('routenew', array(
		'arguments' 	=> trim(serialize(array('tab' => '$tab', 'pageid' => $page['pageid']))),
	), array('routeid' => $route['routeid']));

	self::report('Updated Table', 'routenew');
}

// We're done with everything
unset($route, $page);
?>