<?php
// New tables
self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshout_command` (
	  `commandid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `userid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  `command` VARCHAR( 50 ) NOT NULL DEFAULT '',
	  `useinput` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '0',
	  `output` MEDIUMTEXT NULL DEFAULT NULL ,
	  INDEX ( `userid` ) ,
	  PRIMARY KEY (`commandid`)
	)
");
self::report('Created Table', 'dbtech_vbshout_command');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshout_deeplog` (
	  `deeplogid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `shoutid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0' ,
	  `userid` INT( 10 ) NOT NULL DEFAULT '0' ,
	  `username` VARCHAR( 100 ) NOT NULL DEFAULT '' ,
	  `dateline` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0' ,
	  `message` MEDIUMTEXT NULL ,
	  `type` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1' ,
	  `id` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0' ,
	  `notification` ENUM( '', 'thread', 'reply' ) NOT NULL DEFAULT '' ,
	  PRIMARY KEY (`deeplogid`)
	)
");
self::report('Created Table', 'dbtech_vbshout_deeplog');

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshout_silenced',
		'type'       => 'tinyint',
		'length'     => '1',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbshout_shoutarea',
		'type'       => 'varchar',
		'length'     => '15',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => 'default'
	));
	self::report('Altered Table', 'user');	
}

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshout_chatroom` (
	  `chatroomid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `title` VARCHAR( 50 ) NOT NULL ,
	  `membergroupids` CHAR( 250 ) NOT NULL ,
	  `instanceid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
	  `active` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '1',
	  `creator` INT( 10 ) UNSIGNED NOT NULL DEFAULT '1',
	  PRIMARY KEY (`chatroomid`) ,	  
	  INDEX ( `instanceid` )
	)
");
self::report('Created Table', 'dbtech_vbshout_chatroom');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshout_chatroommember` (
	  `userid` INT( 10 ) UNSIGNED NOT NULL ,
	  `chatroomid` INT( 10 ) UNSIGNED NOT NULL ,
	  `status` TINYINT( 1 ) UNSIGNED NOT NULL DEFAULT '0',
	  PRIMARY KEY (`userid`, `chatroomid`)   
	)
");
self::report('Created Table', 'dbtech_vbshout_chatroommember');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_vbshout_instance` (
	  `instanceid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
	  `name` VARCHAR( 50 ) NOT NULL ,
	  `description` MEDIUMTEXT NULL DEFAULT NULL ,
	  `active` TINYINT( 1 ) UNSIGNED NOT NULL ,
	  `autodisplay` TINYINT( 1 ) UNSIGNED NOT NULL ,
	  `deployment` MEDIUMTEXT NULL DEFAULT NULL ,
	  `templates` MEDIUMTEXT NULL DEFAULT NULL ,
	  `permissions` MEDIUMTEXT NULL DEFAULT NULL ,
	  PRIMARY KEY (`instanceid`)
	)
");
self::report('Created Table', 'dbtech_vbshout_instance');


if (self::$db_alter->fetch_table_info('dbtech_vbshout_shout'))
{
	self::$db_alter->add_field(array(
		'name'       => 'forumid',
		'type'       => 'int',
		'length'     => '10',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'chatroomid',
		'type'       => 'int',
		'length'     => '10',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'instanceid',
		'type'       => 'int',
		'length'     => '10',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'dbtech_vbshout_shout');	
}

$products = vB::getDatastore()->getValue('products');
if (array_key_exists('dbtechvbshout', $products))
{
	$permarray = array();
	foreach (vB::getDatastore()->get_value('usergroupcache') as $usergroupid => $usergroup)
	{
		// Just stuff all the perms in there
		$permarray[$usergroupid] = $usergroup['dbtech_vbshoutpermissions'];
	}
}
else
{
	$permarray = unserialize('a:8:{i:2;i:2108;i:6;i:4092;i:4;i:12;i:8;i:0;i:7;i:3964;i:5;i:4092;i:1;i:4;i:3;i:12;}');
}

self::$db->query_write("
INSERT INTO `" . TABLE_PREFIX . "dbtech_vbshout_instance`
	(`name`, `description`, `active`, `autodisplay`, `permissions`)
VALUES (
	'Shoutbox',
	'This is the default Shoutbox.\r\nYou can change this description by clicking [Edit].',
	1,
	" . (vB::getDatastore()->getOption('dbtech_vbshout_autoadd') ? vB::getDatastore()->getOption('dbtech_vbshout_autoadd') : 1) . ",
	'" . self::$db->escape_string(trim(serialize($permarray))) . "'
)");
self::report('Updated Instance', '1');

// Populate the shout table
self::$db->query_write("UPDATE " . TABLE_PREFIX . "dbtech_vbshout_shout SET instanceid = (SELECT instanceid FROM " . TABLE_PREFIX . "dbtech_vbshout_instance ORDER BY instanceid DESC LIMIT 1)");
self::report('Updated Shouts', 'Instance ID');

self::$db->query_write("UPDATE " . TABLE_PREFIX . "dbtech_vbshout_shout SET type = 32 WHERE userid = -1");
self::report('Updated Shouts', 'SYSTEM');

self::$db->query_write("UPDATE " . TABLE_PREFIX . "user SET dbtech_vbshout_shoutstyle = NULL");
self::report('Updated Shout Styles', 'Reset');

/*
// Populate the shout table
self::$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = value + 256, defaultvalue = defaultvalue + 256 WHERE varname = 'dbtech_vbshout_editors'");
self::report('Updated Setting', 'dbtech_vbshout_editors');

self::$db->query_write("UPDATE " . TABLE_PREFIX . "user SET dbtech_vbshout_settings = dbtech_vbshout_settings + 4096");
self::report('Updated Setting', 'dbtech_vbshout_settings');
*/

?>